/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp.data.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.ActivityTemplate;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.DecisionStatement;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.ActivityPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.NodePnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.defaultimplementation.DefaultEBPPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.defaultimplementation.EventFiringActivityConfiguration;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DefaultActivityPnPWizardData
extends DefaultEBPPnPWizardData
implements ActivityPnPWizardData {
    protected List<String> classPath;
    protected final ChangeableActivityConfiguration activityTypeConfiguration;
    protected Map<Long, long[]> decisionIDsForEdgeCode = Collections.emptyMap();
    protected List<DecisionStatement> decisionStatements = Collections.emptyList();
    protected final Activity activity;

    public DefaultActivityPnPWizardData(ActivityTemplate activityTemplate, Activity ebp, NodePnPWizardData nodeData) {
        super(activityTemplate, (ExecutableBusinessProcess)ebp, nodeData);
        this.activity = ebp;
        Template processTemplate = nodeData.getProcessTemplate();
        Node node = nodeData.getNode();
        if (ebp == null) {
            this.classPath = (List)activityTemplate.getSeparatedClassPaths().get(ActivityConstants.ActivityModelEntityType.ATD);
            this.activityTypeConfiguration = new EventFiringActivityConfiguration(activityTemplate.getConfiguration(), this);
        } else {
            this.classPath = (List)this.activity.getSeparatedClassPaths().get(ActivityConstants.ActivityModelEntityType.ATD);
            this.activityTypeConfiguration = new EventFiringActivityConfiguration(this.activity.getConfiguration(), this);
        }
        if (ebp instanceof DecisionActivity) {
            long[] assignedIDs;
            Edge edge;
            int succ;
            DecisionActivity decisionActivity = (DecisionActivity)this.activity;
            HashMap<Long, long[]> idsForEdges = new HashMap<Long, long[]>();
            this.decisionStatements = Collections.unmodifiableList(new ArrayList(decisionActivity.getAllDecisionStatements()));
            int[] nArray = processTemplate.getSuccByEdgeType(node.getID(), new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL});
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                succ = nArray[n2];
                edge = processTemplate.getEdge(node.getID(), succ, ProcessConstants.EdgeType.ET_CONTROL);
                assignedIDs = decisionActivity.getDecisionID(edge.getEdgeCode());
                if (assignedIDs == null) {
                    assignedIDs = new long[]{};
                }
                idsForEdges.put(edge.getEdgeCode(), assignedIDs);
                ++n2;
            }
            nArray = processTemplate.getSuccByEdgeType(node.getID(), new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_LOOP});
            n = nArray.length;
            n2 = 0;
            while (n2 < n) {
                succ = nArray[n2];
                edge = processTemplate.getEdge(node.getID(), succ, ProcessConstants.EdgeType.ET_LOOP);
                assignedIDs = decisionActivity.getDecisionID(edge.getEdgeCode());
                if (assignedIDs == null) {
                    assignedIDs = new long[]{};
                }
                idsForEdges.put(edge.getEdgeCode(), assignedIDs);
                ++n2;
            }
            this.decisionIDsForEdgeCode = Collections.unmodifiableMap(idsForEdges);
        }
        if (ebp != null && activityTemplate != null && !ebp.getID().equals(activityTemplate.getID())) {
            this.ebpChanged = true;
        }
    }

    @Override
    public String getActivityName() {
        if (this.activityTemplate != null) {
            return this.activityTemplate.getActivityName();
        }
        return "";
    }

    @Override
    public Activity getOriginalEBP() {
        return this.activity;
    }

    @Override
    public List<String> getClassPath() {
        return new ArrayList<String>(this.classPath);
    }

    @Override
    public void setClassPath(List<String> classPath) {
        ArgChecks.checkForNulls(classPath, (String)"classPath");
        this.classPath = new ArrayList<String>(classPath);
    }

    @Override
    public ChangeableActivityConfiguration getConfiguration() {
        return this.activityTypeConfiguration;
    }

    public Activity createChangedEBP() {
        UUID id = this.isExistingEBP() ? this.activity.getID() : this.activityTemplate.getID();
        String ecName = this.isExistingEBP() ? this.activity.getExecutableComponentName() : this.activityTemplate.getExecutableComponentName();
        String string = this.isExistingEBP() ? this.activity.getOperationName() : this.activityTemplate.getOperationName();
        String configurationName = this.isExistingEBP() ? this.activity.getConfigurationName() : this.activityTemplate.getConfigurationName();
        String activityName = this.isExistingEBP() ? this.activity.getActivityName() : this.activityTemplate.getActivityName();
        String description = this.isExistingEBP() ? this.activity.getDescription() : this.activityTemplate.getDescription();
        String implementationClass = this.isExistingEBP() ? this.activity.getImplementationClass() : this.activityTemplate.getImplementationClass();
        Map separatedClassPaths22 = this.isExistingEBP() ? this.activity.getSeparatedClassPaths() : this.activityTemplate.getSeparatedClassPaths();
        separatedClassPaths22.put(ActivityConstants.ActivityModelEntityType.ATD, this.classPath);
        boolean isSingleton22 = this.isExistingEBP() ? this.activity.isSingleton() : this.activityTemplate.isSingleton();
        byte[] systemComponentSignature = this.isExistingEBP() ? this.activity.getSystemComponent() : this.activityTemplate.getSystemComponent();
        String guiContextID = this.isExistingEBP() ? this.activity.getGUIContextID() : this.activityTemplate.getGUIContextID();
        boolean viewOnly = this.isExistingEBP() ? this.activity.supportsViewOnly() : this.activityTemplate.supportsViewOnly();
        boolean testMode = this.isExistingEBP() ? this.activity.supportsTestExecution() : this.activityTemplate.supportsTestExecution();
        UUID iconID = this.isExistingEBP() ? this.activity.getIconID() : this.activityTemplate.getIconID();
        Map attributeOrigins = this.isExistingEBP() ? this.activity.getAttributeOrigins() : this.activityTemplate.getAttributeOrigins();
        ParameterChangePolicy pcp = this.isExistingEBP() ? this.activity.getParameterChangePolicy() : this.activityTemplate.getParameterChangePolicy();
        Activity pluginData = this.isExistingEBP() ? this.activity : this.activityTemplate;
        Map userAttributes = this.isExistingEBP() ? this.activity.getUserAttributes() : this.activityTemplate.getUserAttributes();
        Activity newActivity = Activator.getService().getProcessModelFactory().createActivity(id, ecName, string, configurationName, activityName, description, implementationClass, separatedClassPaths22, isSingleton22, systemComponentSignature, guiContextID, this.getExecutionControlProperties(), viewOnly, testMode, iconID, attributeOrigins, (ActivityConfiguration)this.getConfiguration(), this.getTestConfiguration(), pcp, this.getParameters(ActivityConstants.AccessType.READ), this.getParameters(ActivityConstants.AccessType.WRITE), (PluginDataContainer)pluginData, userAttributes);
        if (this.isExistingEBP() && this.activity instanceof DecisionActivity || this.activityTemplate != null && "true".equals(this.activityTemplate.getUserAttributeValue("decision"))) {
            ProcessModelParameter decisionParameter = null;
            if (this.isExistingEBP() && this.activity instanceof DecisionActivity && ((DecisionActivity)this.activity).getDecisionParameter() != null) {
                decisionParameter = this.getParameter(((DecisionActivity)this.activity).getDecisionParameter().getName(), ActivityConstants.AccessType.WRITE);
            }
            if (decisionParameter == null) {
                for (ProcessModelParameter parameter : this.writeParameters.values()) {
                    if (parameter.getDataType() != ProcessConstants.AdeptDataType.INTEGER || !parameter.getIdentifierID().equals(ProcessConstants.IDENTIFIER_ID_DECISION)) continue;
                    decisionParameter = parameter;
                    break;
                }
                if (decisionParameter == null) {
                    throw new RuntimeException("No parameter could be found in the activity template which could be used as decision parameter.");
                }
            }
            HashMap<Long, Long> edgeCodesForDecisionIDs = new HashMap<Long, Long>();
            for (Map.Entry entry : this.decisionIDsForEdgeCode.entrySet()) {
                long[] isSingleton22 = (long[])entry.getValue();
                int separatedClassPaths22 = isSingleton22.length;
                int n = 0;
                while (n < separatedClassPaths22) {
                    long decisionID = isSingleton22[n];
                    edgeCodesForDecisionIDs.put(decisionID, (Long)entry.getKey());
                    ++n;
                }
            }
            HashMap<Long, HashSet<DecisionStatement>> hashMap = new HashMap<Long, HashSet<DecisionStatement>>();
            for (DecisionStatement stmt : this.decisionStatements) {
                long decisionID = stmt.getDecisionID();
                Long edgeCode = (Long)edgeCodesForDecisionIDs.get(decisionID);
                if (edgeCode == null) continue;
                HashSet<DecisionStatement> collection = (HashSet<DecisionStatement>)hashMap.get(edgeCode);
                if (collection == null) {
                    collection = new HashSet<DecisionStatement>();
                }
                collection.add(stmt);
                hashMap.put(edgeCode, collection);
            }
            newActivity = Activator.getService().getProcessModelFactory().createDecisionActivity(newActivity, decisionParameter, hashMap);
        }
        return newActivity;
    }

    @Override
    public String getExecutableComponentName() {
        if (this.isExistingEBP()) {
            return this.activity.getExecutableComponentName();
        }
        return this.activityTemplate.getExecutableComponentName();
    }

    @Override
    public String getOperationName() {
        if (this.isExistingEBP()) {
            return this.activity.getOperationName();
        }
        return this.activityTemplate.getOperationName();
    }

    public ActivityConfiguration getTestConfiguration() {
        return this.isExistingEBP() ? this.activity.getTestConfiguration() : this.activityTemplate.getTestConfiguration();
    }

    public ExecutionControlProperties getExecutionControlProperties() {
        return this.isExistingEBP() ? this.activity.getExecutionControlProperties() : this.activityTemplate.getExecutionControlProperties();
    }

    @Override
    public Map<Long, long[]> getDecisionIDsForEdgeCode() {
        return this.decisionIDsForEdgeCode;
    }

    @Override
    public List<DecisionStatement> getDecisionStatements() {
        return this.decisionStatements;
    }

    @Override
    public void setDecisionIDsForEdgeCode(Map<Long, long[]> newMap) {
        this.decisionIDsForEdgeCode = Collections.unmodifiableMap(newMap);
        this.ebpChanged = true;
    }

    @Override
    public void setDecisionStatements(List<DecisionStatement> newList) {
        this.decisionStatements = Collections.unmodifiableList(newList);
        this.ebpChanged = true;
    }
}

