/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp.data.defaultimplementation;

import de.aristaflow.adept2.core.changeoperations.ConvertActivityTemplateToActivity;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplate;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.EBPPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.NodePnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.ParameterMappingEntry;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.PnPWizardChangeListener;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public abstract class DefaultEBPPnPWizardData
implements EBPPnPWizardData {
    protected ActivityTemplate activityTemplate;
    protected Map<String, ProcessModelParameter> readParameters;
    protected Map<String, ProcessModelParameter> writeParameters;
    protected Map<ProcessModelParameter, ParameterMappingEntry> readParameterMapping;
    protected Map<ProcessModelParameter, ParameterMappingEntry> writeParameterMapping;
    protected ExecutableBusinessProcess originalEBP;
    protected NodePnPWizardData nodeData;
    protected boolean ebpChanged = false;
    protected Set<DataElement> availableConnectedReadDataElements;
    protected Set<DataElement> availableConnectedWrittenDataElements;
    protected Set<DataElement> availableUnConnectedReadDataElements;
    protected Set<DataElement> availableUnConnectedWrittenDataElements;
    protected final Logger logger = LoggerTools.getLogger((Object)this);
    protected List<PnPWizardChangeListener> listeners = new LinkedList<PnPWizardChangeListener>();

    public DefaultEBPPnPWizardData(ActivityTemplate activityTemplate, ExecutableBusinessProcess ebp, NodePnPWizardData nodeData) {
        HashSet writeParams;
        HashSet readParams;
        this.activityTemplate = activityTemplate;
        this.nodeData = nodeData;
        this.originalEBP = ebp;
        this.readParameters = new HashMap<String, ProcessModelParameter>();
        this.writeParameters = new HashMap<String, ProcessModelParameter>();
        this.readParameterMapping = new HashMap<ProcessModelParameter, ParameterMappingEntry>();
        this.writeParameterMapping = new HashMap<ProcessModelParameter, ParameterMappingEntry>();
        if (ebp != null) {
            readParams = ebp.getParameters(ActivityConstants.AccessType.READ);
            writeParams = ebp.getParameters(ActivityConstants.AccessType.WRITE);
        } else {
            readParams = new HashSet();
            writeParams = new HashSet();
            ConvertActivityTemplateToActivity.convertTemplateParameters((ProcessModelFactory)Activator.getService().getProcessModelFactory(), (ActivityTemplate)activityTemplate, readParams, writeParams);
        }
        for (ProcessModelParameter param : readParams) {
            this.readParameters.put(param.getName(), param);
        }
        for (ProcessModelParameter param : writeParams) {
            this.writeParameters.put(param.getName(), param);
        }
        this.initializeDataElementSets();
        this.ebpChanged = ebp == null;
        this.addParameterMappings(this.readParameters.values(), this.readParameterMapping, ActivityConstants.AccessType.READ);
        this.addParameterMappings(this.writeParameters.values(), this.writeParameterMapping, ActivityConstants.AccessType.WRITE);
    }

    public DefaultEBPPnPWizardData(Template template, ExecutableBusinessProcess ebp, NodePnPWizardData nodeData) {
        Set writeParams;
        Set readParams;
        this.nodeData = nodeData;
        this.originalEBP = ebp;
        this.readParameters = new HashMap<String, ProcessModelParameter>();
        this.writeParameters = new HashMap<String, ProcessModelParameter>();
        this.readParameterMapping = new HashMap<ProcessModelParameter, ParameterMappingEntry>();
        this.writeParameterMapping = new HashMap<ProcessModelParameter, ParameterMappingEntry>();
        if (ebp != null) {
            readParams = ebp.getParameters(ActivityConstants.AccessType.READ);
            writeParams = ebp.getParameters(ActivityConstants.AccessType.WRITE);
        } else {
            readParams = template.getParameters(ActivityConstants.AccessType.READ);
            writeParams = template.getParameters(ActivityConstants.AccessType.WRITE);
        }
        for (ProcessModelParameter param : readParams) {
            this.readParameters.put(param.getName(), param);
        }
        for (ProcessModelParameter param : writeParams) {
            this.writeParameters.put(param.getName(), param);
        }
        this.initializeDataElementSets();
        this.ebpChanged = ebp == null;
        this.addParameterMappings(this.readParameters.values(), this.readParameterMapping, ActivityConstants.AccessType.READ);
        this.addParameterMappings(this.writeParameters.values(), this.writeParameterMapping, ActivityConstants.AccessType.WRITE);
    }

    protected void initializeDataElementSets() {
        int[] connectedWrittenDataElementsIDs;
        int[] connectedReadDataElementIDs;
        this.availableConnectedReadDataElements = new HashSet<DataElement>();
        this.availableConnectedWrittenDataElements = new HashSet<DataElement>();
        this.availableUnConnectedReadDataElements = new HashSet<DataElement>();
        this.availableUnConnectedWrittenDataElements = new HashSet<DataElement>();
        Template processTemplate = this.nodeData.getProcessTemplate();
        Node node = this.nodeData.getNode();
        int[] nArray = connectedReadDataElementIDs = processTemplate.getAccessedDataElementIDsForNode(node.getID(), ActivityConstants.AccessType.READ);
        int n = connectedReadDataElementIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            this.availableConnectedReadDataElements.add(processTemplate.getDataElement(id));
            ++n2;
        }
        int[] nArray2 = connectedWrittenDataElementsIDs = processTemplate.getAccessedDataElementIDsForNode(node.getID(), ActivityConstants.AccessType.WRITE);
        int n3 = connectedWrittenDataElementsIDs.length;
        n = 0;
        while (n < n3) {
            int id = nArray2[n];
            this.availableConnectedWrittenDataElements.add(processTemplate.getDataElement(id));
            ++n;
        }
        for (DataElement data : processTemplate.getDataElements()) {
            if (this.availableConnectedReadDataElements.contains(data) || this.availableConnectedWrittenDataElements.contains(data)) continue;
            this.availableUnConnectedReadDataElements.add(data);
            this.availableUnConnectedWrittenDataElements.add(data);
        }
    }

    protected void pushbackDataElement(DataElement element, ActivityConstants.AccessType type) {
        int[] connectedElements;
        Set<DataElement> unconnectedSet;
        Set<DataElement> connectedSet;
        Template processTemplate = this.nodeData.getProcessTemplate();
        Node node = this.nodeData.getNode();
        switch (type) {
            case READ: {
                connectedSet = this.availableConnectedReadDataElements;
                unconnectedSet = this.availableUnConnectedReadDataElements;
                connectedElements = processTemplate.getAccessedDataElementIDsForNode(node.getID(), ActivityConstants.AccessType.READ);
                break;
            }
            case WRITE: {
                connectedSet = this.availableConnectedWrittenDataElements;
                unconnectedSet = this.availableUnConnectedWrittenDataElements;
                connectedElements = processTemplate.getAccessedDataElementIDsForNode(node.getID(), ActivityConstants.AccessType.WRITE);
                break;
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                String message = String.format("Only activity related values are allowed here, %s may not be used for activities", type);
                throw new IllegalArgumentException(message);
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
        int[] nArray = connectedElements;
        int n = connectedElements.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            if (element.getID() == id) {
                connectedSet.add(element);
                return;
            }
            ++n2;
        }
        unconnectedSet.add(element);
    }

    protected void addParameterMappings(Collection<ProcessModelParameter> parameters, Map<ProcessModelParameter, ParameterMappingEntry> mapping, ActivityConstants.AccessType type) {
        Set<DataElement> unconnectedSet;
        Set<DataElement> connectedSet;
        Template processTemplate = this.nodeData.getProcessTemplate();
        Node node = this.nodeData.getNode();
        switch (type) {
            case READ: {
                connectedSet = this.availableConnectedReadDataElements;
                unconnectedSet = this.availableUnConnectedReadDataElements;
                break;
            }
            case WRITE: {
                connectedSet = this.availableConnectedWrittenDataElements;
                unconnectedSet = this.availableUnConnectedWrittenDataElements;
                break;
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                String message = String.format("Only activity related values are allowed here, %s may not be used for activities", type);
                throw new IllegalArgumentException(message);
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
        ArrayList<ProcessModelParameter> unconnectedParameters = new ArrayList<ProcessModelParameter>();
        int[] disabledConnectors = processTemplate.getDisabledConnectors(node.getID(), type);
        Arrays.sort(disabledConnectors);
        for (ProcessModelParameter param : parameters) {
            int connectorID = node.getConnector(param.getName(), type);
            DataElement dataElement = processTemplate.getDataElement(node.getID(), connectorID);
            if (dataElement == null || this.ebpChanged) {
                if (Arrays.binarySearch(disabledConnectors, connectorID) >= 0) {
                    mapping.put(param, new ParameterMappingEntry(null, ProcessConstants.DataMappingType.DISABLE));
                    continue;
                }
                unconnectedParameters.add(param);
                continue;
            }
            mapping.put(param, new ParameterMappingEntry(dataElement, ProcessConstants.DataMappingType.DATAELEMENT));
            connectedSet.remove(dataElement);
        }
        mapping.putAll(this.createMappingForUnconnectedParams(type, connectedSet, unconnectedSet, unconnectedParameters));
    }

    private Map<ProcessModelParameter, ParameterMappingEntry> createMappingForUnconnectedParams(ActivityConstants.AccessType type, Set<DataElement> connectedSet, Set<DataElement> unconnectedSet, List<ProcessModelParameter> unconnectedParameters) {
        DataElement identifierDataElement;
        HashSet<DataElement> dataElementSet;
        ProcessModelParameter param;
        HashMap<ProcessModelParameter, ParameterMappingEntry> mapping = new HashMap<ProcessModelParameter, ParameterMappingEntry>();
        Iterator<ProcessModelParameter> parameterIterator = unconnectedParameters.iterator();
        while (parameterIterator.hasNext()) {
            param = parameterIterator.next();
            DataElement inoutDataElement = this.checkIfMappedInOutParameter(param, type);
            if (inoutDataElement == null) continue;
            HashSet<DataElement> dataElementSet2 = new HashSet<DataElement>();
            dataElementSet2.add(inoutDataElement);
            this.mapDataElement(dataElementSet2, param);
            mapping.put(param, new ParameterMappingEntry(inoutDataElement, ProcessConstants.DataMappingType.DATAELEMENT));
            parameterIterator.remove();
        }
        parameterIterator = unconnectedParameters.iterator();
        while (parameterIterator.hasNext()) {
            dataElementSet = new HashSet<DataElement>(connectedSet);
            param = parameterIterator.next();
            DataElement nameDataElement = this.mapWithExactName(dataElementSet, param);
            if (nameDataElement == null) {
                dataElementSet = new HashSet<DataElement>(unconnectedSet);
                nameDataElement = this.mapWithExactName(dataElementSet, param);
                if (nameDataElement != null) {
                    unconnectedSet.remove(nameDataElement);
                }
            } else {
                connectedSet.remove(nameDataElement);
            }
            if (nameDataElement == null) continue;
            mapping.put(param, new ParameterMappingEntry(nameDataElement, ProcessConstants.DataMappingType.DATAELEMENT));
            parameterIterator.remove();
        }
        parameterIterator = unconnectedParameters.iterator();
        while (parameterIterator.hasNext()) {
            dataElementSet = new HashSet<DataElement>(connectedSet);
            param = parameterIterator.next();
            identifierDataElement = this.mapWithExactIdentifier(dataElementSet, param);
            if (identifierDataElement == null) {
                dataElementSet = new HashSet<DataElement>(unconnectedSet);
                identifierDataElement = this.mapWithExactIdentifier(dataElementSet, param);
                if (identifierDataElement != null) {
                    unconnectedSet.remove(identifierDataElement);
                }
            } else {
                connectedSet.remove(identifierDataElement);
            }
            if (identifierDataElement == null) continue;
            mapping.put(param, new ParameterMappingEntry(identifierDataElement, ProcessConstants.DataMappingType.DATAELEMENT));
            parameterIterator.remove();
        }
        parameterIterator = unconnectedParameters.iterator();
        while (parameterIterator.hasNext()) {
            dataElementSet = new HashSet<DataElement>(connectedSet);
            param = parameterIterator.next();
            identifierDataElement = this.mapWithoutSpecialProperty(dataElementSet, param);
            if (identifierDataElement == null) {
                dataElementSet = new HashSet<DataElement>(unconnectedSet);
                identifierDataElement = this.mapWithoutSpecialProperty(dataElementSet, param);
                if (identifierDataElement != null) {
                    unconnectedSet.remove(identifierDataElement);
                }
            } else {
                connectedSet.remove(identifierDataElement);
            }
            if (identifierDataElement != null) {
                mapping.put(param, new ParameterMappingEntry(identifierDataElement, ProcessConstants.DataMappingType.DATAELEMENT));
                parameterIterator.remove();
                continue;
            }
            mapping.put(param, new ParameterMappingEntry(null, ProcessConstants.DataMappingType.NEW_DATAELEMENT));
        }
        return mapping;
    }

    protected ParameterMappingEntry createMappingForNewParameter(Set<DataElement> connectedDataElements, Set<DataElement> unconnectedDataElements, ProcessModelParameter param, ActivityConstants.AccessType type) {
        DataElement inoutDataElement = this.checkIfMappedInOutParameter(param, type);
        if (inoutDataElement != null) {
            HashSet<DataElement> dataElementSet = new HashSet<DataElement>();
            dataElementSet.add(inoutDataElement);
            this.mapDataElement(dataElementSet, param);
            return new ParameterMappingEntry(inoutDataElement, ProcessConstants.DataMappingType.DATAELEMENT);
        }
        DataElement dataEl = this.mapDataElement(connectedDataElements, param);
        if (dataEl == null) {
            dataEl = this.mapDataElement(unconnectedDataElements, param);
        }
        if (dataEl == null) {
            return new ParameterMappingEntry(null, ProcessConstants.DataMappingType.NEW_DATAELEMENT);
        }
        return new ParameterMappingEntry(dataEl, ProcessConstants.DataMappingType.DATAELEMENT);
    }

    protected DataElement mapDataElement(Set<DataElement> dataElements, ProcessModelParameter parameter) {
        HashSet<DataElement> tempDataElements = new HashSet<DataElement>(dataElements);
        DataElement dataElement = this.mapWithExactName(tempDataElements, parameter);
        if (dataElement != null) {
            dataElements.remove(dataElement);
            return dataElement;
        }
        dataElement = this.mapWithExactIdentifier(tempDataElements, parameter);
        if (dataElement != null) {
            dataElements.remove(dataElement);
            return dataElement;
        }
        dataElement = this.mapWithoutSpecialProperty(tempDataElements, parameter);
        if (dataElement != null) {
            dataElements.remove(dataElement);
            return dataElement;
        }
        return null;
    }

    private DataElement checkIfMappedInOutParameter(ProcessModelParameter param, ActivityConstants.AccessType type) {
        ParameterMappingEntry entry;
        ProcessModelParameter otherParam = type == ActivityConstants.AccessType.READ ? this.writeParameters.get(param.getName()) : this.readParameters.get(param.getName());
        if (otherParam != null && (entry = this.writeParameterMapping.get(otherParam)) != null && entry.element != null && param.getDataType().equals((Object)otherParam.getDataType()) && param.getIdentifierID().equals(otherParam.getIdentifierID())) {
            return entry.element;
        }
        return null;
    }

    private DataElement mapWithoutSpecialProperty(Set<DataElement> dataElements, ProcessModelParameter parameter) {
        Iterator<DataElement> dataElementIterator = dataElements.iterator();
        while (dataElementIterator.hasNext()) {
            DataElement data = dataElementIterator.next();
            if (this.checkIfParameterIsMappable(parameter, data)) {
                return data;
            }
            dataElementIterator.remove();
        }
        return null;
    }

    private DataElement mapWithExactIdentifier(Set<DataElement> dataElements, ProcessModelParameter parameter) {
        Iterator<DataElement> dataElementIterator = dataElements.iterator();
        while (dataElementIterator.hasNext()) {
            DataElement data = dataElementIterator.next();
            if (!parameter.getIdentifierID().equals(data.getIdentifierID())) continue;
            if (this.checkIfParameterIsMappable(parameter, data)) {
                return data;
            }
            dataElementIterator.remove();
        }
        return null;
    }

    private DataElement mapWithExactName(Set<DataElement> dataElements, ProcessModelParameter parameter) {
        Iterator<DataElement> dataElementIterator = dataElements.iterator();
        while (dataElementIterator.hasNext()) {
            DataElement data = dataElementIterator.next();
            if (!parameter.getName().equals(data.getName())) continue;
            if (this.checkIfParameterIsMappable(parameter, data)) {
                return data;
            }
            dataElementIterator.remove();
        }
        return null;
    }

    private boolean checkIfParameterIsMappable(ProcessModelParameter parameter, DataElement data) {
        if (parameter.getDataType() != data.getDataType() || parameter.isVirtual() != data.isVirtual() || !parameter.getIdentifierID().equals(data.getIdentifierID()) && !data.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) && !data.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET)) {
            return false;
        }
        if (!(parameter.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED || parameter.getUDTName() != null && parameter.getUDTName().equals(data.getUDTName()))) {
            return false;
        }
        if (!data.getIdentifierID().equals(ProcessConstants.IDENTIFIER_NOT_SET) && !parameter.getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID)) {
            boolean incompatible = false;
            for (Map.Entry<ProcessModelParameter, ParameterMappingEntry> entry : this.readParameterMapping.entrySet()) {
                if (entry.getValue().type != ProcessConstants.DataMappingType.DATAELEMENT || entry.getValue().element != data || entry.getKey().getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) || entry.getKey().getIdentifierID().equals(parameter.getIdentifierID())) continue;
                incompatible = true;
                break;
            }
            if (incompatible) {
                return false;
            }
            for (Map.Entry<ProcessModelParameter, ParameterMappingEntry> entry : this.writeParameterMapping.entrySet()) {
                if (entry.getValue().type != ProcessConstants.DataMappingType.DATAELEMENT || entry.getValue().element != data || entry.getKey().getIdentifierID().equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) || entry.getKey().getIdentifierID().equals(parameter.getIdentifierID())) continue;
                incompatible = true;
                break;
            }
            if (incompatible) {
                return false;
            }
        }
        return true;
    }

    @Override
    public ProcessModelParameter getParameter(String name, ActivityConstants.AccessType accessType) {
        switch (accessType) {
            case READ: {
                return this.readParameters.get(name);
            }
            case WRITE: {
                return this.writeParameters.get(name);
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                String message = String.format("Only activity related values are allowed here, %s may not be used for activities", accessType);
                throw new IllegalArgumentException(message);
            }
        }
        throw new AssertionError((Object)"An unknown access type was found!");
    }

    @Override
    public Set<ProcessModelParameter> getParameters(ActivityConstants.AccessType accessType) {
        switch (accessType) {
            case READ: {
                return new HashSet<ProcessModelParameter>(this.readParameters.values());
            }
            case WRITE: {
                return new HashSet<ProcessModelParameter>(this.writeParameters.values());
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                String message = String.format("Only activity related values are allowed here, %s may not be used for activities", accessType);
                throw new IllegalArgumentException(message);
            }
        }
        throw new AssertionError((Object)"An unknown access type was found!");
    }

    @Override
    public void addParameter(ProcessModelParameter p, ActivityConstants.AccessType accessType) {
        Set<DataElement> unconnectedSet;
        Set<DataElement> connectedSet;
        Map<ProcessModelParameter, ParameterMappingEntry> paramMappingMap;
        Map<String, ProcessModelParameter> paramMap;
        switch (accessType) {
            case READ: {
                paramMap = this.readParameters;
                paramMappingMap = this.readParameterMapping;
                connectedSet = this.availableConnectedReadDataElements;
                unconnectedSet = this.availableUnConnectedReadDataElements;
                break;
            }
            case WRITE: {
                paramMap = this.writeParameters;
                paramMappingMap = this.writeParameterMapping;
                connectedSet = this.availableConnectedWrittenDataElements;
                unconnectedSet = this.availableUnConnectedWrittenDataElements;
                break;
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                String message = String.format("Only activity related values are allowed here, %s may not be used for activities", accessType);
                throw new IllegalArgumentException(message);
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
        if (paramMap.containsKey(p.getName())) {
            throw new IllegalArgumentException("Parameter " + p.getName() + " already exists!");
        }
        paramMappingMap.put(p, this.createMappingForNewParameter(connectedSet, unconnectedSet, p, accessType));
        paramMap.put(p.getName(), p);
        this.ebpChanged = true;
        switch (accessType) {
            case READ: {
                this.fireEvent(PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_ADDED, p);
                break;
            }
            case WRITE: {
                this.fireEvent(PnPWizardChangeListener.PnPWizardChangeType.WRITE_PARAMETER_ADDED, p);
                break;
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                throw new AssertionError((Object)"Unreachable code");
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
    }

    @Override
    public void changeParameter(ProcessModelParameter oldParam, ProcessModelParameter newParam, ActivityConstants.AccessType accessType) {
        Map<ProcessModelParameter, ParameterMappingEntry> paramMappingMap;
        Map<String, ProcessModelParameter> paramMap;
        switch (accessType) {
            case READ: {
                paramMap = this.readParameters;
                paramMappingMap = this.readParameterMapping;
                break;
            }
            case WRITE: {
                paramMap = this.writeParameters;
                paramMappingMap = this.writeParameterMapping;
                break;
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                String message = String.format("Only activity related values are allowed here, %s may not be used for activities", accessType);
                throw new IllegalArgumentException(message);
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
        if (!paramMap.containsKey(oldParam.getName())) {
            throw new IllegalArgumentException("Parameter " + oldParam.getName() + " does not exist!");
        }
        if (!oldParam.equals(newParam)) {
            this.ebpChanged = true;
            ParameterMappingEntry oldMapping = paramMappingMap.remove(oldParam);
            if (oldMapping.type != ProcessConstants.DataMappingType.DATAELEMENT) {
                paramMappingMap.put(newParam, oldMapping);
            } else if (oldParam.getDataType() == newParam.getDataType() && (oldParam.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED || oldParam.getUDTName() != null && oldParam.getUDTName().equals(newParam.getUDTName())) && oldParam.getIdentifierID().equals(newParam.getIdentifierID()) && oldParam.isVirtual() == newParam.isVirtual()) {
                paramMappingMap.put(newParam, oldMapping);
            } else {
                Set<DataElement> unconnectedSet;
                Set<DataElement> connectedSet;
                switch (accessType) {
                    case READ: {
                        connectedSet = this.availableConnectedReadDataElements;
                        unconnectedSet = this.availableUnConnectedReadDataElements;
                        break;
                    }
                    case WRITE: {
                        connectedSet = this.availableConnectedWrittenDataElements;
                        unconnectedSet = this.availableUnConnectedWrittenDataElements;
                        break;
                    }
                    case SYSTEM_READ: 
                    case SYSTEM_WRITE: {
                        throw new AssertionError((Object)"Unreachable code");
                    }
                    default: {
                        throw new AssertionError((Object)"An unknown access type was found!");
                    }
                }
                this.pushbackDataElement(oldMapping.element, accessType);
                paramMappingMap.put(newParam, this.createMappingForNewParameter(connectedSet, unconnectedSet, newParam, accessType));
            }
            paramMap.put(newParam.getName(), newParam);
            if (!oldParam.getName().equals(newParam.getName())) {
                paramMap.remove(oldParam.getName());
            }
            switch (accessType) {
                case READ: {
                    this.fireEvent(PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_CHANGED, new ProcessModelParameter[]{oldParam, newParam});
                    break;
                }
                case WRITE: {
                    this.fireEvent(PnPWizardChangeListener.PnPWizardChangeType.WRITE_PARAMETER_CHANGED, new ProcessModelParameter[]{oldParam, newParam});
                    break;
                }
                case SYSTEM_READ: 
                case SYSTEM_WRITE: {
                    throw new AssertionError((Object)"Unreachable code");
                }
                default: {
                    throw new AssertionError((Object)"An unknown access type was found!");
                }
            }
        }
    }

    @Override
    public ProcessModelParameter removeParameter(String name, ActivityConstants.AccessType accessType) {
        this.ebpChanged = true;
        switch (accessType) {
            case READ: {
                ProcessModelParameter param = this.readParameters.get(name);
                if (param == null) {
                    throw new IllegalArgumentException("Parameter " + name + " does not exist!");
                }
                ParameterMappingEntry oldMapping = this.readParameterMapping.remove(param);
                if (oldMapping.type == ProcessConstants.DataMappingType.DATAELEMENT && oldMapping.element != null) {
                    this.pushbackDataElement(oldMapping.element, accessType);
                }
                this.readParameters.remove(name);
                this.fireEvent(PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_REMOVED, param);
                return param;
            }
            case WRITE: {
                ProcessModelParameter param = this.writeParameters.get(name);
                if (param == null) {
                    throw new IllegalArgumentException("Parameter " + name + " does not exist!");
                }
                ParameterMappingEntry oldMapping = this.writeParameterMapping.remove(param);
                if (oldMapping.type == ProcessConstants.DataMappingType.DATAELEMENT && oldMapping.element != null) {
                    this.pushbackDataElement(oldMapping.element, accessType);
                }
                this.writeParameters.remove(name);
                this.fireEvent(PnPWizardChangeListener.PnPWizardChangeType.WRITE_PARAMETER_REMOVED, param);
                return param;
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                String message = String.format("Only activity related values are allowed here, %s may not be used for activities", accessType);
                throw new IllegalArgumentException(message);
            }
        }
        throw new AssertionError((Object)"An unknown access type was found!");
    }

    @Override
    public ActivityTemplate getActivityTemplate() {
        return this.activityTemplate;
    }

    @Override
    public Map<ProcessModelParameter, ParameterMappingEntry> getParameterMapping(ActivityConstants.AccessType type) {
        switch (type) {
            case READ: {
                return Collections.unmodifiableMap(this.readParameterMapping);
            }
            case WRITE: {
                return Collections.unmodifiableMap(this.writeParameterMapping);
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                String message = String.format("Only activity related values are allowed here, %s may not be used for activities", type);
                throw new IllegalArgumentException(message);
            }
        }
        throw new AssertionError((Object)"An unknown access type was found!");
    }

    @Override
    public void addChangeListener(PnPWizardChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(PnPWizardChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void fireEvent(PnPWizardChangeListener.PnPWizardChangeType type, Object data) {
        for (PnPWizardChangeListener listener : this.listeners) {
            listener.changeNotify(type, data);
        }
    }

    @Override
    public boolean isExistingEBP() {
        return this.originalEBP != null;
    }

    @Override
    public void changeMapping(ProcessModelParameter param, DataElement mapping, ProcessConstants.DataMappingType mappingType, ActivityConstants.AccessType accessType) {
        switch (accessType) {
            case READ: {
                if (!this.readParameterMapping.containsKey(param)) {
                    throw new IllegalArgumentException("Parameter does not exist!");
                }
                this.readParameterMapping.put(param, new ParameterMappingEntry(mapping, mappingType));
                this.fireEvent(PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_MAPPING_CHANGED, param);
                break;
            }
            case WRITE: {
                if (!this.writeParameterMapping.containsKey(param)) {
                    throw new IllegalArgumentException("Parameter does not exist!");
                }
                this.writeParameterMapping.put(param, new ParameterMappingEntry(mapping, mappingType));
                this.fireEvent(PnPWizardChangeListener.PnPWizardChangeType.WRITE_PARAMETER_MAPPING_CHANGED, param);
                break;
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                String message = String.format("Only activity related values are allowed here, %s may not be used for activities", accessType);
                throw new IllegalArgumentException(message);
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
    }

    @Override
    public ExecutableBusinessProcess getOriginalEBP() {
        return this.originalEBP;
    }

    @Override
    public boolean isChangedEBP() {
        return this.ebpChanged;
    }

    @Override
    public NodePnPWizardData getNodeData() {
        return this.nodeData;
    }
}

