/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processediting.wizards.pnp.data.defaultimplementation;

import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.NodePnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.VarParWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.defaultimplementation.DefaultEBPPnPWizardData;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultLWPPnPWizardData
extends DefaultEBPPnPWizardData
implements VarParWizardData {
    private final Template template;
    private final TemplateStatus templateStatus;
    private final LightWeightProcess oldLWP;
    private PossibleTemplateUsage templateUsage;
    private boolean noUsage;
    private boolean isVarPar = false;
    private Set<ProcessModelParameter> indexedParameters = new HashSet<ProcessModelParameter>();
    private Set<ProcessModelParameter> inputParameters = new HashSet<ProcessModelParameter>();
    private Set<ProcessModelParameter> outputParameters = new HashSet<ProcessModelParameter>();

    public DefaultLWPPnPWizardData(LightWeightProcess ebp, Template template, TemplateStatus status, NodePnPWizardData nodeData) {
        super(template, (ExecutableBusinessProcess)ebp, nodeData);
        this.template = template;
        this.templateStatus = status;
        this.oldLWP = ebp;
        if (status == null) {
            this.templateUsage = ebp instanceof ReferencedProcess ? (((ReferencedProcess)ebp).fork() ? PossibleTemplateUsage.FORKED : PossibleTemplateUsage.REFERENCED) : PossibleTemplateUsage.EMBEDDED;
        } else if (status.getUsageAsSubprocess().equals((Object)ProcessConstants.TemplateUsage.AS_REFERENCE)) {
            this.templateUsage = ebp instanceof ReferencedProcess && ((ReferencedProcess)ebp).fork() && status.isTopLevelUsable() ? PossibleTemplateUsage.FORKED : PossibleTemplateUsage.REFERENCED;
        } else if (status.getUsageAsSubprocess().equals((Object)ProcessConstants.TemplateUsage.AS_COPY)) {
            this.templateUsage = ebp instanceof ReferencedProcess && ((ReferencedProcess)ebp).fork() && status.isTopLevelUsable() ? PossibleTemplateUsage.FORKED : PossibleTemplateUsage.EMBEDDED;
        } else if (status.getUsageAsSubprocess().equals((Object)ProcessConstants.TemplateUsage.COPY_OR_REFERENCE)) {
            this.templateUsage = ebp instanceof ReferencedProcess ? (((ReferencedProcess)ebp).fork() && status.isTopLevelUsable() ? PossibleTemplateUsage.FORKED : PossibleTemplateUsage.REFERENCED) : PossibleTemplateUsage.EMBEDDED;
        } else if (status.isTopLevelUsable()) {
            this.templateUsage = PossibleTemplateUsage.FORKED;
        } else {
            this.noUsage = true;
            this.templateUsage = ebp instanceof ReferencedProcess ? (((ReferencedProcess)ebp).fork() ? PossibleTemplateUsage.FORKED : PossibleTemplateUsage.REFERENCED) : PossibleTemplateUsage.EMBEDDED;
        }
    }

    public DefaultLWPPnPWizardData(VariableParallelismEBP varParEbp, Template template, TemplateStatus status, NodePnPWizardData nodeData) {
        this(varParEbp.getLightWeightProcess(), template, status, nodeData);
        this.indexedParameters = new HashSet<ProcessModelParameter>(varParEbp.getIndexedInputParameters());
        this.inputParameters = new HashSet<ProcessModelParameter>(varParEbp.getParameters(ActivityConstants.AccessType.READ));
        this.outputParameters = new HashSet<ProcessModelParameter>(varParEbp.getParameters(ActivityConstants.AccessType.WRITE));
        this.isVarPar = true;
        this.readParameterMapping.clear();
        this.writeParameterMapping.clear();
        this.addParameterMappings(this.inputParameters, this.readParameterMapping, ActivityConstants.AccessType.READ);
        this.addParameterMappings(this.outputParameters, this.writeParameterMapping, ActivityConstants.AccessType.WRITE);
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public ExecutableBusinessProcess createChangedEBP() {
        Map userAttributes;
        Template pluginData;
        ExecutionControlProperties executionControlProperties;
        Configuration conf = null;
        Configuration testConf = null;
        ProcessModelFactory pmf = Activator.getService().getProcessModelFactory();
        if (this.oldLWP != null) {
            conf = this.oldLWP.getConfiguration();
            testConf = this.oldLWP.getTestConfiguration();
            executionControlProperties = this.oldLWP.getExecutionControlProperties();
            pluginData = this.oldLWP;
            userAttributes = this.oldLWP.getUserAttributes();
        } else {
            executionControlProperties = new ExecutionControlProperties(true, false, false);
            pluginData = this.template;
            userAttributes = this.template.getUserAttributes();
        }
        EmbeddedProcess ebp = null;
        switch (this.templateUsage) {
            case EMBEDDED: {
                ebp = pmf.createEmbeddedProcess(this.template, this.nodeData.getProcessTemplate().getID(), null, conf, testConf, executionControlProperties, (PluginDataContainer)pluginData, userAttributes);
                break;
            }
            case REFERENCED: {
                ebp = pmf.createReferencedProcess(this.template.getID(), false, conf, testConf, executionControlProperties, this.getParameters(ActivityConstants.AccessType.READ), this.getParameters(ActivityConstants.AccessType.WRITE), (PluginDataContainer)pluginData, userAttributes);
                break;
            }
            case FORKED: {
                ebp = pmf.createReferencedProcess(this.template.getID(), true, conf, testConf, executionControlProperties, this.getParameters(ActivityConstants.AccessType.READ), this.getParameters(ActivityConstants.AccessType.WRITE), (PluginDataContainer)pluginData, userAttributes);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported template usage type");
            }
        }
        if (this.isVariableParallelism()) {
            ebp = pmf.createVariableParallelismEBP((LightWeightProcess)ebp, this.getIndexedInputParameters(), conf, testConf, executionControlProperties, this.getInputParameters(), this.getOutputParameters(), (PluginDataContainer)pluginData, userAttributes);
        }
        return ebp;
    }

    @Override
    public PossibleTemplateUsage getTemplateUsage() {
        return this.templateUsage;
    }

    @Override
    public Set<PossibleTemplateUsage> getPossibleTemplateUsageValues() {
        HashSet<PossibleTemplateUsage> possibleUsage = new HashSet<PossibleTemplateUsage>();
        if (this.isEmbeddedAllowed()) {
            possibleUsage.add(PossibleTemplateUsage.EMBEDDED);
        }
        if (this.isReferencedAllowed()) {
            possibleUsage.add(PossibleTemplateUsage.REFERENCED);
        }
        if (this.isForkedAllowed()) {
            possibleUsage.add(PossibleTemplateUsage.FORKED);
        }
        return possibleUsage;
    }

    @Override
    public void setTemplateUsage(PossibleTemplateUsage templateUsage) {
        this.templateUsage = templateUsage;
    }

    @Override
    public boolean noUsage() {
        return this.noUsage;
    }

    private boolean isEmbeddedAllowed() {
        boolean allowed = false;
        if (this.templateStatus != null) {
            allowed = this.templateStatus.getUsageAsSubprocess().equals((Object)ProcessConstants.TemplateUsage.AS_COPY) || this.templateStatus.getUsageAsSubprocess().equals((Object)ProcessConstants.TemplateUsage.COPY_OR_REFERENCE);
        } else if (this.oldLWP == null || this.oldLWP instanceof EmbeddedProcess) {
            allowed = true;
        }
        return allowed;
    }

    private boolean isReferencedAllowed() {
        boolean allowed = false;
        if (this.templateStatus != null) {
            allowed = this.templateStatus.getUsageAsSubprocess().equals((Object)ProcessConstants.TemplateUsage.AS_REFERENCE) || this.templateStatus.getUsageAsSubprocess().equals((Object)ProcessConstants.TemplateUsage.COPY_OR_REFERENCE);
        } else if (this.oldLWP instanceof ReferencedProcess) {
            allowed = !((ReferencedProcess)this.oldLWP).fork();
        }
        return allowed;
    }

    private boolean isForkedAllowed() {
        boolean allowed = false;
        if (this.templateStatus != null) {
            allowed = this.templateStatus.isTopLevelUsable();
        } else if (this.oldLWP instanceof ReferencedProcess) {
            allowed = ((ReferencedProcess)this.oldLWP).fork();
        }
        return allowed;
    }

    @Override
    public Set<ProcessModelParameter> getParameters(ActivityConstants.AccessType accessType) {
        if (!this.isVariableParallelism()) {
            return super.getParameters(accessType);
        }
        switch (accessType) {
            case READ: 
            case WRITE: {
                return new HashSet<ProcessModelParameter>(this.template.getParameters(accessType));
            }
            case SYSTEM_READ: 
            case SYSTEM_WRITE: {
                String message = String.format("Only activity related values are allowed here, %s may not be used for activities", accessType);
                throw new IllegalArgumentException(message);
            }
        }
        throw new AssertionError((Object)"An unknown access type was found!");
    }

    @Override
    public Set<ProcessModelParameter> getIndexedInputParameters() {
        return this.indexedParameters;
    }

    @Override
    public boolean isVariableParallelism() {
        return this.isVarPar;
    }

    @Override
    public Set<ProcessModelParameter> getInputParameters() {
        return this.inputParameters;
    }

    @Override
    public Set<ProcessModelParameter> getOutputParameters() {
        return this.outputParameters;
    }

    @Override
    public void setInputParameters(Set<ProcessModelParameter> inputParameters) {
        this.inputParameters = new HashSet<ProcessModelParameter>(inputParameters);
    }

    @Override
    public void setOutputParameters(Set<ProcessModelParameter> outputParameters) {
        for (ProcessModelParameter param : outputParameters) {
            if (param.getDataType().equals((Object)ProcessConstants.AdeptDataType.USERDEFINED) && param.getUDTName().startsWith("java.util.List")) continue;
            throw new IllegalArgumentException("The given set of output parameters contains parameter types other than USERDEFINED and a starting UDTName of java.util.List");
        }
        this.outputParameters = new HashSet<ProcessModelParameter>(outputParameters);
    }

    @Override
    public void setIndexedInputParameters(Set<ProcessModelParameter> indexedInputParameters) {
        this.indexedParameters = indexedInputParameters;
    }

    @Override
    public void setVariableParallelism(boolean isVarPar) {
        this.isVarPar = isVarPar;
    }

    public static enum PossibleTemplateUsage {
        EMBEDDED,
        REFERENCED,
        FORKED;

    }
}

