/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.templatemanagerview;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.processmanager.TemplateManager;
import de.aristaflow.adept2.model.filter.AttributeFactory;
import de.aristaflow.adept2.model.filter.ComparisonOperator;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.filter.UnaryFilter;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.ui.dialogues.CheckReportDialogue;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.TemplateStatusEditor;
import de.aristaflow.adept2.ui.processediting.TemplateStatusProcessManagerInput;
import de.aristaflow.adept2.ui.processediting.dnd.UUIDTransfer;
import de.aristaflow.adept2.ui.processlistview.TemplateListView;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.ui.util.list.AdeptFilterWrapper;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.w3c.dom.Document;

public final class TemplateManagerView
extends TemplateListView {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".views.TemplateManagerView";
    protected final int dragOperations = 1;
    protected final Transfer[] dragTransferTypes = new Transfer[]{UUIDTransfer.getInstance()};
    protected final Transfer[] dropTransferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
    protected boolean showOutdated = false;
    protected final TemplateManager templateManager = Activator.getService().getProcessManager().getTemplateManager();

    public void setMessage(String message) {
    }

    public void updateInput() {
        if (this.templateManager == null) {
            return;
        }
        SessionToken session = Activator.getService().getSessionToken();
        this.templates.clear();
        for (TemplateReference templateRef : this.templateManager.getAllTemplateReferences(session)) {
            if (!this.showOutdated) {
                if ((templateRef.getUsageAsSubprocess().equals((Object)ProcessConstants.TemplateUsage.NO_SUBPROCESS) || templateRef.isOutdated(true)) && (!templateRef.isTopLevelUsable() || templateRef.isOutdated(false))) continue;
                this.templates.add(templateRef);
                continue;
            }
            this.templates.add(templateRef);
        }
        this.viewer.setInput((Object)this.templates);
    }

    public void createPartControl(final Composite parent) {
        super.createPartControl(parent);
        FilterFactory filterFac = Activator.getService().getFilterFactory();
        AttributeFactory afTempl = filterFac.createAttributeFactory(TemplateReference.class);
        UnaryFilter subprocessFilter = filterFac.createNotFilter((Filter)filterFac.createComparisonFilter(afTempl.selectAttribute("getUsageAsSubprocess"), ComparisonOperator.EQUALS, (Comparable)ProcessConstants.TemplateUsage.NO_SUBPROCESS));
        this.viewer.registerFilter("subprocess", "Subprocess Usable", (ViewerFilter)new AdeptFilterWrapper((Filter)subprocessFilter));
        final ResourceBundle messages = ResourceBundle.getBundle("de.aristaflow.adept2.ui.templatemanagerview.TMVBundle", Activator.getService().getActiveAgent().getLocale());
        DragSource ds = new DragSource(this.viewer.getColumnViewer().getControl(), 1);
        ds.setTransfer(this.dragTransferTypes);
        ds.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                TemplateReference entry = (TemplateReference)TemplateManagerView.this.getSelection().getFirstElement();
                event.data = entry.getID();
            }
        });
        DropTarget dt = new DropTarget(this.viewer.getColumnViewer().getControl(), 1);
        dt.setTransfer(this.dropTransferTypes);
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                if (!(event.data instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)event.data;
                Iterator it = selection.iterator();
                while (it.hasNext()) {
                    Document templateDoc;
                    InputStream inputStream;
                    try {
                        IFile file = (IFile)it.next();
                        if (!file.getFileExtension().equals("template")) {
                            MessageBox mb = new MessageBox(new Shell(), 1);
                            mb.setMessage(messages.getString("TMVMessage1"));
                            mb.open();
                            continue;
                        }
                        inputStream = file.getContents();
                    }
                    catch (CoreException e) {
                        TemplateManagerView.this.logger.log(Level.SEVERE, "Error while trying to convert the selection into an input stream.", e);
                        throw new RuntimeException(e);
                    }
                    ProcessModelFactory pmf = Activator.getService().getProcessModelFactory();
                    ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(pmf);
                    try {
                        templateDoc = XMLHelperTools.getDocumentFromStream((InputStream)inputStream);
                    }
                    catch (XMLFormatException e) {
                        TemplateManagerView.this.logger.log(Level.SEVERE, "The format of the xml file is not correct.", e);
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        TemplateManagerView.this.logger.log(Level.SEVERE, "Error while trying to read the input stream.", e);
                        throw new RuntimeException(e);
                    }
                    Template template = xmlImport.getTemplateFromDocument(templateDoc);
                    TemplateStatus templateStatus = null;
                    try {
                        templateStatus = xmlImport.getTemplateStatusFromDocument(templateDoc);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    if (templateStatus == null) {
                        templateStatus = pmf.createDefaultTemplateStatus(template.getID());
                    } else {
                        Node startNode = template.getStartNode();
                        int[] successors = template.getSuccByEdgeType(startNode.getID(), new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL});
                        Node secondNode = template.getNode(successors[0]);
                        if (secondNode.isAutoStartEnabled()) {
                            templateStatus.setSubprocessUsage(ProcessConstants.TemplateUsage.NO_SUBPROCESS);
                        }
                    }
                    SessionToken session = Activator.getService().getSessionToken();
                    try {
                        CheckReport checkReport = TemplateManagerView.this.templateManager.storeNewTemplate(session, template, templateStatus);
                        if (checkReport.getCheckResult().ordinal() >= CheckReport.ResultType.WARNING.ordinal()) {
                            new CheckReportDialogue(parent.getShell(), checkReport, messages.getString("TMVMessage4"), 8, CheckReport.ResultType.WARNING).open();
                        } else {
                            new CheckReportDialogue(parent.getShell(), checkReport, messages.getString("TMVMessage5"), 2, CheckReport.ResultType.INFO).open();
                        }
                    }
                    catch (RuntimeException e) {
                        StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)messages.getString("TMVMessage2"), (Throwable)e);
                        throw e;
                    }
                    TemplateManagerView.this.updateInput();
                }
            }
        });
        this.viewer.getColumnViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = TemplateManagerView.this.viewer.getColumnViewer().getSelection();
                if (selection.isEmpty() || !(selection instanceof IStructuredSelection) || ((IStructuredSelection)selection).size() > 1) {
                    return;
                }
                TemplateReference templateEntry = (TemplateReference)((IStructuredSelection)selection).getFirstElement();
                UUID templateID = templateEntry.getID();
                String templateName = templateEntry.getName();
                ProcessManager processManager = Activator.getService().getProcessManager();
                TemplateStatusProcessManagerInput input = new TemplateStatusProcessManagerInput(processManager, templateID, templateName);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)input, TemplateStatusEditor.ID);
                }
                catch (PartInitException e) {
                    String message = "Could not instantiate editor for the template status.";
                    StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
                }
            }
        });
    }

    public boolean showOutdated() {
        return this.showOutdated;
    }

    public void setShowOutdated(boolean showOutdated) {
        this.showOutdated = showOutdated;
        this.updateInput();
    }

    protected FormToolkit initToolkit(Composite parent) {
        return new FormToolkit(parent.getDisplay());
    }

    public String getID() {
        return ID;
    }
}

