/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.actions;

import de.aristaflow.adept2.core.checks.processmodel.ProcessCheckService;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheckRunner;
import de.aristaflow.adept2.core.timemanager.TimeManager;
import de.aristaflow.adept2.core.timemanager.TimeModellingService;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.timemodel.InconsistencyException;
import de.aristaflow.adept2.model.timemodel.TemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableTCN;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.NodeMapping;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNEdge;
import de.aristaflow.adept2.model.timemodel.tcn.TCNInconsistencyException;
import de.aristaflow.adept2.model.timemodel.tcn.TCNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.TCNAlgorithms;
import de.aristaflow.adept2.ui.dialogues.CheckReportDialogue;
import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processvisualisation.preferences.LocalTimeModellingService;
import de.aristaflow.adept2.ui.processvisualisation.preferences.TimeModelPreferences;
import de.aristaflow.adept2.ui.processvisualisation.timeconstraints.Activator;
import de.aristaflow.adept2.util.CheckReport;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.progress.IProgressService;

public class CheckConsistencyAction
implements IEditorActionDelegate {
    private IEditorPart activeEditor;
    private TimeManager timeManager;

    public void run(IAction action) {
        if (this.activeEditor instanceof Editor) {
            CheckReport checkReport;
            Template template;
            Editor editor = (Editor)this.activeEditor;
            if (editor.isDirty()) {
                String title = "Unsaved Changes";
                String msg = "The template in the editor contains changes. Do you want to save them before creating the time model?";
                String[] buttonLabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                MessageDialog dlg = new MessageDialog(this.activeEditor.getEditorSite().getShell(), title, null, msg, 3, buttonLabels, 0);
                int returnCode = dlg.open();
                switch (returnCode) {
                    case 0: {
                        this.activeEditor.getSite().getPage().saveEditor((IEditorPart)editor, false);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            ProcessCheckService processChecks = Activator.getModellingClientService().getProcessChecks();
            ProcessTemplateCheckRunner testClientChecks = new ProcessTemplateCheckRunner(new ProcessTemplateCheck[]{processChecks.getConsistencyChecks(), processChecks.getStructureChecks(), processChecks.getBasicModellingChecks()});
            boolean result = testClientChecks.performCheck(template = editor.getTemplate(), new NodeRelations(template), checkReport = new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)template, (String)"localhost")));
            if (!result) {
                Shell shell = this.activeEditor.getEditorSite().getShell();
                String message = "Template does not fulfil basic checks, aborting!";
                CheckReportDialogue dialog = new CheckReportDialogue(shell, checkReport, message, 1, CheckReport.ResultType.WARNING);
                dialog.open();
                if (checkReport.getCheckResult().compareTo((Enum)CheckReport.ResultType.WARNING) > 0) {
                    return;
                }
            }
            TimeModelPreferences preferences = new TimeModelPreferences();
            final LocalTimeModellingService timeModellingService = new LocalTimeModellingService(this.getTimeManager(), preferences);
            IProgressService ps = this.getProgressService();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    monitor.beginTask("Checking Consistency", -1);
                    try {
                        try {
                            CheckConsistencyAction.this.checkConsistency(template, timeModellingService, monitor);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e, "An error occurred");
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                ps.run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Unexpected Error", (String)"An unexpected error occurred while checking consistency of the process model!", (IStatus)new Status(4, "de.aristaflow.adept2.ui.processvisualisation.timeconstraints", e.getMessage(), (Throwable)e));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void showOKMessage() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Consistency Check", (String)"The process model is consistent!");
            }
        });
    }

    protected <N extends TCNTimePoint, E extends TCNEdge<N, ?>> void showInconsistencyException(final InconsistencyException e, final Template template, final TCNTemplateTimeModel<N, E> templateTimeModel) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String message = e.getMessage();
                if (e instanceof TCNInconsistencyException) {
                    TCNInconsistencyException ex = (TCNInconsistencyException)e;
                    TCNTimePoint startEvent = ex.getStartEvent();
                    TCNTimePoint endEvent = ex.getEndEvent();
                    TCNTimePoint intermediateEvent = ex.getIntermediateEvent();
                    NodeMapping startNodeMapping = templateTimeModel.getNodeMapping(startEvent);
                    NodeMapping endNodeMapping = templateTimeModel.getNodeMapping(endEvent);
                    String startNodeName = CheckConsistencyAction.this.getNodeName(template, startNodeMapping);
                    String startInstant = CheckConsistencyAction.this.eventIDToInstant(startEvent.getEventID());
                    String endNodeName = CheckConsistencyAction.this.getNodeName(template, endNodeMapping);
                    String endInstant = CheckConsistencyAction.this.eventIDToInstant(startEvent.getEventID());
                    if (intermediateEvent != null) {
                        NodeMapping intermediateNodeMapping = templateTimeModel.getNodeMapping(intermediateEvent);
                        String intermediateNodeName = CheckConsistencyAction.this.getNodeName(template, intermediateNodeMapping);
                        String intermediateInstant = CheckConsistencyAction.this.eventIDToInstant(intermediateEvent.getEventID());
                        message = String.format("The constraint between the %2$s of '%1$s' and the %4$s of '%3$s' is not consistent with the constraints form the %2$s of '%1$s' via the %6$s of '%5$s' to the %4$s of '%3$s'.", startNodeName, startInstant, endNodeName, endInstant, intermediateNodeName, intermediateInstant);
                    } else {
                        message = String.format("The constraint between the %2$s of '%1$s' and the %4$s of '%3$s' is not consistent with the remaining process.", startNodeName, startInstant, endNodeName, endInstant);
                    }
                }
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Consistency Check", (String)"The process model is inconsistent!", (IStatus)new Status(4, "de.aristaflow.adept2.ui.processvisualisation.timeconstraints", message, (Throwable)e));
            }
        });
    }

    private String getNodeName(Template template, NodeMapping<?> nodeMapping) {
        int startNodeID = nodeMapping.getNodeInstance().getNodeID();
        if (startNodeID >= 0) {
            Node node = template.getNode(startNodeID);
            String nodeName = node.getName();
            if (nodeName == null || nodeName.isEmpty()) {
                nodeName = "#" + node.getID();
            }
            return nodeName;
        }
        return "origin";
    }

    protected String eventIDToInstant(String eventID) {
        if (eventID.equals("S")) {
            return "start";
        }
        if (eventID.equals("E")) {
            return "end";
        }
        if (eventID.equals("C")) {
            return "end";
        }
        return "unkown";
    }

    private IProgressService getProgressService() {
        return this.activeEditor.getSite().getWorkbenchWindow().getWorkbench().getProgressService();
    }

    TimeManager getTimeManager() {
        if (this.timeManager == null) {
            this.timeManager = Activator.getTimeManager();
        }
        return this.timeManager;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.activeEditor = targetEditor;
    }

    protected void checkConsistency(Template template, TimeModellingService timeModellingService, IProgressMonitor monitor) throws Exception {
        TemplateTimeModel templateTimeModel = timeModellingService.createTimeModelForTemplate(template);
        monitor.worked(1);
        try {
            TCNTemplateTimeModel tcnTemplateTimeModel = (TCNTemplateTimeModel)templateTimeModel;
            TCN cstnu = tcnTemplateTimeModel.getBaseTimeModel();
            try {
                this.doCheckConsistency(monitor, (TCN<LabeledTimePoint, LabeledEdge>)cstnu);
                this.showOKMessage();
            }
            catch (InconsistencyException e) {
                this.showInconsistencyException(e, template, tcnTemplateTimeModel);
            }
        }
        catch (Exception e) {
            monitor.setCanceled(false);
            throw e;
        }
    }

    protected void doCheckConsistency(IProgressMonitor monitor, TCN<LabeledTimePoint, LabeledEdge> cstnu) throws InterruptedException, InconsistencyException {
        TCNSolver solver = TCNAlgorithms.getSolver(cstnu);
        try {
            ChangeableTCN result = (ChangeableTCN)cstnu.clone();
            monitor.worked(1);
            try {
                solver.solve(result);
            }
            finally {
                monitor.worked(10);
            }
        }
        catch (InconsistencyException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
    }
}

