/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.preferences;

import de.aristaflow.adept2.core.timemanager.ScheduleEvaluation;
import de.aristaflow.adept2.core.timemanager.ScheduleResolutionException;
import de.aristaflow.adept2.model.common.timedata.CalendarElement;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultCalendarElement;
import de.aristaflow.adept2.model.timemodel.Schedule;
import de.aristaflow.adept2.model.timemodel.ScheduleInterval;
import de.aristaflow.adept2.model.timemodel.ScheduleIntervalSet;
import de.aristaflow.adept2.ui.processvisualisation.timeconstraints.Activator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CustomCalendarDialog
extends TitleAreaDialog {
    private Text calendarName;
    private Text scheduleText;
    private Text scheduleEvaluation;
    private Button btnEvaluate;
    DateFormat format = new SimpleDateFormat("dd.MM.yy HH:mm:ss");
    private DateTime untilDate;
    private DateTime fromDate;
    private String id;
    private Schedule schedule;

    protected CustomCalendarDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Custom Calendar");
    }

    public String getID() {
        return this.id;
    }

    private String getRule() {
        return this.scheduleText.getText();
    }

    private Schedule internalGetSchedule() {
        ScheduleEvaluation scheduleEvaluation = this.getScheduleEvaluation();
        Schedule schedule = null;
        try {
            schedule = scheduleEvaluation.parseSchedule(this.getRule());
        }
        catch (ScheduleResolutionException e) {
            this.setErrorMessage(e.getMessage());
        }
        return schedule;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Custom Calender");
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblCalendarName = new Label(composite, 0);
        lblCalendarName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCalendarName.setText("Calendar Name");
        this.calendarName = new Text(composite, 2048);
        this.calendarName.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.text != null && e.text.length() > 1) {
                    StringBuilder s = new StringBuilder();
                    char[] cArray = e.text.toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        if (Character.isLetter(c) || Character.isDigit(c)) {
                            s.append(c);
                        }
                        ++n2;
                    }
                    e.text = s.toString();
                } else {
                    e.doit = Character.isLetter(e.character) || Character.isDigit(e.character);
                }
            }
        });
        this.calendarName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblRule = new Label(composite, 0);
        lblRule.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblRule.setText("Rule");
        this.scheduleText = new Text(composite, 2114);
        this.scheduleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomCalendarDialog.this.setPageComplete(CustomCalendarDialog.this.validatePageComplete());
            }
        });
        GridData gd_text_1 = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_text_1.heightHint = 75;
        this.scheduleText.setLayoutData((Object)gd_text_1);
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 2));
        group.setText("Evaluate");
        group.setLayout((Layout)new GridLayout(6, false));
        this.btnEvaluate = new Button((Composite)group, 0);
        this.btnEvaluate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomCalendarDialog.this.evaluate();
            }
        });
        this.btnEvaluate.setText("Evaluate");
        this.btnEvaluate.setEnabled(false);
        Label label = new Label((Composite)group, 0);
        GridData gd_label = new GridData(131072, 0x1000000, true, false, 1, 1);
        gd_label.minimumWidth = 60;
        label.setLayoutData((Object)gd_label);
        label.setText("Range:");
        Label label_1 = new Label((Composite)group, 0);
        label_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label_1.setText("From");
        this.fromDate = new DateTime((Composite)group, 2052);
        this.fromDate.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        Label label_2 = new Label((Composite)group, 0);
        label_2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label_2.setText("Until");
        this.untilDate = new DateTime((Composite)group, 2052);
        this.untilDate.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.scheduleEvaluation = new Text((Composite)group, 2570);
        GridData gd_text_2 = new GridData(4, 0x1000000, true, true, 6, 1);
        gd_text_2.heightHint = 80;
        this.scheduleEvaluation.setLayoutData((Object)gd_text_2);
        return composite;
    }

    protected void evaluate() {
        ScheduleIntervalSet evaluatedSchedule;
        Schedule schedule;
        ScheduleEvaluation scheduleEvaluation = Activator.getTimeManager().getTimeModellingService().getScheduleEvaluation();
        try {
            schedule = scheduleEvaluation.parseSchedule(this.getRule());
            this.scheduleEvaluation.setText(schedule.toString());
        }
        catch (ScheduleResolutionException e) {
            this.scheduleEvaluation.setText(e.getMessage());
            return;
        }
        try {
            evaluatedSchedule = scheduleEvaluation.evaluateSchedule(schedule, this.getCalendarElement(this.fromDate), this.getCalendarElement(this.untilDate));
        }
        catch (ScheduleResolutionException e) {
            this.scheduleEvaluation.setText(e.getMessage());
            return;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < evaluatedSchedule.getSize()) {
            ScheduleInterval interval = evaluatedSchedule.getInterval(i);
            builder.append("[" + this.toString(interval.getFrom()) + ", " + this.toString(interval.getTo()) + "]");
            builder.append("\n");
            ++i;
        }
        this.scheduleEvaluation.setText(builder.toString());
    }

    private String toString(CalendarElement cal) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(cal.getTimeInMillis());
        return this.format.format(calendar.getTime());
    }

    public void setPageComplete(boolean complete) {
        this.getButton(0).setEnabled(complete);
        this.btnEvaluate.setEnabled(complete);
    }

    protected boolean validatePageComplete() {
        if (this.scheduleText.getText().trim().equals("")) {
            this.setErrorMessage("Please provide a valid schedule");
            return false;
        }
        ScheduleEvaluation scheduleEvaluation = this.getScheduleEvaluation();
        try {
            Schedule schedule = scheduleEvaluation.parseSchedule(this.getRule());
            CalendarElement now = this.getCalendarElement(Calendar.getInstance());
            scheduleEvaluation.evaluateSchedule(schedule, now, now);
        }
        catch (ScheduleResolutionException e) {
            this.setErrorMessage("Invalid Schedule: " + e.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private ScheduleEvaluation getScheduleEvaluation() {
        ScheduleEvaluation scheduleEvaluation = Activator.getTimeManager().getTimeModellingService().getScheduleEvaluation();
        return scheduleEvaluation;
    }

    private CalendarElement getCalendarElement(Calendar calendar) {
        return new DefaultCalendarElement(calendar.getTimeInMillis());
    }

    private CalendarElement getCalendarElement(DateTime datePicker) {
        Calendar calendar = this.getCalendar(datePicker);
        return this.getCalendarElement(calendar);
    }

    private Calendar getCalendar(DateTime datePicker) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, datePicker.getYear());
        cal.set(2, datePicker.getMonth());
        cal.set(5, datePicker.getDay());
        cal.set(11, datePicker.getHours());
        cal.set(12, datePicker.getMinutes());
        cal.set(13, datePicker.getSeconds());
        return cal;
    }

    protected void okPressed() {
        this.id = this.calendarName.getText();
        this.schedule = this.internalGetSchedule();
        super.okPressed();
    }

    public int open(String id, Schedule schedule) {
        this.id = id;
        this.schedule = schedule;
        return super.open();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.init();
        return contents;
    }

    private void init() {
        if (this.id != null) {
            this.calendarName.setText(this.id);
            this.calendarName.setEnabled(false);
        }
        if (this.schedule != null) {
            this.scheduleText.setText(this.schedule.getRule());
        }
        this.setPageComplete(this.validatePageComplete());
        this.setErrorMessage(null);
    }
}

