/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.preferences;

import de.aristaflow.adept2.core.timemanager.ScheduleManager;
import de.aristaflow.adept2.model.timemodel.Schedule;
import de.aristaflow.adept2.ui.processvisualisation.preferences.CustomCalendarDialog;
import de.aristaflow.adept2.util.DataSourceException;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class CustomCalendarsDialog
extends TitleAreaDialog {
    private ListViewer listViewer;
    private ScheduleManager scheduleManager;
    private List list;
    private Button btnRemove;

    public CustomCalendarsDialog(Shell parent) {
        super(parent);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Custom Calendars");
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Custom Calendars");
        this.setMessage("Create or edit custom calendars.");
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.listViewer = new ListViewer(composite, 2560);
        this.list = this.listViewer.getList();
        this.list.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.listViewer.setContentProvider((IContentProvider)new CalendarContentProvider());
        Composite buttonBar = new Composite(composite, 0);
        GridLayout gl_buttonBar = new GridLayout(1, false);
        gl_buttonBar.marginHeight = 0;
        gl_buttonBar.marginWidth = 0;
        buttonBar.setLayout((Layout)gl_buttonBar);
        buttonBar.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Button btnAdd = new Button(buttonBar, 0);
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomCalendarDialog dialog = new CustomCalendarDialog(CustomCalendarsDialog.this.getShell());
                if (dialog.open() == 0) {
                    String id = dialog.getID();
                    Schedule schedule = dialog.getSchedule();
                    try {
                        CustomCalendarsDialog.this.scheduleManager.addCustomCalendar(id, schedule);
                        CustomCalendarsDialog.this.listViewer.setInput((Object)CustomCalendarsDialog.this.scheduleManager.getKnownCustomCalendars());
                    }
                    catch (DataSourceException e1) {
                        String msg = "Error retrieving Custom Calendar.";
                        Status status = new Status(4, "TimeConstraintsPlugin", e1.getMessage(), (Throwable)e1);
                        ErrorDialog.openError((Shell)CustomCalendarsDialog.this.getShell(), (String)"Error while saving!", (String)msg, (IStatus)status);
                    }
                }
            }
        });
        btnAdd.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnAdd.setText("Add");
        this.btnRemove = new Button(buttonBar, 0);
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)CustomCalendarsDialog.this.listViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof String) {
                    String id = (String)element;
                    try {
                        CustomCalendarsDialog.this.scheduleManager.removeCustomCalendar(id);
                    }
                    catch (DataSourceException e1) {
                        String msg = "Error removing Custom Calendar.";
                        Status status = new Status(4, "TimeConstraintsPlugin", e1.getMessage(), (Throwable)e1);
                        ErrorDialog.openError((Shell)CustomCalendarsDialog.this.getShell(), (String)"Error while saving!", (String)msg, (IStatus)status);
                    }
                }
            }
        });
        this.btnRemove.setEnabled(false);
        this.btnRemove.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnRemove.setText("Remove");
        final Button btnEdit = new Button(buttonBar, 0);
        btnEdit.setEnabled(false);
        btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)CustomCalendarsDialog.this.listViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof String) {
                    try {
                        String id = (String)element;
                        Schedule schedule = (Schedule)CustomCalendarsDialog.this.scheduleManager.getKnownCustomCalendars().get(id);
                        CustomCalendarDialog dialog = new CustomCalendarDialog(CustomCalendarsDialog.this.getShell());
                        if (dialog.open(id, schedule) == 0) {
                            schedule = dialog.getSchedule();
                            CustomCalendarsDialog.this.scheduleManager.addCustomCalendar(id, schedule);
                            CustomCalendarsDialog.this.listViewer.setInput((Object)CustomCalendarsDialog.this.scheduleManager.getKnownCustomCalendars());
                        }
                    }
                    catch (DataSourceException e1) {
                        String msg = "Error retrieving Custom Calendar.";
                        Status status = new Status(4, "TimeConstraintsPlugin", e1.getMessage(), (Throwable)e1);
                        ErrorDialog.openError((Shell)CustomCalendarsDialog.this.getShell(), (String)"Error while saving!", (String)msg, (IStatus)status);
                    }
                }
            }
        });
        btnEdit.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnEdit.setText("Edit");
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                btnEdit.setEnabled(true);
                CustomCalendarsDialog.this.btnRemove.setEnabled(true);
            }
        });
        try {
            this.listViewer.setInput((Object)this.scheduleManager.getKnownCustomCalendars());
        }
        catch (DataSourceException e1) {
            String msg = "Error retrieving Custom Calendar.";
            Status status = new Status(4, "TimeConstraintsPlugin", e1.getMessage(), (Throwable)e1);
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error while saving!", (String)msg, (IStatus)status);
        }
        return composite;
    }

    public void init(ScheduleManager scheduleManager) {
        this.scheduleManager = scheduleManager;
    }

    public int open(ScheduleManager scheduleManager) {
        return super.open();
    }

    public class CalendarContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Map map = (Map)inputElement;
            return map.keySet().toArray();
        }
    }
}

