/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.preferences;

import de.aristaflow.adept2.core.timemanager.ScheduleEvaluation;
import de.aristaflow.adept2.core.timemanager.ScheduleManager;
import de.aristaflow.adept2.core.timemanager.TimeManager;
import de.aristaflow.adept2.core.timemanager.TimeModellingService;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.timemodel.TemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.ui.processvisualisation.preferences.TimeModelPreferences;

public class LocalTimeModellingService
implements TimeModellingService {
    private TimeManager timeManager;
    private TimeModellingService globalTimeModellingService;
    private TimeModelPreferences preferences;

    public LocalTimeModellingService(TimeManager timeManager, TimeModelPreferences preferences) {
        this.timeManager = timeManager;
        this.preferences = preferences;
        this.globalTimeModellingService = this.timeManager.getTimeModellingService();
    }

    public TemplateTimeModel createTimeModelForTemplate(Template template) {
        TemporalTemplate temporalTemplate = this.getTimeModelFactory().createTemporalTemplate(template);
        TemplateTimeModel timeModel = this.getTimeModelFactory().createTimeModelForTemplate(temporalTemplate);
        return timeModel;
    }

    public TimeModelFactory getTimeModelFactory() {
        if (this.preferences.isUseDefault()) {
            return this.globalTimeModellingService.getTimeModelFactory();
        }
        return this.preferences.getTimeModelFactory();
    }

    public ScheduleEvaluation getScheduleEvaluation() {
        return this.globalTimeModellingService.getScheduleEvaluation();
    }

    public ScheduleManager getScheduleManager() {
        return this.globalTimeModellingService.getScheduleManager();
    }
}

