/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.preferences;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class TimeDistanceFieldEditor
extends FieldEditor {
    private Spinner sp_min;
    private Spinner sp_sec;
    private Spinner sp_milis;
    private Composite composite;
    private TimeDistance defaults;
    private Label lblM;
    private Label lblS;
    private Label lblMs;
    private Button btnInfinity;
    private boolean enabled = true;

    public TimeDistanceFieldEditor(String name, String labelText, Composite parent, TimeDistance defaults) {
        super(name, labelText, parent);
        this.defaults = defaults;
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.composite.getLayoutData()).horizontalSpan = numColumns;
        this.composite.layout();
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, false, numColumns, 1));
        GridLayout layout = new GridLayout(9, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite.setLayout((Layout)layout);
        Label labelControl = this.getLabelControl(this.composite);
        labelControl.setLayoutData((Object)new GridData(16384, 4, true, false, 1, 1));
        this.sp_min = new Spinner(this.composite, 2048);
        this.lblM = new Label(this.composite, 0);
        GridData gd_lblM = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblM.minimumWidth = 10;
        this.lblM.setLayoutData((Object)gd_lblM);
        this.lblM.setText("m");
        this.sp_sec = new Spinner(this.composite, 2048);
        this.lblS = new Label(this.composite, 0);
        GridData gd_lblS = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblS.minimumWidth = 10;
        this.lblS.setLayoutData((Object)gd_lblS);
        this.lblS.setText("s");
        this.sp_milis = new Spinner(this.composite, 2048);
        this.lblMs = new Label(this.composite, 0);
        GridData gd_lblMs = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblMs.minimumWidth = 10;
        this.lblMs.setLayoutData((Object)gd_lblMs);
        this.lblMs.setText("ms");
        new Label(this.composite, 0);
        this.btnInfinity = new Button(this.composite, 32);
        this.btnInfinity.setText("Infinity");
        this.btnInfinity.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TimeDistanceFieldEditor.this.setInfinity(TimeDistanceFieldEditor.this.btnInfinity.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void setInfinity(boolean infinity) {
        this.sp_milis.setEnabled(!infinity);
        this.sp_min.setEnabled(!infinity);
        this.sp_sec.setEnabled(!infinity);
    }

    protected void doLoad() {
        if (!this.getPreferenceStore().contains(this.getPreferenceName())) {
            this.doLoadDefault();
        } else {
            long milis = this.getPreferenceStore().getLong(this.getPreferenceName());
            DefaultTimeDistance td = new DefaultTimeDistance(milis, 0L, 0L, 0L, 0L, 0L);
            this.setTimeDistance((TimeDistance)td);
        }
    }

    private void setTimeDistance(TimeDistance td) {
        this.sp_milis.setSelection((int)td.getMilliseconds());
        this.sp_sec.setSelection((int)td.getSeconds());
        this.sp_min.setSelection((int)td.getMinutes());
        if (td.isInfinity()) {
            this.btnInfinity.setSelection(true);
            this.setInfinity(true);
        }
    }

    protected void doLoadDefault() {
        if (this.defaults != null) {
            this.setTimeDistance(this.defaults);
        }
    }

    protected void doStore() {
        int milis = this.sp_milis.getSelection();
        int sec = this.sp_sec.getSelection();
        int min = this.sp_min.getSelection();
        Object td = this.btnInfinity.getSelection() ? DefaultTimeDistance.POSITIVE_INFINITE_TIME_DISTANCE : new DefaultTimeDistance((long)milis, (long)sec, (long)min, 0L, 0L, 0L);
        this.getPreferenceStore().setValue(this.getPreferenceName(), td.toMilliseconds());
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, this.composite);
        this.sp_milis.setEnabled(enabled);
        this.sp_min.setEnabled(enabled);
        this.sp_sec.setEnabled(enabled);
        this.lblM.setEnabled(enabled);
        this.lblMs.setEnabled(enabled);
        this.lblS.setEnabled(enabled);
        this.btnInfinity.setEnabled(enabled);
        if (enabled) {
            this.setInfinity(this.btnInfinity.getSelection());
        }
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

