/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.preferences;

import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimeDistance;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.model.timemodel.tcn.cstnImpl.CSTNTimeModelFactory;
import de.aristaflow.adept2.model.timemodel.tcn.cstnuImpl.CSTNUTimeModelFactory;
import de.aristaflow.adept2.ui.processvisualisation.timeconstraints.Activator;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class TimeModelPreferences
implements IPropertyChangeListener {
    public static final String P_USE_DEFAULT = "useDefault";
    public static final String P_TIME_MODEL = "timeModel";
    public static final String C_CSTNU_COOPIS = "cstnuCoopis";
    public static final String C_CSTNU = "cstnu";
    public static final String C_CSTN = "cstn";
    public static final String P_CONTROL_FLOW_MIN_TIME_LAG = "controlFlowMin";
    public static final String P_CONTROL_FLOW_MAX_TIME_LAG = "controlFlowMax";
    public static final String P_STRUCTURE_NODE_MIN_TIME_LAG = "structureFlowMin";
    public static final String P_STRUCTURE_NODE_MAX_TIME_LAG = "structureFlowMax";
    public static final String P_STRUCTURE_NODE_MIN_DURATION = "structureNodeMin";
    public static final String P_STRUCTURE_NODE_MAX_DURATION = "structureNodeMax";
    public static final String P_XORSPLIT_MAX_DURATION = "xorSplitMax";
    private static TimeModelPreferences instance;
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private TimeModelFactory timeModelFactory;

    public TimeModelPreferences() {
        this.store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public TimeModelFactory getTimeModelFactory() {
        if (this.timeModelFactory == null) {
            BaseConfiguration configuration = new BaseConfiguration();
            if (!this.isUseDefault()) {
                configuration.setProperty("TCNTransformation.ControlFlowMinTimeLag", (Object)this.getControlFlowMinTimeLag().toMilliseconds());
                configuration.setProperty("TCNTransformation.ControlFlowMaxTimeLag", (Object)this.getControlFlowMaxTimeLag().toMilliseconds());
                configuration.setProperty("TCNTransformation.StructureNodeMinTimeLag", (Object)this.getStructureNodeMinTimeLag().toMilliseconds());
                configuration.setProperty("TCNTransformation.StructureNodeMaxTimeLag", (Object)this.getStructureNodeMaxTimeLag().toMilliseconds());
                configuration.setProperty("TCNTransformation.StructureNodeMinDuration", (Object)this.getStructureNodeMinDuration().toMilliseconds());
                configuration.setProperty("TCNTransformation.StructureNodeMaxDuration", (Object)this.getStructureNodeMaxDuration().toMilliseconds());
                configuration.setProperty("TCNTransformation.XORSplitMaxDuration", (Object)this.getXORSplitMaxDuration().toMilliseconds());
            }
            switch (this.getTimeModelType()) {
                case CSTN: {
                    this.timeModelFactory = new CSTNTimeModelFactory((Configuration)configuration);
                    break;
                }
                case CSTNU: {
                    configuration.setProperty("TCNTransformation.AdvancedActivityTransformation", (Object)0);
                    this.timeModelFactory = new CSTNUTimeModelFactory((Configuration)configuration);
                    break;
                }
                default: {
                    configuration.setProperty("TCNTransformation.AdvancedActivityTransformation", (Object)1);
                    this.timeModelFactory = new CSTNUTimeModelFactory((Configuration)configuration);
                }
            }
        }
        return this.timeModelFactory;
    }

    public TimeModelType getTimeModelType() {
        String timeModel = this.store.getString(P_TIME_MODEL);
        if (C_CSTN.equals(timeModel)) {
            return TimeModelType.CSTN;
        }
        if (C_CSTNU_COOPIS.equals(timeModel)) {
            return TimeModelType.CSTNU_EXTENDED;
        }
        if (C_CSTNU.equals(timeModel)) {
            return TimeModelType.CSTNU;
        }
        return TimeModelType.CSTNU_EXTENDED;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.timeModelFactory = null;
    }

    public boolean isUseDefault() {
        return this.store.getBoolean(P_USE_DEFAULT);
    }

    public TimeDistance getControlFlowMinTimeLag() {
        long minTimeLag = this.store.getLong(P_CONTROL_FLOW_MIN_TIME_LAG);
        return this.secondsToTimeDistance(minTimeLag);
    }

    public TimeDistance getControlFlowMaxTimeLag() {
        long minTimeLag = this.store.getLong(P_CONTROL_FLOW_MAX_TIME_LAG);
        return this.secondsToTimeDistance(minTimeLag);
    }

    public TimeDistance getStructureNodeMinTimeLag() {
        long timeLag = this.store.getLong(P_STRUCTURE_NODE_MIN_TIME_LAG);
        return this.secondsToTimeDistance(timeLag);
    }

    public TimeDistance getStructureNodeMaxTimeLag() {
        long timeLag = this.store.getLong(P_STRUCTURE_NODE_MAX_TIME_LAG);
        return this.secondsToTimeDistance(timeLag);
    }

    public TimeDistance getStructureNodeMinDuration() {
        long duration = this.store.getLong(P_STRUCTURE_NODE_MIN_DURATION);
        return this.secondsToTimeDistance(duration);
    }

    public TimeDistance getStructureNodeMaxDuration() {
        long duration = this.store.getLong(P_STRUCTURE_NODE_MAX_DURATION);
        return this.secondsToTimeDistance(duration);
    }

    public TimeDistance getXORSplitMaxDuration() {
        long duration = this.store.getLong(P_XORSPLIT_MAX_DURATION);
        return this.secondsToTimeDistance(duration);
    }

    private TimeDistance secondsToTimeDistance(long milis) {
        return new DefaultTimeDistance(milis, 0L, 0L, 0L, 0L, 0L);
    }

    public static TimeModelPreferences getInstance() {
        if (instance == null) {
            instance = new TimeModelPreferences();
        }
        return instance;
    }

    public static enum TimeModelType {
        CSTN,
        CSTNU,
        CSTNU_EXTENDED;

    }
}

