/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.preferences;

import de.aristaflow.adept2.model.timemodel.tcn.TCNTransformation;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.AbstractTemplateTransformation;
import de.aristaflow.adept2.ui.processvisualisation.preferences.LabelFieldEditor;
import de.aristaflow.adept2.ui.processvisualisation.preferences.TimeDistanceFieldEditor;
import de.aristaflow.adept2.ui.processvisualisation.timeconstraints.Activator;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TimeModelPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    private ComboFieldEditor timeModelEditor;
    private LabelFieldEditor labelFieldEditor_1;
    private TimeDistanceFieldEditor controlFlowMin;
    private TimeDistanceFieldEditor controlFlowMax;
    private LabelFieldEditor labelFieldEditor;
    private TimeDistanceFieldEditor structureNodeMinTimeLag;
    private TimeDistanceFieldEditor structureNodeMaxTimeLag;
    private TimeDistanceFieldEditor structureNodeMinDuration;
    private TimeDistanceFieldEditor structureNodeMaxDuration;
    private BooleanFieldEditor useDefault;
    private TimeDistanceFieldEditor xorSplitMaxDuration;

    public TimeModelPreferencesPage() {
        super(1);
        this.setTitle("Time Model");
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Change the settings of the Time Model created for templates or instances.");
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("useDefault")) {
            Boolean bool = (Boolean)event.getNewValue();
            this.setUserDefined(bool == false);
        }
    }

    public void createFieldEditors() {
        this.useDefault = new BooleanFieldEditor("useDefault", "Use Default", 0, this.getFieldEditorParent()){

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                super.doFillIntoGrid(parent, numColumns);
                Button changeControl = this.getChangeControl(parent);
                changeControl.addSelectionListener((SelectionListener)TimeModelPreferencesPage.this);
            }
        };
        this.addField((FieldEditor)this.useDefault);
        this.addField(new LabelFieldEditor("", this.getFieldEditorParent()));
        this.timeModelEditor = new ComboFieldEditor("timeModel", "&Time Model", (String[][])new String[][]{{"CSTNU (extended)", "cstnuCoopis"}, {"CSTNU", "cstnu"}, {"CSTN", "cstn"}}, this.getFieldEditorParent());
        this.addField((FieldEditor)this.timeModelEditor);
        this.labelFieldEditor_1 = new LabelFieldEditor("Control-flow", this.getFieldEditorParent());
        this.addField(this.labelFieldEditor_1);
        this.controlFlowMin = new TimeDistanceFieldEditor("controlFlowMin", "Min time lag:", this.getFieldEditorParent(), TCNTransformation.DEFAULT_CONTROL_FLOW_MIN_TIME_LAG);
        this.addField(this.controlFlowMin);
        this.controlFlowMax = new TimeDistanceFieldEditor("controlFlowMax", "Max time lag:", this.getFieldEditorParent(), TCNTransformation.DEFAULT_CONTROL_FLOW_MAX_TIME_LAG);
        this.addField(this.controlFlowMax);
        this.labelFieldEditor = new LabelFieldEditor("Structure Nodes", this.getFieldEditorParent());
        this.addField(this.labelFieldEditor);
        this.structureNodeMinTimeLag = new TimeDistanceFieldEditor("structureFlowMin", "Min time lag:", this.getFieldEditorParent(), TCNTransformation.DEFAULT_STRUCTURE_NODE_MIN_TIME_LAG);
        this.addField(this.structureNodeMinTimeLag);
        this.structureNodeMaxTimeLag = new TimeDistanceFieldEditor("structureFlowMax", "Max time lag:", this.getFieldEditorParent(), TCNTransformation.DEFAULT_STRUCTURE_NODE_MAX_TIME_LAG);
        this.addField(this.structureNodeMaxTimeLag);
        this.structureNodeMinDuration = new TimeDistanceFieldEditor("structureNodeMin", "Min Duration:", this.getFieldEditorParent(), TCNTransformation.DEFAULT_STRUCTURE_NODE_MIN_DURATION);
        this.addField(this.structureNodeMinDuration);
        this.structureNodeMaxDuration = new TimeDistanceFieldEditor("structureNodeMax", "Max Duration:", this.getFieldEditorParent(), TCNTransformation.DEFAULT_STRUCTURE_NODE_MAX_DURATION);
        this.addField(this.structureNodeMaxDuration);
        this.xorSplitMaxDuration = new TimeDistanceFieldEditor("xorSplitMax", "XOR Max Duration:", this.getFieldEditorParent(), AbstractTemplateTransformation.DEFAULT_XORSPLIT_MAX_DURATION);
        this.addField(this.xorSplitMaxDuration);
        this.setUserDefined(false);
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        this.setUserDefined(!this.useDefault.getBooleanValue());
    }

    public void widgetSelected(SelectionEvent e) {
        Button b = (Button)e.getSource();
        this.setUserDefined(!b.getSelection());
    }

    private void setUserDefined(boolean userDefined) {
        this.timeModelEditor.setEnabled(userDefined, this.getFieldEditorParent());
        this.labelFieldEditor_1.setEnabled(userDefined, this.getFieldEditorParent());
        this.controlFlowMin.setEnabled(userDefined, this.getFieldEditorParent());
        this.controlFlowMax.setEnabled(userDefined, this.getFieldEditorParent());
        this.labelFieldEditor.setEnabled(userDefined, this.getFieldEditorParent());
        this.structureNodeMinTimeLag.setEnabled(userDefined, this.getFieldEditorParent());
        this.structureNodeMaxTimeLag.setEnabled(userDefined, this.getFieldEditorParent());
        this.structureNodeMinDuration.setEnabled(userDefined, this.getFieldEditorParent());
        this.structureNodeMaxDuration.setEnabled(userDefined, this.getFieldEditorParent());
        this.xorSplitMaxDuration.setEnabled(userDefined, this.getFieldEditorParent());
    }

    protected void performDefaults() {
        super.performDefaults();
        this.setUserDefined(false);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

