/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections;

import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.changeoperations.UpdatePluginDataContainer;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.timemodel.ConstraintEdgeTemporalInformation;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.parts.ConstraintEdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.AbstractConstraintEdgePropertySection;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.sections.TimeLagPropertySection;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class EdgeTimeConstraintsSection
extends AbstractPropertySection
implements ModifyListener {
    protected final Logger logger = LoggerTools.getLogger((Object)((Object)this));
    private ConstraintEdgeEditPart edgePart;
    Template template;
    Instance instance;
    private Form form;
    private AbstractConstraintEdgePropertySection timeLagPropertySection;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory toolkit = this.getWidgetFactory();
        this.form = toolkit.createForm(parent);
        this.form.setText("Time Lag");
        toolkit.decorateFormHeading(this.form);
        this.form.getBody().setLayout((Layout)new TableWrapLayout());
        this.timeLagPropertySection = new TimeLagPropertySection(this);
        this.timeLagPropertySection.createControls(this.form.getBody());
        this.timeLagPropertySection.addModifyListener(this);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof ConstraintEdgeEditPart));
        if (this.timeLagPropertySection == null || this.form.isDisposed()) {
            return;
        }
        if (this.isModified() && this.edgePart != null && this.isValidEditPart((EditPart)this.edgePart)) {
            this.commitChanges();
        }
        this.edgePart = (ConstraintEdgeEditPart)input;
        if (this.edgePart.getInstance() != null) {
            this.instance = this.edgePart.getInstance();
            this.template = this.instance.getTemplate();
        } else {
            this.template = this.edgePart.getTemplate();
            this.instance = null;
        }
        if (this.instance == null && !(this.template instanceof ChangeableTemplate) || this.instance != null && !(this.instance instanceof ChangeableInstance)) {
            this.form.setMessage("Read-only mode: Attributes of Template / Instance not changeable!");
            this.form.setEnabled(false);
        }
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (this.isValidEditPart((EditPart)this.edgePart) && this.isModified()) {
            this.commitChanges();
        }
    }

    private synchronized void commitChanges() {
        if (this.timeLagPropertySection == null) {
            return;
        }
        if (!this.isModified()) {
            this.logger.warning("calling commit without beeing modified");
        }
        ConstraintEdge edge = this.getConstraintEdge();
        UpdateManager updateManager = Activator.getModellingClientService().getUpdateManager();
        String transactionLabel = String.format("Changing duration of TimeLag %s", edge.toString());
        HashMap temporalInformation = this.getConstraintEdge().getPluginData("TimeData.ConstraintEdgeTemporalInformation") != null ? new HashMap(this.getConstraintEdge().getPluginData("TimeData.ConstraintEdgeTemporalInformation").getPluginData()) : new HashMap();
        ConstraintEdgeTemporalInformation edgeTemporalInformation = (ConstraintEdgeTemporalInformation)ModelViewer.createView(temporalInformation, ConstraintEdgeTemporalInformation.class);
        try {
            this.timeLagPropertySection.commit(edgeTemporalInformation);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception occurred while commiting changes!", e);
            return;
        }
        if (this.instance == null) {
            StartTransaction.performOperation((ChangeableTemplate)this.getTemplate(), (UpdateManager)updateManager);
            try {
                DefaultPluginData edgeTemporalInformationPluginData = new DefaultPluginData("TimeData.ConstraintEdgeTemporalInformation", temporalInformation);
                if (UpdatePluginDataContainer.isPossible((Template)this.getTemplate(), (PluginDataContainer)this.getConstraintEdge(), (String)"TimeData.ConstraintEdgeTemporalInformation", (String)"TimeData.ConstraintEdgeTemporalInformation", (PluginData)edgeTemporalInformationPluginData)) {
                    UpdatePluginDataContainer.performOperation((ChangeableTemplate)this.getTemplate(), (PluginDataContainer)this.getConstraintEdge(), (String)"TimeData.ConstraintEdgeTemporalInformation", (String)"TimeData.ConstraintEdgeTemporalInformation", (PluginData)edgeTemporalInformationPluginData, (UpdateManager)updateManager);
                }
            }
            finally {
                EndTransaction.performOperation((ChangeableTemplate)this.getTemplate(), (UpdateManager)updateManager, (String)transactionLabel);
            }
        }
    }

    private ChangeableTemplate getTemplate() {
        return (ChangeableTemplate)this.template;
    }

    private ConstraintEdge getConstraintEdge() {
        return (ConstraintEdge)this.edgePart.getModel();
    }

    private boolean isValidEditPart(EditPart part) {
        return part instanceof ConstraintEdgeEditPart;
    }

    public void refresh() {
        if (this.form.isDisposed()) {
            return;
        }
        if (!this.isValidEditPart((EditPart)this.edgePart)) {
            this.form.setText("TimeConstraints are not available for this element.");
            this.timeLagPropertySection.setVisible(false);
            return;
        }
        this.form.setText("Time Constraints");
        this.timeLagPropertySection.setVisible(true);
        ConstraintEdge edge = this.getConstraintEdge();
        this.timeLagPropertySection.setInput(this.template, edge);
    }

    private boolean isModified() {
        if (this.timeLagPropertySection == null) {
            return false;
        }
        return this.timeLagPropertySection.isModified();
    }

    public void dispose() {
        super.dispose();
        if (this.timeLagPropertySection != null) {
            AbstractConstraintEdgePropertySection temp = this.timeLagPropertySection;
            this.timeLagPropertySection = null;
            temp.removeModifyListener(this);
            temp.dispose();
        }
    }

    public void modifyText(ModifyEvent e) {
        if (this.isValidEditPart((EditPart)this.edgePart) && this.isModified()) {
            this.commitChanges();
        }
    }
}

