/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections;

import de.aristaflow.adept2.model.processmodel.Template;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class ElementPropertySubSection<V> {
    protected final AbstractPropertySection propertySection;
    protected final TabbedPropertySheetWidgetFactory toolkit;
    private Composite composite;
    protected boolean modified;
    protected Template template;
    private List<ModifyListener> listeners = new ArrayList<ModifyListener>();

    public ElementPropertySubSection(AbstractPropertySection propertySection) {
        this.propertySection = propertySection;
        this.toolkit = propertySection.getWidgetFactory();
    }

    public abstract void createControls(Composite var1);

    public void dispose() {
    }

    protected void setComposite(Composite composite) {
        this.composite = composite;
    }

    protected Composite getComposite() {
        return this.composite;
    }

    protected abstract void commit(V var1);

    public boolean isModified() {
        boolean repeat = true;
        while (repeat) {
            try {
                repeat = Display.getCurrent().readAndDispatch();
            }
            catch (RuntimeException runtimeException) {}
        }
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners() {
        ModifyListener[] list;
        List<ModifyListener> list2 = this.listeners;
        synchronized (list2) {
            list = this.listeners.toArray(new ModifyListener[this.listeners.size()]);
        }
        Event e = new Event();
        e.display = this.composite.getDisplay();
        e.widget = this.composite;
        e.data = this;
        ModifyListener[] modifyListenerArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            ModifyListener listener = modifyListenerArray[n2];
            listener.modifyText(new ModifyEvent(e));
            ++n2;
        }
    }

    public void setVisible(boolean visible) {
        this.getComposite().setVisible(visible);
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setEnabled(boolean enabled) {
        this.getComposite().setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModifyListener(ModifyListener listener) {
        List<ModifyListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModifyListener(ModifyListener listener) {
        List<ModifyListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    protected Section createSection(Composite parent, String title, String description) {
        Section section = this.toolkit.createSection(parent, 450);
        TableWrapData layout = new TableWrapData(256);
        section.setLayoutData((Object)layout);
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                ElementPropertySubSection.this.handleExpand(ElementPropertySubSection.this.getScrollingParent(e.getSource()));
            }
        });
        section.setText(title);
        section.setDescription(description);
        return section;
    }

    private void handleExpand(ScrolledComposite composite) {
        if (composite == null) {
            return;
        }
        try {
            composite.setRedraw(false);
            Composite c = (Composite)composite.getContent();
            if (c == null) {
                return;
            }
            Point newSize = c.computeSize(-1, -1);
            composite.setMinSize(newSize);
            c.layout(true);
        }
        finally {
            composite.setRedraw(true);
        }
    }

    private ScrolledComposite getScrollingParent(Object obj) {
        if (obj instanceof ExpandableComposite) {
            ExpandableComposite ecomp = (ExpandableComposite)obj;
            Composite parent = ecomp.getParent();
            while (parent != null && !(parent instanceof ScrolledComposite)) {
                parent = parent.getParent();
            }
            if (parent != null) {
                return (ScrolledComposite)parent;
            }
        }
        if (obj instanceof ScrolledComposite) {
            return (ScrolledComposite)obj;
        }
        return null;
    }
}

