/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections;

import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.changeoperations.UpdatePluginDataContainer;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.timemodel.NodeTemporalInformation;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.parts.BranchEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.TemplateEditPart;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.AbstractNodePropertySection;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.sections.ActivityDurationPropertySection;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.sections.NodeFixedDatePropertySection;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.sections.NodeScheduleRestrictedPropertySection;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.sections.NodeValidityPeriodPropertySection;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class NodeTimeConstraintsSection
extends AbstractPropertySection
implements ModifyListener {
    protected final Logger logger = LoggerTools.getLogger((Object)((Object)this));
    DefaultNodeEditPart nodePart;
    Template template;
    Instance instance;
    private Form form;
    private AbstractNodePropertySection[] sections;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory toolkit = this.getWidgetFactory();
        this.form = this.getWidgetFactory().createForm(parent);
        this.form.setText("Time Constraints");
        toolkit.decorateFormHeading(this.form);
        this.form.getBody().setLayout((Layout)new TableWrapLayout());
        AbstractNodePropertySection[] abstractNodePropertySectionArray = this.sections = new AbstractNodePropertySection[]{new ActivityDurationPropertySection(this), new NodeFixedDatePropertySection(this), new NodeScheduleRestrictedPropertySection(this), new NodeValidityPeriodPropertySection(this)};
        int n = this.sections.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractNodePropertySection section = abstractNodePropertySectionArray[n2];
            section.createControls(this.form.getBody());
            section.addModifyListener(this);
            ++n2;
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof EditPart));
        if (this.sections == null || this.form.isDisposed()) {
            return;
        }
        if (this.isModified() && this.nodePart != null && this.isValidEditPart((EditPart)this.nodePart)) {
            this.commitChanges();
        }
        this.nodePart = (DefaultNodeEditPart)input;
        if (this.nodePart.getInstance() != null) {
            this.instance = this.nodePart.getInstance();
            this.template = this.instance.getTemplate();
        } else {
            this.template = this.nodePart.getTemplate();
            this.instance = null;
        }
        if (this.instance == null && !(this.template instanceof ChangeableTemplate) || this.instance != null && !(this.instance instanceof ChangeableInstance)) {
            this.form.setMessage("Read-only mode: Attributes of Template / Instance not changeable!");
            this.form.setEnabled(false);
        }
    }

    protected synchronized void commitChanges() {
        if (this.sections == null) {
            return;
        }
        if (!this.isModified()) {
            this.logger.warning("calling commit without beeing modified");
        }
        Node node = this.getNode();
        UpdateManager updateManager = Activator.getModellingClientService().getUpdateManager();
        String transactionLabel = String.format("Changing duration of Node %s", node.getName());
        HashMap temporalInformation = this.getNode().getPluginData("TimeData.NodeTemporalInformation") != null ? new HashMap(this.getNode().getPluginData("TimeData.NodeTemporalInformation").getPluginData()) : new HashMap();
        NodeTemporalInformation nodeTemporalInformation = (NodeTemporalInformation)ModelViewer.createView(temporalInformation, NodeTemporalInformation.class);
        AbstractNodePropertySection[] abstractNodePropertySectionArray = this.sections;
        int n = this.sections.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractNodePropertySection section = abstractNodePropertySectionArray[n2];
            if (section.isModified()) {
                try {
                    section.commit(nodeTemporalInformation);
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Exception occurred while committing changes!", e);
                    new ErrorDialog(this.getPart().getSite().getShell(), "Error committing changes!", "Exception occurred while committing changes!", (IStatus)new Status(4, "de.aristaflow.adept2.ui.processvisualisation.timeconstraints", e.getMessage(), (Throwable)e), 2).open();
                    return;
                }
            }
            ++n2;
        }
        if (this.instance == null) {
            StartTransaction.performOperation((ChangeableTemplate)((ChangeableTemplate)this.template), (UpdateManager)updateManager);
            try {
                DefaultPluginData nodeTemporalInformationPluginData = new DefaultPluginData("TimeData.NodeTemporalInformation", temporalInformation);
                if (UpdatePluginDataContainer.isPossible((Template)this.getTemplate(), (PluginDataContainer)this.getNode(), (String)"TimeData.NodeTemporalInformation", (String)"TimeData.NodeTemporalInformation", (PluginData)nodeTemporalInformationPluginData)) {
                    UpdatePluginDataContainer.performOperation((ChangeableTemplate)((ChangeableTemplate)this.getTemplate()), (PluginDataContainer)this.getNode(), (String)"TimeData.NodeTemporalInformation", (String)"TimeData.NodeTemporalInformation", (PluginData)nodeTemporalInformationPluginData, (UpdateManager)updateManager);
                }
            }
            finally {
                EndTransaction.performOperation((ChangeableTemplate)((ChangeableTemplate)this.template), (UpdateManager)updateManager, (String)transactionLabel);
            }
        }
    }

    private Node getNode() {
        return (Node)this.nodePart.getModel();
    }

    public void refresh() {
        if (this.form.isDisposed()) {
            return;
        }
        if (!this.isValidEditPart((EditPart)this.nodePart)) {
            this.form.setText("TimeConstraints are not available for this element.");
            this.setSectionsVisible(false);
            return;
        }
        this.form.setText("Time Constraints");
        this.setSectionsVisible(true);
        Node node = this.getNode();
        AbstractNodePropertySection[] abstractNodePropertySectionArray = this.sections;
        int n = this.sections.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractNodePropertySection section = abstractNodePropertySectionArray[n2];
            section.setInput(this.template, node);
            ++n2;
        }
    }

    private void setSectionsVisible(boolean visible) {
        AbstractNodePropertySection[] abstractNodePropertySectionArray = this.sections;
        int n = this.sections.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractNodePropertySection section = abstractNodePropertySectionArray[n2];
            section.setVisible(visible);
            ++n2;
        }
    }

    private boolean isValidEditPart(EditPart part) {
        DefaultNodeEditPart nodePart = null;
        if (part instanceof DefaultNodeEditPart) {
            nodePart = (DefaultNodeEditPart)part;
        }
        return part != null && !(part instanceof DataElementEditPart) && (part instanceof DefaultNodeEditPart && nodePart != null && !(part instanceof BranchEditPart) && nodePart.getTemplate().getStartNode().getID() != ((Node)nodePart.getModel()).getID() && nodePart.getTemplate().getEndNode().getID() != ((Node)nodePart.getModel()).getID() && !ProcessModelTools.isNullNode((ProcessConstants.NodeType)nodePart.getTemplate().getNodeType(((Node)nodePart.getModel()).getID())) && !this.isControlElement(nodePart.getTemplate().getNodeType(((Node)nodePart.getModel()).getID())) || part instanceof TemplateEditPart);
    }

    private boolean isControlElement(ProcessConstants.NodeType nodeType) {
        return !ProcessConstants.NodeType.NT_NORMAL.equals((Object)nodeType);
    }

    private boolean isModified() {
        if (this.sections == null) {
            return false;
        }
        AbstractNodePropertySection[] abstractNodePropertySectionArray = this.sections;
        int n = this.sections.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractNodePropertySection section = abstractNodePropertySectionArray[n2];
            if (section.isModified()) {
                return true;
            }
            ++n2;
        }
        return true;
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (this.isValidEditPart((EditPart)this.nodePart) && this.isModified()) {
            this.commitChanges();
        }
    }

    public Template getTemplate() {
        return this.template;
    }

    public DefaultNodeEditPart getNodePart() {
        return this.nodePart;
    }

    public void dispose() {
        super.dispose();
        if (this.sections != null) {
            AbstractNodePropertySection[] temp = this.sections;
            this.sections = null;
            AbstractNodePropertySection[] abstractNodePropertySectionArray = temp;
            int n = temp.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractNodePropertySection section = abstractNodePropertySectionArray[n2];
                section.removeModifyListener(this);
                section.dispose();
                ++n2;
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        if (this.isValidEditPart((EditPart)this.nodePart) && this.isModified()) {
            this.commitChanges();
        }
    }
}

