/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections;

import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.changeoperations.UpdatePluginDataContainer;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.timemodel.TemplateTemporalInformation;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.parts.BranchEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.TemplateEditPart;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.AbstractPropertySource;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.AbstractTemplatePropertySection;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.sections.TemplateDurationPropertySection;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.sections.TemplateScheduleRestrictedPropertySection;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.sections.TemplateValidityPeriodPropertySection;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class TemplateTimeConstraintsSection
extends AbstractPropertySection
implements ModifyListener {
    protected final Logger logger = LoggerTools.getLogger((Object)((Object)this));
    Template template;
    Instance instance;
    TemplateEditPart templateEditPart;
    AbstractPropertySource properties;
    private Form form;
    private AbstractTemplatePropertySection[] sections;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory toolkit = this.getWidgetFactory();
        this.form = this.getWidgetFactory().createForm(parent);
        this.form.setText("Time Constraints");
        toolkit.decorateFormHeading(this.form);
        this.form.getBody().setLayout((Layout)new TableWrapLayout());
        AbstractTemplatePropertySection[] abstractTemplatePropertySectionArray = this.sections = new AbstractTemplatePropertySection[]{new TemplateDurationPropertySection(this), new TemplateScheduleRestrictedPropertySection(this), new TemplateValidityPeriodPropertySection(this)};
        int n = this.sections.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTemplatePropertySection section = abstractTemplatePropertySectionArray[n2];
            section.createControls(this.form.getBody());
            section.addModifyListener(this);
            ++n2;
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof EditPart));
        if (this.sections == null || this.form.isDisposed()) {
            return;
        }
        if (this.isModified() && this.templateEditPart != null && this.isValidEditPart((EditPart)this.templateEditPart)) {
            this.commitChanges();
        }
        this.templateEditPart = (TemplateEditPart)input;
        if (this.templateEditPart.getInstance() != null) {
            this.instance = this.templateEditPart.getInstance();
            this.template = this.instance.getTemplate();
        } else {
            this.template = this.templateEditPart.getTemplate();
            this.instance = null;
        }
        if (this.instance == null && !(this.template instanceof ChangeableTemplate) || this.instance != null && !(this.instance instanceof ChangeableInstance)) {
            this.form.setMessage("Read-only mode: Attributes of Template / Instance not changeable!");
            this.form.setEnabled(false);
        }
    }

    private boolean isValidEditPart(EditPart part) {
        TemplateEditPart templatePart = null;
        if (part instanceof TemplateEditPart) {
            templatePart = (TemplateEditPart)part;
        }
        return part != null && !(part instanceof DataElementEditPart) && (part instanceof DefaultNodeEditPart && templatePart != null && !(part instanceof BranchEditPart) && templatePart.getTemplate().getStartNode().getID() != ((Node)templatePart.getModel()).getID() && templatePart.getTemplate().getEndNode().getID() != ((Node)templatePart.getModel()).getID() && !ProcessModelTools.isNullNode((ProcessConstants.NodeType)templatePart.getTemplate().getNodeType(((Node)templatePart.getModel()).getID())) || part instanceof TemplateEditPart);
    }

    private boolean isModified() {
        if (this.sections == null) {
            return false;
        }
        AbstractTemplatePropertySection[] abstractTemplatePropertySectionArray = this.sections;
        int n = this.sections.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTemplatePropertySection section = abstractTemplatePropertySectionArray[n2];
            if (section.isModified()) {
                return true;
            }
            ++n2;
        }
        return true;
    }

    public void refresh() {
        if (this.form.isDisposed()) {
            return;
        }
        if (!this.isValidEditPart((EditPart)this.templateEditPart)) {
            this.form.setText("TimeConstraints are not available for this element.");
            this.setSectionsVisible(false);
            return;
        }
        this.form.setText("Time Constraints");
        this.setSectionsVisible(true);
        AbstractTemplatePropertySection[] abstractTemplatePropertySectionArray = this.sections;
        int n = this.sections.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTemplatePropertySection section = abstractTemplatePropertySectionArray[n2];
            section.setInput(this.template);
            ++n2;
        }
    }

    protected synchronized void commitChanges() {
        if (this.sections == null) {
            return;
        }
        if (!this.isModified()) {
            this.logger.warning("calling commit without beeing modified");
        }
        Template template = this.getTemplate();
        UpdateManager updateManager = Activator.getModellingClientService().getUpdateManager();
        String transactionLabel = String.format("Changing duration of Template %s", template.getName());
        HashMap temporalInformation = this.getTemplate().getPluginData("TimeData.TemplateTemporalInformation") != null ? new HashMap(this.getTemplate().getPluginData("TimeData.TemplateTemporalInformation").getPluginData()) : new HashMap();
        TemplateTemporalInformation templateTemporalInformation = (TemplateTemporalInformation)ModelViewer.createView(temporalInformation, TemplateTemporalInformation.class);
        AbstractTemplatePropertySection[] abstractTemplatePropertySectionArray = this.sections;
        int n = this.sections.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTemplatePropertySection section = abstractTemplatePropertySectionArray[n2];
            if (section.isModified()) {
                try {
                    section.commit(templateTemporalInformation);
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Exception occurred while commiting changes!", e);
                    return;
                }
            }
            ++n2;
        }
        if (this.instance == null) {
            StartTransaction.performOperation((ChangeableTemplate)((ChangeableTemplate)template), (UpdateManager)updateManager);
            try {
                DefaultPluginData templateTemporalInformationPluginData = new DefaultPluginData("TimeData.TemplateTemporalInformation", temporalInformation);
                if (UpdatePluginDataContainer.isPossible((Template)this.getTemplate(), (PluginDataContainer)this.getTemplate(), (String)"TimeData.TemplateTemporalInformation", (String)"TimeData.TemplateTemporalInformation", (PluginData)templateTemporalInformationPluginData)) {
                    UpdatePluginDataContainer.performOperation((ChangeableTemplate)((ChangeableTemplate)this.getTemplate()), (PluginDataContainer)this.getTemplate(), (String)"TimeData.TemplateTemporalInformation", (String)"TimeData.TemplateTemporalInformation", (PluginData)templateTemporalInformationPluginData, (UpdateManager)updateManager);
                }
            }
            finally {
                EndTransaction.performOperation((ChangeableTemplate)((ChangeableTemplate)template), (UpdateManager)updateManager, (String)transactionLabel);
            }
        }
    }

    private Template getTemplate() {
        return (Template)this.templateEditPart.getModel();
    }

    private void setSectionsVisible(boolean visible) {
        AbstractTemplatePropertySection[] abstractTemplatePropertySectionArray = this.sections;
        int n = this.sections.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTemplatePropertySection section = abstractTemplatePropertySectionArray[n2];
            section.setVisible(visible);
            ++n2;
        }
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (this.isValidEditPart((EditPart)this.templateEditPart) && this.isModified()) {
            this.commitChanges();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.sections != null) {
            AbstractTemplatePropertySection[] temp = this.sections;
            this.sections = null;
            AbstractTemplatePropertySection[] abstractTemplatePropertySectionArray = temp;
            int n = temp.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractTemplatePropertySection section = abstractTemplatePropertySectionArray[n2];
                section.removeModifyListener(this);
                section.dispose();
                ++n2;
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        if (this.isValidEditPart((EditPart)this.templateEditPart) && this.isModified()) {
            this.commitChanges();
        }
    }
}

