/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.sections;

import de.aristaflow.adept2.core.timemanager.TimeManager;
import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.TimePoint;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.timemodel.ActivityDuration;
import de.aristaflow.adept2.model.processmodel.timemodel.NodeTemporalInformation;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeModelTools;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.model.timemodel.TimeModelOperations;
import de.aristaflow.adept2.ui.processvisualisation.preferences.LocalTimeModellingService;
import de.aristaflow.adept2.ui.processvisualisation.preferences.TimeModelPreferences;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.AbstractNodePropertySection;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.NodeTimeConstraintsSection;
import de.aristaflow.adept2.ui.processvisualisation.timeconstraints.Activator;
import de.aristaflow.adept2.ui.processvisualisation.widgets.GraphicalDurationWidget;
import de.aristaflow.adept2.ui.processvisualisation.widgets.TimePointWidget;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ActivityDurationPropertySection
extends AbstractNodePropertySection {
    private ActivityDuration activityDuration;
    private TimePointWidget flexibleMinSpinner;
    private TimePointWidget guardMinSpinner;
    private TimePointWidget guardMaxSpinner;
    private TimePointWidget flexibleMaxSpinner;
    private TimePointWidget expectedSpinner;
    private GraphicalDurationWidget graphicalWidget;
    private TimePointWidget contingencySpinner;
    private TimeModelOperations timeModelOperations;

    public ActivityDurationPropertySection(NodeTimeConstraintsSection propertySection) {
        super(propertySection);
    }

    @Override
    protected void commit(NodeTemporalInformation nodeTemporalInformation) {
        nodeTemporalInformation.setActivityDuration(this.activityDuration);
        this.modified = false;
    }

    @Deprecated
    private void handleLegacyDataStructure(NodeTemporalInformation nodeTemporalInformation) {
        if (TimeModelTools.getStartFixedDate((Node)this.getNode()) != null) {
            nodeTemporalInformation.setStartFixedDate(TimeModelTools.getStartFixedDate((Node)this.getNode()));
        }
        if (TimeModelTools.getCompletionFixedDate((Node)this.getNode()) != null) {
            nodeTemporalInformation.setCompletionFixedDate(TimeModelTools.getCompletionFixedDate((Node)this.getNode()));
        }
        if (TimeModelTools.getStartSchedule((Node)this.getNode()) != null) {
            nodeTemporalInformation.setStartSchedule(TimeModelTools.getStartSchedule((Node)this.getNode()));
        }
        if (TimeModelTools.getCompletionSchedule((Node)this.getNode()) != null) {
            nodeTemporalInformation.setCompletionSchedule(TimeModelTools.getCompletionSchedule((Node)this.getNode()));
        }
        if (TimeModelTools.getStartValidityPeriod((Node)this.getNode()) != null) {
            nodeTemporalInformation.setStartValidityPeriod(TimeModelTools.getStartValidityPeriod((Node)this.getNode()));
        }
        if (TimeModelTools.getCompletionValidityPeriod((Node)this.getNode()) != null) {
            nodeTemporalInformation.setCompletionValidityPeriod(TimeModelTools.getCompletionValidityPeriod((Node)this.getNode()));
        }
    }

    @Override
    public void createControls(Composite parent) {
        Section section = this.createSection(parent, "Activity Duration", "Specify the allowed duration range of the activity. It is also possible to specify an expected duration.");
        this.setComposite((Composite)section);
        Composite activityDurationClient = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)activityDurationClient);
        activityDurationClient.setLayout((Layout)new GridLayout(2, false));
        this.createActivityDurationWidgets(activityDurationClient);
        this.createGraphicalRepresentation(activityDurationClient);
    }

    private void createActivityDurationWidgets(Composite composite) {
        Composite activityDurationGroup = this.toolkit.createComposite(composite);
        GridData gridData = new GridData(4, 4, false, false);
        activityDurationGroup.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        activityDurationGroup.setLayout((Layout)layout);
        TimePointWidget.TimePointModifyListener activityDurationSelectionListener = new TimePointWidget.TimePointModifyListener(){

            @Override
            public void modifyTimePoint(TimePointWidget source, TimePoint newTimePoint) {
                ActivityDurationPropertySection.this.validate(source);
            }
        };
        GridDataFactory gridDataFactory = GridDataFactory.createFrom((GridData)new GridData(4, 0x1000000, true, false));
        this.flexibleMinSpinner = new TimePointWidget(activityDurationGroup, 0, "Minimum", (FormToolkit)this.toolkit);
        this.flexibleMinSpinner.setLayoutData(gridDataFactory.create());
        this.flexibleMinSpinner.addModifyListener(activityDurationSelectionListener);
        this.guardMinSpinner = new TimePointWidget(activityDurationGroup, 0, "Guard Minimum", (FormToolkit)this.toolkit);
        this.guardMinSpinner.setLayoutData(gridDataFactory.create());
        this.guardMinSpinner.addModifyListener(activityDurationSelectionListener);
        this.guardMaxSpinner = new TimePointWidget(activityDurationGroup, 0, "Guard Maximum", (FormToolkit)this.toolkit);
        this.guardMaxSpinner.setLayoutData(gridDataFactory.create());
        this.guardMaxSpinner.addModifyListener(activityDurationSelectionListener);
        this.flexibleMaxSpinner = new TimePointWidget(activityDurationGroup, 0, "Maximum", (FormToolkit)this.toolkit);
        this.flexibleMaxSpinner.setLayoutData(gridDataFactory.create());
        this.flexibleMaxSpinner.addModifyListener(activityDurationSelectionListener);
        this.contingencySpinner = new TimePointWidget(activityDurationGroup, 0, "Contingency", (FormToolkit)this.toolkit);
        this.contingencySpinner.setLayoutData(gridDataFactory.create());
        this.contingencySpinner.addModifyListener(activityDurationSelectionListener);
        Label separator = this.toolkit.createSeparator(activityDurationGroup, 256);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, false, false, layout.numColumns, 1));
        this.expectedSpinner = new TimePointWidget(activityDurationGroup, 0, "Expected Duration", (FormToolkit)this.toolkit);
        this.expectedSpinner.setLayoutData(gridDataFactory.create());
        this.expectedSpinner.addModifyListener(activityDurationSelectionListener);
    }

    private void createGraphicalRepresentation(Composite parent) {
        Group graphicalDurationGroup = this.toolkit.createGroup(parent, "Duration");
        GridData gridData = new GridData(4, 4, true, false);
        graphicalDurationGroup.setLayoutData((Object)gridData);
        graphicalDurationGroup.setLayout((Layout)new GridLayout(1, false));
        this.graphicalWidget = new GraphicalDurationWidget((Composite)graphicalDurationGroup, 0, true, (FormToolkit)this.toolkit);
        GridData graphGridData = new GridData(4, 4, true, true);
        this.graphicalWidget.setLayoutData(graphGridData);
    }

    protected void validate(TimePointWidget spinner) {
        if (this.activityDuration == null) {
            return;
        }
        TimePoint minDuration = this.flexibleMinSpinner.getTimePoint();
        TimePoint guardMin = this.guardMinSpinner.getTimePoint();
        TimePoint guardMax = this.guardMaxSpinner.getTimePoint();
        TimePoint maxDuration = this.flexibleMaxSpinner.getTimePoint();
        TimePoint contingency = this.contingencySpinner.getTimePoint();
        TimePoint newDuration = spinner.getTimePoint();
        if (spinner == this.expectedSpinner) {
            if (minDuration != null && this.toTimeStamp(newDuration) < this.toTimeStamp(minDuration)) {
                newDuration = minDuration;
            }
            if (maxDuration != null && this.toTimeStamp(newDuration) > this.toTimeStamp(maxDuration)) {
                newDuration = maxDuration;
            }
            this.expectedSpinner.setTimePoint(newDuration);
            this.activityDuration.setExpectedDuration(newDuration);
            this.graphicalWidget.setExpectedValue(newDuration);
        } else if (spinner == this.flexibleMinSpinner) {
            if (guardMin != null && this.toTimeStamp(newDuration) > this.toTimeStamp(guardMin)) {
                newDuration = guardMin;
            }
            if (guardMax != null && this.toTimeStamp(newDuration) > this.toTimeStamp(guardMax)) {
                newDuration = guardMax;
            }
            if (maxDuration != null && this.toTimeStamp(newDuration) > this.toTimeStamp(maxDuration)) {
                newDuration = maxDuration;
            }
            this.flexibleMinSpinner.setTimePoint(newDuration);
            this.activityDuration.setFlexibleMinimumDuration(newDuration);
            this.graphicalWidget.setFlexibleMinimumValue(newDuration);
        } else if (spinner == this.guardMinSpinner) {
            if (maxDuration != null && this.toTimeStamp(newDuration) > this.toTimeStamp(maxDuration)) {
                newDuration = maxDuration;
            }
            if (minDuration != null && this.toTimeStamp(newDuration) < this.toTimeStamp(minDuration)) {
                newDuration = minDuration;
            }
            this.guardMinSpinner.setTimePoint(newDuration);
            this.activityDuration.setGuardMinimumDuration(newDuration);
            this.graphicalWidget.setGuardMinimumValue(newDuration);
            TimeModelPreferences.getInstance();
        } else if (spinner == this.guardMaxSpinner) {
            if (maxDuration != null && this.toTimeStamp(newDuration) > this.toTimeStamp(maxDuration)) {
                newDuration = maxDuration;
            }
            if (minDuration != null && this.toTimeStamp(newDuration) < this.toTimeStamp(minDuration)) {
                newDuration = minDuration;
            }
            this.guardMaxSpinner.setTimePoint(newDuration);
            this.activityDuration.setGuardMaximumDuration(newDuration);
            this.graphicalWidget.setGuardMaximumValue(newDuration);
        } else if (spinner == this.flexibleMaxSpinner) {
            if (guardMax != null && this.toTimeStamp(newDuration) < this.toTimeStamp(guardMax)) {
                newDuration = guardMax;
            }
            if (guardMin != null && this.toTimeStamp(newDuration) < this.toTimeStamp(guardMin)) {
                newDuration = guardMin;
            }
            if (minDuration != null && this.toTimeStamp(newDuration) < this.toTimeStamp(minDuration)) {
                newDuration = minDuration;
            }
            this.flexibleMaxSpinner.setTimePoint(newDuration);
            this.activityDuration.setFlexibleMaximumDuration(newDuration);
            this.graphicalWidget.setFlexibleMaximumValue(newDuration);
        } else if (spinner == this.contingencySpinner) {
            if (guardMin != null && guardMax != null && this.toTimeStamp(guardMax) - this.toTimeStamp(guardMin) > this.toTimeStamp(contingency)) {
                TimeDistance newValue = this.timeModelOperations.convertToTimeDistance(guardMax).sub(this.timeModelOperations.convertToTimeDistance(guardMin));
                newDuration = this.timeModelOperations.convertToTimePoint(newValue);
            }
            this.contingencySpinner.setTimePoint(newDuration);
            this.activityDuration.setContingency(newDuration);
        }
        this.setModified();
        this.graphicalWidget.redraw();
    }

    private long toTimeStamp(TimePoint timePoint) {
        return this.timeModelOperations.convertToSeconds(timePoint);
    }

    @Override
    public void setInput(Template template, Node node) {
        TimeModelPreferences preferences = TimeModelPreferences.getInstance();
        TimeManager timeManager = Activator.getTimeManager();
        LocalTimeModellingService timeModellingService = new LocalTimeModellingService(timeManager, preferences);
        TimeModelFactory factory = timeModellingService.getTimeModelFactory();
        this.timeModelOperations = factory.getTimeModelOperations();
        super.setInput(template, node);
        if (node != null) {
            this.activityDuration = TimeModelTools.getActivityDuration((Node)node);
            if (this.activityDuration == null) {
                this.activityDuration = (ActivityDuration)ModelViewer.createNew(ActivityDuration.class);
            }
        } else {
            this.activityDuration = null;
        }
        this.setDataToWidgets();
        this.modified = false;
    }

    private void setDataToWidgets() {
        TimeModelPreferences preferences = TimeModelPreferences.getInstance();
        if (this.activityDuration != null) {
            if (this.activityDuration.getExpectedDuration() != null) {
                this.expectedSpinner.setTimePoint(this.activityDuration.getExpectedDuration());
            } else {
                this.expectedSpinner.setTimePoint(null);
            }
            this.graphicalWidget.setExpectedValue(this.activityDuration.getExpectedDuration());
            if (this.activityDuration.getMinimumDuration() != null) {
                this.flexibleMinSpinner.setTimePoint(this.activityDuration.getMinimumDuration());
            } else {
                this.flexibleMinSpinner.setTimePoint(null);
            }
            this.graphicalWidget.setFlexibleMinimumValue(this.activityDuration.getMinimumDuration());
            if (this.activityDuration.getGuardMinimumDuration() != null) {
                this.guardMinSpinner.setTimePoint(this.activityDuration.getGuardMinimumDuration());
            } else {
                this.guardMinSpinner.setTimePoint(null);
            }
            this.graphicalWidget.setGuardMinimumValue(this.activityDuration.getGuardMinimumDuration());
            if (this.activityDuration.getGuardMaximumDuration() != null) {
                this.guardMaxSpinner.setTimePoint(this.activityDuration.getGuardMaximumDuration());
            } else {
                this.guardMaxSpinner.setTimePoint(null);
            }
            this.graphicalWidget.setGuardMaximumValue(this.activityDuration.getGuardMaximumDuration());
            if (this.activityDuration.getMaximumDuration() != null) {
                this.flexibleMaxSpinner.setTimePoint(this.activityDuration.getMaximumDuration());
            } else {
                this.flexibleMaxSpinner.setTimePoint(null);
            }
            this.graphicalWidget.setFlexibleMaximumValue(this.activityDuration.getMaximumDuration());
        } else {
            this.expectedSpinner.setTimePoint(null);
            this.flexibleMinSpinner.setTimePoint(null);
            this.guardMaxSpinner.setTimePoint(null);
            this.guardMinSpinner.setTimePoint(null);
            this.flexibleMaxSpinner.setTimePoint(null);
            this.graphicalWidget.setExpectedValue(null);
            this.graphicalWidget.setFlexibleMinimumValue(null);
            this.graphicalWidget.setGuardMaximumValue(null);
            this.graphicalWidget.setGuardMinimumValue(null);
            this.graphicalWidget.setFlexibleMaximumValue(null);
        }
        boolean hasContingency = false;
        boolean hasMinGuard = false;
        boolean hasMaxGuard = false;
        switch (preferences.getTimeModelType()) {
            case CSTN: {
                break;
            }
            case CSTNU: {
                break;
            }
            case CSTNU_EXTENDED: {
                hasMaxGuard = true;
                break;
            }
        }
        this.setVisibility(this.contingencySpinner, hasContingency);
        this.setVisibility(this.guardMinSpinner, hasMinGuard);
        this.setVisibility(this.guardMaxSpinner, hasMaxGuard);
        this.graphicalWidget.redraw();
    }

    private void setVisibility(TimePointWidget widget, boolean visible) {
        widget.setVisible(visible);
        ((GridData)widget.getLayoutData()).exclude = !visible;
    }
}

