/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.sections;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.changeoperations.UpdatePluginDataContainer;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.systemdata.Dependency;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.globals.TimeModelConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDate;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDateUpdateProcedureData;
import de.aristaflow.adept2.model.processmodel.timemodel.NodeTemporalInformation;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeModelTools;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.AbstractNodePropertySection;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.NodeTimeConstraintsSection;
import de.aristaflow.adept2.ui.processvisualisation.timeconstraints.SystemParamaterTools;
import de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.selectionwizard.FixedDateWizard;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;

public class NodeFixedDatePropertySection
extends AbstractNodePropertySection {
    protected Logger logger = LoggerTools.getLogger((Object)this);
    private Text startFixedDateTime;
    private Text completionFixedDateTime;
    private FixedDate startFixedDate;
    private FixedDate completionFixedDate;
    private Section section;

    public NodeFixedDatePropertySection(NodeTimeConstraintsSection propertySection) {
        super(propertySection);
    }

    @Override
    protected void commit(NodeTemporalInformation nodeTemporalInformation) {
    }

    @Override
    public void createControls(Composite parent) {
        this.section = this.createSection(parent, "Fixed Date", "Specify a fixed date for executing the Activity. It is possible to specify a fixed date for the start as well as the completion of the activity. Fixed dates are generally provided by some data element.");
        this.setComposite((Composite)this.section);
        this.section.setExpanded(false);
        Composite fixeDateSectionClient = this.toolkit.createComposite((Composite)this.section);
        this.section.setClient((Control)fixeDateSectionClient);
        fixeDateSectionClient.setLayout((Layout)new GridLayout(2, true));
        this.createFixedDateGroup(fixeDateSectionClient);
    }

    private void createFixedDateGroup(Composite fixeDateSectionClient) {
        Group startDateGroup = this.toolkit.createGroup(fixeDateSectionClient, "Activity Start");
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 10;
        startDateGroup.setLayout((Layout)gl);
        startDateGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.startFixedDateTime = new Text((Composite)startDateGroup, 2050);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.heightHint = 45;
        gridData.horizontalSpan = 2;
        this.startFixedDateTime.setLayoutData((Object)gridData);
        this.startFixedDateTime.setText("not set");
        this.startFixedDateTime.setEditable(false);
        Button startFixedDateChangeButton = this.toolkit.createButton((Composite)startDateGroup, "change", 524288);
        Button startClearButton = this.toolkit.createButton((Composite)startDateGroup, "clear", 524288);
        startFixedDateChangeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FixedDate fixedDate = NodeFixedDatePropertySection.this.openFixedDateWizard(NodeFixedDatePropertySection.this.propertySection.getPart().getSite().getShell(), NodeFixedDatePropertySection.this.getTemplate(), NodeFixedDatePropertySection.this.getNode(), NodeFixedDatePropertySection.this.startFixedDate, TimeModelConstants.ReferencePoint.START);
                if (fixedDate != null) {
                    NodeFixedDatePropertySection.this.startFixedDate = fixedDate;
                    NodeFixedDatePropertySection.this.setDataToWidgets();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        startClearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FixedDate oldFixedDate = NodeFixedDatePropertySection.this.startFixedDate;
                NodeFixedDatePropertySection.this.startFixedDate = null;
                Map<String, Dependency> emptyMap = Collections.emptyMap();
                NodeFixedDatePropertySection.this.updateFixedDate(NodeFixedDatePropertySection.this.getTemplate(), NodeFixedDatePropertySection.this.getNode(), TimeModelConstants.ReferencePoint.START, oldFixedDate, NodeFixedDatePropertySection.this.startFixedDate, emptyMap);
                NodeFixedDatePropertySection.this.setDataToWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Group completionDateGroup = this.toolkit.createGroup(fixeDateSectionClient, "Activity Completion");
        gl = new GridLayout(2, false);
        gl.horizontalSpacing = 10;
        completionDateGroup.setLayout((Layout)gl);
        completionDateGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.completionFixedDateTime = new Text((Composite)completionDateGroup, 2050);
        gridData = new GridData(4, 4, true, false);
        gridData.heightHint = 45;
        gridData.horizontalSpan = 2;
        this.completionFixedDateTime.setLayoutData((Object)gridData);
        this.completionFixedDateTime.setText("not set");
        this.completionFixedDateTime.setEditable(false);
        Button completionFixedDateChangeButton = this.toolkit.createButton((Composite)completionDateGroup, "change", 524288);
        Button completionClearButton = this.toolkit.createButton((Composite)completionDateGroup, "clear", 524288);
        completionFixedDateChangeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FixedDate fixedDate = NodeFixedDatePropertySection.this.openFixedDateWizard(NodeFixedDatePropertySection.this.propertySection.getPart().getSite().getShell(), NodeFixedDatePropertySection.this.getTemplate(), NodeFixedDatePropertySection.this.getNode(), NodeFixedDatePropertySection.this.completionFixedDate, TimeModelConstants.ReferencePoint.COMPLETION);
                if (fixedDate != null) {
                    NodeFixedDatePropertySection.this.completionFixedDate = fixedDate;
                    NodeFixedDatePropertySection.this.setDataToWidgets();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        completionClearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FixedDate oldFixedDate = NodeFixedDatePropertySection.this.completionFixedDate;
                NodeFixedDatePropertySection.this.completionFixedDate = null;
                Map<String, Dependency> emptyMap = Collections.emptyMap();
                NodeFixedDatePropertySection.this.updateFixedDate(NodeFixedDatePropertySection.this.getTemplate(), NodeFixedDatePropertySection.this.getNode(), TimeModelConstants.ReferencePoint.COMPLETION, oldFixedDate, NodeFixedDatePropertySection.this.startFixedDate, emptyMap);
                NodeFixedDatePropertySection.this.setDataToWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    @Override
    public void setInput(Template template, Node node) {
        super.setInput(template, node);
        if (node != null) {
            this.startFixedDate = TimeModelTools.getStartFixedDate((Node)node);
            this.completionFixedDate = TimeModelTools.getCompletionFixedDate((Node)node);
        } else {
            this.startFixedDate = null;
            this.completionFixedDate = null;
        }
        this.setDataToWidgets();
        this.modified = false;
    }

    private void setDataToWidgets() {
        String description;
        FixedDateUpdateProcedureData procedure;
        boolean expanded = false;
        if (this.startFixedDate == null) {
            this.startFixedDateTime.setText("not set");
        } else {
            if (this.startFixedDate.getFixedDateUpdateProcedure() != null) {
                procedure = this.startFixedDate.getFixedDateUpdateProcedure();
                description = procedure.getDescription();
                String text = description == null || description.isEmpty() ? procedure.getProcedureID() : description;
                this.startFixedDateTime.setText(text);
            }
            expanded = true;
        }
        if (this.completionFixedDate == null) {
            this.completionFixedDateTime.setText("not set");
        } else {
            if (this.completionFixedDate.getFixedDateUpdateProcedure() != null) {
                procedure = this.completionFixedDate.getFixedDateUpdateProcedure();
                description = procedure.getDescription();
                this.completionFixedDateTime.setText(description == null || description.isEmpty() ? procedure.getProcedureID() : description);
            }
            expanded = true;
        }
        this.section.setExpanded(expanded);
    }

    public FixedDate openFixedDateWizard(Shell shell, Template template, Node node, FixedDate oldFixedDate, TimeModelConstants.ReferencePoint referencePoint) {
        FixedDateWizard fixedDateWizard = new FixedDateWizard();
        fixedDateWizard.init(template, node, oldFixedDate, referencePoint);
        WizardDialog wizard = new WizardDialog(shell, (IWizard)fixedDateWizard);
        int open = wizard.open();
        if (open == 0) {
            FixedDate newFixedDate = fixedDateWizard.getFixedDate();
            Map<String, Dependency> parameterBindings = fixedDateWizard.getParameterBindings();
            this.updateFixedDate(template, node, referencePoint, oldFixedDate, newFixedDate, parameterBindings);
            return newFixedDate;
        }
        return null;
    }

    public void updateFixedDate(Template template, Node node, TimeModelConstants.ReferencePoint referencePoint, FixedDate oldFixedDate, FixedDate newFixedDate, Map<String, Dependency> parameterBindings) {
        this.commit(template, node, newFixedDate, referencePoint);
        Set<String> oldParameterBindings = Collections.emptySet();
        if (oldFixedDate != null) {
            oldParameterBindings = this.getParameters(oldFixedDate);
        }
        UpdateManager updateManager = Activator.getModellingClientService().getUpdateManager();
        SessionToken session = Activator.getModellingClientService().getSessionToken();
        CheckReport checkReport = new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)template, (String)"localhost"));
        this.updateParameterBinding(session, template, node, oldParameterBindings, parameterBindings, checkReport, updateManager);
        if (checkReport.getCheckResult().ordinal() >= CheckReport.ResultType.WARNING.ordinal()) {
            this.logger.severe("Unable to perform all changes:\n" + checkReport.getReportSummary());
        }
    }

    public void updateParameterBinding(SessionToken session, Template template, Node node, Set<String> oldParameterBindings, Map<String, Dependency> parameterBindings, CheckReport checkReport, UpdateManager updateManager) {
        if (oldParameterBindings != null) {
            if (parameterBindings != null) {
                oldParameterBindings.removeAll(parameterBindings.keySet());
            }
            for (String string : oldParameterBindings) {
                SystemParamaterTools.removeParameterConnection(session, template, node, updateManager, checkReport, string);
            }
        }
        if (parameterBindings != null) {
            for (Map.Entry entry : parameterBindings.entrySet()) {
                DataElement de = (DataElement)((Dependency)entry.getValue()).getArgument();
                SystemParamaterTools.addParameterConnection(session, template, node, de, updateManager, checkReport, (String)entry.getKey(), ProcessConstants.UNIVERSAL_IDENTIFIER_ID, de.getDataType());
            }
        }
    }

    private void commit(Template template, Node node, FixedDate newFixedDate, TimeModelConstants.ReferencePoint referencePoint) {
        UpdateManager updateManager = Activator.getModellingClientService().getUpdateManager();
        String transactionLabel = String.format("Changing duration of Node %s", node.getName());
        HashMap temporalInformation = node.getPluginData("TimeData.NodeTemporalInformation") != null ? new HashMap(node.getPluginData("TimeData.NodeTemporalInformation").getPluginData()) : new HashMap();
        NodeTemporalInformation nodeTemporalInformation = (NodeTemporalInformation)ModelViewer.createView(temporalInformation, NodeTemporalInformation.class);
        switch (referencePoint) {
            case START: {
                nodeTemporalInformation.setStartFixedDate(newFixedDate);
                break;
            }
            case COMPLETION: {
                nodeTemporalInformation.setCompletionFixedDate(newFixedDate);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        StartTransaction.performOperation((ChangeableTemplate)((ChangeableTemplate)template), (UpdateManager)updateManager);
        try {
            DefaultPluginData nodeTemporalInformationPluginData = new DefaultPluginData("TimeData.NodeTemporalInformation", temporalInformation);
            if (UpdatePluginDataContainer.isPossible((Template)template, (PluginDataContainer)node, (String)"TimeData.NodeTemporalInformation", (String)"TimeData.NodeTemporalInformation", (PluginData)nodeTemporalInformationPluginData)) {
                UpdatePluginDataContainer.performOperation((ChangeableTemplate)((ChangeableTemplate)template), (PluginDataContainer)node, (String)"TimeData.NodeTemporalInformation", (String)"TimeData.NodeTemporalInformation", (PluginData)nodeTemporalInformationPluginData, (UpdateManager)updateManager);
            }
        }
        finally {
            EndTransaction.performOperation((ChangeableTemplate)((ChangeableTemplate)template), (UpdateManager)updateManager, (String)transactionLabel);
        }
    }

    public Set<String> getParameters(FixedDate fixedDate) {
        Set<ParameterRef> paramatereRefs = this.getParameterRefs(fixedDate);
        HashSet<String> result = new HashSet<String>();
        for (ParameterRef ref : paramatereRefs) {
            result.add(ref.getName());
        }
        return result;
    }

    private Set<ParameterRef> getParameterRefs(FixedDate fixedDate) {
        PluginData configuration;
        FixedDateUpdateProcedureData updateProcedure = fixedDate.getFixedDateUpdateProcedure();
        if (updateProcedure != null && (configuration = updateProcedure.getConfiguration()) != null) {
            return SystemParamaterTools.getParamaterRefs(configuration);
        }
        return Collections.emptySet();
    }
}

