/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.sections;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.changeoperations.UpdatePluginDataContainer;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.systemdata.Dependency;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.globals.TimeModelConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.timemodel.NodeTemporalInformation;
import de.aristaflow.adept2.model.processmodel.timemodel.ScheduleRestrictedElement;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeModelTools;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.AbstractNodePropertySection;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.NodeTimeConstraintsSection;
import de.aristaflow.adept2.ui.processvisualisation.timeconstraints.SystemParamaterTools;
import de.aristaflow.adept2.ui.processvisualisation.wizards.scheduleRestricted.IScheduleRestrictedWizard;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;

public class NodeScheduleRestrictedPropertySection
extends AbstractNodePropertySection {
    protected Logger logger = LoggerTools.getLogger((Object)this);
    private Text startScheduleRestrText;
    private ScheduleRestrictedElement startSchedule;
    private ScheduleRestrictedElement completionSchedule;
    private Text completionScheduleRestrText;
    private Section section;

    public NodeScheduleRestrictedPropertySection(NodeTimeConstraintsSection propertySection) {
        super(propertySection);
    }

    @Override
    protected void commit(NodeTemporalInformation nodeTemporalInformation) {
        this.modified = false;
    }

    private void commit(Template template, Node node, ScheduleRestrictedElement newSchedule, TimeModelConstants.ReferencePoint referencePoint) {
        UpdateManager updateManager = Activator.getModellingClientService().getUpdateManager();
        String transactionLabel = String.format("Changing duration of Node %s", node.getName());
        HashMap temporalInformation = node.getPluginData("TimeData.NodeTemporalInformation") != null ? new HashMap(node.getPluginData("TimeData.NodeTemporalInformation").getPluginData()) : new HashMap();
        NodeTemporalInformation nodeTemporalInformation = (NodeTemporalInformation)ModelViewer.createView(temporalInformation, NodeTemporalInformation.class);
        switch (referencePoint) {
            case START: {
                nodeTemporalInformation.setStartSchedule(newSchedule);
                break;
            }
            case COMPLETION: {
                nodeTemporalInformation.setCompletionSchedule(newSchedule);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        StartTransaction.performOperation((ChangeableTemplate)((ChangeableTemplate)template), (UpdateManager)updateManager);
        try {
            DefaultPluginData nodeTemporalInformationPluginData = new DefaultPluginData("TimeData.NodeTemporalInformation", temporalInformation);
            if (UpdatePluginDataContainer.isPossible((Template)template, (PluginDataContainer)node, (String)"TimeData.NodeTemporalInformation", (String)"TimeData.NodeTemporalInformation", (PluginData)nodeTemporalInformationPluginData)) {
                UpdatePluginDataContainer.performOperation((ChangeableTemplate)((ChangeableTemplate)template), (PluginDataContainer)node, (String)"TimeData.NodeTemporalInformation", (String)"TimeData.NodeTemporalInformation", (PluginData)nodeTemporalInformationPluginData, (UpdateManager)updateManager);
            }
        }
        finally {
            EndTransaction.performOperation((ChangeableTemplate)((ChangeableTemplate)template), (UpdateManager)updateManager, (String)transactionLabel);
        }
    }

    @Override
    public void createControls(Composite parent) {
        this.section = this.createSection(parent, "Schedule Restriction", "Specify a schedule-based restriction for the activity. It is possible to specify a schedule-based restriction for the start as well as the completion of the activity.");
        this.setComposite((Composite)this.section);
        this.section.setExpanded(false);
        Composite scheduleRestrictedClient = this.toolkit.createComposite((Composite)this.section);
        this.section.setClient((Control)scheduleRestrictedClient);
        scheduleRestrictedClient.setLayout((Layout)new GridLayout(1, false));
        this.createScheduleRestrictedGroup(scheduleRestrictedClient);
    }

    private void createScheduleRestrictedGroup(Composite scheduleRestrictedClient) {
        Group startScheduleGroup = this.toolkit.createGroup(scheduleRestrictedClient, "Activity Start");
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 10;
        startScheduleGroup.setLayout((Layout)gl);
        this.startScheduleRestrText = new Text((Composite)startScheduleGroup, 2116);
        GridData gridDataText = new GridData(4, 4, true, false);
        gridDataText.minimumHeight = 200;
        gridDataText.widthHint = 300;
        this.startScheduleRestrText.setLayoutData((Object)gridDataText);
        this.startScheduleRestrText.setText("not set ");
        this.startScheduleRestrText.setEditable(false);
        Composite buttonWrapper = this.toolkit.createComposite((Composite)startScheduleGroup);
        buttonWrapper.setLayout((Layout)new GridLayout(2, true));
        Button scheduleChangeButton = this.toolkit.createButton(buttonWrapper, "change", 0);
        scheduleChangeButton.setEnabled(true);
        scheduleChangeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleRestrictedElement scheduleRestrictedElement = NodeScheduleRestrictedPropertySection.this.openScheduleRestrictedElementWizard(NodeScheduleRestrictedPropertySection.this.propertySection.getPart().getSite().getShell(), NodeScheduleRestrictedPropertySection.this.getTemplate(), NodeScheduleRestrictedPropertySection.this.getNode(), NodeScheduleRestrictedPropertySection.this.startSchedule, TimeModelConstants.ReferencePoint.START);
                if (scheduleRestrictedElement != null) {
                    NodeScheduleRestrictedPropertySection.this.startSchedule = scheduleRestrictedElement;
                    NodeScheduleRestrictedPropertySection.this.setDataToWidgets();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        scheduleChangeButton.setLayoutData((Object)new GridData(4, 4, true, false));
        Button startClearButton = this.toolkit.createButton(buttonWrapper, "clear", 0);
        startClearButton.setLayoutData((Object)new GridData(4, 4, true, false));
        startClearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleRestrictedElement oldStartSchedule = NodeScheduleRestrictedPropertySection.this.startSchedule;
                NodeScheduleRestrictedPropertySection.this.startSchedule = null;
                Map<String, Dependency> emptyMap = Collections.emptyMap();
                NodeScheduleRestrictedPropertySection.this.updateSchedule(NodeScheduleRestrictedPropertySection.this.getTemplate(), NodeScheduleRestrictedPropertySection.this.getNode(), TimeModelConstants.ReferencePoint.START, oldStartSchedule, NodeScheduleRestrictedPropertySection.this.startSchedule, emptyMap);
                NodeScheduleRestrictedPropertySection.this.setDataToWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Group completionScheduleGroup = this.toolkit.createGroup(scheduleRestrictedClient, "Activity Completion");
        gl = new GridLayout(2, false);
        gl.horizontalSpacing = 10;
        completionScheduleGroup.setLayout((Layout)gl);
        this.completionScheduleRestrText = new Text((Composite)completionScheduleGroup, 2116);
        gridDataText = new GridData(4, 4, true, false);
        gridDataText.minimumHeight = 200;
        gridDataText.widthHint = 300;
        this.completionScheduleRestrText.setLayoutData((Object)gridDataText);
        this.completionScheduleRestrText.setText("not set ");
        this.completionScheduleRestrText.setEditable(false);
        buttonWrapper = this.toolkit.createComposite((Composite)completionScheduleGroup);
        buttonWrapper.setLayout((Layout)new GridLayout(2, true));
        scheduleChangeButton = this.toolkit.createButton(buttonWrapper, "change", 524288);
        scheduleChangeButton.setEnabled(true);
        scheduleChangeButton.setLayoutData((Object)new GridData(4, 4, true, false));
        scheduleChangeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleRestrictedElement scheduleRestrictedElement = NodeScheduleRestrictedPropertySection.this.openScheduleRestrictedElementWizard(NodeScheduleRestrictedPropertySection.this.propertySection.getPart().getSite().getShell(), NodeScheduleRestrictedPropertySection.this.getTemplate(), NodeScheduleRestrictedPropertySection.this.getNode(), NodeScheduleRestrictedPropertySection.this.completionSchedule, TimeModelConstants.ReferencePoint.COMPLETION);
                if (scheduleRestrictedElement != null) {
                    NodeScheduleRestrictedPropertySection.this.completionSchedule = scheduleRestrictedElement;
                    NodeScheduleRestrictedPropertySection.this.setDataToWidgets();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        startClearButton = this.toolkit.createButton(buttonWrapper, "clear", 524288);
        startClearButton.setLayoutData((Object)new GridData(4, 4, true, false));
        startClearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleRestrictedElement oldSchedule = NodeScheduleRestrictedPropertySection.this.completionSchedule;
                NodeScheduleRestrictedPropertySection.this.completionSchedule = null;
                Map<String, Dependency> emptyMap = Collections.emptyMap();
                NodeScheduleRestrictedPropertySection.this.updateSchedule(NodeScheduleRestrictedPropertySection.this.getTemplate(), NodeScheduleRestrictedPropertySection.this.getNode(), TimeModelConstants.ReferencePoint.COMPLETION, oldSchedule, NodeScheduleRestrictedPropertySection.this.completionSchedule, emptyMap);
                NodeScheduleRestrictedPropertySection.this.setDataToWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected ScheduleRestrictedElement openScheduleRestrictedElementWizard(Shell shell, Template template, Node node, ScheduleRestrictedElement oldSchedule, TimeModelConstants.ReferencePoint referencePoint) {
        IScheduleRestrictedWizard scheduleWizard = this.getScheduleRestrictedElementWizard();
        scheduleWizard.init(template, node, oldSchedule, referencePoint);
        WizardDialog wizard = new WizardDialog(shell, (IWizard)scheduleWizard);
        int open = wizard.open();
        if (open == 0) {
            ScheduleRestrictedElement newSchedule = scheduleWizard.getScheduleRestrictedElement();
            Map<String, Dependency> parameterBindings = scheduleWizard.getParameterBindings();
            this.updateSchedule(template, node, referencePoint, oldSchedule, newSchedule, parameterBindings);
            return newSchedule;
        }
        return null;
    }

    public void updateSchedule(Template template, Node node, TimeModelConstants.ReferencePoint referencePoint, ScheduleRestrictedElement oldSchedule, ScheduleRestrictedElement newSchedule, Map<String, Dependency> parameterBindings) {
        this.commit(template, node, newSchedule, referencePoint);
        Set<String> oldParameterBindings = Collections.emptySet();
        if (oldSchedule != null) {
            oldParameterBindings = this.getParameters(oldSchedule);
        }
        UpdateManager updateManager = Activator.getModellingClientService().getUpdateManager();
        SessionToken session = Activator.getModellingClientService().getSessionToken();
        CheckReport checkReport = new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)template, (String)"localhost"));
        this.updateParameterBinding(session, template, node, oldParameterBindings, parameterBindings, checkReport, updateManager);
        if (checkReport.getCheckResult().ordinal() >= CheckReport.ResultType.WARNING.ordinal()) {
            this.logger.severe("Unable to perform all changes:\n" + checkReport.getReportSummary());
        }
    }

    public void updateParameterBinding(SessionToken session, Template template, Node node, Set<String> oldParameterBindings, Map<String, Dependency> parameterBindings, CheckReport checkReport, UpdateManager updateManager) {
        if (oldParameterBindings != null) {
            if (parameterBindings != null) {
                oldParameterBindings.removeAll(parameterBindings.keySet());
            }
            for (String string : oldParameterBindings) {
                SystemParamaterTools.removeParameterConnection(session, template, node, updateManager, checkReport, string);
            }
        }
        if (parameterBindings != null) {
            for (Map.Entry entry : parameterBindings.entrySet()) {
                DataElement de = (DataElement)((Dependency)entry.getValue()).getArgument();
                SystemParamaterTools.addParameterConnection(session, template, node, de, updateManager, checkReport, (String)entry.getKey(), ProcessConstants.UNIVERSAL_IDENTIFIER_ID, de.getDataType());
            }
        }
    }

    public Set<String> getParameters(ScheduleRestrictedElement ScheduleRestrictedElement2) {
        Set<ParameterRef> paramatereRefs = this.getParameterRefs(ScheduleRestrictedElement2);
        HashSet<String> result = new HashSet<String>();
        for (ParameterRef ref : paramatereRefs) {
            result.add(ref.getName());
        }
        return result;
    }

    private Set<ParameterRef> getParameterRefs(ScheduleRestrictedElement scheduleRestrictedElement) {
        return Collections.emptySet();
    }

    @Override
    public void setInput(Template template, Node node) {
        super.setInput(template, node);
        boolean expanded = false;
        if (node != null) {
            this.startSchedule = TimeModelTools.getStartSchedule((Node)node);
            if (this.startSchedule == null) {
                this.startSchedule = (ScheduleRestrictedElement)ModelViewer.createNew(ScheduleRestrictedElement.class);
                this.startSchedule.setReferencePoint(TimeModelConstants.ReferencePoint.START);
            } else {
                expanded = true;
            }
            this.completionSchedule = TimeModelTools.getCompletionSchedule((Node)node);
            if (this.completionSchedule == null) {
                this.completionSchedule = (ScheduleRestrictedElement)ModelViewer.createNew(ScheduleRestrictedElement.class);
                this.completionSchedule.setReferencePoint(TimeModelConstants.ReferencePoint.COMPLETION);
            } else {
                expanded = true;
            }
        } else {
            this.startSchedule = null;
            this.completionSchedule = null;
        }
        this.setDataToWidgets();
        this.section.setExpanded(expanded);
        this.modified = false;
    }

    public void setDataToWidgets() {
        if (this.startSchedule == null || this.startSchedule.getSchedule() == null) {
            this.startScheduleRestrText.setText("not set");
        } else {
            this.startScheduleRestrText.setText(this.startSchedule.getSchedule());
        }
        if (this.completionSchedule == null || this.completionSchedule.getSchedule() == null) {
            this.completionScheduleRestrText.setText("not set");
        } else {
            this.completionScheduleRestrText.setText(this.completionSchedule.getSchedule());
        }
    }

    private IScheduleRestrictedWizard getScheduleRestrictedElementWizard() {
        IScheduleRestrictedWizard wizard = null;
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("de.aristaflow.adept2.ui.processvisualisation.timeconstraints.ScheduleRestrictedWizard");
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                System.out.println("Evaluating extension");
                Object o = element.createExecutableExtension("class");
                if (o instanceof IScheduleRestrictedWizard) {
                    wizard = (IScheduleRestrictedWizard)o;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            System.out.println(ex.getMessage());
        }
        return wizard;
    }
}

