/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.sections;

import de.aristaflow.adept2.core.checks.processmodel.ProcessCheckService;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheck;
import de.aristaflow.adept2.core.checks.processmodel.ProcessTemplateCheckRunner;
import de.aristaflow.adept2.core.timemanager.TimeManager;
import de.aristaflow.adept2.model.common.timedata.TimeDistance;
import de.aristaflow.adept2.model.common.timedata.TimePoint;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemporalTemplate;
import de.aristaflow.adept2.model.processmodel.timemodel.ProcessDuration;
import de.aristaflow.adept2.model.processmodel.timemodel.TemplateTemporalInformation;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeModelTools;
import de.aristaflow.adept2.model.processmodel.tools.NodeRelations;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.timemodel.GuardedInterval;
import de.aristaflow.adept2.model.timemodel.InconsistencyException;
import de.aristaflow.adept2.model.timemodel.TemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModel;
import de.aristaflow.adept2.model.timemodel.TimeModelFactory;
import de.aristaflow.adept2.model.timemodel.TimeModelOperations;
import de.aristaflow.adept2.model.timemodel.tcn.ChangeableTCN;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledEdge;
import de.aristaflow.adept2.model.timemodel.tcn.LabeledTimePoint;
import de.aristaflow.adept2.model.timemodel.tcn.TCN;
import de.aristaflow.adept2.model.timemodel.tcn.TCNSolver;
import de.aristaflow.adept2.model.timemodel.tcn.TCNTemplateTimeModel;
import de.aristaflow.adept2.model.timemodel.tcn.defaultimplementation.TCNAlgorithms;
import de.aristaflow.adept2.ui.dialogues.CheckReportDialogue;
import de.aristaflow.adept2.ui.processvisualisation.preferences.LocalTimeModellingService;
import de.aristaflow.adept2.ui.processvisualisation.preferences.TimeModelPreferences;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.AbstractTemplatePropertySection;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.TemplateTimeConstraintsSection;
import de.aristaflow.adept2.ui.processvisualisation.timeconstraints.Activator;
import de.aristaflow.adept2.ui.processvisualisation.widgets.GraphicalDurationWidget;
import de.aristaflow.adept2.ui.processvisualisation.widgets.TimePointWidget;
import de.aristaflow.adept2.util.CheckReport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TemplateDurationPropertySection
extends AbstractTemplatePropertySection {
    TimePointWidget flexibleMinSpinner;
    TimePointWidget guardMinSpinner;
    TimePointWidget guardMaxSpinner;
    TimePointWidget flexibleMaxSpinner;
    TimePointWidget expectedSpinner;
    private GraphicalDurationWidget graphicalWidget;
    private ProcessDuration processDuration;
    Section section;
    private Job processDurationThread;
    private TimePointWidget contingencySpinner;

    public TemplateDurationPropertySection(TemplateTimeConstraintsSection propertySection) {
        super(propertySection);
    }

    @Override
    protected void commit(TemplateTemporalInformation templateTemporalInformation) {
        this.abortCalculation();
        templateTemporalInformation.setProcessDuration(this.processDuration);
        this.modified = false;
    }

    private void abortCalculation() {
        if (this.processDurationThread != null) {
            this.processDurationThread.cancel();
        }
    }

    @Override
    public void createControls(Composite parent) {
        this.section = this.createSection(parent, "Process Duration", "In this Section you can specify the duration of the process");
        this.setComposite((Composite)this.section);
        Composite processDurationClient = this.toolkit.createComposite((Composite)this.section);
        this.section.setClient((Control)processDurationClient);
        processDurationClient.setLayout((Layout)new GridLayout(2, false));
        this.createProcessDurationWidgets(processDurationClient);
        this.createGraphicalRepresentation(processDurationClient);
    }

    private void createProcessDurationWidgets(Composite composite) {
        Group activityDurationGroup = this.toolkit.createGroup(composite, "Formal View");
        GridData gridData = new GridData(4, 4, false, false);
        activityDurationGroup.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        activityDurationGroup.setLayout((Layout)layout);
        TimePointWidget.TimePointModifyListener activityDurationSelectionListener = new TimePointWidget.TimePointModifyListener(){

            @Override
            public void modifyTimePoint(TimePointWidget source, TimePoint newTimePoint) {
                TemplateDurationPropertySection.this.validate(source);
            }
        };
        GridDataFactory gridDataFactory = GridDataFactory.createFrom((GridData)new GridData(4, 0x1000000, true, false));
        this.flexibleMinSpinner = new TimePointWidget((Composite)activityDurationGroup, 0, "Minimum", (FormToolkit)this.toolkit);
        this.flexibleMinSpinner.setLayoutData(gridDataFactory.create());
        this.flexibleMinSpinner.addModifyListener(activityDurationSelectionListener);
        this.guardMinSpinner = new TimePointWidget((Composite)activityDurationGroup, 0, "Guard Minimum", (FormToolkit)this.toolkit);
        this.guardMinSpinner.setLayoutData(gridDataFactory.create());
        this.guardMinSpinner.addModifyListener(activityDurationSelectionListener);
        this.guardMaxSpinner = new TimePointWidget((Composite)activityDurationGroup, 0, "Guard Maximum", (FormToolkit)this.toolkit);
        this.guardMaxSpinner.setLayoutData(gridDataFactory.create());
        this.guardMaxSpinner.addModifyListener(activityDurationSelectionListener);
        this.flexibleMaxSpinner = new TimePointWidget((Composite)activityDurationGroup, 0, "Maximum", (FormToolkit)this.toolkit);
        this.flexibleMaxSpinner.setLayoutData(gridDataFactory.create());
        this.flexibleMaxSpinner.addModifyListener(activityDurationSelectionListener);
        this.contingencySpinner = new TimePointWidget((Composite)activityDurationGroup, 0, "Contingency", (FormToolkit)this.toolkit);
        this.contingencySpinner.setLayoutData(gridDataFactory.create());
        this.contingencySpinner.addModifyListener(activityDurationSelectionListener);
        Button updateButton = this.toolkit.createButton((Composite)activityDurationGroup, "Derive Duration from Template", 8);
        updateButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, layout.numColumns - 1, 1));
        updateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TemplateDurationPropertySection.this.calculateProcessDuration();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Label separator = this.toolkit.createSeparator((Composite)activityDurationGroup, 256);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, false, false, layout.numColumns, 1));
        this.expectedSpinner = new TimePointWidget((Composite)activityDurationGroup, 0, "Expected Duration", (FormToolkit)this.toolkit);
        this.expectedSpinner.addModifyListener(activityDurationSelectionListener);
        this.expectedSpinner.setLayoutData(gridDataFactory.create());
    }

    protected void calculateProcessDuration() {
        CheckReport checkReport;
        if (this.processDurationThread != null) {
            return;
        }
        ProcessCheckService processChecks = Activator.getModellingClientService().getProcessChecks();
        ProcessTemplateCheckRunner testClientChecks = new ProcessTemplateCheckRunner(new ProcessTemplateCheck[]{processChecks.getConsistencyChecks(), processChecks.getStructureChecks(), processChecks.getBasicModellingChecks()});
        boolean result = testClientChecks.performCheck(this.template, new NodeRelations(this.template), checkReport = new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)this.template, (String)"localhost")));
        if (!result) {
            Shell shell = this.getComposite().getShell();
            String message = "Template does not fulfil basic checks, aborting!";
            CheckReportDialogue dialog = new CheckReportDialogue(shell, checkReport, message, 1, CheckReport.ResultType.WARNING);
            dialog.open();
            if (checkReport.getCheckResult().compareTo((Enum)CheckReport.ResultType.WARNING) > 0) {
                return;
            }
        }
        this.processDurationThread = new ProcessDurationJob("Calculating process duration");
        this.processDurationThread.schedule();
    }

    private void createGraphicalRepresentation(Composite composite) {
        Group graphicalDurationGroup = this.toolkit.createGroup(composite, "Graphical View");
        GridData gridData = new GridData(4, 4, true, false);
        graphicalDurationGroup.setLayoutData((Object)gridData);
        graphicalDurationGroup.setLayout((Layout)new GridLayout(1, false));
        this.graphicalWidget = new GraphicalDurationWidget((Composite)graphicalDurationGroup, 0, true, (FormToolkit)this.toolkit);
        GridData graphGridData = new GridData(4, 4, true, true);
        this.graphicalWidget.setLayoutData(graphGridData);
    }

    protected void validate(TimePointWidget spinner) {
        TimePoint newDuration;
        TimePoint expected;
        TimePoint flexibleMax;
        TimePoint guardedMax;
        TimePoint guardedMin;
        if (this.getTemplate() == null) {
            return;
        }
        TimePoint flexibleMin = this.flexibleMinSpinner.getTimePoint();
        TimePoint correctedDuration = this.validateDurations(spinner, flexibleMin, guardedMin = this.guardMinSpinner.getTimePoint(), guardedMax = this.guardMaxSpinner.getTimePoint(), flexibleMax = this.flexibleMaxSpinner.getTimePoint(), expected = this.expectedSpinner.getTimePoint(), newDuration = spinner.getTimePoint());
        if (correctedDuration != null) {
            spinner.setTimePoint(correctedDuration);
            newDuration = correctedDuration;
        }
        if (spinner == this.expectedSpinner) {
            this.processDuration.setExpectedDuration(newDuration);
            this.graphicalWidget.setExpectedValue(newDuration);
        } else if (spinner == this.flexibleMinSpinner) {
            this.processDuration.setFlexibleMinimumDuration(newDuration);
            this.graphicalWidget.setFlexibleMinimumValue(newDuration);
        } else if (spinner == this.guardMinSpinner) {
            this.processDuration.setGuardMinimumDuration(newDuration);
            this.graphicalWidget.setGuardMinimumValue(newDuration);
        } else if (spinner == this.guardMaxSpinner) {
            this.processDuration.setGuardMaximumDuration(newDuration);
            this.graphicalWidget.setGuardMaximumValue(newDuration);
        } else if (spinner == this.flexibleMaxSpinner) {
            this.processDuration.setFlexibleMaximumDuration(newDuration);
            this.graphicalWidget.setFlexibleMaximumValue(newDuration);
        }
        if (spinner == this.contingencySpinner) {
            this.processDuration.setContingency(newDuration);
        }
        this.setModified();
        this.graphicalWidget.redraw();
    }

    private long toTimeStamp(TimePoint timePoint) {
        if (timePoint == null) {
            return Long.MIN_VALUE;
        }
        long minutes = 0L;
        long hours = 0L;
        long days = 0L;
        long months = 0L;
        if (timePoint.getMinutes() != Long.MIN_VALUE) {
            minutes = timePoint.getMinutes();
        }
        if (timePoint.getHours() != Long.MIN_VALUE) {
            hours = timePoint.getHours();
        }
        if (timePoint.getDays() != Long.MIN_VALUE) {
            days = timePoint.getDays();
        }
        if (timePoint.getMonths() != Long.MIN_VALUE) {
            months = timePoint.getMonths();
        }
        return (minutes + (hours + (days + months * 30L) * 24L) * 60L) * 60L * 1000L;
    }

    private TimePoint validateDurations(TimePointWidget spinner, TimePoint flexibleMin, TimePoint guardedMin, TimePoint guardedMax, TimePoint flexibleMax, TimePoint expected, TimePoint newDuration) {
        long newDurationL = this.toTimeStamp(newDuration);
        long flexibleMinL = this.toTimeStamp(flexibleMin);
        long flexibleMaxL = this.toTimeStamp(flexibleMax);
        long guardedMaxL = this.toTimeStamp(guardedMax);
        TimePoint newValue = null;
        if (spinner == this.expectedSpinner) {
            if (newDurationL < flexibleMinL) {
                newValue = flexibleMin;
            }
            if (flexibleMax != null && newDurationL > flexibleMaxL) {
                newValue = flexibleMax;
            }
            if (flexibleMax == null && guardedMax != null && newDurationL > guardedMaxL) {
                newValue = guardedMax;
            }
        } else if (spinner == this.flexibleMinSpinner) {
            if (guardedMax != null && newDurationL > guardedMaxL) {
                newValue = guardedMax;
            } else if (guardedMax == null && flexibleMax != null && newDurationL > flexibleMaxL) {
                newValue = flexibleMax;
            }
        } else if (spinner == this.guardMaxSpinner) {
            if (flexibleMax != null && newDurationL > flexibleMaxL) {
                newValue = flexibleMax;
            }
            if (flexibleMin != null && newDurationL < flexibleMinL) {
                newValue = flexibleMin;
            }
        } else if (spinner == this.flexibleMaxSpinner) {
            if (newDurationL < guardedMaxL) {
                newValue = guardedMax;
            }
            if (guardedMax == null && flexibleMin != null && newDurationL < flexibleMinL) {
                newValue = flexibleMin;
            }
        }
        if (newValue != null && newDuration != null) {
            if (newValue.getMonths() > newDuration.getMonths()) {
                newDuration.setMonths(newValue.getMonths());
            } else if (newValue.getDays() > newDuration.getDays()) {
                newDuration.setDays(newValue.getDays());
            } else if (newValue.getHours() > newDuration.getHours()) {
                newDuration.setHours(newValue.getHours());
            } else if (newValue.getMinutes() > newDuration.getMinutes()) {
                newDuration.setMinutes(newValue.getMinutes());
            } else if (newValue.getSeconds() > newDuration.getSeconds()) {
                newDuration.setSeconds(newValue.getSeconds());
            }
            return newDuration;
        }
        return null;
    }

    @Override
    public void setInput(Template template) {
        this.abortCalculation();
        super.setInput(template);
        if (template != null) {
            this.processDuration = TimeModelTools.getProcessDuration((Template)template);
            if (this.processDuration == null) {
                this.processDuration = (ProcessDuration)ModelViewer.createNew(ProcessDuration.class);
            }
        } else {
            this.processDuration = null;
        }
        this.setDataToWidgets();
        this.modified = false;
    }

    private void setDataToWidgets() {
        TimeModelPreferences preferences = TimeModelPreferences.getInstance();
        if (this.processDuration != null) {
            this.expectedSpinner.setTimePoint(this.processDuration.getExpectedDuration());
            this.graphicalWidget.setExpectedValue(this.processDuration.getExpectedDuration());
            this.flexibleMinSpinner.setTimePoint(this.processDuration.getMinimumDuration());
            this.graphicalWidget.setFlexibleMinimumValue(this.processDuration.getMinimumDuration());
            this.guardMinSpinner.setTimePoint(this.processDuration.getGuardMinimumDuration());
            this.graphicalWidget.setGuardMinimumValue(this.processDuration.getGuardMinimumDuration());
            this.guardMaxSpinner.setTimePoint(this.processDuration.getGuardMaximumDuration());
            this.graphicalWidget.setGuardMaximumValue(this.processDuration.getGuardMaximumDuration());
            this.flexibleMaxSpinner.setTimePoint(this.processDuration.getMaximumDuration());
            this.graphicalWidget.setFlexibleMaximumValue(this.processDuration.getMaximumDuration());
            this.contingencySpinner.setTimePoint(this.processDuration.getContingency());
        } else {
            this.expectedSpinner.setTimePoint(null);
            this.flexibleMinSpinner.setTimePoint(null);
            this.guardMinSpinner.setTimePoint(null);
            this.guardMaxSpinner.setTimePoint(null);
            this.flexibleMaxSpinner.setTimePoint(null);
            this.contingencySpinner.setTimePoint(null);
            this.graphicalWidget.setExpectedValue(null);
            this.graphicalWidget.setFlexibleMinimumValue(null);
            this.graphicalWidget.setGuardMinimumValue(null);
            this.graphicalWidget.setGuardMaximumValue(null);
            this.graphicalWidget.setFlexibleMaximumValue(null);
        }
        boolean hasContingency = false;
        boolean hasMinGuard = false;
        boolean hasMaxGuard = false;
        switch (preferences.getTimeModelType()) {
            case CSTN: {
                break;
            }
            case CSTNU: {
                break;
            }
            case CSTNU_EXTENDED: {
                hasMaxGuard = true;
                break;
            }
        }
        this.setVisibility(this.contingencySpinner, hasContingency);
        this.setVisibility(this.guardMinSpinner, hasMinGuard);
        this.setVisibility(this.guardMaxSpinner, hasMaxGuard);
        this.graphicalWidget.redraw();
    }

    private void setVisibility(TimePointWidget widget, boolean visible) {
        widget.setVisible(visible);
        ((GridData)widget.getLayoutData()).exclude = !visible;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.processDurationThread != null) {
            this.abortCalculation();
        }
    }

    private final class ProcessDurationJob
    extends Job {
        private ProcessDurationJob(String name) {
            super(name);
            this.setUser(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            TimeModelPreferences preferences = TimeModelPreferences.getInstance();
            TimeManager timeManager = Activator.getTimeManager();
            LocalTimeModellingService timeModellingService = new LocalTimeModellingService(timeManager, preferences);
            TimeModelFactory factory = timeModellingService.getTimeModelFactory();
            try {
                TemporalTemplate temporalTemplate = factory.createTemporalTemplate(TemplateDurationPropertySection.this.template);
                TemplateTimeModel timeModel = factory.createTimeModelForTemplate(temporalTemplate);
                final TimeModelOperations timeModelOperations = factory.getTimeModelOperations();
                if (Thread.currentThread().isInterrupted() || monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                TCNTemplateTimeModel tcnTemplateTimeModel = (TCNTemplateTimeModel)timeModel;
                TCN cstnu = tcnTemplateTimeModel.getBaseTimeModel();
                this.doCheckConsistency(monitor, (TCN<LabeledTimePoint, LabeledEdge>)cstnu);
                if (Thread.currentThread().isInterrupted() || monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                final GuardedInterval restrictableDuration = timeModelOperations.getRestrictableProcessDuration((TimeModel)timeModel);
                if (Thread.currentThread().isInterrupted() || monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                try {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("The duration of the process has been determined as:\n");
                            stringBuilder.append("Overall Duration:\t");
                            stringBuilder.append("[[").append(restrictableDuration.getFlexibleMinimum()).append(", ").append(restrictableDuration.getGuardedMinimum()).append("] [").append(restrictableDuration.getGuardedMaximum()).append(", ").append(restrictableDuration.getFlexibleMaximum()).append("]]");
                            stringBuilder.append("\n").append("Contingency:\t  ").append(restrictableDuration.getContingency());
                            stringBuilder.append("\n\nDo you want to use these value?");
                            if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Process Duration", (String)stringBuilder.toString())) {
                                TimePoint flexibleMinDuration = timeModelOperations.convertToTimePoint((TimeDistance)restrictableDuration.getFlexibleMinimum());
                                TimePoint guardMinDuration = timeModelOperations.convertToTimePoint((TimeDistance)restrictableDuration.getGuardedMinimum());
                                TimePoint guardMaxDuration = timeModelOperations.convertToTimePoint((TimeDistance)restrictableDuration.getGuardedMaximum());
                                TimePoint flexibleMaxDuration = timeModelOperations.convertToTimePoint((TimeDistance)restrictableDuration.getFlexibleMaximum());
                                ((ProcessDurationJob)ProcessDurationJob.this).TemplateDurationPropertySection.this.flexibleMinSpinner.setTimePoint(flexibleMinDuration);
                                ((ProcessDurationJob)ProcessDurationJob.this).TemplateDurationPropertySection.this.guardMinSpinner.setTimePoint(guardMinDuration);
                                ((ProcessDurationJob)ProcessDurationJob.this).TemplateDurationPropertySection.this.guardMaxSpinner.setTimePoint(guardMaxDuration);
                                ((ProcessDurationJob)ProcessDurationJob.this).TemplateDurationPropertySection.this.flexibleMaxSpinner.setTimePoint(flexibleMaxDuration);
                                TemplateDurationPropertySection.this.contingencySpinner.setTimePoint(timeModelOperations.convertToTimePoint((TimeDistance)restrictableDuration.getContingency()));
                                TemplateDurationPropertySection.this.validate(((ProcessDurationJob)ProcessDurationJob.this).TemplateDurationPropertySection.this.flexibleMinSpinner);
                                TemplateDurationPropertySection.this.validate(((ProcessDurationJob)ProcessDurationJob.this).TemplateDurationPropertySection.this.guardMinSpinner);
                                TemplateDurationPropertySection.this.validate(((ProcessDurationJob)ProcessDurationJob.this).TemplateDurationPropertySection.this.guardMaxSpinner);
                                TemplateDurationPropertySection.this.validate(((ProcessDurationJob)ProcessDurationJob.this).TemplateDurationPropertySection.this.flexibleMaxSpinner);
                                TemplateDurationPropertySection.this.validate(TemplateDurationPropertySection.this.contingencySpinner);
                            }
                        }
                    });
                }
                catch (InconsistencyException e) {
                    String errorMessage = "The process duration could not be calculated because the process is not controllable!";
                    Status status = new Status(4, "de.aristaflow.adept2.ui.processvisualisation.timeconstraints", errorMessage, (Throwable)e);
                    return status;
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "de.aristaflow.adept2.ui.processvisualisation.timeconstraints", "Some unexpected error occurred!", (Throwable)e);
                return status;
            }
            finally {
                TemplateDurationPropertySection.this.processDurationThread = null;
            }
            return Status.OK_STATUS;
        }

        protected void doCheckConsistency(IProgressMonitor monitor, TCN<LabeledTimePoint, LabeledEdge> cstnu) throws InterruptedException, InconsistencyException {
            TCNSolver solver = TCNAlgorithms.getSolver(cstnu);
            try {
                ChangeableTCN result = (ChangeableTCN)cstnu;
                monitor.worked(1);
                try {
                    solver.solve(result);
                }
                finally {
                    monitor.worked(10);
                }
            }
            catch (InconsistencyException e) {
                throw e;
            }
            catch (InterruptedException e) {
                throw e;
            }
        }
    }
}

