/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.sections;

import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.globals.TimeModelConstants;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.timemodel.ScheduleRestrictedElement;
import de.aristaflow.adept2.model.processmodel.timemodel.TemplateTemporalInformation;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeModelTools;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.AbstractTemplatePropertySection;
import de.aristaflow.adept2.ui.processvisualisation.wizards.scheduleRestricted.IScheduleRestrictedWizard;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;

public class TemplateScheduleRestrictedPropertySection
extends AbstractTemplatePropertySection {
    private Text startScheduleRestrText;
    private ScheduleRestrictedElement startSchedule;
    private ScheduleRestrictedElement completionSchedule;
    private Text completionScheduleRestrText;
    private Section section;

    public TemplateScheduleRestrictedPropertySection(AbstractPropertySection propertySection) {
        super(propertySection);
    }

    @Override
    protected void commit(TemplateTemporalInformation temporalInformation) {
        temporalInformation.setStartSchedule(this.startSchedule);
        temporalInformation.setCompletionSchedule(this.completionSchedule);
        this.modified = false;
    }

    @Override
    public void createControls(Composite parent) {
        this.section = this.createSection(parent, "Schedule Restricted", "In this Section you can specifie a schedule-based restriction for this activity");
        this.setComposite((Composite)this.section);
        this.section.setExpanded(false);
        Composite scheduleRestrictedClient = this.toolkit.createComposite((Composite)this.section);
        this.section.setClient((Control)scheduleRestrictedClient);
        scheduleRestrictedClient.setLayout((Layout)new GridLayout(1, false));
        this.createScheduleRestrictedGroup(scheduleRestrictedClient);
    }

    private void createScheduleRestrictedGroup(Composite scheduleRestrictedClient) {
        Group startScheduleGroup = this.toolkit.createGroup(scheduleRestrictedClient, "Process Start");
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 10;
        startScheduleGroup.setLayout((Layout)gl);
        this.startScheduleRestrText = new Text((Composite)startScheduleGroup, 2116);
        GridData gridDataText = new GridData(4, 4, true, false);
        gridDataText.minimumHeight = 200;
        gridDataText.widthHint = 300;
        this.startScheduleRestrText.setLayoutData((Object)gridDataText);
        this.startScheduleRestrText.setText("not set ");
        this.startScheduleRestrText.setEditable(false);
        Composite buttonWrapper = this.toolkit.createComposite((Composite)startScheduleGroup);
        buttonWrapper.setLayout((Layout)new GridLayout(2, true));
        Button scheduleChangeButton = this.toolkit.createButton(buttonWrapper, "change", 524288);
        scheduleChangeButton.setEnabled(true);
        Button startClearButton = this.toolkit.createButton(buttonWrapper, "clear", 524288);
        scheduleChangeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        startClearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TemplateScheduleRestrictedPropertySection.this.startSchedule = (ScheduleRestrictedElement)ModelViewer.createNew(ScheduleRestrictedElement.class);
                TemplateScheduleRestrictedPropertySection.this.setDataToWidgets();
                TemplateScheduleRestrictedPropertySection.this.setModified();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Group completionScheduleGroup = this.toolkit.createGroup(scheduleRestrictedClient, "Process Completion");
        gl = new GridLayout(2, false);
        gl.horizontalSpacing = 10;
        completionScheduleGroup.setLayout((Layout)gl);
        this.completionScheduleRestrText = new Text((Composite)completionScheduleGroup, 2116);
        gridDataText = new GridData(4, 4, true, false);
        gridDataText.minimumHeight = 200;
        gridDataText.widthHint = 300;
        this.completionScheduleRestrText.setLayoutData((Object)gridDataText);
        this.completionScheduleRestrText.setText("not set ");
        this.completionScheduleRestrText.setEditable(false);
        buttonWrapper = this.toolkit.createComposite((Composite)completionScheduleGroup);
        buttonWrapper.setLayout((Layout)new GridLayout(2, true));
        scheduleChangeButton = this.toolkit.createButton(buttonWrapper, "change", 524288);
        scheduleChangeButton.setEnabled(true);
        startClearButton = this.toolkit.createButton(buttonWrapper, "clear", 524288);
        scheduleChangeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        startClearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TemplateScheduleRestrictedPropertySection.this.completionSchedule = (ScheduleRestrictedElement)ModelViewer.createNew(ScheduleRestrictedElement.class);
                TemplateScheduleRestrictedPropertySection.this.setDataToWidgets();
                TemplateScheduleRestrictedPropertySection.this.setModified();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    @Override
    public void setInput(Template template) {
        super.setInput(template);
        boolean expand = false;
        if (template != null) {
            this.startSchedule = TimeModelTools.getStartSchedule((Template)template);
            if (this.startSchedule == null) {
                this.startSchedule = (ScheduleRestrictedElement)ModelViewer.createNew(ScheduleRestrictedElement.class);
                this.startSchedule.setReferencePoint(TimeModelConstants.ReferencePoint.START);
            } else {
                expand = true;
            }
            this.completionSchedule = TimeModelTools.getCompletionSchedule((Template)template);
            if (this.completionSchedule == null) {
                this.completionSchedule = (ScheduleRestrictedElement)ModelViewer.createNew(ScheduleRestrictedElement.class);
                this.completionSchedule.setReferencePoint(TimeModelConstants.ReferencePoint.COMPLETION);
            } else {
                expand = true;
            }
        } else {
            this.startSchedule = null;
            this.completionSchedule = null;
        }
        this.setDataToWidgets();
        this.section.setExpanded(expand);
        this.modified = false;
    }

    public void setDataToWidgets() {
        if (this.startSchedule == null || this.startSchedule.getSchedule() == null) {
            this.startScheduleRestrText.setText("not set");
        } else {
            this.startScheduleRestrText.setText(this.startSchedule.getSchedule());
        }
        if (this.completionSchedule == null || this.completionSchedule.getSchedule() == null) {
            this.completionScheduleRestrText.setText("not set");
        } else {
            this.completionScheduleRestrText.setText(this.completionSchedule.getSchedule());
        }
    }

    private IScheduleRestrictedWizard getScheduleRestrictedElementWizard() {
        IScheduleRestrictedWizard wizard = null;
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("de.aristaflow.adept2.ui.processvisualisation.timeconstraints.ScheduleRestrictedWizard");
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                System.out.println("Evaluating extension");
                Object o = element.createExecutableExtension("class");
                if (o instanceof IScheduleRestrictedWizard) {
                    wizard = (IScheduleRestrictedWizard)o;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            System.out.println(ex.getMessage());
        }
        return wizard;
    }
}

