/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.sections;

import de.aristaflow.adept2.model.common.timedata.TimePoint;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.globals.TimeModelConstants;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.timemodel.ConstraintEdgeTemporalInformation;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeLag;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeModelTools;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.AbstractConstraintEdgePropertySection;
import de.aristaflow.adept2.ui.processvisualisation.widgets.TimePointWidget;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;

public class TimeLagPropertySection
extends AbstractConstraintEdgePropertySection {
    private static final int LOWER_MIN = 0;
    private static final int UPPER_MIN = 1;
    private static final int LOWER_MAX = 2;
    private static final int UPPER_MAX = 3;
    private static final int EXPECTED = 4;
    private Map<TimeModelConstants.RelationType, TimeLag> timeLags;
    private Map<TimeModelConstants.RelationType, TimePointWidget[]> controls = new HashMap<TimeModelConstants.RelationType, TimePointWidget[]>();

    public TimeLagPropertySection(AbstractPropertySection propertySection) {
        super(propertySection);
    }

    @Override
    protected void commit(ConstraintEdgeTemporalInformation edgeTemporalInformation) {
        Iterator<TimeLag> iter = this.timeLags.values().iterator();
        while (iter.hasNext()) {
            TimeLag timeLag = iter.next();
            if (timeLag.getLowerMinimumTimeLag() != null || timeLag.getUpperMinimumTimeLag() != null || timeLag.getLowerMaximumTimeLag() != null || timeLag.getUpperMaximumTimeLag() != null || timeLag.getEscalationData() != null) continue;
            iter.remove();
        }
        TimeLag[] timeLags = this.timeLags.values().toArray(new TimeLag[this.timeLags.values().size()]);
        edgeTemporalInformation.setTimeLags(timeLags);
        this.modified = false;
    }

    @Override
    public void createControls(Composite parent) {
        Section section = this.createSection(parent, "Time Lag", "Add one or more time lags to this constraint edge. A time lag expresses a minimum and maximum temporal distance between the two activities connected by the constraint edge.");
        this.setComposite((Composite)section);
        Composite timeLagClient = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)timeLagClient);
        timeLagClient.setLayout((Layout)new GridLayout(2, true));
        TimeModelConstants.RelationType[] relationTypeArray = TimeModelConstants.RelationType.values();
        int n = relationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeModelConstants.RelationType r = relationTypeArray[n2];
            this.createTimeLagWidgets(timeLagClient, r);
            ++n2;
        }
    }

    @Override
    public void setInput(Template template, ConstraintEdge edge) {
        super.setInput(template, edge);
        if (edge != null) {
            this.timeLags = new HashMap<TimeModelConstants.RelationType, TimeLag>();
            TimeLag[] lags = TimeModelTools.getTimeLags((ConstraintEdge)edge);
            if (lags != null) {
                TimeLag[] timeLagArray = lags;
                int n = lags.length;
                int n2 = 0;
                while (n2 < n) {
                    TimeLag timeLag = timeLagArray[n2];
                    boolean set = timeLag.getExpectedTimeLag() != null | timeLag.getLowerMinimumTimeLag() != null | timeLag.getLowerMaximumTimeLag() != null | timeLag.getUpperMinimumTimeLag() != null | timeLag.getUpperMaximumTimeLag() != null;
                    if (set) {
                        this.timeLags.put(timeLag.getRelationType(), timeLag);
                    }
                    ++n2;
                }
            }
        } else {
            this.timeLags = null;
        }
        this.setDataToWidgets();
        this.modified = false;
    }

    private void setDataToWidgets() {
        TimeModelConstants.RelationType[] relationTypeArray = TimeModelConstants.RelationType.values();
        int n = relationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeModelConstants.RelationType r = relationTypeArray[n2];
            TimePointWidget[] typeControls = this.controls.get(r);
            Section sec = (Section)typeControls[0].getParent().getParent();
            TimeLag timeLag = null;
            if (this.timeLags != null) {
                timeLag = this.timeLags.get(r);
            }
            boolean set = false;
            if (timeLag != null) {
                if (timeLag.getExpectedTimeLag() != null) {
                    typeControls[4].setTimePoint(timeLag.getExpectedTimeLag());
                    set = true;
                } else {
                    typeControls[4].setTimePoint(null);
                }
                if (timeLag.getLowerMinimumTimeLag() != null) {
                    typeControls[0].setTimePoint(timeLag.getLowerMinimumTimeLag());
                    set = true;
                } else {
                    typeControls[0].setTimePoint(null);
                }
                if (timeLag.getLowerMaximumTimeLag() != null) {
                    typeControls[2].setTimePoint(timeLag.getLowerMaximumTimeLag());
                    set = true;
                } else {
                    typeControls[2].setTimePoint(null);
                }
                if (timeLag.getUpperMinimumTimeLag() != null) {
                    typeControls[1].setTimePoint(timeLag.getUpperMinimumTimeLag());
                    set = true;
                } else {
                    typeControls[1].setTimePoint(null);
                }
                if (timeLag.getUpperMaximumTimeLag() != null) {
                    typeControls[3].setTimePoint(timeLag.getUpperMaximumTimeLag());
                    set = true;
                } else {
                    typeControls[3].setTimePoint(null);
                }
            } else {
                TimePointWidget[] timePointWidgetArray = typeControls;
                int n3 = typeControls.length;
                int n4 = 0;
                while (n4 < n3) {
                    TimePointWidget s = timePointWidgetArray[n4];
                    s.setTimePoint(null);
                    ++n4;
                }
            }
            sec.setExpanded(set);
            ++n2;
        }
    }

    private void createTimeLagWidgets(Composite composite, final TimeModelConstants.RelationType relationType) {
        final Section section = this.toolkit.createSection(composite, 386);
        section.setText(relationType.toString());
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                if (e.getState()) {
                    section.setLayoutData((Object)new GridData(4, 4, true, false, 1, 3));
                } else {
                    section.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                }
                section.layout();
                TimeLagPropertySection.this.recursiveLayout(section.getParent());
            }
        });
        GridData gridData = new GridData(4, 4, true, false);
        section.setLayoutData((Object)gridData);
        Composite timeLagGroup = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)timeLagGroup);
        timeLagGroup.setLayout((Layout)new GridLayout(1, false));
        TimePointWidget.TimePointModifyListener timeLagSelectionListener = new TimePointWidget.TimePointModifyListener(){

            @Override
            public void modifyTimePoint(TimePointWidget source, TimePoint newTimePoint) {
                TimeLagPropertySection.this.validate(source, relationType);
            }
        };
        TimePointWidget[] typeControls = new TimePointWidget[5];
        this.controls.put(relationType, typeControls);
        GridDataFactory gridDataFactory = GridDataFactory.createFrom((GridData)new GridData(4, 0x1000000, true, false));
        typeControls[0] = new TimePointWidget(timeLagGroup, 0, "Minimum", (FormToolkit)this.toolkit);
        typeControls[0].setLayoutData(gridDataFactory.create());
        typeControls[0].addModifyListener(timeLagSelectionListener);
        typeControls[1] = new TimePointWidget(timeLagGroup, 0, "Upper Minimum", (FormToolkit)this.toolkit);
        typeControls[1].setLayoutData(gridDataFactory.copy().exclude(true).create());
        typeControls[1].addModifyListener(timeLagSelectionListener);
        typeControls[1].setVisible(false);
        typeControls[2] = new TimePointWidget(timeLagGroup, 0, "Lower Maximum", (FormToolkit)this.toolkit);
        typeControls[2].setLayoutData(gridDataFactory.copy().exclude(true).create());
        typeControls[2].addModifyListener(timeLagSelectionListener);
        typeControls[2].setVisible(false);
        typeControls[3] = new TimePointWidget(timeLagGroup, 0, "Maximum", (FormToolkit)this.toolkit);
        typeControls[3].setLayoutData(gridDataFactory.create());
        typeControls[3].addModifyListener(timeLagSelectionListener);
        Label label = new Label(timeLagGroup, 258);
        label.setLayoutData((Object)gridDataFactory.create());
        typeControls[4] = new TimePointWidget(timeLagGroup, 0, "Expected", (FormToolkit)this.toolkit);
        typeControls[4].setLayoutData(gridDataFactory.create());
        typeControls[4].addModifyListener(timeLagSelectionListener);
    }

    protected void validate(TimePointWidget spinner, TimeModelConstants.RelationType relationType) {
        TimeLag timeLag = null;
        if (this.timeLags != null) {
            timeLag = this.timeLags.get(relationType);
        }
        if (timeLag == null) {
            timeLag = (TimeLag)ModelViewer.createNew(TimeLag.class);
            timeLag.setRelationType(relationType);
        }
        TimePointWidget[] widgets = this.controls.get(relationType);
        TimePointWidget lowerMinSpinner = widgets[0];
        TimePointWidget upperMinSpinner = widgets[1];
        TimePointWidget lowerMaxSpinner = widgets[2];
        TimePointWidget upperMaxSpinner = widgets[3];
        TimePointWidget expectedSpinner = widgets[4];
        TimePoint newDuration = spinner.getTimePoint();
        if (spinner == expectedSpinner) {
            timeLag.setExpectedTimeLag(newDuration);
        }
        if (spinner == lowerMinSpinner) {
            timeLag.setLowerMinimumTimeLag(newDuration);
        }
        if (spinner == upperMinSpinner) {
            timeLag.setUpperMinimumTimeLag(newDuration);
        }
        if (spinner == lowerMaxSpinner) {
            timeLag.setLowerMaximumTimeLag(newDuration);
        }
        if (spinner == upperMaxSpinner) {
            timeLag.setUpperMaximumTimeLag(newDuration);
        }
        if (this.timeLags == null) {
            this.timeLags = new HashMap<TimeModelConstants.RelationType, TimeLag>();
        }
        this.timeLags.put(relationType, timeLag);
        this.setModified();
    }

    private long toTimeStamp(TimePoint timePoint) {
        if (timePoint == null) {
            return Long.MIN_VALUE;
        }
        long minutes = 0L;
        long hours = 0L;
        long days = 0L;
        long months = 0L;
        if (timePoint.getMinutes() != Long.MIN_VALUE) {
            minutes = timePoint.getMinutes();
        }
        if (timePoint.getHours() != Long.MIN_VALUE) {
            hours = timePoint.getHours();
        }
        if (timePoint.getDays() != Long.MIN_VALUE) {
            days = timePoint.getDays();
        }
        if (timePoint.getMonths() != Long.MIN_VALUE) {
            months = timePoint.getMonths();
        }
        return (minutes + (hours + (days + months * 30L) * 24L) * 60L) * 60L * 1000L;
    }

    private TimePoint validateTimeLag(TimePointWidget spinner, TimePoint lowerMin, TimePoint upperMin, TimePoint lowerMax, TimePoint upperMax, TimePoint expected, TimePoint newDuration) {
        long newDurationL = this.toTimeStamp(newDuration);
        long lowerMinL = this.toTimeStamp(lowerMin);
        long upperMaxL = this.toTimeStamp(upperMax);
        long lowerMaxL = this.toTimeStamp(lowerMax);
        long upperMinL = this.toTimeStamp(upperMin);
        TimePointWidget[] typeControls = this.controls.get(null);
        TimePoint newValue = null;
        if (spinner == typeControls[4]) {
            if (newDurationL < lowerMinL) {
                newValue = lowerMin;
            }
            if (upperMax != null && newDurationL > upperMaxL) {
                newValue = upperMax;
            }
            if (upperMax == null && lowerMax != null && newDurationL > lowerMaxL) {
                newValue = lowerMax;
            }
        }
        if (spinner == typeControls[0]) {
            if (upperMin != null && newDurationL > upperMinL) {
                newValue = upperMin;
            } else if (lowerMax != null && newDurationL > lowerMaxL) {
                newValue = lowerMax;
            } else if (upperMin == null && lowerMax == null && upperMax != null && newDurationL > upperMaxL) {
                newValue = upperMax;
            }
        }
        if (spinner == typeControls[1]) {
            if (lowerMin != null && newDurationL < lowerMinL) {
                newValue = lowerMin;
            }
            if (lowerMax != null && newDurationL > lowerMaxL) {
                newValue = lowerMax;
            }
            if (lowerMax == null && upperMax != null && newDurationL > upperMaxL) {
                newValue = upperMax;
            }
        }
        if (spinner == typeControls[2]) {
            if (newDurationL < upperMinL) {
                newValue = upperMin;
            }
            if (upperMax != null && newDurationL > upperMaxL) {
                newValue = upperMax;
            }
            if (upperMin == null && lowerMin != null && newDurationL < lowerMinL) {
                newValue = lowerMin;
            }
        }
        if (spinner == typeControls[3]) {
            if (newDurationL < lowerMaxL) {
                newValue = lowerMax;
            }
            if (lowerMax == null && newDurationL < upperMinL) {
                newValue = upperMin;
            }
            if (lowerMax == null && upperMin == null && lowerMin != null && newDurationL < lowerMinL) {
                newValue = lowerMin;
            }
        }
        if (newValue != null && newDuration != null) {
            if (newValue.getMonths() > newDuration.getMonths()) {
                newDuration.setMonths(newValue.getMonths());
            } else if (newValue.getDays() > newDuration.getDays()) {
                newDuration.setDays(newValue.getDays());
            } else if (newValue.getHours() > newDuration.getHours()) {
                newDuration.setHours(newValue.getHours());
            } else if (newValue.getMinutes() > newDuration.getMinutes()) {
                newDuration.setMinutes(newValue.getMinutes());
            } else if (newValue.getSeconds() > newDuration.getSeconds()) {
                newDuration.setSeconds(newValue.getSeconds());
            }
            return newDuration;
        }
        return null;
    }

    private void recursiveLayout(Composite composite) {
        Composite parent;
        composite.layout();
        if (!(composite instanceof ScrolledComposite) && !(composite instanceof Shell) && (parent = composite.getParent()) != null) {
            this.recursiveLayout(parent);
        }
    }
}

