/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.timeconstraints;

import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.client.ADEPT2ClientService;
import de.aristaflow.adept2.core.client.ModellingClientService;
import de.aristaflow.adept2.core.timemanager.TimeManager;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.ui.processvisualisation.ProcessVisualiser;
import de.aristaflow.adept2.ui.processvisualisation.UISettings;
import de.aristaflow.adept2.ui.processvisualisation.widgets.LabelTextFormatter;
import de.aristaflow.adept2.ui.processvisualisation.widgets.TemporalNodeFormatter;
import org.eclipse.swt.SWTError;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends AbstractUIPlugin
implements IStartup {
    PageListener pg = new PageListener();
    public static final String PLUGIN_ID = "de.aristaflow.adept2.ui.processvisualisation.timeconstraints";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.hookUpListeners();
    }

    private void hookUpListeners() {
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbenchWindow[] windows;
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.pg);
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage[] pages;
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                window.addPageListener((IPageListener)this.pg);
                IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                int n3 = pages.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorReference[] editorReferences;
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    page.addPartListener((IPartListener)this.pg);
                    IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
                    int n5 = editorReferences.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IEditorReference ref = iEditorReferenceArray[n6];
                        final IEditorPart editor = ref.getEditor(false);
                        if (editor instanceof ProcessVisualiser) {
                            window.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Activator.this.configureProcessVisualiser((ProcessVisualiser)editor);
                                }
                            });
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    protected void configureProcessVisualiser(ProcessVisualiser visualiser) {
        UISettings uiSettings = visualiser.getUISettings();
        uiSettings.addLabelTextFormatter(Node.class, (LabelTextFormatter)new TemporalNodeFormatter());
    }

    public void earlyStartup() {
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        try {
            if (!PlatformUI.getWorkbench().isClosing()) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().removePageListener((IPageListener)this.pg);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SWTError sWTError) {}
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ModellingClientService getModellingClientService() {
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(ModellingClientService.class.getName());
        return (ModellingClientService)context.getService(ref);
    }

    public static ADEPT2ClientService getFullService() {
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(ADEPT2ClientService.class.getName());
        return (ADEPT2ClientService)context.getService(ref);
    }

    public static TimeManager getTimeManager() {
        TimeManager timeManager;
        ADEPT2ClientService fullService = Activator.getFullService();
        SessionToken sessionToken = fullService.getSessionToken();
        try {
            timeManager = (TimeManager)fullService.getServiceOfType(sessionToken, "TimeManager", TimeManager.class);
        }
        catch (ServiceNotKnownException serviceNotKnownException) {
            return null;
        }
        return timeManager;
    }

    public class PageListener
    implements IPageListener,
    IPartListener,
    IWindowListener {
        public void pageActivated(IWorkbenchPage page) {
        }

        public void pageClosed(IWorkbenchPage page) {
            try {
                IPartService service = (IPartService)page.getActivePart().getSite().getService(IPartService.class);
                service.removePartListener((IPartListener)this);
            }
            catch (NullPointerException nullPointerException) {}
        }

        public void pageOpened(IWorkbenchPage page) {
            try {
                IPartService service = (IPartService)page.getActivePart().getSite().getService(IPartService.class);
                service.addPartListener((IPartListener)this);
            }
            catch (NullPointerException nullPointerException) {}
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            if (part instanceof ProcessVisualiser) {
                ProcessVisualiser visualiser = (ProcessVisualiser)part;
                Activator.this.configureProcessVisualiser(visualiser);
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            window.addPageListener((IPageListener)this);
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            window.removePageListener((IPageListener)this);
        }

        public void windowOpened(IWorkbenchWindow window) {
            window.addPageListener((IPageListener)this);
        }
    }
}

