/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.timeconstraints;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.AddNodeSystemParameter;
import de.aristaflow.adept2.core.changeoperations.DeleteDataEdge;
import de.aristaflow.adept2.core.changeoperations.InsertDataEdge;
import de.aristaflow.adept2.core.changeoperations.RemoveNodeSystemParameter;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.timeconstraints.Activator;
import de.aristaflow.adept2.util.CheckReport;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class SystemParamaterTools {
    public static Set<ParameterRef> getParamaterRefs(PluginData pluginData) {
        HashSet<ParameterRef> paramatereRefs = new HashSet<ParameterRef>();
        for (String paramString : pluginData.getPluginData().values()) {
            if (paramString == null) continue;
            ParameterRef[] refs = SystemDataTools.findParameterReferences((String)paramString);
            paramatereRefs.addAll(Arrays.asList(refs));
        }
        return paramatereRefs;
    }

    public static void removeParameterConnection(SessionToken session, Template template, Node node, UpdateManager updateManager, CheckReport checkReport, String parameterName) {
        boolean parameterExists;
        boolean bl = parameterExists = node.getSystemParameter(parameterName, ActivityConstants.AccessType.SYSTEM_READ) != null;
        if (parameterExists) {
            Method[] methods = Node.class.getMethods();
            boolean parameterReferenceExists = AddNodeSystemParameter.parameterReferenceExists((Object)node, (Method[])methods, (String)parameterName);
            DataElement dataElement = template.getDataElement(node.getID(), node.getConnector(parameterName, ActivityConstants.AccessType.SYSTEM_READ));
            if (!parameterReferenceExists && DeleteDataEdge.isPossible((Template)template, (Node)node, (DataElement)dataElement, (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (CheckReport)checkReport)) {
                DeleteDataEdge.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)template), (Node)node, (DataElement)dataElement, (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (UpdateManager)updateManager);
            }
            if (!parameterReferenceExists && RemoveNodeSystemParameter.isPossible((Template)template, (int)node.getID(), (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (String)parameterName, (CheckReport)checkReport)) {
                RemoveNodeSystemParameter.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)template), (int)node.getID(), (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (String)parameterName, (UpdateManager)updateManager);
            }
        }
    }

    public static void addParameterConnection(SessionToken session, Template template, Node node, DataElement dataElement, UpdateManager updateManager, CheckReport checkReport, String parameterName, UUID parameterIdentifierID, ProcessConstants.AdeptDataType parameterType) {
        boolean parameterExists;
        boolean bl = parameterExists = node.getSystemParameter(parameterName, ActivityConstants.AccessType.SYSTEM_READ) != null;
        if (!parameterExists) {
            ProcessModelParameter parameter = Activator.getModellingClientService().getProcessModelFactory().createProcessModelParameter(parameterName, "", parameterType, "", parameterIdentifierID, false, false, false, null, null, null, null);
            if (AddNodeSystemParameter.isPossible((Template)template, (int)node.getID(), (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (ProcessModelParameter)parameter, (CheckReport)checkReport)) {
                AddNodeSystemParameter.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)template), (int)node.getID(), (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (ProcessModelParameter)parameter, (UpdateManager)updateManager);
            }
        }
        if (template.getDataEdge(node.getID(), dataElement.getID(), ActivityConstants.AccessType.SYSTEM_READ) == null && InsertDataEdge.isPossible((Template)template, (Node)node, (DataElement)dataElement, (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (CheckReport)checkReport)) {
            InsertDataEdge.performOperation((SessionToken)session, (ChangeableTemplate)((ChangeableTemplate)template), (Node)node, (DataElement)dataElement, (ActivityConstants.AccessType)ActivityConstants.AccessType.SYSTEM_READ, (UpdateManager)updateManager);
        }
    }
}

