/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.widgets;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class DurationDialog
extends Dialog {
    private String selectedSpinner;
    private Combo combo;
    private Spinner weekSpinner;
    private Spinner daySpinner;
    private Spinner hourSpinner;
    private Spinner minuteSpinner;
    private long timeStamp;

    public DurationDialog(Shell parent, String spinner, long timeStamp) {
        this(parent, 67680, spinner);
        this.selectedSpinner = spinner;
        this.timeStamp = timeStamp;
    }

    private DurationDialog(Shell parent, int style, String spinner) {
        super(parent, style);
        this.setText("Update Duration");
        this.selectedSpinner = spinner;
    }

    public String open() {
        Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText(this.getText());
        this.createContents(shell);
        this.setTimestampToSpinner(this.timeStamp);
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return "";
    }

    private void createContents(final Shell shell) {
        shell.setLayout((Layout)new GridLayout(4, true));
        GridData data = new GridData();
        data.horizontalSpan = 4;
        Combo combo = new Combo((Composite)shell, 4);
        combo.select(this.getIndex(this.selectedSpinner));
        combo.setSize(200, 200);
        data = new GridData(768);
        data.horizontalSpan = 4;
        combo.setLayoutData((Object)data);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selection = ((Combo)e.getSource()).getSelectionIndex();
                DurationDialog.this.setSpinnerName(selection);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label = new Label((Composite)shell, 0);
        label.setText("weeks");
        data = new GridData();
        data.horizontalSpan = 1;
        label.setLayoutData((Object)data);
        Label label1 = new Label((Composite)shell, 0);
        label1.setText("days");
        data = new GridData();
        data.horizontalSpan = 1;
        label1.setLayoutData((Object)data);
        Label label2 = new Label((Composite)shell, 0);
        label2.setText("hours");
        data = new GridData();
        data.horizontalSpan = 1;
        label2.setLayoutData((Object)data);
        Label label3 = new Label((Composite)shell, 0);
        label3.setText("minutes");
        data = new GridData();
        data.horizontalSpan = 1;
        label3.setLayoutData((Object)data);
        this.weekSpinner = new Spinner((Composite)shell, 2048);
        this.weekSpinner.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.weekSpinner.setMaximum(208);
        data = new GridData();
        data.horizontalSpan = 1;
        this.weekSpinner.setLayoutData((Object)data);
        this.daySpinner = new Spinner((Composite)shell, 2048);
        this.daySpinner.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.daySpinner.setMaximum(6);
        data = new GridData();
        data.horizontalSpan = 1;
        this.daySpinner.setLayoutData((Object)data);
        this.hourSpinner = new Spinner((Composite)shell, 2048);
        this.hourSpinner.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.hourSpinner.setMaximum(23);
        data = new GridData();
        data.horizontalSpan = 1;
        this.hourSpinner.setLayoutData((Object)data);
        this.minuteSpinner = new Spinner((Composite)shell, 2048);
        this.minuteSpinner.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.minuteSpinner.setMaximum(59);
        data = new GridData();
        data.horizontalSpan = 1;
        this.minuteSpinner.setLayoutData((Object)data);
        shell.pack();
        shell.open();
        Button ok = new Button((Composite)shell, 8);
        ok.setText("OK");
        data = new GridData(768);
        ok.setLayoutData((Object)data);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }
        });
        Button cancel = new Button((Composite)shell, 8);
        cancel.setText("Cancel");
        data = new GridData(768);
        cancel.setLayoutData((Object)data);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                shell.close();
            }
        });
        shell.setDefaultButton(ok);
    }

    private int getIndex(String name) {
        if (name.equals("ExpectedDuration")) {
            return 0;
        }
        if (name.equals("LowerMinimumDuration")) {
            return 1;
        }
        if (name.equals("LowerMaximumDuration")) {
            return 3;
        }
        if (name.equals("UpperMinimumDuration")) {
            return 2;
        }
        if (name.equals("UpperMaximumDuration")) {
            return 4;
        }
        return 0;
    }

    private void setSpinnerName(int selection) {
    }

    private void setTimestampToSpinner(long duration) {
        int minutes = (int)(duration / 1000L / 60L % 60L);
        int hours = (int)(duration / 1000L / 60L / 60L % 24L);
        int days = (int)(duration / 1000L / 60L / 60L / 24L % 7L);
        int weeks = (int)(duration / 1000L / 60L / 60L / 24L / 7L);
        this.minuteSpinner.setSelection(minutes);
        this.hourSpinner.setSelection(hours);
        this.daySpinner.setSelection(days);
        this.weekSpinner.setSelection(weeks);
    }

    public Combo getCombo() {
        return this.combo;
    }
}

