/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.widgets;

import de.aristaflow.adept2.model.common.timedata.TimePoint;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GraphicalDurationWidget
extends Composite {
    private static final int BOX_LINE_WIDTH = 2;
    private static final int BAR_HEIGHT = 14;
    private static final int MIN_HEIGHT = 84;
    private static final int MAX_HEIGHT = 114;
    private static final String S_INFINITY = "oo";
    static final int MARGIN = 10;
    static final int ORIGINX = 10;
    static final int ORIGINY = 30;
    private long scale;
    private boolean zeroSplit = false;
    private int zeroPos;
    private double factor;
    private Rectangle[] mouseRegions = new Rectangle[5];
    private Color boxBackgroundColor;
    private Canvas canvas;
    boolean drawWithInfiniteEnd;
    private long guardMin;
    private long flexibleMin;
    private long guardMax;
    private long flexibleMax;
    private long expected;
    protected Cursor scrollCursor = new Cursor((Device)Display.getCurrent(), 9);
    private boolean duration;
    private Color baseBackgroundColor;

    public GraphicalDurationWidget(Composite parent, int style, boolean duration, FormToolkit toolkit) {
        super(parent, style);
        this.duration = duration;
        this.expected = 0L;
        this.flexibleMax = 0L;
        this.guardMax = 0L;
        this.flexibleMin = 0L;
        this.boxBackgroundColor = this.getDisplay().getSystemColor(15);
        this.baseBackgroundColor = this.getDisplay().getSystemColor(16);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.canvas = new Canvas((Composite)this, 0);
        GridData grid = new GridData(4, 4, true, true);
        grid.minimumHeight = 84;
        grid.minimumWidth = 200;
        this.canvas.setLayoutData((Object)grid);
        toolkit.adapt((Composite)this.canvas);
        MouseListenerImplementation mouseListener = new MouseListenerImplementation();
        this.canvas.addMouseMoveListener((MouseMoveListener)mouseListener);
        this.canvas.addMouseListener((MouseListener)mouseListener);
        this.canvas.addMouseTrackListener((MouseTrackListener)mouseListener);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                if (gc.isDisposed()) {
                    return;
                }
                Rectangle clientArea = GraphicalDurationWidget.this.getClientArea();
                GraphicalDurationWidget.this.reDrawDiagramm(gc, clientArea.width - 10, clientArea.height);
            }
        });
    }

    protected int getMouseRegion(int x, int y) {
        int i = 0;
        while (i < this.mouseRegions.length) {
            Rectangle r = this.mouseRegions[i];
            if (r != null && r.contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void reDrawDiagramm(GC gc, int width, int height) {
        int internalWidth = width - 20;
        int internalHeight = Math.min(height - 20, 114);
        this.initDimensions(internalWidth, internalHeight);
        if (this.flexibleMin == Long.MIN_VALUE && this.guardMax == Long.MIN_VALUE && this.flexibleMax == Long.MIN_VALUE) {
            this.mouseRegions[0] = null;
            this.mouseRegions[1] = null;
            this.mouseRegions[2] = null;
            this.mouseRegions[3] = null;
            this.drawZeroLine(gc, this.zeroPos);
            if (this.expected == Long.MIN_VALUE) {
                this.mouseRegions[4] = null;
                this.printScaleText(gc, internalWidth, internalHeight, "xxx");
            } else {
                this.printScaleText(gc, internalWidth, internalHeight, this.timeStampToString(this.scale));
                this.drawExpectedValue(gc, this.zeroPos, this.factor);
                this.drawScale(gc, internalWidth, internalHeight);
            }
            this.drawArrow(gc, this.zeroPos, 0, internalWidth, 0, 3);
            this.drawArrow(gc, this.zeroPos, 0, 0, 0, 3);
            return;
        }
        this.drawZeroLine(gc, this.zeroPos);
        this.printScaleText(gc, internalWidth, internalHeight, this.timeStampToString(this.scale));
        this.drawScale(gc, internalWidth, internalHeight);
        this.drawBox(gc, internalWidth);
        if (this.expected != Long.MIN_VALUE) {
            this.drawExpectedValue(gc, this.zeroPos, this.factor);
        }
    }

    private void drawBox(GC gc, int internalWidth) {
        boolean lowerRightOpen;
        boolean upperRightOpen;
        int upperRightBound;
        boolean leftOpen;
        int leftBound;
        int lowerRightBound = -1;
        if (this.flexibleMin != Long.MIN_VALUE) {
            leftBound = (int)((double)this.zeroPos + (double)this.flexibleMin / this.factor);
            leftOpen = false;
        } else {
            leftBound = -5;
            leftOpen = true;
        }
        if (this.flexibleMax != Long.MIN_VALUE) {
            upperRightBound = (int)((double)this.zeroPos + (double)this.flexibleMax / this.factor);
            upperRightOpen = false;
        } else {
            upperRightBound = internalWidth;
            upperRightOpen = true;
        }
        if (this.guardMax != Long.MIN_VALUE) {
            lowerRightBound = (int)((double)this.zeroPos + (double)this.guardMax / this.factor);
            lowerRightOpen = false;
        } else {
            lowerRightBound = upperRightBound;
            lowerRightOpen = true;
        }
        if (this.duration) {
            gc.setBackground(this.baseBackgroundColor);
            gc.fillRectangle(11, 23, leftBound, 14);
            gc.setBackground(this.getBackground());
            this.drawLine(gc, 1, -7, leftBound, -7, 2);
            this.drawLine(gc, 1, 7, leftBound, 7, 2);
        }
        gc.setBackground(this.boxBackgroundColor);
        gc.fillRectangle(10 + leftBound, 23, lowerRightBound - leftBound, 14);
        gc.setBackground(this.getBackground());
        this.drawLine(gc, leftBound, -7, lowerRightBound, -7, 2);
        this.drawLine(gc, leftBound, 7, lowerRightBound, 7, 2);
        if (!leftOpen) {
            this.drawLine(gc, leftBound, 7, leftBound, -7, 2);
            this.drawText(gc, this.timeStampToString(this.flexibleMin), leftBound - 7, -25);
        } else {
            this.drawText(gc, "-oo", leftBound - 7, -25);
        }
        this.mouseRegions[0] = new Rectangle(10 + leftBound - 5, 18, 7, 30);
        if (!lowerRightOpen) {
            this.drawLine(gc, lowerRightBound, 7, lowerRightBound, -7, 2);
            this.drawText(gc, this.timeStampToString(this.guardMax), lowerRightBound - 7, -25);
        } else {
            this.drawText(gc, S_INFINITY, lowerRightBound - 7, -25);
        }
        this.mouseRegions[3] = new Rectangle(10 + lowerRightBound - 5, 18, 7, 30);
        if (upperRightBound != lowerRightBound) {
            this.drawLine(gc, lowerRightBound, -7, upperRightBound, -7);
            this.drawLine(gc, lowerRightBound, 7, upperRightBound, 7);
            if (!upperRightOpen) {
                this.drawLine(gc, upperRightBound, -7, upperRightBound, 7);
            }
            this.drawLine(gc, lowerRightBound, -5, lowerRightBound, 5);
            this.drawArrow(gc, upperRightBound, 0, lowerRightBound, 0, 3);
            this.drawText(gc, this.timeStampToString(this.flexibleMax), upperRightBound - 7, 17);
            this.mouseRegions[2] = new Rectangle(10 + lowerRightBound - 5, 18, 7, 30);
        } else {
            this.mouseRegions[2] = null;
        }
    }

    private void initDimensions(int width, int height) {
        this.zeroSplit = false;
        if (this.flexibleMin == Long.MIN_VALUE && this.guardMax == Long.MIN_VALUE && this.flexibleMax == Long.MIN_VALUE) {
            this.zeroSplit = true;
            this.zeroPos = width / 2;
            if (this.expected != Long.MIN_VALUE) {
                this.scale = this.getScale(Math.abs(this.expected));
                this.factor = (float)this.scale * 2.0f / (float)(width + 10);
            }
        } else {
            int s;
            int sgn = Integer.MIN_VALUE;
            long min = Long.MIN_VALUE;
            long max = Long.MIN_VALUE;
            if (this.guardMax != Long.MIN_VALUE) {
                s = this.sgn(this.guardMax);
                if (s != sgn) {
                    if (sgn == Integer.MIN_VALUE) {
                        sgn = s;
                    } else if (sgn == 0) {
                        sgn = s;
                    } else if (s != 0) {
                        this.zeroSplit = true;
                    }
                }
                max = this.guardMax;
                if (min == Long.MIN_VALUE) {
                    min = this.guardMax;
                }
            }
            if (this.flexibleMin != Long.MIN_VALUE) {
                s = this.sgn(this.flexibleMin);
                if (s != sgn) {
                    if (sgn == Integer.MIN_VALUE) {
                        sgn = s;
                    } else if (sgn == 0) {
                        sgn = s;
                    } else if (s != 0) {
                        this.zeroSplit = true;
                    }
                }
                min = this.flexibleMin;
                if (max == Long.MIN_VALUE) {
                    max = this.flexibleMin;
                }
            }
            if (this.flexibleMax != Long.MIN_VALUE) {
                s = this.sgn(this.flexibleMax);
                if (s != sgn) {
                    if (sgn == Integer.MIN_VALUE) {
                        sgn = s;
                    } else if (sgn == 0) {
                        sgn = s;
                    } else if (s != 0) {
                        this.zeroSplit = true;
                    }
                }
                max = this.flexibleMax;
                if (min == Long.MIN_VALUE) {
                    min = this.flexibleMax;
                }
            }
            if (this.expected != Long.MIN_VALUE) {
                s = this.sgn(this.expected);
                if (s != sgn) {
                    if (sgn == Integer.MIN_VALUE) {
                        sgn = s;
                    } else if (sgn == 0) {
                        sgn = s;
                    } else if (s != 0) {
                        this.zeroSplit = true;
                    }
                }
                if (this.expected > max || max == Long.MIN_VALUE) {
                    max = this.expected;
                }
                if (this.expected < min || min == Long.MIN_VALUE) {
                    min = this.expected;
                }
            }
            long maxDist = Math.max(Math.abs(min), Math.abs(max));
            this.scale = this.getScale(maxDist);
            this.factor = (double)this.scale * (double)(this.zeroSplit ? 2 : 1) / (double)(width + 10);
            this.zeroPos = this.zeroSplit ? width / 2 : (sgn >= 0 ? 0 : width);
        }
        this.factor = Math.floor(this.factor * 1.0E7) / 1.0E7;
    }

    private int sgn(long value) {
        if (value < 0L) {
            return -1;
        }
        if (value > 0L) {
            return 1;
        }
        return 0;
    }

    private void drawLine(GC gc, int x1, int y1, int x2, int y2) {
        gc.drawLine(10 + x1, 30 + y1, 10 + x2, 30 + y2);
    }

    private void drawLine(GC gc, int x1, int y1, int x2, int y2, int lineWidth) {
        int oldLineWidth = gc.getLineWidth();
        gc.setLineWidth(lineWidth);
        gc.drawLine(10 + x1, 30 + y1, 10 + x2, 30 + y2);
        gc.setLineWidth(oldLineWidth);
    }

    private void drawText(GC gc, String string, int x, int y) {
        gc.drawText(string, 10 + x, 30 + y);
    }

    private void drawExpectedValue(GC gc, int zeroPos, double factor) {
        int x = (int)((double)zeroPos + (double)this.expected / factor);
        int oldLineStyle = gc.getLineStyle();
        gc.setLineStyle(3);
        this.drawLine(gc, x, -7, x, 7);
        this.drawText(gc, this.timeStampToString(this.expected), x - 3, 17);
        this.mouseRegions[4] = new Rectangle(10 + x - 5, 18, 10, 27);
        gc.setLineStyle(oldLineStyle);
    }

    private void drawScale(GC gc, int width, int height) {
        int steps = 0;
        if (this.scale <= 60L) {
            steps = 5;
        } else if (this.scale <= 1440L) {
            long s = this.scale / 5L;
            steps = (int)(s /= (long)(this.zeroSplit ? 6 : 12)) * 5;
        }
        double stepSize = (double)steps / this.factor;
        if (steps > 0) {
            this.drawLine(gc, this.zeroPos, 8, this.zeroPos, 13);
            double x = (double)this.zeroPos + stepSize;
            while (x <= (double)width + stepSize / 2.0) {
                this.drawLine(gc, (int)x, 9, (int)x, 12);
                x += stepSize;
            }
            String text = this.timeStampToString(this.scale);
            Point stringExtent = gc.stringExtent(text);
            this.drawText(gc, text, (int)(x - stepSize) - stringExtent.x / 2, 17);
            x = (double)this.zeroPos - stepSize;
            if (x >= 0.0) {
                while (x >= 0.0) {
                    this.drawLine(gc, (int)x, 9, (int)x, 12);
                    x -= stepSize;
                }
                text = this.timeStampToString(-this.scale);
                stringExtent = gc.stringExtent(text);
                this.drawText(gc, text, (int)(x + stepSize) - stringExtent.x / 2, 17);
            }
        }
    }

    private void drawArrow(GC gc, int x1, int y1, int x2, int y2, int lineStyle) {
        int oldLineStyle = gc.getLineStyle();
        gc.setLineStyle(lineStyle);
        this.drawLine(gc, x1, y1, x2, y2);
        if (Math.abs(x1 - x2) > 5) {
            gc.setLineStyle(1);
            if (x1 < x2) {
                this.drawLine(gc, x2 - 5, y2 - 4, x2, y2);
                this.drawLine(gc, x2 - 5, y2 + 4, x2, y2);
            } else {
                this.drawLine(gc, x2 + 5, y2 - 4, x2, y2);
                this.drawLine(gc, x2 + 5, y2 + 4, x2, y2);
            }
        }
        gc.setLineStyle(oldLineStyle);
    }

    private void printScaleText(GC gc, int width, int height, String scale) {
        String text = "Scale: " + scale;
        Point extent = gc.stringExtent(text);
        this.drawText(gc, text, width / 2 - extent.x / 2, 22 + extent.y);
    }

    private void drawZeroLine(GC gc, int zeroPos) {
        this.drawLine(gc, zeroPos, -12, zeroPos, 12);
        this.drawText(gc, "0", zeroPos - 3, 17);
    }

    private long getScale(long scaleBasis) {
        if (scaleBasis <= 60L) {
            return 60L;
        }
        if (scaleBasis <= 1440L) {
            long s = 60L * (scaleBasis / 60L + 1L);
            return s;
        }
        if (scaleBasis <= 44640L) {
            return 44640L;
        }
        if (scaleBasis <= 525600L) {
            return 525600L;
        }
        return scaleBasis;
    }

    private String timeStampToString(long t) {
        long temp;
        if (t == 0L) {
            return "0m";
        }
        String s = "";
        if (t < 0L) {
            s = "-";
        }
        if ((temp = Math.abs(t)) >= 525600L) {
            s = String.valueOf(s) + temp / 525600L + "J";
            temp %= 525600L;
        }
        if (temp >= 1440L) {
            s = String.valueOf(s) + temp / 1440L + "D";
            temp %= 1440L;
        }
        if (temp >= 60L) {
            s = String.valueOf(s) + temp / 60L + "H";
            temp %= 60L;
        }
        if (temp > 0L) {
            s = String.valueOf(s) + temp + "m";
        }
        return s;
    }

    public void redraw() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
        super.redraw();
    }

    void refresh() {
        this.redraw();
    }

    public void setExpectedValue(TimePoint duration) {
        this.expected = this.toTimeStamp(duration);
        this.refresh();
    }

    public void setFlexibleMinimumValue(TimePoint duration) {
        this.flexibleMin = this.toTimeStamp(duration);
        this.refresh();
    }

    public void setGuardMinimumValue(TimePoint duration) {
        this.guardMin = this.toTimeStamp(duration);
        this.refresh();
    }

    public void setGuardMaximumValue(TimePoint duration) {
        this.guardMax = this.toTimeStamp(duration);
        this.refresh();
    }

    public void setFlexibleMaximumValue(TimePoint duration) {
        this.flexibleMax = this.toTimeStamp(duration);
        this.refresh();
    }

    private long toTimeStamp(TimePoint timePoint) {
        if (timePoint == null) {
            return Long.MIN_VALUE;
        }
        long minutes = 0L;
        long hours = 0L;
        long days = 0L;
        long months = 0L;
        boolean set = false;
        if (timePoint.getSeconds() != Long.MIN_VALUE) {
            set = true;
        }
        if (timePoint.getMinutes() != Long.MIN_VALUE) {
            minutes = timePoint.getMinutes();
            set = true;
        }
        if (timePoint.getHours() != Long.MIN_VALUE) {
            hours = timePoint.getHours();
            set = true;
        }
        if (timePoint.getDays() != Long.MIN_VALUE) {
            days = timePoint.getDays();
            set = true;
        }
        if (timePoint.getMonths() != Long.MIN_VALUE) {
            months = timePoint.getMonths();
            set = true;
        }
        if (set) {
            return minutes + (hours + (days + months * 30L) * 24L) * 60L;
        }
        return Long.MIN_VALUE;
    }

    private final class MouseListenerImplementation
    implements MouseMoveListener,
    MouseListener,
    MouseTrackListener {
        private Cursor oldCursor;

        private MouseListenerImplementation() {
        }

        public void mouseMove(MouseEvent e) {
            int i = GraphicalDurationWidget.this.getMouseRegion(e.x, e.y);
            if (i != -1) {
                if (this.oldCursor == null) {
                    this.oldCursor = GraphicalDurationWidget.this.canvas.getCursor();
                }
                GraphicalDurationWidget.this.canvas.setCursor(GraphicalDurationWidget.this.scrollCursor);
                String toolTip = this.getToolTip(i);
                if (toolTip != null) {
                    GraphicalDurationWidget.this.canvas.setToolTipText(toolTip);
                } else {
                    GraphicalDurationWidget.this.canvas.setToolTipText(null);
                }
            } else {
                GraphicalDurationWidget.this.canvas.setCursor(this.oldCursor);
                this.oldCursor = null;
                GraphicalDurationWidget.this.canvas.setToolTipText(null);
            }
        }

        private String getToolTip(int element) {
            switch (element) {
                case 0: {
                    return "Minimum: " + GraphicalDurationWidget.this.timeStampToString(GraphicalDurationWidget.this.flexibleMin);
                }
                case 2: {
                    return "Guard Maximum: " + GraphicalDurationWidget.this.timeStampToString(GraphicalDurationWidget.this.guardMax);
                }
                case 3: {
                    return "Flexible Maximum: " + GraphicalDurationWidget.this.timeStampToString(GraphicalDurationWidget.this.flexibleMax);
                }
                case 4: {
                    return "Expected: " + GraphicalDurationWidget.this.timeStampToString(GraphicalDurationWidget.this.expected);
                }
            }
            return null;
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
            GraphicalDurationWidget.this.canvas.setCursor(this.oldCursor);
            this.oldCursor = null;
            GraphicalDurationWidget.this.canvas.setToolTipText(null);
        }

        public void mouseHover(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }
}

