/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.widgets;

import de.aristaflow.adept2.model.common.timedata.TimePoint;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.timemodel.ActivityDuration;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDate;
import de.aristaflow.adept2.model.processmodel.timemodel.ScheduleRestrictedElement;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeModelTools;
import de.aristaflow.adept2.ui.icons.MiscImages;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.preferences.TimeModelPreferences;
import de.aristaflow.adept2.ui.processvisualisation.widgets.LabelTextFormatter;
import de.aristaflow.adept2.ui.processvisualisation.widgets.NodeFigure;
import java.util.Locale;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class TemporalNodeFormatter
extends LabelTextFormatter.DefaultNodeFormatter {
    private static final int MAX_STR_LENGTH = 30;

    protected String getSecondaryLabel(Node node) {
        String completionSchedule;
        String startSchedule;
        String completionFD;
        String startFD;
        String secondary = "";
        String durationString = this.getDurationString(node);
        if (durationString != null) {
            secondary = "Duration: " + durationString;
        }
        if ((startFD = this.getStartFixedDateString(node)) != null) {
            if (secondary.length() > 0) {
                secondary = String.valueOf(secondary) + "\n";
            }
            secondary = String.valueOf(secondary) + this.fixedLength("Start Date: " + startFD, 30);
        }
        if ((completionFD = this.getCompletionFixedDateString(node)) != null) {
            if (secondary.length() > 0) {
                secondary = String.valueOf(secondary) + "\n";
            }
            secondary = String.valueOf(secondary) + this.fixedLength("End Date: " + completionFD, 30);
        }
        if ((startSchedule = this.getStartScheduleString(node)) != null) {
            if (secondary.length() > 0) {
                secondary = String.valueOf(secondary) + "\n";
            }
            secondary = String.valueOf(secondary) + this.fixedLength("Start: " + startSchedule, 30);
        }
        if ((completionSchedule = this.getCompletionScheduleString(node)) != null) {
            if (secondary.length() > 0) {
                secondary = String.valueOf(secondary) + "\n";
            }
            secondary = String.valueOf(secondary) + this.fixedLength("End: " + completionSchedule, 30);
        }
        return secondary.length() > 0 ? secondary : null;
    }

    private String getCompletionScheduleString(Node node) {
        String completionSchedule = null;
        ScheduleRestrictedElement schedule = TimeModelTools.getCompletionSchedule((Node)node);
        if (schedule != null) {
            completionSchedule = TimeModelTools.toString((ScheduleRestrictedElement)schedule);
        }
        return completionSchedule;
    }

    private String getStartScheduleString(Node node) {
        String startSchedule = null;
        ScheduleRestrictedElement schedule = TimeModelTools.getStartSchedule((Node)node);
        if (schedule != null) {
            startSchedule = TimeModelTools.toString((ScheduleRestrictedElement)schedule);
        }
        return startSchedule;
    }

    private String getCompletionFixedDateString(Node node) {
        String completionFD = null;
        FixedDate fixedDate = TimeModelTools.getCompletionFixedDate((Node)node);
        if (fixedDate != null) {
            completionFD = TimeModelTools.toString((FixedDate)fixedDate);
            completionFD.replace('\r', ' ');
            completionFD.replace('\n', ';');
        }
        return completionFD;
    }

    private String getStartFixedDateString(Node node) {
        String startFD = null;
        FixedDate fixedDate = TimeModelTools.getStartFixedDate((Node)node);
        if (fixedDate != null) {
            startFD = TimeModelTools.toString((FixedDate)fixedDate);
            startFD.replace('\r', ' ');
            startFD.replace('\n', ';');
        }
        return startFD;
    }

    private String getDurationString(Node node) {
        String durationString = null;
        ActivityDuration activityDuration = TimeModelTools.getActivityDuration((Node)node);
        if (activityDuration != null) {
            String flexibleMin = null;
            String guardMin = null;
            String guardMax = null;
            String flexibleMax = null;
            TimePoint duration = activityDuration.getMinimumDuration();
            flexibleMin = duration != null ? TimeModelTools.convertToString((TimePoint)duration) : "1s";
            duration = activityDuration.getGuardMinimumDuration();
            if (duration != null) {
                guardMin = TimeModelTools.convertToString((TimePoint)duration);
            }
            if ((duration = activityDuration.getGuardMaximumDuration()) != null) {
                guardMax = TimeModelTools.convertToString((TimePoint)duration);
            }
            if ((duration = activityDuration.getMaximumDuration()) != null) {
                flexibleMax = TimeModelTools.convertToString((TimePoint)duration);
            }
            TimeModelPreferences preferences = TimeModelPreferences.getInstance();
            StringBuilder s = new StringBuilder();
            switch (preferences.getTimeModelType()) {
                case CSTNU_EXTENDED: {
                    s.append("[[");
                    s.append(flexibleMin);
                    s.append(", ");
                    if (guardMax != null) {
                        s.append(guardMax);
                    } else {
                        s.append(flexibleMin);
                    }
                    s.append("] ");
                    if (flexibleMax != null) {
                        s.append(flexibleMax);
                    } else if (flexibleMin != null) {
                        s.append("Inf");
                    }
                    s.append("]");
                    break;
                }
                case CSTN: 
                case CSTNU: {
                    s.append("[");
                    s.append(flexibleMin);
                    s.append(", ");
                    if (flexibleMax != null) {
                        s.append(flexibleMax);
                    } else if (flexibleMin != null) {
                        s.append("Inf");
                    }
                    s.append("]");
                    break;
                }
                default: {
                    s.append("[");
                    s.append(flexibleMin);
                    s.append(", ");
                    if (guardMin != null) {
                        s.append(guardMin);
                    } else if (flexibleMax != null) {
                        s.append(flexibleMax);
                    } else {
                        s.append("Inf");
                    }
                    s.append("][");
                    if (guardMax != null) {
                        s.append(guardMax);
                    } else {
                        s.append(flexibleMin);
                    }
                    s.append(", ");
                    if (flexibleMax != null) {
                        s.append(flexibleMax);
                    } else if (flexibleMin != null) {
                        s.append("Inf");
                    }
                    s.append("]");
                }
            }
            durationString = s.toString();
        }
        return durationString;
    }

    private String fixedLength(String string, int length) {
        if (string.length() > length) {
            return String.valueOf(string.substring(0, length - 3)) + "...";
        }
        return string;
    }

    private String checkDurationSetting(Node node) {
        ActivityDuration activityDuration;
        String ret = "";
        if (node != null && (activityDuration = TimeModelTools.getActivityDuration((Node)node)) != null) {
            ret = "ActivityDuration";
        }
        return ret;
    }

    private String checkFixedDateSetting(Node node) {
        String ret = "";
        if (node != null && (TimeModelTools.getStartFixedDate((Node)node) != null || TimeModelTools.getCompletionFixedDate((Node)node) != null)) {
            ret = "FixedDate";
        }
        return ret;
    }

    private String checkSchedulingSetting(Node node) {
        String ret = "";
        if (node != null && (TimeModelTools.getStartSchedule((Node)node) != null || TimeModelTools.getCompletionSchedule((Node)node) != null)) {
            ret = "ScheduleRestricted";
        }
        return ret;
    }

    private String checkValiditySetting(Node node) {
        String ret = "";
        if (node != null && (TimeModelTools.getStartValidityPeriod((Node)node) != null || TimeModelTools.getCompletionValidityPeriod((Node)node) != null)) {
            ret = "ValidityPeriod";
        }
        return ret;
    }

    public void format(NodeFigure figure, Object source, Instance instance, Locale locale) {
        super.format(figure, source, instance, locale);
        Node node = (Node)source;
        figure.setFixedDateIcon(this.getFixedDateIcon(this.checkFixedDateSetting(node)));
        figure.setScheduleIcon(this.getScheduleIcon(this.checkSchedulingSetting(node)));
        figure.setValidityIcon(this.getValidityIcon(this.checkValiditySetting(node)));
    }

    protected String getToolTipText(Node node, Instance instance, String labelNodeName) {
        String toolTipText = super.getToolTipText(node, instance, labelNodeName);
        StringBuilder stringBuilder = new StringBuilder(toolTipText);
        stringBuilder.append('\n').append(' ').append("Duration: ");
        String durationString = this.getDurationString(node);
        if (durationString != null) {
            stringBuilder.append(durationString).append(' ');
        } else {
            stringBuilder.append("not set ");
        }
        String str = this.getStartFixedDateString(node);
        if (str != null) {
            stringBuilder.append('\n').append(' ').append("Start: ").append(str).append(' ');
        }
        if ((str = this.getCompletionFixedDateString(node)) != null) {
            stringBuilder.append('\n').append(' ').append("Completion: ").append(str).append(' ');
        }
        if ((str = this.getStartScheduleString(node)) != null) {
            stringBuilder.append('\n').append(' ').append("Start schedule: ").append(str).append(' ');
        }
        if ((str = this.getCompletionScheduleString(node)) != null) {
            stringBuilder.append('\n').append(' ').append("Completion schedule: ").append(str).append(' ');
        }
        return stringBuilder.toString();
    }

    Image getDurationIcon(String time) {
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        if (time.equals("")) {
            return null;
        }
        String imageKey = "de.aristaflow.adept2.ui.icons.misc.MiscImages.Duration";
        Image icon = imageRegistry.get(imageKey);
        if (icon == null) {
            Image unscaledImage = null;
            if (imageKey.equals("nosar.png")) {
                unscaledImage = MiscImages.getImage((String)imageKey);
            } else {
                ImageDescriptor unscaledImageDesc = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/duration.png");
                unscaledImage = unscaledImageDesc.createImage();
            }
            icon = new Image(unscaledImage.getDevice(), unscaledImage.getImageData().scaledTo(16, 16));
            unscaledImage.dispose();
            imageRegistry.put(imageKey, icon);
        }
        return icon;
    }

    Image getFixedDateIcon(String time) {
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        if (time.equals("")) {
            return null;
        }
        String imageKey = "de.aristaflow.adept2.ui.icons.misc.MiscImages.FixedDate";
        Image icon = imageRegistry.get(imageKey);
        if (icon == null) {
            Image unscaledImage = null;
            if (imageKey.equals("nosar.png")) {
                unscaledImage = MiscImages.getImage((String)imageKey);
            } else {
                ImageDescriptor unscaledImageDesc = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/fixedDate_16.png");
                unscaledImage = unscaledImageDesc.createImage();
            }
            icon = new Image(unscaledImage.getDevice(), unscaledImage.getImageData().scaledTo(16, 16));
            unscaledImage.dispose();
            imageRegistry.put(imageKey, icon);
        }
        return icon;
    }

    Image getScheduleIcon(String time) {
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        if (time.equals("")) {
            return null;
        }
        String imageKey = "de.aristaflow.adept2.ui.icons.misc.MiscImages.Schedule";
        Image icon = imageRegistry.get(imageKey);
        if (icon == null) {
            Image unscaledImage = null;
            if (imageKey.equals("nosar.png")) {
                unscaledImage = MiscImages.getImage((String)imageKey);
            } else {
                ImageDescriptor unscaledImageDesc = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/schedule_16.png");
                unscaledImage = unscaledImageDesc.createImage();
            }
            icon = new Image(unscaledImage.getDevice(), unscaledImage.getImageData().scaledTo(16, 16));
            unscaledImage.dispose();
            imageRegistry.put(imageKey, icon);
        }
        return icon;
    }

    Image getValidityIcon(String time) {
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        if (time.equals("")) {
            return null;
        }
        String imageKey = "de.aristaflow.adept2.ui.icons.misc.MiscImages.Validity";
        Image icon = imageRegistry.get(imageKey);
        if (icon == null) {
            Image unscaledImage = null;
            if (imageKey.equals("nosar.png")) {
                unscaledImage = MiscImages.getImage((String)imageKey);
            } else {
                ImageDescriptor unscaledImageDesc = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/validity_16.png");
                unscaledImage = unscaledImageDesc.createImage();
            }
            icon = new Image(unscaledImage.getDevice(), unscaledImage.getImageData().scaledTo(16, 16));
            unscaledImage.dispose();
            imageRegistry.put(imageKey, icon);
        }
        return icon;
    }
}

