/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.widgets;

import de.aristaflow.adept2.model.common.timedata.TimePoint;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultTimePoint;
import de.aristaflow.adept2.ui.processvisualisation.widgets.CSpinner;
import de.aristaflow.adept2.ui.util.CalendarToolTip;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TimePointSpinnerWidget
extends PopupDialog {
    private CSpinner monthsSpinner;
    private CSpinner daySpinner;
    private CSpinner hourSpinner;
    private CSpinner minuteSpinner;
    private CSpinner secondsSpinner;
    private TimePoint timePoint;
    private Set<CalendarToolTip.ToolTipListener> listener = new HashSet<CalendarToolTip.ToolTipListener>();
    boolean changed = false;
    private Button clear;

    public TimePointSpinnerWidget(Control parent, int style) {
        super(parent.getShell(), style, true, false, false, false, false, null, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToolTipListener(CalendarToolTip.ToolTipListener listener) {
        ArgChecks.checkForNull((Object)listener, (String)"listener");
        CalendarToolTip.ToolTipListener toolTipListener = listener;
        synchronized (toolTipListener) {
            this.listener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToolTipListener(CalendarToolTip.ToolTipListener listener) {
        ArgChecks.checkForNull((Object)listener, (String)"listener");
        CalendarToolTip.ToolTipListener toolTipListener = listener;
        synchronized (toolTipListener) {
            this.listener.remove(listener);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createContent(composite);
        composite.setTabList(new Control[]{this.secondsSpinner, this.minuteSpinner, this.hourSpinner, this.daySpinner, this.monthsSpinner});
        return composite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Composite createContent(Composite composite) {
        CalendarToolTip.ToolTipListener[] current;
        GridLayout layout = new GridLayout(14, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.horizontalSpacing = 2;
        composite.setLayout((Layout)layout);
        SelectionListener spinnerSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!e.widget.isDisposed()) {
                    TimePointSpinnerWidget.this.modified();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        KeyListener keyListener = new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (!e.widget.isDisposed()) {
                    TimePointSpinnerWidget.this.modified();
                    if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                        TimePointSpinnerWidget.this.close();
                    }
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        };
        GridDataFactory spinnerGridDataFactory = GridDataFactory.createFrom((GridData)new GridData(131072, 0x1000000, false, false)).hint(40, -1);
        GridDataFactory labelGridDataFactory = GridDataFactory.createFrom((GridData)new GridData(16384, 0x1000000, false, false));
        GridDataFactory separatorGridDataFactory = GridDataFactory.createFrom((GridData)new GridData(3, -1));
        this.monthsSpinner = new CSpinner(composite, 2048);
        this.monthsSpinner.setLayoutData(spinnerGridDataFactory.create());
        this.monthsSpinner.setMaximum(999);
        this.monthsSpinner.setMinimum(-999);
        this.monthsSpinner.addSelectionListener(spinnerSelectionListener);
        this.monthsSpinner.addKeyListener(keyListener);
        Label label = this.createLabel(composite, "months");
        label.setLayoutData((Object)labelGridDataFactory.create());
        Label separator = new Label(composite, 0);
        separator.setLayoutData((Object)separatorGridDataFactory.create());
        this.daySpinner = new CSpinner(composite, 2048);
        this.daySpinner.setLayoutData(spinnerGridDataFactory.create());
        this.daySpinner.setMaximum(999);
        this.daySpinner.setMinimum(-999);
        this.daySpinner.addSelectionListener(spinnerSelectionListener);
        this.daySpinner.addKeyListener(keyListener);
        label = this.createLabel(composite, "days");
        label.setLayoutData((Object)labelGridDataFactory.create());
        separator = new Label(composite, 0);
        separator.setLayoutData((Object)separatorGridDataFactory.create());
        this.hourSpinner = new CSpinner(composite, 2048);
        this.hourSpinner.setLayoutData(spinnerGridDataFactory.create());
        this.hourSpinner.setMaximum(999);
        this.hourSpinner.setMinimum(-999);
        this.hourSpinner.addSelectionListener(spinnerSelectionListener);
        this.hourSpinner.addKeyListener(keyListener);
        label = this.createLabel(composite, "hours");
        label.setLayoutData((Object)labelGridDataFactory.create());
        separator = new Label(composite, 0);
        separator.setLayoutData((Object)separatorGridDataFactory.create());
        this.minuteSpinner = new CSpinner(composite, 2048);
        this.minuteSpinner.setLayoutData(spinnerGridDataFactory.create());
        this.minuteSpinner.setMaximum(999);
        this.minuteSpinner.setMinimum(-999);
        this.minuteSpinner.addSelectionListener(spinnerSelectionListener);
        this.minuteSpinner.addKeyListener(keyListener);
        label = this.createLabel(composite, "minutes");
        label.setLayoutData((Object)labelGridDataFactory.create());
        separator = new Label(composite, 0);
        separator.setLayoutData((Object)separatorGridDataFactory.create());
        this.secondsSpinner = new CSpinner(composite, 2048);
        this.secondsSpinner.setLayoutData(spinnerGridDataFactory.create());
        this.secondsSpinner.setMaximum(999);
        this.secondsSpinner.setMinimum(-999);
        this.secondsSpinner.addSelectionListener(spinnerSelectionListener);
        this.secondsSpinner.addKeyListener(keyListener);
        label = this.createLabel(composite, "seconds");
        label.setLayoutData((Object)labelGridDataFactory.create());
        Set<CalendarToolTip.ToolTipListener> set = this.listener;
        synchronized (set) {
            current = this.listener.toArray(new CalendarToolTip.ToolTipListener[this.listener.size()]);
        }
        CalendarToolTip.ToolTipListener[] toolTipListenerArray = current;
        int n = current.length;
        int n2 = 0;
        while (n2 < n) {
            CalendarToolTip.ToolTipListener listener = toolTipListenerArray[n2];
            listener.toolTipCreated();
            ++n2;
        }
        return composite;
    }

    protected Control createInfoTextArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        super.createInfoTextArea(composite);
        this.clear = new Button(composite, 8);
        this.clear.setText("Clear");
        this.clear.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!e.widget.isDisposed()) {
                    TimePointSpinnerWidget.this.clear();
                }
                TimePointSpinnerWidget.this.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridDataFactory.defaultsFor((Control)this.clear).grab(false, false).align(4, 0x1000000).hint(100, -1).applyTo((Control)composite);
        return composite;
    }

    void modified() {
        TimePoint newTimePoint = this.internalGetTimePoint();
        this.changed |= newTimePoint != null && !newTimePoint.equals(this.timePoint) || newTimePoint == null && this.timePoint != null;
        if (this.changed) {
            this.timePoint = newTimePoint;
        }
    }

    public void setTimePoint(TimePoint timePoint) {
        if (this.monthsSpinner.isDisposed()) {
            throw new IllegalStateException();
        }
        if (timePoint != null) {
            if (timePoint.getMonths() != Long.MIN_VALUE) {
                this.monthsSpinner.setSelection((int)timePoint.getMonths());
            } else {
                this.monthsSpinner.clearSelection();
            }
            if (timePoint.getDays() != Long.MIN_VALUE) {
                this.daySpinner.setSelection((int)timePoint.getDays());
            } else {
                this.daySpinner.clearSelection();
            }
            if (timePoint.getHours() != Long.MIN_VALUE) {
                this.hourSpinner.setSelection((int)timePoint.getHours());
            } else {
                this.hourSpinner.clearSelection();
            }
            if (timePoint.getMinutes() != Long.MIN_VALUE) {
                this.minuteSpinner.setSelection((int)timePoint.getMinutes());
            } else {
                this.minuteSpinner.clearSelection();
            }
            if (timePoint.getSeconds() != Long.MIN_VALUE) {
                this.secondsSpinner.setSelection((int)timePoint.getSeconds());
            } else {
                this.secondsSpinner.clearSelection();
            }
        } else {
            this.monthsSpinner.clearSelection();
            this.daySpinner.clearSelection();
            this.hourSpinner.clearSelection();
            this.minuteSpinner.clearSelection();
            this.secondsSpinner.clearSelection();
        }
        this.timePoint = timePoint;
        this.changed = false;
    }

    void clear() {
        if (this.monthsSpinner.isDisposed()) {
            throw new IllegalStateException();
        }
        this.monthsSpinner.clearSelection();
        this.daySpinner.clearSelection();
        this.hourSpinner.clearSelection();
        this.minuteSpinner.clearSelection();
        this.secondsSpinner.clearSelection();
        this.modified();
    }

    private TimePoint internalGetTimePoint() {
        if (this.monthsSpinner.isDisposed()) {
            throw new IllegalStateException();
        }
        boolean set = false;
        long months = Long.MIN_VALUE;
        long days = Long.MIN_VALUE;
        long hours = Long.MIN_VALUE;
        long minutes = Long.MIN_VALUE;
        long seconds = Long.MIN_VALUE;
        if (this.monthsSpinner.hasSelection()) {
            months = this.monthsSpinner.getSelection();
            set = true;
        }
        if (this.daySpinner.hasSelection()) {
            days = this.daySpinner.getSelection();
            set = true;
        }
        if (this.hourSpinner.hasSelection()) {
            hours = this.hourSpinner.getSelection();
            set = true;
        }
        if (this.minuteSpinner.hasSelection()) {
            minutes = this.minuteSpinner.getSelection();
            set = true;
        }
        if (this.secondsSpinner.hasSelection()) {
            seconds = this.secondsSpinner.getSelection();
            set = true;
        }
        if (set) {
            return new DefaultTimePoint(seconds, minutes, hours, days, months);
        }
        return null;
    }

    private Label createLabel(Composite parent, String text) {
        Label lbl = new Label(parent, 0);
        lbl.setText(text);
        return lbl;
    }

    public Control getFocusControl() {
        return this.secondsSpinner;
    }

    public boolean setFocus() {
        if (!this.secondsSpinner.isDisposed()) {
            return this.secondsSpinner.setFocus();
        }
        return false;
    }

    public TimePoint getTimePoint() {
        return this.timePoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        boolean closed = super.close();
        if (closed) {
            CalendarToolTip.ToolTipListener[] current;
            Set<CalendarToolTip.ToolTipListener> set = this.listener;
            synchronized (set) {
                current = this.listener.toArray(new CalendarToolTip.ToolTipListener[this.listener.size()]);
            }
            CalendarToolTip.ToolTipListener[] toolTipListenerArray = current;
            int n = current.length;
            int n2 = 0;
            while (n2 < n) {
                CalendarToolTip.ToolTipListener listener = toolTipListenerArray[n2];
                listener.toolTipHidden(this.changed);
                ++n2;
            }
        }
        return closed;
    }

    protected void adjustBounds() {
        super.adjustBounds();
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        Point point = d.getCursorLocation();
        this.getShell().setLocation(point.x + 9, point.y + 14);
    }
}

