/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.widgets;

import de.aristaflow.adept2.model.common.timedata.TimePoint;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeModelTools;
import de.aristaflow.adept2.ui.processvisualisation.widgets.TimePointSpinnerWidget;
import de.aristaflow.adept2.ui.util.CalendarToolTip;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TimePointWidget
extends Composite
implements MouseListener {
    private final FormToolkit toolkit;
    Label timePointLabel;
    TimePoint timePoint;
    TimePointSpinnerWidget overlayComposite;
    private CalendarToolTip.ToolTipListener toolTipListener;
    private String title;
    private Set<TimePointModifyListener> listeners = new HashSet<TimePointModifyListener>();
    private Label titleLabel;

    public TimePointWidget(Composite parent, int style, String title, FormToolkit toolkit) {
        super(parent, style);
        this.title = title;
        this.toolkit = toolkit;
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.createContent(this);
    }

    public void setTitle(String title) {
        this.title = title;
        this.titleLabel.setText(title);
    }

    protected void createContent(Composite parent) {
        this.titleLabel = this.createLabel(parent, this.title);
        GridData labelLayoutData = new GridData(16384, 0x1000000, false, false);
        labelLayoutData.widthHint = 150;
        this.titleLabel.setLayoutData((Object)labelLayoutData);
        this.timePointLabel = this.createLabel(parent, "not set");
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.minimumWidth = 100;
        this.timePointLabel.setLayoutData((Object)layoutData);
        this.timePointLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TimePointWidget.this.setOverlayCompositeVisible(true);
            }
        });
        this.overlayComposite = new TimePointSpinnerWidget((Control)this.timePointLabel, 0);
        this.toolTipListener = new CalendarToolTip.ToolTipListener(){

            public void toolTipHidden(boolean changed) {
                if (changed) {
                    TimePointWidget.this.updateValue(TimePointWidget.this.overlayComposite.getTimePoint());
                }
            }

            public void toolTipCreated() {
            }
        };
        this.overlayComposite.addToolTipListener(this.toolTipListener);
    }

    private Label createLabel(Composite parent, String text) {
        if (this.toolkit != null) {
            return this.toolkit.createLabel(parent, text);
        }
        Label lbl = new Label(parent, 0);
        lbl.setText(text);
        return lbl;
    }

    protected void setOverlayCompositeVisible(boolean visible) {
        if (visible) {
            this.overlayComposite.open();
            this.overlayComposite.setTimePoint(this.timePoint);
        } else {
            this.overlayComposite.close();
        }
    }

    public void commit() {
        this.setOverlayCompositeVisible(false);
    }

    void updateValue(final TimePoint newTimePoint) {
        if (newTimePoint == null || !newTimePoint.equals(this.timePoint)) {
            this.setTimePoint(newTimePoint);
            this.getParent().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TimePointWidget.this.notifyListeners(TimePointWidget.this, newTimePoint);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(TimePointWidget source, TimePoint newTimePoint) {
        TimePointModifyListener[] current;
        Set<TimePointModifyListener> set = this.listeners;
        synchronized (set) {
            current = this.listeners.toArray(new TimePointModifyListener[this.listeners.size()]);
        }
        TimePointModifyListener[] timePointModifyListenerArray = current;
        int n = current.length;
        int n2 = 0;
        while (n2 < n) {
            TimePointModifyListener l = timePointModifyListenerArray[n2];
            l.modifyTimePoint(source, newTimePoint);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModifyListener(TimePointModifyListener listener) {
        Set<TimePointModifyListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    public void setTimePoint(TimePoint timePoint) {
        this.timePoint = timePoint;
        if (this.timePointLabel.isDisposed()) {
            return;
        }
        if (timePoint != null) {
            this.timePointLabel.setText(TimeModelTools.convertToString((TimePoint)timePoint));
        } else {
            this.timePointLabel.setText("not set");
        }
        this.timePointLabel.getParent().layout();
    }

    public TimePoint getTimePoint() {
        return this.timePoint;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        this.setOverlayCompositeVisible(false);
    }

    public static interface TimePointModifyListener {
        public void modifyTimePoint(TimePointWidget var1, TimePoint var2);
    }
}

