/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.dataelementwizard;

import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.systemdata.Dependency;
import de.aristaflow.adept2.model.common.timedata.TimePoint;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDate;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDateUpdateProcedureData;
import de.aristaflow.adept2.model.processmodel.timemodel.TimeModelTools;
import de.aristaflow.adept2.model.processmodel.timemodel.updatehandlers.DataElementFixedDateConfiguration;
import de.aristaflow.adept2.model.processmodel.timemodel.updatehandlers.DataElementUpdateTrigger;
import de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.AbstractFixedDateWizard;
import de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.IFixedDateWizard;
import de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.dataelementwizard.FixedDateDataElementWizardPage;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;

public class DataElementFixedDateWizard
extends AbstractFixedDateWizard
implements IFixedDateWizard {
    private static final String ID = "de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.DataElementFixedDateWizard";
    public static final String UPDATE_PROCEDURE_ID = "de.aristaflow.adept2.model.processmodel.timemodel.updatehandlers.DataElementFixedDateUpdateHandler";
    private FixedDateDataElementWizardPage chooseDataElement;
    private Map<String, Dependency> parameterBindings;

    public DataElementFixedDateWizard() {
        this.setWindowTitle("Data element based fixed date");
        this.chooseDataElement = new FixedDateDataElementWizardPage("ChooseDataElement", this);
        this.addPage((IWizardPage)this.chooseDataElement);
    }

    public boolean performFinish() {
        DataElementUpdateTrigger trigger;
        HashMap map;
        this.parameterBindings = new HashMap<String, Dependency>();
        HashMap configuration = new HashMap();
        DataElementFixedDateConfiguration config = (DataElementFixedDateConfiguration)ModelViewer.createView(configuration, DataElementFixedDateConfiguration.class);
        DataElement dataElementEarliest = this.chooseDataElement.getSelectedDataElementEarliest();
        if (dataElementEarliest != null) {
            String parameterName = this.chooseDataElement.getEarliestParameterName();
            config.setEarliestDateParameterName(this.getParameterReference(parameterName, dataElementEarliest));
            Dependency dependency = new Dependency(Dependency.DEPENDENCY_TYPE_DATA_ELEMENT, (Object)dataElementEarliest);
            this.parameterBindings.put(parameterName, dependency);
        } else if (this.chooseDataElement.getEarliestRelativeTimePoint() != null) {
            config.setEarliestRelativeDate(this.chooseDataElement.getEarliestRelativeTimePoint());
        }
        DataElement dataElementLatest = this.chooseDataElement.getSelectedDataElementLatest();
        if (dataElementLatest != null) {
            String parameterName = this.chooseDataElement.getLatestParameterName();
            config.setLatestDateParameterName(this.getParameterReference(parameterName, dataElementLatest));
            Dependency dependency = new Dependency(Dependency.DEPENDENCY_TYPE_DATA_ELEMENT, (Object)dataElementLatest);
            this.parameterBindings.put(parameterName, dependency);
        } else if (this.chooseDataElement.getLatestRelativeTimePoint() != null) {
            config.setLatestRelativeDate(this.chooseDataElement.getLatestRelativeTimePoint());
        }
        FixedDate result = (FixedDate)ModelViewer.createNew(FixedDate.class);
        FixedDateUpdateProcedureData procedure = (FixedDateUpdateProcedureData)ModelViewer.createNew(FixedDateUpdateProcedureData.class);
        procedure.setConfiguration((PluginData)new DefaultPluginData(ID, configuration));
        procedure.setProcedureID(UPDATE_PROCEDURE_ID);
        String description = this.chooseDataElement.getUpdateProcedureDescription();
        if (!description.isEmpty()) {
            procedure.setDescription(description);
        } else {
            procedure.setDescription(this.getDescription(config));
        }
        int updateCount = 0;
        updateCount = dataElementEarliest != null ? updateCount + 1 : updateCount;
        updateCount = dataElementLatest != null ? updateCount + 1 : updateCount;
        PluginData[] triggerList = new PluginData[updateCount];
        updateCount = 0;
        if (dataElementEarliest != null) {
            map = new HashMap();
            trigger = (DataElementUpdateTrigger)ModelViewer.createView(map, DataElementUpdateTrigger.class);
            trigger.setDataElementID(dataElementEarliest.getID());
            triggerList[updateCount++] = new DefaultPluginData("de.aristaflow.adept2.model.processmodel.timemodel.updatehandlers.DataElementUpdateTrigger", map);
        }
        if (dataElementLatest != null) {
            map = new HashMap();
            trigger = (DataElementUpdateTrigger)ModelViewer.createView(map, DataElementUpdateTrigger.class);
            trigger.setDataElementID(dataElementLatest.getID());
            triggerList[updateCount++] = new DefaultPluginData("de.aristaflow.adept2.model.processmodel.timemodel.updatehandlers.DataElementUpdateTrigger", map);
        }
        procedure.setUpdateTriggerList(triggerList);
        result.setFixedDateUpdateProcedure(procedure);
        this.fixedDate = result;
        return true;
    }

    private String getDescription(DataElementFixedDateConfiguration config) {
        TimePoint relativeDate;
        StringBuilder description = new StringBuilder();
        String earliestParameterName = config.getEarliestDateParameterName();
        String latestParameterName = config.getLatestDateParameterName();
        if (earliestParameterName != null && !earliestParameterName.isEmpty()) {
            description.append("Earliest Date: " + earliestParameterName);
        } else {
            relativeDate = config.getEarliestRelativeDate();
            if (relativeDate != null && latestParameterName != null && !latestParameterName.isEmpty()) {
                description.append("Earliest Date: " + latestParameterName + " - " + TimeModelTools.convertToString((TimePoint)relativeDate));
            }
        }
        if (description.length() > 0) {
            description.append('\n');
        }
        if (latestParameterName != null && !latestParameterName.isEmpty()) {
            description.append("Latest Date: " + latestParameterName);
        } else {
            relativeDate = config.getLatestRelativeDate();
            if (relativeDate != null && earliestParameterName != null && !earliestParameterName.isEmpty()) {
                description.append("Latest Date: " + earliestParameterName + " + " + TimeModelTools.convertToString((TimePoint)relativeDate));
            }
        }
        return description.toString();
    }

    private String getParameterReference(String parameterName, DataElement dataElement) {
        ParameterRef parameterRef = new ParameterRef(dataElement.getDataType(), parameterName);
        return parameterRef.toString();
    }

    @Override
    public String getName() {
        return "Read Fixed Date from Data Element";
    }

    @Override
    public Map<String, Dependency> getParameterBindings() {
        return this.parameterBindings;
    }

    public String[] getSupportedUpdateProcedureIDs() {
        return new String[]{UPDATE_PROCEDURE_ID};
    }
}

