/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.dataelementwizard;

import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.common.timedata.TimePoint;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDate;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDateUpdateProcedureData;
import de.aristaflow.adept2.model.processmodel.timemodel.updatehandlers.DataElementFixedDateConfiguration;
import de.aristaflow.adept2.ui.processvisualisation.widgets.TimePointWidget;
import de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.dataelementwizard.DataElementFixedDateWizard;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FixedDateDataElementWizardPage
extends WizardPage {
    protected static final int NO_DATE = 0;
    protected static final int ABSOLUTE_DATE = 1;
    protected static final int RELATIVE_DATE = 2;
    private DataElementFixedDateWizard parentWizard;
    private Combo cbEarliestDataElement;
    private DataElement[] dataElements;
    private Text txtEarliestParameter;
    private Group grpAbsolutEarliest;
    private Group grpRelativeEarliest;
    private Group grpAbsoluteLatest;
    private Text txtLatestParameter;
    private Combo cbLatestDataElement;
    private TimePointWidget spnLatestDist;
    private Group grpRelativeLatest;
    private Button btnLatestRelative;
    private Button btnEarliestRelative;
    private Button btnEarliestNone;
    private Button btnLatestNone;
    private TimePointWidget spnEarliestDist;
    private Button btnEarliestAbsolut;
    private Button btnLatestAbsolut;
    private Group grpComment;
    private Text textComment;

    protected FixedDateDataElementWizardPage(String pageName, DataElementFixedDateWizard parentWizard) {
        super(pageName);
        this.setTitle("Data element based Fixed Date");
        this.setMessage("Please configure the Fixed Date for the Activity.");
        this.parentWizard = parentWizard;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)composite);
        this.grpComment = new Group(composite, 0);
        this.grpComment.setLayout((Layout)new GridLayout(1, false));
        this.grpComment.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.grpComment.setText("Comment");
        this.textComment = new Text((Composite)this.grpComment, 2626);
        GridData gd_textComment = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_textComment.heightHint = 30;
        gd_textComment.minimumHeight = 30;
        this.textComment.setLayoutData((Object)gd_textComment);
        Group grpEarliestDate = new Group(composite, 0);
        grpEarliestDate.setLayout((Layout)new GridLayout(4, false));
        grpEarliestDate.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpEarliestDate.setText("Earliest Date:");
        Label lblTypeEarliest = new Label((Composite)grpEarliestDate, 0);
        lblTypeEarliest.setText("Type:");
        this.btnEarliestNone = new Button((Composite)grpEarliestDate, 16);
        this.btnEarliestNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FixedDateDataElementWizardPage.this.setTypeEarliest(0);
                FixedDateDataElementWizardPage.this.setPageComplete(FixedDateDataElementWizardPage.this.validatePageComplete());
            }
        });
        this.btnEarliestNone.setSelection(true);
        this.btnEarliestNone.setText("None");
        this.btnEarliestAbsolut = new Button((Composite)grpEarliestDate, 16);
        this.btnEarliestAbsolut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FixedDateDataElementWizardPage.this.setTypeEarliest(1);
                FixedDateDataElementWizardPage.this.setPageComplete(FixedDateDataElementWizardPage.this.validatePageComplete());
            }
        });
        this.btnEarliestAbsolut.setText("Absolute Date");
        this.btnEarliestRelative = new Button((Composite)grpEarliestDate, 16);
        this.btnEarliestRelative.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FixedDateDataElementWizardPage.this.setTypeEarliest(2);
                FixedDateDataElementWizardPage.this.setPageComplete(FixedDateDataElementWizardPage.this.validatePageComplete());
            }
        });
        this.btnEarliestRelative.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnEarliestRelative.setText("Relative to Latest Date");
        this.grpAbsolutEarliest = new Group((Composite)grpEarliestDate, 0);
        this.grpAbsolutEarliest.setText("Absolute Date");
        this.grpAbsolutEarliest.setLayout((Layout)new GridLayout(2, false));
        this.grpAbsolutEarliest.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        Label lblParameterEarliest = new Label((Composite)this.grpAbsolutEarliest, 0);
        lblParameterEarliest.setText("Parameter Name:");
        Label lblDataElementEarliest = new Label((Composite)this.grpAbsolutEarliest, 0);
        lblDataElementEarliest.setText("Data Element:");
        this.txtEarliestParameter = new Text((Composite)this.grpAbsolutEarliest, 2048);
        this.txtEarliestParameter.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.txtEarliestParameter.setText("earliestFixedDate");
        this.txtEarliestParameter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FixedDateDataElementWizardPage.this.setPageComplete(FixedDateDataElementWizardPage.this.validatePageComplete());
            }
        });
        this.cbEarliestDataElement = new Combo((Composite)this.grpAbsolutEarliest, 8);
        this.cbEarliestDataElement.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.grpRelativeEarliest = new Group((Composite)grpEarliestDate, 0);
        this.grpRelativeEarliest.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        this.grpRelativeEarliest.setText("Relative to Latest Date");
        this.grpRelativeEarliest.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory gridDataFactory = GridDataFactory.createFrom((GridData)new GridData(4, 0x1000000, true, false));
        this.spnEarliestDist = new TimePointWidget((Composite)this.grpRelativeEarliest, 0, "Relative to Latest Date", null);
        this.spnEarliestDist.setLayoutData(gridDataFactory.create());
        this.cbEarliestDataElement.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FixedDateDataElementWizardPage.this.setPageComplete(FixedDateDataElementWizardPage.this.validatePageComplete());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Group grpLatestDate = new Group(composite, 0);
        grpLatestDate.setText("Latest Date:");
        grpLatestDate.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpLatestDate.setLayout((Layout)new GridLayout(4, false));
        Label lblTypeLatest = new Label((Composite)grpLatestDate, 0);
        lblTypeLatest.setText("Type:");
        this.btnLatestNone = new Button((Composite)grpLatestDate, 16);
        this.btnLatestNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FixedDateDataElementWizardPage.this.setTypeLatest(0);
                FixedDateDataElementWizardPage.this.setPageComplete(FixedDateDataElementWizardPage.this.validatePageComplete());
            }
        });
        this.btnLatestNone.setSelection(true);
        this.btnLatestNone.setText("None");
        this.btnLatestAbsolut = new Button((Composite)grpLatestDate, 16);
        this.btnLatestAbsolut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FixedDateDataElementWizardPage.this.setTypeLatest(1);
                FixedDateDataElementWizardPage.this.setPageComplete(FixedDateDataElementWizardPage.this.validatePageComplete());
            }
        });
        this.btnLatestAbsolut.setText("Absolute Date");
        this.btnLatestRelative = new Button((Composite)grpLatestDate, 16);
        this.btnLatestRelative.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FixedDateDataElementWizardPage.this.setTypeLatest(2);
                FixedDateDataElementWizardPage.this.setPageComplete(FixedDateDataElementWizardPage.this.validatePageComplete());
            }
        });
        this.btnLatestRelative.setText("Relative to Earliest Date");
        this.grpAbsoluteLatest = new Group((Composite)grpLatestDate, 0);
        this.grpAbsoluteLatest.setText("Absolute Date");
        this.grpAbsoluteLatest.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        this.grpAbsoluteLatest.setLayout((Layout)new GridLayout(2, false));
        Label lblParameterLatest = new Label((Composite)this.grpAbsoluteLatest, 0);
        lblParameterLatest.setText("Parameter Name:");
        Label lblDataElementLatest = new Label((Composite)this.grpAbsoluteLatest, 0);
        lblDataElementLatest.setText("Data Element:");
        this.txtLatestParameter = new Text((Composite)this.grpAbsoluteLatest, 2048);
        this.txtLatestParameter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtLatestParameter.setText("latestFixedDate");
        this.txtLatestParameter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FixedDateDataElementWizardPage.this.setPageComplete(FixedDateDataElementWizardPage.this.validatePageComplete());
            }
        });
        this.cbLatestDataElement = new Combo((Composite)this.grpAbsoluteLatest, 8);
        this.cbLatestDataElement.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FixedDateDataElementWizardPage.this.setPageComplete(FixedDateDataElementWizardPage.this.validatePageComplete());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.cbLatestDataElement.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.grpRelativeLatest = new Group((Composite)grpLatestDate, 0);
        this.grpRelativeLatest.setText("Relative to Earliest Date");
        this.grpRelativeLatest.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        this.grpRelativeLatest.setLayout((Layout)new GridLayout(1, false));
        this.spnLatestDist = new TimePointWidget((Composite)this.grpRelativeLatest, 0, "Relative to Earliest Date", null);
        this.spnLatestDist.setLayoutData(gridDataFactory.create());
        this.init();
    }

    protected void setTypeLatest(int type) {
        switch (type) {
            case 1: {
                this.btnLatestNone.setSelection(false);
                this.btnLatestAbsolut.setSelection(true);
                this.btnLatestRelative.setSelection(false);
                this.setEnabled((Composite)this.grpAbsoluteLatest, true);
                this.setEnabled((Composite)this.grpRelativeLatest, false);
                this.btnEarliestRelative.setEnabled(true);
                break;
            }
            case 2: {
                this.btnLatestNone.setSelection(false);
                this.btnLatestAbsolut.setSelection(false);
                this.btnLatestRelative.setSelection(true);
                this.setEnabled((Composite)this.grpAbsoluteLatest, false);
                this.setEnabled((Composite)this.grpRelativeLatest, true);
                this.btnEarliestRelative.setEnabled(true);
                if (!this.btnEarliestRelative.getSelection()) break;
                this.setTypeEarliest(0);
                break;
            }
            default: {
                this.btnLatestNone.setSelection(true);
                this.btnLatestAbsolut.setSelection(false);
                this.btnLatestRelative.setSelection(false);
                this.setEnabled((Composite)this.grpAbsoluteLatest, false);
                this.setEnabled((Composite)this.grpRelativeLatest, false);
                this.btnEarliestRelative.setEnabled(false);
                if (!this.btnEarliestRelative.getSelection()) break;
                this.setTypeEarliest(0);
            }
        }
    }

    protected void setTypeEarliest(int type) {
        switch (type) {
            case 1: {
                this.btnEarliestAbsolut.setSelection(true);
                this.btnEarliestNone.setSelection(false);
                this.btnEarliestRelative.setSelection(false);
                this.setEnabled((Composite)this.grpAbsolutEarliest, true);
                this.setEnabled((Composite)this.grpRelativeEarliest, false);
                this.btnLatestRelative.setEnabled(true);
                break;
            }
            case 2: {
                this.btnEarliestAbsolut.setSelection(false);
                this.btnEarliestNone.setSelection(false);
                this.btnEarliestRelative.setSelection(true);
                this.setEnabled((Composite)this.grpAbsolutEarliest, false);
                this.setEnabled((Composite)this.grpRelativeEarliest, true);
                this.btnLatestRelative.setEnabled(false);
                if (!this.btnLatestRelative.getSelection()) break;
                this.setTypeLatest(0);
                break;
            }
            default: {
                this.btnEarliestAbsolut.setSelection(false);
                this.btnEarliestNone.setSelection(true);
                this.btnEarliestRelative.setSelection(false);
                this.setEnabled((Composite)this.grpAbsolutEarliest, false);
                this.setEnabled((Composite)this.grpRelativeEarliest, false);
                this.btnLatestRelative.setEnabled(false);
                if (!this.btnLatestRelative.getSelection()) break;
                this.setTypeLatest(0);
            }
        }
    }

    private void setEnabled(Composite composite, boolean enabled) {
        composite.setEnabled(enabled);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setEnabled(enabled);
            if (child instanceof Composite) {
                this.setEnabled((Composite)child, enabled);
            }
            ++n2;
        }
    }

    private void init() {
        FixedDateUpdateProcedureData updateProcedure;
        this.setTypeEarliest(0);
        this.setTypeLatest(0);
        this.initDataElements();
        DataElement[] dataElementArray = this.dataElements;
        int n = this.dataElements.length;
        int n2 = 0;
        while (n2 < n) {
            DataElement data = dataElementArray[n2];
            this.cbEarliestDataElement.add(" " + data.getID() + ": " + data.getName());
            this.cbLatestDataElement.add(" " + data.getID() + ": " + data.getName());
            ++n2;
        }
        FixedDate fixedDate = this.parentWizard.getFixedDate();
        if (fixedDate != null && (updateProcedure = fixedDate.getFixedDateUpdateProcedure()) != null && updateProcedure.getConfiguration() != null) {
            int i;
            DataElementFixedDateConfiguration config = (DataElementFixedDateConfiguration)ModelViewer.createView((Map)updateProcedure.getConfiguration().getPluginData(), DataElementFixedDateConfiguration.class);
            this.textComment.setText(fixedDate.getFixedDateUpdateProcedure().getDescription());
            ParameterRef parameterRefEarliest = this.getParameterRef(config.getEarliestDateParameterName());
            DataElement dataElementEarliest = null;
            if (parameterRefEarliest != null) {
                dataElementEarliest = this.getDataElement(parameterRefEarliest);
            }
            ParameterRef parameterRefLatest = this.getParameterRef(config.getLatestDateParameterName());
            DataElement dataElementLatest = null;
            if (parameterRefLatest != null) {
                dataElementLatest = this.getDataElement(parameterRefLatest);
            }
            if (parameterRefEarliest != null) {
                int indexEarliest = -1;
                i = 0;
                while (i < this.dataElements.length) {
                    if (this.dataElements[i] == dataElementEarliest) {
                        indexEarliest = i;
                        break;
                    }
                    ++i;
                }
                this.cbEarliestDataElement.select(indexEarliest);
                this.txtEarliestParameter.setText(parameterRefEarliest.getName());
                this.setTypeEarliest(1);
                if (config.getLatestRelativeDate() != null && dataElementLatest == null) {
                    this.spnLatestDist.setTimePoint(config.getLatestRelativeDate());
                    this.btnLatestRelative.setSelection(true);
                    this.setTypeLatest(2);
                }
            }
            if (parameterRefLatest != null) {
                int indexLatest = -1;
                i = 0;
                while (i < this.dataElements.length) {
                    if (this.dataElements[i] == dataElementLatest) {
                        indexLatest = i;
                    }
                    ++i;
                }
                this.cbLatestDataElement.select(indexLatest);
                this.txtEarliestParameter.setText(parameterRefLatest.getName());
                this.setTypeLatest(1);
                if (config.getEarliestRelativeDate() != null && dataElementEarliest == null) {
                    this.spnEarliestDist.setTimePoint(config.getEarliestRelativeDate());
                    this.setTypeLatest(2);
                }
            }
        }
        this.setPageComplete(this.validatePageComplete());
    }

    private DataElement getDataElement(ParameterRef parameterRef) {
        return this.getTemplate().getDataElement(this.getNode().getID(), this.getNode().getConnector(parameterRef.getName(), ActivityConstants.AccessType.SYSTEM_READ));
    }

    protected ParameterRef getParameterRef(String parameterName) {
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        ParameterRef parameterRefsEarliest = SystemDataTools.parseParameterReference((String)parameterName);
        return parameterRefsEarliest;
    }

    private Node getNode() {
        return this.parentWizard.getNode();
    }

    private Template getTemplate() {
        return this.parentWizard.getTemplate();
    }

    private void initDataElements() {
        HashSet<DataElement> usableDataElements = new HashSet<DataElement>();
        Set dataElementsAllTypes = this.getTemplate().getDataElements();
        for (DataElement element : dataElementsAllTypes) {
            if (element.getDataType() != ProcessConstants.AdeptDataType.INTEGER && element.getDataType() != ProcessConstants.AdeptDataType.DATE) continue;
            usableDataElements.add(element);
        }
        this.dataElements = usableDataElements.toArray(new DataElement[0]);
    }

    private boolean validatePageComplete() {
        if (this.btnEarliestAbsolut != null && this.btnEarliestAbsolut.getSelection()) {
            if ("".equals(this.txtEarliestParameter.getText().trim())) {
                this.setErrorMessage("Parameter name for earliest date must be set!");
                return false;
            }
            if (this.cbEarliestDataElement.getSelectionIndex() == -1) {
                this.setErrorMessage("A data element must be selected for earliest date!");
                return false;
            }
        }
        if (this.btnLatestAbsolut != null && this.btnLatestAbsolut.getSelection()) {
            if ("".equals(this.txtLatestParameter.getText().trim())) {
                this.setErrorMessage("Parameter name for latest date must be set!");
                return false;
            }
            if (this.cbLatestDataElement.getSelectionIndex() == -1) {
                this.setErrorMessage("A data element must be selected for latest date!");
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    DataElement getSelectedDataElementLatest() {
        int index = this.cbLatestDataElement.getSelectionIndex();
        if (index > -1) {
            return this.dataElements[index];
        }
        return null;
    }

    DataElement getSelectedDataElementEarliest() {
        int index = this.cbEarliestDataElement.getSelectionIndex();
        if (index > -1) {
            return this.dataElements[index];
        }
        return null;
    }

    public String getEarliestParameterName() {
        return this.txtEarliestParameter.getText().trim();
    }

    public TimePoint getEarliestRelativeTimePoint() {
        return this.spnEarliestDist.getTimePoint();
    }

    public String getLatestParameterName() {
        return this.txtLatestParameter.getText().trim();
    }

    public TimePoint getLatestRelativeTimePoint() {
        return this.spnLatestDist.getTimePoint();
    }

    public String getUpdateProcedureDescription() {
        return this.textComment.getText();
    }
}

