/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.selectionwizard;

import de.aristaflow.adept2.model.common.systemdata.Dependency;
import de.aristaflow.adept2.model.globals.TimeModelConstants;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDate;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDateUpdateProcedureData;
import de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.FixedDateWizardRegistry;
import de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.IFixedDateWizard;
import de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.selectionwizard.FixedDateWizardSelectionPage;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class FixedDateWizard
extends Wizard
implements IFixedDateWizard {
    private FixedDateWizardSelectionPage selectionPage;
    private Template template;
    private Node node;
    private FixedDate fixedDate;
    private TimeModelConstants.ReferencePoint referencePoint;
    private Map<String, Dependency> parameterBindings;
    private IFixedDateWizard wizard;

    public FixedDateWizard() {
        this.setWindowTitle("Fixed Date Element");
        this.setForcePreviousAndNextButtons(true);
    }

    @Override
    public void init(Template template, Node node, FixedDate fixedDate, TimeModelConstants.ReferencePoint referencePoint) {
        this.template = template;
        this.node = node;
        this.fixedDate = fixedDate;
        this.referencePoint = referencePoint;
    }

    public void addPages() {
        super.addPages();
        FixedDateWizardRegistry.FixedDateWizardConfigurationElement[] wizards = FixedDateWizardRegistry.getExtensions();
        if (wizards.length == 1) {
            FixedDateWizardRegistry.FixedDateWizardConfigurationElement wizardConfigurationElement = wizards[0];
            try {
                this.wizard = wizardConfigurationElement.createWizard();
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            this.wizard.init(this.template, this.node, this.fixedDate, this.referencePoint);
            this.wizard.addPages();
            if (this.wizard.getPageCount() > 0) {
                this.wizard.setContainer(this.getContainer());
                IWizardPage[] pages = this.wizard.getPages();
                int i = 0;
                while (i < pages.length) {
                    this.addPage(pages[i]);
                    ++i;
                }
                return;
            }
        }
        if (this.wizard == null) {
            this.selectionPage = new FixedDateWizardSelectionPage("PageOne", this);
            this.addPage((IWizardPage)this.selectionPage);
        }
    }

    public boolean performFinish() {
        IFixedDateWizard selectedWizard = this.wizard != null ? this.wizard : this.selectionPage.getSelectedWizard();
        if (!selectedWizard.performFinish()) {
            return false;
        }
        if (selectedWizard.getFixedDate() != null) {
            this.fixedDate = selectedWizard.getFixedDate();
            this.parameterBindings = selectedWizard.getParameterBindings();
            return true;
        }
        return false;
    }

    public IWizardPage getStartingPage() {
        if (this.fixedDate != null) {
            FixedDateWizardRegistry.FixedDateWizardConfigurationElement[] wizards = FixedDateWizardRegistry.getExtensions();
            FixedDateUpdateProcedureData updateProcedure = this.fixedDate.getFixedDateUpdateProcedure();
            if (updateProcedure != null) {
                String procedureID = updateProcedure.getProcedureID();
                FixedDateWizardRegistry.FixedDateWizardConfigurationElement selectedWizard = null;
                FixedDateWizardRegistry.FixedDateWizardConfigurationElement[] fixedDateWizardConfigurationElementArray = wizards;
                int n = wizards.length;
                int n2 = 0;
                while (n2 < n) {
                    FixedDateWizardRegistry.FixedDateWizardConfigurationElement wizard = fixedDateWizardConfigurationElementArray[n2];
                    if (this.contains(wizard.getUpdateProcedureIDs(), procedureID)) {
                        if (selectedWizard != null) {
                            selectedWizard = null;
                            break;
                        }
                        selectedWizard = wizard;
                    }
                    ++n2;
                }
                if (selectedWizard != null) {
                    FixedDateWizardRegistry.FixedDateWizardConfigurationElement wizardConfigurationElement = selectedWizard;
                    try {
                        this.wizard = wizardConfigurationElement.createWizard();
                    }
                    catch (CoreException e) {
                        throw new RuntimeException(e);
                    }
                    this.wizard.init(this.template, this.node, this.fixedDate, this.referencePoint);
                    this.getContainer().getShell().setText(this.wizard.getWindowTitle());
                    return this.wizard.getStartingPage();
                }
            }
        }
        return super.getStartingPage();
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage previousPage = super.getPreviousPage(page);
        if (previousPage == null && this.wizard != null && this.selectionPage != null) {
            return this.selectionPage;
        }
        return previousPage;
    }

    private boolean contains(String[] supportedUpdateProcedureIDs, String procedureID) {
        if (supportedUpdateProcedureIDs == null || procedureID == null) {
            return false;
        }
        String[] stringArray = supportedUpdateProcedureIDs;
        int n = supportedUpdateProcedureIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedProcedure = stringArray[n2];
            if (procedureID.equals(supportedProcedure)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.wizard != null) {
            return this.wizard.getNextPage(page);
        }
        return this.selectionPage.getNextPage();
    }

    public boolean canFinish() {
        IFixedDateWizard selectedWizard;
        if (this.getContainer().getCurrentPage() == this.selectionPage && (selectedWizard = this.selectionPage.getSelectedWizard()) != null) {
            selectedWizard.canFinish();
        }
        if (this.wizard != null) {
            return this.wizard.canFinish();
        }
        return super.canFinish();
    }

    public FixedDateWizardSelectionPage getSelectionPage() {
        return this.selectionPage;
    }

    public Template getTemplate() {
        return this.template;
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public FixedDate getFixedDate() {
        return this.fixedDate;
    }

    @Override
    public String getName() {
        return "Fixed Date Element";
    }

    @Override
    public Map<String, Dependency> getParameterBindings() {
        return this.parameterBindings;
    }

    public TimeModelConstants.ReferencePoint getReferencePoint() {
        return this.referencePoint;
    }

    public String[] getSupportedUpdateProcedureIDs() {
        return new String[0];
    }
}

