/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.selectionwizard;

import de.aristaflow.adept2.model.processmodel.timemodel.FixedDate;
import de.aristaflow.adept2.model.processmodel.timemodel.FixedDateUpdateProcedureData;
import de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.FixedDateWizardRegistry;
import de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.IFixedDateWizard;
import de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.selectionwizard.FixedDateWizard;
import de.aristaflow.adept2.ui.processvisualisation.wizards.fixedDate.selectionwizard.FixedDateWizardLabelProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class FixedDateWizardSelectionPage
extends WizardPage {
    private FixedDateWizard parentWizard;
    private FixedDateWizardRegistry.FixedDateWizardConfigurationElement selectedWizardElement;
    private FilteredList filterList;
    private FixedDateWizardRegistry.FixedDateWizardConfigurationElement[] wizards;
    private boolean initialized = false;
    private IFixedDateWizard selectedWizard;
    private Text descriptionText;
    private FixedDateWizardRegistry.FixedDateWizardConfigurationElement currentWizardElement;

    public FixedDateWizardSelectionPage(String name, FixedDateWizard wizard) {
        super(name);
        this.setTitle("Select a wizard for configuring the Fixed Date");
        this.setDescription("Select the Wizard you want to use for configuring the fixed date.");
        this.parentWizard = wizard;
    }

    protected FixedDateWizardSelectionPage(String pageName) {
        this(pageName, null);
    }

    public void stop() {
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)composite);
        this.filterList = new FilteredList(composite, 2820, (ILabelProvider)new FixedDateWizardLabelProvider(), true, true, true);
        this.filterList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.wizards = FixedDateWizardRegistry.getExtensions();
        this.filterList.setElements((Object[])this.wizards);
        this.filterList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FixedDateWizardSelectionPage.this.selectionChanged(FixedDateWizardSelectionPage.this.filterList.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Group grpDescription = new Group(composite, 0);
        grpDescription.setLayout((Layout)new GridLayout(1, false));
        grpDescription.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        grpDescription.setText("Description");
        this.descriptionText = new Text((Composite)grpDescription, 2634);
        GridData gd_text = new GridData(4, 4, true, false, 1, 1);
        gd_text.minimumWidth = 45;
        gd_text.heightHint = 45;
        this.descriptionText.setLayoutData((Object)gd_text);
    }

    protected void selectionChanged(Object[] selection) {
        if (selection != null && selection.length > 0) {
            this.setSelectedWizardElement((FixedDateWizardRegistry.FixedDateWizardConfigurationElement)selection[0]);
        } else {
            this.setSelectedWizardElement(null);
        }
        this.getContainer().updateButtons();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    protected void init() {
        FixedDateUpdateProcedureData updateProcedure;
        FixedDate fixedDate = this.parentWizard.getFixedDate();
        if (fixedDate != null && (updateProcedure = fixedDate.getFixedDateUpdateProcedure()) != null) {
            String procedureID = updateProcedure.getProcedureID();
            FixedDateWizardRegistry.FixedDateWizardConfigurationElement[] fixedDateWizardConfigurationElementArray = this.wizards;
            int n = this.wizards.length;
            int n2 = 0;
            while (n2 < n) {
                FixedDateWizardRegistry.FixedDateWizardConfigurationElement wizard = fixedDateWizardConfigurationElementArray[n2];
                if (this.contains(wizard.getUpdateProcedureIDs(), procedureID)) {
                    this.filterList.setSelection(new Object[]{wizard});
                    this.setSelectedWizardElement(wizard);
                    this.getContainer().updateButtons();
                    break;
                }
                ++n2;
            }
        }
    }

    private boolean contains(String[] supportedUpdateProcedureIDs, String procedureID) {
        if (supportedUpdateProcedureIDs == null || procedureID == null) {
            return false;
        }
        String[] stringArray = supportedUpdateProcedureIDs;
        int n = supportedUpdateProcedureIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedProcedure = stringArray[n2];
            if (procedureID.equals(supportedProcedure)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IWizardPage getNextPage() {
        if (this.selectedWizardElement != null) {
            if (this.currentWizardElement != this.selectedWizardElement && this.selectedWizard != null) {
                this.selectedWizard.dispose();
                this.selectedWizard = null;
            }
            if (this.selectedWizard == null) {
                try {
                    this.selectedWizard = this.selectedWizardElement.createWizard();
                    this.currentWizardElement = this.selectedWizardElement;
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.selectedWizard.getFixedDate() == null) {
                this.selectedWizard.init(this.parentWizard.getTemplate(), this.parentWizard.getNode(), this.parentWizard.getFixedDate(), this.parentWizard.getReferencePoint());
            }
            return this.selectedWizard.getStartingPage();
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        if (!this.initialized) {
            this.initialized = true;
            this.init();
        }
        return super.canFlipToNextPage();
    }

    public boolean isPageComplete() {
        return this.selectedWizardElement != null;
    }

    public IFixedDateWizard getSelectedWizard() {
        return this.selectedWizard;
    }

    private void setSelectedWizardElement(FixedDateWizardRegistry.FixedDateWizardConfigurationElement selectedWizardElement) {
        if (this.selectedWizardElement != selectedWizardElement) {
            this.selectedWizardElement = selectedWizardElement;
            if (selectedWizardElement != null) {
                this.descriptionText.setText(selectedWizardElement.getDescription());
            } else {
                this.descriptionText.setText("");
            }
        }
    }
}

