/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.wizards.scheduleRestricted.defaultimplementation;

import de.aristaflow.adept2.core.timemanager.ScheduleEvaluation;
import de.aristaflow.adept2.core.timemanager.ScheduleManager;
import de.aristaflow.adept2.core.timemanager.ScheduleResolutionException;
import de.aristaflow.adept2.model.common.timedata.CalendarElement;
import de.aristaflow.adept2.model.common.timedata.defaultimplementation.DefaultCalendarElement;
import de.aristaflow.adept2.model.processmodel.timemodel.ScheduleRestrictedElement;
import de.aristaflow.adept2.model.timemodel.Schedule;
import de.aristaflow.adept2.model.timemodel.ScheduleInterval;
import de.aristaflow.adept2.model.timemodel.ScheduleIntervalSet;
import de.aristaflow.adept2.ui.processvisualisation.preferences.CustomCalendarsDialog;
import de.aristaflow.adept2.ui.processvisualisation.timeconstraints.Activator;
import de.aristaflow.adept2.ui.processvisualisation.wizards.scheduleRestricted.defaultimplementation.ScheduleRestrictedWizard;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ScheduleRestrictedWizardSchedulePage
extends WizardPage {
    private ScheduleRestrictedWizard parentWizard;
    private Text schedule;
    private Text scheduleEvaluation;
    private Button btnEvaluate;
    private DateTime untilDate;
    private DateTime fromDate;
    DateFormat format = new SimpleDateFormat("dd.MM.yy HH:mm:ss");

    public ScheduleRestrictedWizardSchedulePage(ScheduleRestrictedWizard parentWizard) {
        super("ScheduleRestrictedWizardSchedulePage");
        this.setTitle("Schedule Restricted Element");
        this.setDescription("Please configure the schedule-based restriction for the activity.");
        this.parentWizard = parentWizard;
        parentWizard.setHelpAvailable(true);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        composite.setLayout((Layout)gl);
        Text description = new Text(composite, 0x2000008);
        description.setText("Type in a restriction");
        description.setLayoutData((Object)new GridData(4, 4, false, false));
        this.schedule = new Text(composite, 33556546);
        GridData gridDataSchedule = new GridData(4, 4, true, false);
        gridDataSchedule.horizontalSpan = 4;
        gridDataSchedule.heightHint = 100;
        this.schedule.setLayoutData((Object)gridDataSchedule);
        this.schedule.setEditable(true);
        this.schedule.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScheduleRestrictedWizardSchedulePage.this.setPageComplete(ScheduleRestrictedWizardSchedulePage.this.validatePageComplete());
            }
        });
        Button btnCustomCalendars = new Button(composite, 0);
        btnCustomCalendars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomCalendarsDialog dialog = new CustomCalendarsDialog(ScheduleRestrictedWizardSchedulePage.this.getShell());
                dialog.init(ScheduleRestrictedWizardSchedulePage.this.getScheduleManager());
                dialog.open();
            }
        });
        btnCustomCalendars.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        btnCustomCalendars.setText("Custom Calendars");
        Group grpEvaluate = new Group(composite, 0);
        grpEvaluate.setLayout((Layout)new GridLayout(6, false));
        grpEvaluate.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpEvaluate.setText("Evaluate");
        this.btnEvaluate = new Button((Composite)grpEvaluate, 0);
        this.btnEvaluate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScheduleRestrictedWizardSchedulePage.this.evaluate();
            }
        });
        this.btnEvaluate.setEnabled(false);
        this.btnEvaluate.setText("Evaluate");
        Label lblRange = new Label((Composite)grpEvaluate, 0);
        GridData gd_lblRange = new GridData(131072, 0x1000000, true, false, 1, 1);
        gd_lblRange.minimumWidth = 60;
        lblRange.setLayoutData((Object)gd_lblRange);
        lblRange.setText("Range:");
        Label lblFrom = new Label((Composite)grpEvaluate, 0);
        lblFrom.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFrom.setText("From");
        this.fromDate = new DateTime((Composite)grpEvaluate, 2052);
        this.fromDate.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        Label lblUntil = new Label((Composite)grpEvaluate, 0);
        lblUntil.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblUntil.setText("Until");
        this.untilDate = new DateTime((Composite)grpEvaluate, 2052);
        this.untilDate.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.scheduleEvaluation = new Text((Composite)grpEvaluate, 2570);
        GridData gd_scheduleEvaluation = new GridData(4, 0x1000000, true, true, 6, 1);
        gd_scheduleEvaluation.heightHint = 80;
        this.scheduleEvaluation.setLayoutData((Object)gd_scheduleEvaluation);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "de.aristaflow.adept2.ui.processvisualisation.timeconstraints.ScheduleRestrictedElement");
        this.init();
    }

    protected ScheduleManager getScheduleManager() {
        return Activator.getTimeManager().getTimeModellingService().getScheduleManager();
    }

    private void init() {
        if (this.parentWizard.getScheduleRestrictedElement() != null) {
            ScheduleRestrictedElement scheduleRestrictedElement = this.parentWizard.getScheduleRestrictedElement();
            String scheduleString = scheduleRestrictedElement.getSchedule();
            if (scheduleString != null) {
                this.schedule.setText(scheduleString);
            } else {
                this.schedule.setText("");
            }
        }
        this.setPageComplete(this.validatePageComplete());
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        this.btnEvaluate.setEnabled(complete);
    }

    public String getSchedule() {
        return this.schedule.getText();
    }

    private boolean validatePageComplete() {
        if (this.schedule.getText().trim().equals("")) {
            this.setErrorMessage("Please provide a valid schedule");
            return false;
        }
        ScheduleEvaluation scheduleEvaluation = Activator.getTimeManager().getTimeModellingService().getScheduleEvaluation();
        try {
            Schedule schedule = scheduleEvaluation.parseSchedule(this.getSchedule());
            DefaultCalendarElement now = this.getCalendarElement(Calendar.getInstance());
            scheduleEvaluation.evaluateSchedule(schedule, (CalendarElement)now, (CalendarElement)now);
        }
        catch (ScheduleResolutionException e) {
            this.setErrorMessage("Invalid Schedule: " + e.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void evaluate() {
        ScheduleIntervalSet evaluatedSchedule;
        Schedule schedule;
        ScheduleEvaluation scheduleEvaluation = Activator.getTimeManager().getTimeModellingService().getScheduleEvaluation();
        try {
            schedule = scheduleEvaluation.parseSchedule(this.getSchedule());
            this.scheduleEvaluation.setText(schedule.toString());
        }
        catch (ScheduleResolutionException e) {
            this.scheduleEvaluation.setText(e.getMessage());
            return;
        }
        try {
            evaluatedSchedule = scheduleEvaluation.evaluateSchedule(schedule, this.getCalendarElement(this.fromDate), this.getCalendarElement(this.untilDate));
        }
        catch (ScheduleResolutionException e) {
            this.scheduleEvaluation.setText(e.getMessage());
            return;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < evaluatedSchedule.getSize()) {
            ScheduleInterval interval = evaluatedSchedule.getInterval(i);
            builder.append("[" + this.toString(interval.getFrom()) + ", " + this.toString(interval.getTo()) + "]");
            builder.append("\n");
            ++i;
        }
        this.scheduleEvaluation.setText(builder.toString());
    }

    private String toString(CalendarElement cal) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(cal.getTimeInMillis());
        return this.format.format(calendar.getTime());
    }

    private CalendarElement getCalendarElement(DateTime datePicker) {
        Calendar calendar = this.getCalendar(datePicker);
        return this.getCalendarElement(calendar);
    }

    private DefaultCalendarElement getCalendarElement(Calendar calendar) {
        return new DefaultCalendarElement(calendar.getTimeInMillis());
    }

    private Calendar getCalendar(DateTime datePicker) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, datePicker.getYear());
        cal.set(2, datePicker.getMonth());
        cal.set(5, datePicker.getDay());
        cal.set(11, datePicker.getHours());
        cal.set(12, datePicker.getMinutes());
        cal.set(13, datePicker.getSeconds());
        return cal;
    }

    public void performHelp() {
        this.getControl().notifyListeners(28, new Event());
    }
}

