grammar Callang6;

options {
    language = Java;
}

@header {
  package de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang;
  import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.expression.*;
  import de.aristaflow.adept2.model.processmodel.timemodel.schedules.lang.script.*;
}

//@lexer::header { 
//  package cal.lang;
//}

calendarScript returns [CalendarScript c]
:
    '{'
    {$c = new CalendarScript();}

    (
        statements
        {$c.addStatement($statements.s);}

    )*
    (
        returnStmt
        {$c.addStatement($returnStmt.r);}
    )? '}'
    EOF
;

statements returns [CalendarStatement s]
:
    assignmentStmt
    {$s = $assignmentStmt.a;}

    | ifStmt
    {$s = $ifStmt.i;}

    | whileStmt
    {$s = $whileStmt.w;}

;

assignmentStmt returns [AssignementStmt a]
:
    {$a = new AssignementStmt();}

    IDENT
    {$a.setIdent(new Ident($IDENT.text));}

    '=' calendarExpression
    {$a.setCalendarExpression($calendarExpression.cExp);
	                    }

    ';'
;

ifStmt returns [IfStmt i]
:
    {$i = new IfStmt();}

    'if' '(' calendarExpression
    {$i.setCondition($calendarExpression.cExp);}

    ')' '{'
    (
        (
            stmt1 = statements
            {$i.getTrueScript().addStatement($stmt1.s);}

        )+
        (
            ret1 = returnStmt
            {$i.getTrueScript().addStatement($ret1.r);}

        )?

    ) '}'
    (
        'else' '{'
        (
            (
                stmt2 = statements
                {$i.getFalseScript().addStatement($stmt2.s);}

            )+
            (
                ret3 = returnStmt
                {$i.getFalseScript().addStatement($ret3.r);}

            )?
        ) '}'
    )?
;

whileStmt returns [WhileStmt w]
:
    {$w = new WhileStmt();}

    (
        'while' '(' calendarExpression
        {$w.setCondition($calendarExpression.cExp);}

        ')'
        (
            '{'
            (
                statements
                {$w.addStatement($statements.s);}

            )+
            (
                returnStmt
                {$w.addStatement($returnStmt.r);}

            )? '}'
        )?
    )
;

returnStmt returns [ReturnStmt r]
:
    'return' '('
    (
        '"' STRING '"'
        {$r = new ReturnString($STRING.text);}

        | returnExpression
        {$r = $returnExpression.rExp;}

    ) ')' ';'
;

returnExpression returns [ReturnExpression rExp]
:
    s1 = calendarExpression
    {$rExp = new ReturnExpression($s1.cExp);}
;

parseCalendarExpression returns [CalendarExpression expression]
:
	cExp = calendarExpression
	{
		$expression = $cExp.cExp;
	}
	EOF
;

calendarExpression returns [CalendarExpression cExp]
:

	(
	unExp = unionExpression
	{
		$cExp = $unExp.cExp;
	}
 	|
 	simpExp = simpleCalendarExpression
 	{
		$cExp = $simpExp.cExp;
	}
	) 
  
;

simpleCalendarExpression returns  [CalendarExpression cExp]
:
	(
		'(' exp = calendarExpression ')'
		{ $cExp = $exp.cExp; }
	)
    | 
    sld = slicingDicingExpression
    {$cExp = $sld.cExp;}
;

unionExpression  returns [CalendarExpression cExp]
:
	first = simpleCalendarExpression 
	    
	    '+'
	      second = calendarExpression  
	      {$cExp = new Union($first.cExp, $second.cExp);}
;

slicingDicingExpression returns [CalendarExpression cExp]
:
	     (
	            slicing
	            { $cExp = $slicing.sl; }
	            |   
		        basic = basicCalendarExpression
		        {$cExp = $basic.cExp;}
		        |
		        complex = dicingExpression
		        {$cExp = $complex.cExp;}
	    )
;

basicCalendarExpression returns [CalendarExpression cExp]
:
    {}
    (
        IDENT
        {   $cExp = new Ident($IDENT.text);  }
        |
        basicCalendar
            {   $cExp = new BasicCalendarExpression($basicCalendar.b);    }
    )
 ;

dicingExpression returns [Dicing cExp]
:
    {$cExp = new Dicing();}

    (
        (
            
            basicCalendarExpression
            {$cExp.setFirstOperand($basicCalendarExpression.cExp);}
            
            |
            
            '('
            op1 = simpleCalendarExpression
        	{$cExp.setSecondOperand($op1.cExp);}
            ')'
            
        )
            
        (
	        strictDicing
		        {$cExp.setStrict(true);
		        	$cExp.setSetop($strictDicing.se);
		        }

        	| 
        	relaxDicing
		        {$cExp.setStrict(false);
		        	$cExp.setSetop($relaxDicing.se);
		        }

    	)

        op2 = simpleCalendarExpression
        {$cExp.setSecondOperand($op2.cExp);}

    )
    
;

//dicing returns [Dicing d]
//:
//    {$d = new Dicing();}
//
//    (
//        strictDicing
//        {$d.setStrict(true);$d.setSetop($strictDicing.se);}
//
//        | relaxDicing
//        {$d.setStrict(false);$d.setSetop($relaxDicing.se);}
//
//    )
//;

strictDicing returns [Setops se]
:
    ':' setops
    {$se = $setops.se;}

    ':'
;

relaxDicing returns [Setops se]
:
    '.' setops
    {$se = $setops.se;}

    '.'
;

setops returns [Setops se]
:
    'during'
    {$se=Setops.during;}

    | 'overlaps'
    {$se=Setops.overlaps;}

    | 'contains'
    {$se=Setops.contains;}

    | 'meets'
    {$se=Setops.meets;}

    |
    (
        '<'
        {$se=Setops.moreThan;}

        (
            '='
            {$se=Setops.moreThanEqual;}

        )?
        | '>'
        {$se=Setops.lessThan;}

        (
            '='
            {$se=Setops.lessThanEqual;}

        )?
    )
;

basicCalendar returns [BasicCalendar b]
:
    SECONDS
    {$b=BasicCalendar.SECONDS;}

    | MINUTES
    {$b=BasicCalendar.MINUTES;}

    | HOURS
    {$b=BasicCalendar.HOURS;}

    | DAYS
    {$b=BasicCalendar.DAYS;}

    | WEEKS
    {$b=BasicCalendar.WEEKS;}

    | MONTHS
    {$b=BasicCalendar.MONTHS;}

    | YEARS
    {$b=BasicCalendar.YEARS;}

;




slicing returns [Slicing sl]
:
    (
        singleSelection
        {$sl = $singleSelection.ssl;}
        
        |
        
        intervalSelection
        {$sl = $intervalSelection.isl;}

        | 
        
        multiSelection
        {$sl = $multiSelection.msl;}

        | 
        
        setSelection
        {$sl = $setSelection.csl;}

    ) '/'
     calExp = calendarExpression
    {$sl.setCalendarExpression($calExp.cExp);}
;

singleSelection returns [SingleSelection ssl]
:
    {$ssl = new SingleSelection();}

    (
        'the'
        {$ssl.setSelectionFunction(SelectionFunctions.the);}

        | 'any'
        {$ssl.setSelectionFunction(SelectionFunctions.any);}

        | integer
        {$ssl.setSelectionFunction($integer.i);}
    )
;

multiSelection returns [MultiSelection msl]
:
    {$msl = new MultiSelection();}

    '[' 'any' integer
    {$msl.setAnyIntFunction($integer.i);}

    ']'
;

intervalSelection returns [IntervalSelection isl]
:
	'[' i1 = integer '-' i2 = integer 
    	{$isl = new IntervalSelection($i1.i, $i2.i);}
   ']'
;

integer returns [int i]
:
	{boolean neg = false;}
	('-' {neg = true;})? INTEGER
	{$i = Integer.parseInt((neg ? "-" : "") + $INTEGER.text);}
;


setSelection returns [SetSelection csl]
:
    {$csl = new SetSelection();}

'['
    (    	
        i = integer
        {$csl.addSelection($i.i);}

    )
    (
        ',' 
        (
            i = integer
            {$csl.addSelection($i.i);}    
        )

    )*
    ']'
;

//STRING
//	:	'"'
//		{ StringBuilder b = new StringBuilder(); }
//		(	'"' '"'				{ b.appendCodePoint('"');}
//		|	c=~('"'|'\r'|'\n')	{ b.appendCodePoint(c);}
//		)*
//		'"'
//		{ setText(b.toString()); }
//	;

SECONDS : [Ss] [Ee] [Cc] [Oo] [Nn] [Dd] [Ss] ;
HOURS : [Hh] [Oo] [Uu] [Rr] [Ss];
MINUTES : [Mm] [Ii] [Nn] [Uu] [Tt] [Ee] [Ss];
DAYS : [Dd] [Aa] [Yy] [Ss] ;
WEEKS : [Ww] [Ee] [Ee] [Kk] [Ss];
MONTHS : [Mm] [Oo] [Nn] [Tt] [Hh] [Ss];
YEARS : [Yy] [Ee] [Aa] [Rr] [Ss];

STRING
:
    '"' ~( '\r' | '\n' | '"' )* '"'
;

MULTILINE_COMMENT
:
    '/*' .*? '*/' -> skip
;

fragment
LETTER
:
    (
        'a' .. 'z'
        | 'A' .. 'Z'
    )
;

fragment
DIGIT
:
    '0' .. '9'
;

fragment A:('a'|'A');
fragment B:('b'|'B');
fragment C:('c'|'C');
fragment D:('d'|'D');
fragment E:('e'|'E');
fragment F:('f'|'F');
fragment G:('g'|'G');
fragment H:('h'|'H');
fragment I:('i'|'I');
fragment J:('j'|'J');
fragment K:('k'|'K');
fragment L:('l'|'L');
fragment M:('m'|'M');
fragment N:('n'|'N');
fragment O:('o'|'O');
fragment P:('p'|'P');
fragment Q:('q'|'Q');
fragment R:('r'|'R');
fragment S:('s'|'S');
fragment T:('t'|'T');
fragment U:('u'|'U');
fragment V:('v'|'V');
fragment W:('w'|'W');
fragment X:('x'|'X');
fragment Y:('y'|'Y');
fragment Z:('z'|'Z');

INTEGER
:
    DIGIT+
;

IDENT
:
    LETTER
    (
        LETTER
        | DIGIT
    )*
;

WS
:
    (
        ' '
        | '\t'
        | '\n'
        | '\r'
        | '\f'
    )+ -> skip
;

COMMENT
:
    '//' .*?
    (
        '\n'
        | '\r'
    ) -> skip
;
