-- some columns are suffixed with _ to prevent collisions with reserved words
-- ID_ is an internally used ID


{createSeq "AR_RevisionNo" start=1};
{createSeq "AR_BranchNo" start=1};

{createSeq "AR_EcdID" start=1};
{createSeq "AR_OpID" start=1};
{createSeq "AR_CsID" start=1};
{createSeq "AR_AtdID" start=1};

{createSeq "AR_IconID" start=1};


CREATE TABLE AR_Revisions
(
  revisionNo                  {type BIGINT} NOT NULL,

  timestamp_                  {type BIGINT} NOT NULL,
  agentID                     {type BIGINT} NOT NULL,
  agentUserName               {type VARCHAR(30)} NOT NULL,
  agentOrgposID               {type BIGINT} NOT NULL,
  agentOrgposName             {type VARCHAR(250)} NOT NULL,

  comment_                    {type LONGVARCHAR},


  PRIMARY KEY (revisionNo)
);

INSERT INTO AR_Revisions
  VALUES (0, 0, -2, 'system', -2, 'system', 'initial empty state of the activity repository');


CREATE TABLE AR_Branches
(
  branchNo                    {type BIGINT} NOT NULL,
  baseRevision                {type BIGINT} NOT NULL,

  creationTime                {type BIGINT} NOT NULL,
  creationAgentID             {type BIGINT} NOT NULL,
  creationAgentUserName       {type VARCHAR(30)} NOT NULL,
  creationAgentOrgposID       {type BIGINT} NOT NULL,
  creationAgentOrgposName     {type VARCHAR(250)} NOT NULL,

  modificationTime            {type BIGINT} NOT NULL,
  modificationAgentID         {type BIGINT} NOT NULL,
  modificationAgentUserName   {type VARCHAR(30)} NOT NULL,
  modificationAgentOrgposID   {type BIGINT} NOT NULL,
  modificationAgentOrgposName {type VARCHAR(250)} NOT NULL,

  comment_                    {type LONGVARCHAR},


  PRIMARY KEY (branchNo),
  FOREIGN KEY (baseRevision) REFERENCES AR_Revisions(revisionNo)
);


CREATE TABLE AR_Identifiers
(
  id_hi                       {type BIGINT} NOT NULL,
  id_lo                       {type BIGINT} NOT NULL,
  name                        {type VARCHAR(254)} NOT NULL,
  description                 {type LONGVARCHAR},

  revision                    {type BIGINT} NOT NULL,
  branch                      {type BIGINT},
  state                       {type TINYINT} NOT NULL,

  pluginData                  {type BLOB},
  userAttributes              {type BLOB},


--  UNIQUE (id_hi, id_lo, branch),             DB2 does not support UNIQUE on columns without NOT NULL
--  UNIQUE (id_hi, id_lo, revision, branch),
--  UNIQUE(name, branch),
--  UNIQUE(name, revision, branch),
  FOREIGN KEY (revision)
    REFERENCES AR_Revisions(revisionNo),
  FOREIGN KEY (branch)
    REFERENCES AR_Branches(branchNo) ON DELETE CASCADE
);


CREATE TABLE AR_ECDs
(
  ID_                         {type BIGINT} NOT NULL,

  name                        {type VARCHAR(254)} NOT NULL,
  devDescription              {type LONGVARCHAR},

  revision                    {type BIGINT} NOT NULL,
  branch                      {type BIGINT},
  state                       {type TINYINT} NOT NULL,

  implementationClass         {type VARCHAR(254)},
  classPath                   {type LONGVARCHAR},
  isSingleton                 {type BOOLEAN} NOT NULL,
  sysCompSignature            {type LONGVARBINARY},
  guiContextID                {type VARCHAR(254)} NOT NULL,
  executionControlProperties  {type TINYINT} NOT NULL,

  iconID_hi                   {type BIGINT},
  iconID_lo                   {type BIGINT},
  licence                     {type LONGVARCHAR},

  configurationDescription    {type BLOB},

  pluginData                  {type BLOB},
  userAttributes              {type BLOB},


  PRIMARY KEY (ID_),
--  UNIQUE (name, revision, branch),
  FOREIGN KEY (revision)
    REFERENCES AR_Revisions(revisionNo),
  FOREIGN KEY (branch)
    REFERENCES AR_Branches(branchNo) ON DELETE CASCADE
);

CREATE TABLE AR_Operations
(
  ID_                         {type BIGINT} NOT NULL,

  ecName                      {type VARCHAR(254)} NOT NULL,

  name                        {type VARCHAR(254)} NOT NULL,
  description                 {type LONGVARCHAR},
  devDescription              {type LONGVARCHAR},

  revision                    {type BIGINT} NOT NULL,
  branch                      {type BIGINT},
  state                       {type TINYINT} NOT NULL,

  implementationClass         {type VARCHAR(254)},
  classPath                   {type LONGVARCHAR},
  isSingleton                 {type BOOLEAN},
  sysCompSignature            {type LONGVARBINARY},
  guiContextID                {type VARCHAR(254)},
  executionControlProperties  {type TINYINT},

  supportsViewOnly            {type BOOLEAN} NOT NULL,
  supportsTestExecution       {type BOOLEAN} NOT NULL,

  iconID_hi                   {type BIGINT},
  iconID_lo                   {type BIGINT},
  licence                     {type LONGVARCHAR},

  configurationDescription    {type BLOB},
  configuration               {type BLOB},
  testConfiguration           {type BLOB},

  parameterChangePolicy       {type TINYINT},

  staffAssignmentRule         {type LONGVARCHAR},

  pluginData                  {type BLOB},
  userAttributes              {type BLOB},


  PRIMARY KEY (ID_),
--  UNIQUE (ecName, name, revision, branch),
  FOREIGN KEY (revision)
    REFERENCES AR_Revisions(revisionNo),
  FOREIGN KEY (branch)
    REFERENCES AR_Branches(branchNo) ON DELETE CASCADE
);


CREATE TABLE AR_CSs
(
  ID_                         {type BIGINT} NOT NULL,

  name                        {type VARCHAR(254)} NOT NULL,
  devDescription              {type LONGVARCHAR},

  revision                    {type BIGINT} NOT NULL,
  branch                      {type BIGINT},
  state                       {type TINYINT} NOT NULL,

  pluginData                  {type BLOB},
  userAttributes              {type BLOB},


  PRIMARY KEY (ID_),
--  UNIQUE (name, revision, branch),
  FOREIGN KEY (revision)
    REFERENCES AR_Revisions(revisionNo),
  FOREIGN KEY (branch)
    REFERENCES AR_Branches(branchNo) ON DELETE CASCADE
);
CREATE TABLE AR_CSs_Entries
(
  csID                        {type BIGINT} NOT NULL,
  ecName                      {type VARCHAR(254)},
  opName                      {type VARCHAR(254)},

  configurationDescription    {type BLOB},
  configuration               {type BLOB},
  testConfiguration           {type BLOB},

  staffAssignmentRule         {type LONGVARCHAR},


--  UNIQUE (csID, ecName, opName),
  FOREIGN KEY (csID) REFERENCES AR_CSs(ID_) ON DELETE CASCADE
);


CREATE TABLE AR_ATDs
(
  ID_                         {type BIGINT} NOT NULL,

  ecName                      {type VARCHAR(254)} NOT NULL,
  opName                      {type VARCHAR(254)} NOT NULL,

  configurationSetName        {type VARCHAR(254)},

  id_hi                       {type BIGINT} NOT NULL,
  id_lo                       {type BIGINT} NOT NULL,

  name                        {type VARCHAR(254)} NOT NULL,
  description                 {type LONGVARCHAR},
  devDescription              {type LONGVARCHAR},

  revision                    {type BIGINT} NOT NULL,
  branch                      {type BIGINT},
  state                       {type TINYINT} NOT NULL,

  implementationClass         {type VARCHAR(254)},
  classPath                   {type LONGVARCHAR},
  isSingleton                 {type BOOLEAN},
  sysCompSignature            {type LONGVARBINARY},
  guiContextID                {type VARCHAR(254)},
  executionControlProperties  {type TINYINT},

  supportsViewOnly            {type BOOLEAN},
  supportsTestExecution       {type BOOLEAN},

  iconID_hi                   {type BIGINT},
  iconID_lo                   {type BIGINT},
  licence                     {type LONGVARCHAR},

  configurationDescription    {type BLOB},
  configuration               {type BLOB},
  testConfiguration           {type BLOB},

  parameterChangePolicy       {type TINYINT},

  staffAssignmentRule         {type LONGVARCHAR},

  pluginData                  {type BLOB},
  userAttributes              {type BLOB},


  PRIMARY KEY (ID_),
--  UNIQUE (ecName, opName, name, revision, branch),

  UNIQUE (id_hi, id_lo),

  FOREIGN KEY (revision)
    REFERENCES AR_Revisions(revisionNo),
  FOREIGN KEY (branch)
    REFERENCES AR_Branches(branchNo) ON DELETE CASCADE
);



CREATE TABLE AR_Parameters
(
  opID                        {type BIGINT},
  atdID                       {type BIGINT},

  accessType                  {type BIT} NOT NULL,
  name                        {type VARCHAR(254)} NOT NULL,

  removed                     {type BOOLEAN} NOT NULL,

  description                 {type LONGVARCHAR},
  devDescription              {type LONGVARCHAR},

  dataType                    {type TINYINT},
  udtName                     {type VARCHAR(254)},
  identifierID_hi             {type BIGINT},
  identifierID_lo             {type BIGINT},

  isOptional                  {type BOOLEAN},
  isVirtual                   {type BOOLEAN},
  isFailure                   {type BOOLEAN},

  defaultValue                {type LONGVARCHAR},

  configurationDescription    {type BLOB},
  configuration               {type BLOB},

  pluginData                  {type BLOB},
  userAttributes              {type BLOB}


--  UNIQUE (opID, atdID, accessType, name),
--  FOREIGN KEY (opID) REFERENCES AR_Operations(ID_) ON DELETE CASCADE,    MSSQL would only allow one of them but not both
--  FOREIGN KEY (atdID) REFERENCES AR_ATDs(ID_) ON DELETE CASCADE
  -- ,
  -- FOREIGN KEY (identifierID_hi, identifierID_lo)
  -- REFERENCES AR_Identifiers(id_hi, id_lo)
);

CREATE TABLE AR_ParameterTemplates
(
  ecdID                       {type BIGINT},
  opID                        {type BIGINT},

  csID                        {type BIGINT},
  csECName                    {type VARCHAR(254)},
  csOpName                    {type VARCHAR(254)},

  atdID                       {type BIGINT},


  templateName                {type VARCHAR(254)} NOT NULL,

  removed                     {type BOOLEAN} NOT NULL,

  templateDescription         {type LONGVARCHAR},
  accessType                  {type BIT},
  name                        {type VARCHAR(254)},
  description                 {type LONGVARCHAR},

  dataType                    {type TINYINT},
  udtName                     {type VARCHAR(254)},
  identifierID_hi             {type BIGINT},
  identifierID_lo             {type BIGINT},

  isOptional                  {type BOOLEAN},
  isVirtual                   {type BOOLEAN},
  isFailure                   {type BOOLEAN},

  defaultValue                {type LONGVARCHAR},

  configurationDescription    {type BLOB},
  configuration               {type BLOB},

  pluginData                  {type BLOB},
  userAttributes              {type BLOB}


--  UNIQUE (ecdID, opID, csID, csECName, csOpName, atdID, templateName),
--  FOREIGN KEY (ecdID) REFERENCES AR_ECDs(ID_) ON DELETE CASCADE,
--  FOREIGN KEY (opID) REFERENCES AR_Operations(ID_) ON DELETE CASCADE,
--  FOREIGN KEY (csID) REFERENCES AR_CSs(ID_) ON DELETE CASCADE,
--  FOREIGN KEY (csID, csECName, csOpName) REFERENCES AR_CSs_Entries(csID, ecName, opName) ON DELETE CASCADE,
--  FOREIGN KEY (atdID) REFERENCES AR_ATDs(ID_) ON DELETE CASCADE
  -- ,
  -- FOREIGN KEY (identifierID_hi, identifierID_lo)
  --  REFERENCES AR_Identifiers(id_hi, id_lo)
);


CREATE TABLE AR_Icons
(
  -- internal ID
  ID_                         {type BIGINT} NOT NULL,

  id_hi                       {type BIGINT} NOT NULL,
  id_lo                       {type BIGINT} NOT NULL,
  name                        {type VARCHAR(254)} NOT NULL,
  description                 {type LONGVARCHAR},

  revision                    {type BIGINT} NOT NULL,
  branch                      {type BIGINT},
  state                       {type TINYINT} NOT NULL,

  pluginData                  {type BLOB},
  userAttributes              {type BLOB},


  PRIMARY KEY (ID_),

--  UNIQUE (id_hi, id_lo, branch),
--  UNIQUE (id_hi, id_lo, revision, branch),
  FOREIGN KEY (revision)
    REFERENCES AR_Revisions(revisionNo),
  FOREIGN KEY (branch)
    REFERENCES AR_Branches(branchNo) ON DELETE CASCADE
);
CREATE TABLE AR_Icons_Data
(
  iconID                      {type BIGINT} NOT NULL,

  width                       {type INTEGER} NOT NULL,
  height                      {type INTEGER} NOT NULL,

  data                        {type BLOB} NOT NULL,


  FOREIGN KEY (iconID)
    REFERENCES AR_Icons(ID_) ON DELETE CASCADE
);


CREATE TABLE AR_Resources
(
  id_hi                       {type BIGINT} NOT NULL,
  id_lo                       {type BIGINT} NOT NULL,
  name                        {type VARCHAR(254)} NOT NULL,
  description                 {type LONGVARCHAR},

  data                        {type BLOB} NOT NULL,

  revision                    {type BIGINT} NOT NULL,
  branch                      {type BIGINT},
  state                       {type TINYINT} NOT NULL,

  pluginData                  {type BLOB},
  userAttributes              {type BLOB},


--  UNIQUE (id_hi, id_lo, branch),
--  UNIQUE (id_hi, id_lo, revision, branch),
  FOREIGN KEY (revision)
    REFERENCES AR_Revisions(revisionNo),
  FOREIGN KEY (branch)
    REFERENCES AR_Branches(branchNo) ON DELETE CASCADE

);