-- create tables for the dataManager archive

-- isNull is reserved in PostgreSQL -> isNull_

CREATE TABLE dataElementsArchive
(
  instanceID_hi {type BIGINT} NOT NULL,
  instanceID_lo {type BIGINT} NOT NULL,
  dataElementID {type INTEGER} NOT NULL,
  type {type VARCHAR(256)} NOT NULL,
  isNull_ {type BIT},
  latestNull {type SMALLINT},
  latestBooleanValue {type SMALLINT},
  latestIntegerValue {type BIGINT},
  latestFloatValue {type DOUBLE},
  latestStringValue {type LONGVARCHAR},
  latestBLOBvalue {type BLOB},
  externalNull {type SMALLINT},
  externalBooleanValue {type SMALLINT},
  externalIntegerValue {type BIGINT},
  externalFloatValue {type DOUBLE},
  externalStringValue {type LONGVARCHAR},
  externalBLOBvalue {type BLOB},

  PRIMARY KEY (instanceID_hi, instanceID_lo, dataElementID)
);

CREATE TABLE dataValuesArchive
(
  instanceID_hi {type BIGINT} NOT NULL,
  instanceID_lo {type BIGINT} NOT NULL,
  dataElementID {type INTEGER} NOT NULL,
  nodeID {type INTEGER} NOT NULL,
  iteration {type INTEGER} NOT NULL,
  createTime {type TIMESTAMP} NOT NULL,
  agent {type BIGINT} NOT NULL,
  orgPosition {type BIGINT} NOT NULL,
  valid {type BIT} DEFAULT 0 NOT NULL,
  isNull_ {type BIT} DEFAULT 0 NOT NULL,
  BooleanValue {type SMALLINT},
  IntegerValue {type BIGINT},
  FloatValue {type DOUBLE},
  StringValue {type LONGVARCHAR},
  BLOBvalue {type BLOB},
  
  PRIMARY KEY (instanceID_hi, instanceID_lo, dataElementID, nodeID, iteration),
  FOREIGN KEY (instanceID_hi, instanceID_lo, dataElementID)
      REFERENCES dataElementsArchive (instanceID_hi, instanceID_lo, dataElementID) ON DELETE CASCADE

);

CREATE TABLE externalDataValuesArchive
(
  instanceID_hi {type BIGINT} NOT NULL,
  instanceID_lo {type BIGINT} NOT NULL,
  dataElementID {type INTEGER} NOT NULL,
  createTime {type TIMESTAMP} NOT NULL,
  agent {type BIGINT} NOT NULL,
  orgPosition {type BIGINT} NOT NULL,
  isNull_ {type BIT} DEFAULT 0 NOT NULL,
  BooleanValue {type SMALLINT},
  IntegerValue {type BIGINT},
  FloatValue {type DOUBLE},
  StringValue {type LONGVARCHAR},
  BLOBvalue {type BLOB},
  
  PRIMARY KEY (instanceID_hi, instanceID_lo, dataElementID, createTime),
  FOREIGN KEY (instanceID_hi, instanceID_lo, dataElementID)
		  REFERENCES dataElementsArchive (instanceID_hi, instanceID_lo, dataElementID) ON DELETE CASCADE
);
