-- create tables for the dataManager

-- isNull is reserved in PostgreSQL -> isNull_

CREATE TABLE instanceIDMapping
(
  instanceID_hi {type BIGINT} NOT NULL,
  instanceID_lo {type BIGINT} NOT NULL,
  instanceLogID_hi {type BIGINT} NOT NULL,
  instanceLogID_lo {type BIGINT} NOT NULL
);

CREATE TABLE dataTypes
(
  dataType {type VARCHAR(256)} NOT NULL,
  isUserDefined {type SMALLINT},

  PRIMARY KEY(dataType)
);

CREATE TABLE dataElements
(
  instanceID_hi {type BIGINT} NOT NULL,
  instanceID_lo {type BIGINT} NOT NULL,
  dataElementID {type INTEGER} NOT NULL,
  type {type VARCHAR(256)} NOT NULL,

  PRIMARY KEY(instanceID_hi, instanceID_lo, dataElementID)
--  , FOREIGN KEY(type) REFERENCES dataTypes(dataType)
);

CREATE TABLE dataValues
(
  instanceID_hi {type BIGINT} NOT NULL,
  instanceID_lo {type BIGINT} NOT NULL,
  dataElementID {type INTEGER} NOT NULL,
  nodeID {type INTEGER} NOT NULL,
  iteration {type INTEGER} NOT NULL,
  createTime {type TIMESTAMP} NOT NULL,
  agent {type BIGINT} NOT NULL,
  orgPosition {type BIGINT} NOT NULL,
  valid {type BIT} DEFAULT 0 NOT NULL,
  isNull_ {type BOOLEAN} DEFAULT {false} NOT NULL,
  BooleanValue {type BOOLEAN},
  IntegerValue {type BIGINT},
  FloatValue {type DOUBLE},
  StringValue {type CLOB},
  BLOBvalue {type BLOB},
  
  PRIMARY KEY (instanceID_hi, instanceID_lo, dataElementID, nodeID, iteration)
--  ,
--  FOREIGN KEY (instanceId, dataElementId) REFERENCES 
--	     	   dataElements (instanceId,dataElementId) ON DELETE CASCADE
);

CREATE TABLE externalDataValues
(
  instanceID_hi {type BIGINT} NOT NULL,
  instanceID_lo {type BIGINT} NOT NULL,
  dataElementID {type INTEGER} NOT NULL,
  createTime {type TIMESTAMP} NOT NULL,
  agent {type BIGINT} NOT NULL,
  orgPosition {type BIGINT} NOT NULL,
  isNull_ {type BOOLEAN} DEFAULT {false} NOT NULL,
  BooleanValue {type BOOLEAN},
  IntegerValue {type BIGINT},
  FloatValue {type DOUBLE},
  StringValue {type LONGVARCHAR},
  BLOBvalue {type BLOB},
  
  PRIMARY KEY (instanceID_hi, instanceID_lo, dataElementID, createTime),
  FOREIGN KEY (instanceID_hi, instanceID_lo, dataElementID) 
		  REFERENCES dataElements (instanceID_hi, instanceID_lo, dataElementID) ON DELETE CASCADE
);

CREATE TABLE savepoints
(
  savepointID {type INTEGER} NOT NULL,
  instanceID_hi {type BIGINT} NOT NULL,
  instanceID_lo {type BIGINT} NOT NULL,
  nodeID {type INTEGER} NOT NULL,
  iteration {type INTEGER} NOT NULL,
  createTime {type TIMESTAMP} NOT NULL,
  sessionState {type BLOB},
  agent {type BIGINT} NOT NULL,
  orgPosition {type BIGINT} NOT NULL,
  
  PRIMARY KEY (savepointID, instanceID_hi, instanceID_lo, nodeID, iteration)
);

CREATE TABLE instanceDataContainers
(
  instanceID_hi {type BIGINT} NOT NULL,
  instanceID_lo {type BIGINT} NOT NULL,
  dataContainer {type BLOB} NOT NULL,
  
  PRIMARY KEY (instanceID_hi, instanceID_lo)
);

CREATE TABLE userDefinedFunctions
(
  userDefinedType {type VARCHAR(256)} NOT NULL,
  functionName {type VARCHAR(256)} NOT NULL,
  returnType {type VARCHAR(256)},
  body {type CLOB} NOT NULL,
  language {type VARCHAR(100)} NOT NULL,
  
  PRIMARY KEY (userDefinedType, functionName)
--  , FOREIGN KEY (userDefinedType) REFERENCES dataTypes(dataType) ON DELETE CASCADE
);
