
{createSeq "AgentID" start=20};
{createSeq "OrgPositionID" start=20};
{createSeq "OrgUnitID" start=20};
{createSeq "OrgGroupID" start=20};
{createSeq "ProjectGroupID" start=20};
{createSeq "AbilityID" start=20};
{createSeq "RoleID" start=20};
{createSeq "SubstitutionRuleID" start=20};

-- create all entity types

CREATE TABLE Agent (
  id {type BIGINT} NOT NULL,
  userName {type VARCHAR(30)} NOT NULL,
  password {type VARCHAR(40)} NOT NULL,
  locale {type VARCHAR(50)},
  email {type VARCHAR(100)},

  PRIMARY KEY(id),
  UNIQUE(userName)
);

CREATE TABLE OrgPosition (
  id {type BIGINT} NOT NULL,
  name {type VARCHAR(250)},
  orgUnitId {type BIGINT},

  PRIMARY KEY(id)
);

CREATE TABLE OrgUnit (
  id {type BIGINT} NOT NULL,
  supId {type BIGINT},
  managerId {type BIGINT},

  PRIMARY KEY (id),
--  FOREIGN KEY (supId) REFERENCES OrgUnit(id) ON DELETE CASCADE,  doesn't work with SQL Server 2005
  FOREIGN KEY (supId) REFERENCES OrgUnit(id),
  FOREIGN KEY (managerId) REFERENCES OrgPosition(id) ON DELETE SET NULL
);
ALTER TABLE OrgPosition
  ADD CONSTRAINT orgUnitId_FK FOREIGN KEY (orgUnitId) REFERENCES OrgUnit(id) ON DELETE SET NULL;


CREATE TABLE OrgGroup (
  id {type BIGINT} NOT NULL,
  managerId {type BIGINT},

  PRIMARY KEY (id),
  FOREIGN KEY (managerId) REFERENCES OrgPosition(id) ON DELETE SET NULL
);
CREATE TABLE ProjectGroup (
  id {type BIGINT} NOT NULL,
  supId {type BIGINT},
  managerId {type BIGINT},

  PRIMARY KEY (id),
--  FOREIGN KEY (supId) REFERENCES ProjectGroup(id) ON DELETE CASCADE,  doesn't work with SQL Server 2005
  FOREIGN KEY (supId) REFERENCES ProjectGroup(id),
  FOREIGN KEY (managerId) REFERENCES OrgPosition(id) ON DELETE SET NULL
);


CREATE TABLE Ability (
  id {type BIGINT} NOT NULL,

  PRIMARY KEY (id)
);

CREATE TABLE Role (
  id {type BIGINT} NOT NULL,
  supId {type BIGINT},

  PRIMARY KEY (id),
--  FOREIGN KEY (supId) REFERENCES Role(id) ON DELETE CASCADE  doesn't work with SQL Server 2005
  FOREIGN KEY (supId) REFERENCES Role(id)
);


CREATE TABLE SubstitutionRule (
  id {type BIGINT} NOT NULL,
  orgPositionId {type BIGINT},
  substituteId {type BIGINT},
  roleId {type BIGINT},

  PRIMARY KEY (id),
--  FOREIGN KEY (orgPositionId) REFERENCES OrgPosition(id) ON DELETE CASCADE,  doesn't work with SQL Server 2005
 -- FOREIGN KEY (substituteId) REFERENCES OrgPosition(id) ON DELETE CASCADE,
  FOREIGN KEY (orgPositionId) REFERENCES OrgPosition(id),
  FOREIGN KEY (substituteId) REFERENCES OrgPosition(id),
  FOREIGN KEY (roleId) REFERENCES Role(id) ON DELETE CASCADE
);



-- create all n:m relation types

CREATE TABLE OrgPositionOccupation (
  orgPositionId {type BIGINT} NOT NULL,
  agentId {type BIGINT} NOT NULL,

  UNIQUE (orgPositionId, agentId),
  FOREIGN KEY (orgPositionId) REFERENCES OrgPosition(id) ON DELETE CASCADE,
  FOREIGN KEY (agentId) REFERENCES Agent(id) ON DELETE CASCADE
);

CREATE TABLE OrgPositionDescription (
  orgPositionId {type BIGINT} NOT NULL,
  roleId {type BIGINT} NOT NULL,

  UNIQUE (orgPositionId, roleId),
  FOREIGN KEY (orgPositionId) REFERENCES OrgPosition(id) ON DELETE CASCADE,
  FOREIGN KEY (roleId) REFERENCES Role(id) ON DELETE CASCADE
);

CREATE TABLE OrgGroupInvolvement (
  orgGroupId {type BIGINT} NOT NULL,
  orgUnitId {type BIGINT} NOT NULL,

  UNIQUE (orgGroupId, orgUnitId),
  FOREIGN KEY (orgGroupId) REFERENCES OrgGroup(id) ON DELETE CASCADE,
  FOREIGN KEY (orgUnitId) REFERENCES OrgUnit(id) ON DELETE CASCADE
);

CREATE TABLE ProjectInvolvementOrgPosition (
  projectGroupId {type BIGINT} NOT NULL,
  orgPositionId {type BIGINT} NOT NULL,

  UNIQUE (projectGroupId, orgPositionId),
  FOREIGN KEY (projectGroupId) REFERENCES ProjectGroup(id) ON DELETE CASCADE,
  FOREIGN KEY (orgPositionId) REFERENCES OrgPosition(id) ON DELETE CASCADE
);

CREATE TABLE ProjectInvolvementOrgUnit (
  projectGroupId {type BIGINT} NOT NULL,
  orgUnitId {type BIGINT} NOT NULL,
  UNIQUE (projectGroupId, orgUnitId),
  FOREIGN KEY (projectGroupId) REFERENCES ProjectGroup(id) ON DELETE CASCADE,
  FOREIGN KEY (orgUnitId) REFERENCES OrgUnit(id) ON DELETE CASCADE
);


CREATE TABLE AgentAbility (
  agentId {type BIGINT} NOT NULL,
  abilityId {type BIGINT} NOT NULL,

  UNIQUE (agentId, abilityId),
  FOREIGN KEY (agentId) REFERENCES Agent(id) ON DELETE CASCADE,
  FOREIGN KEY (abilityId) REFERENCES Ability(id) ON DELETE CASCADE
);

CREATE TABLE RoleDescription (
  roleId {type BIGINT} NOT NULL,
  abilityId {type BIGINT} NOT NULL,

  UNIQUE (roleId, abilityId),
  FOREIGN KEY (roleId) REFERENCES Role(id) ON DELETE CASCADE,
  FOREIGN KEY (abilityId) REFERENCES Ability(id) ON DELETE CASCADE
);



-- create the attribute meta tables that store information about attributes
CREATE TABLE AgentMeta (
  attrName {type VARCHAR(50)} NOT NULL,
  dataType {type VARCHAR(20)} NOT NULL,
  sizeHint {type INTEGER},

  mappedTo {type VARCHAR(254)},
  imported {type BOOLEAN},
  readOnly {type BOOLEAN},

  PRIMARY KEY(attrName)
);
INSERT INTO AgentMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('id', 'INTEGER', null, {false}, {true});
INSERT INTO AgentMeta (attrName, dataType, sizeHint, mappedTo, imported, readOnly)
  VALUES ('userName', 'STRING', 30, 'uid', {true}, {false});
INSERT INTO AgentMeta (attrName, dataType, sizeHint, mappedTo, imported, readOnly)
  VALUES ('password', 'STRING', 40, null, {false}, {false});
INSERT INTO AgentMeta (attrName, dataType, sizeHint, mappedTo, imported, readOnly)
  VALUES ('locale', 'STRING', 50, null, {false}, {false});
INSERT INTO AgentMeta (attrName, dataType, sizeHint, mappedTo, imported, readOnly)
  VALUES ('email', 'STRING', 100, 'mail', {true}, {false});


CREATE TABLE OrgPositionMeta (
  attrName {type VARCHAR(50)} NOT NULL,
  dataType {type VARCHAR(20)} NOT NULL,
  sizeHint {type INTEGER},

  mappedTo {type VARCHAR(254)},
  imported {type BOOLEAN},
  readOnly {type BOOLEAN},

  PRIMARY KEY(attrName)
);
INSERT INTO OrgPositionMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('id', 'INTEGER', null, {false}, {true});
INSERT INTO OrgPositionMeta (attrName, dataType, sizeHint, mappedTo, imported, readOnly)
  VALUES ('name', 'STRING', 250, null, {false}, {false});
INSERT INTO OrgPositionMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('orgUnitId', 'INTEGER', null, {false}, {true});

CREATE TABLE OrgUnitMeta (
  attrName {type VARCHAR(50)} NOT NULL,
  dataType {type VARCHAR(20)} NOT NULL,
  sizeHint {type INTEGER},

  mappedTo {type VARCHAR(254)},
  imported {type BOOLEAN},
  readOnly {type BOOLEAN},

  PRIMARY KEY(attrName)
);
INSERT INTO OrgUnitMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('id', 'INTEGER', null, {false}, {true});
INSERT INTO OrgUnitMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('supId', 'INTEGER', null, {false}, {true});
INSERT INTO OrgUnitMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('managerId', 'INTEGER', null, {false}, {true});

CREATE TABLE OrgGroupMeta (
  attrName {type VARCHAR(50)} NOT NULL,
  dataType {type VARCHAR(20)} NOT NULL,
  sizeHint {type INTEGER},

  mappedTo {type VARCHAR(254)},
  imported {type BOOLEAN},
  readOnly {type BOOLEAN},

  PRIMARY KEY(attrName)
);
INSERT INTO OrgGroupMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('id', 'INTEGER', null, {false}, {true});
INSERT INTO OrgGroupMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('managerId', 'INTEGER', null, {false}, {true});

CREATE TABLE ProjectGroupMeta (
  attrName {type VARCHAR(50)} NOT NULL,
  dataType {type VARCHAR(20)} NOT NULL,
  sizeHint {type INTEGER},

  mappedTo {type VARCHAR(254)},
  imported {type BOOLEAN},
  readOnly {type BOOLEAN},

  PRIMARY KEY(attrName)
);
INSERT INTO ProjectGroupMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('id', 'INTEGER', null, {false}, {true});
INSERT INTO ProjectGroupMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('supId', 'INTEGER', null, {false}, {true});
INSERT INTO ProjectGroupMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('managerId', 'INTEGER', null, {false}, {true});


CREATE TABLE AbilityMeta (
  attrName {type VARCHAR(50)} NOT NULL,
  dataType {type VARCHAR(20)} NOT NULL,
  sizeHint {type INTEGER},

  mappedTo {type VARCHAR(254)},
  imported {type BOOLEAN},
  readOnly {type BOOLEAN},

  PRIMARY KEY(attrName)
);
INSERT INTO AbilityMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('id', 'INTEGER', null, {false}, {true});

CREATE TABLE RoleMeta (
  attrName {type VARCHAR(50)} NOT NULL,
  dataType {type VARCHAR(20)} NOT NULL,
  sizeHint {type INTEGER},

  mappedTo {type VARCHAR(254)},
  imported {type BOOLEAN},
  readOnly {type BOOLEAN},

  PRIMARY KEY(attrName)
);
INSERT INTO RoleMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('id', 'INTEGER', null, {false}, {true});
INSERT INTO RoleMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('supId', 'INTEGER', null, {false}, {true});


CREATE TABLE SubstitutionRuleMeta (
  attrName {type VARCHAR(50)} NOT NULL,
  dataType {type VARCHAR(20)} NOT NULL,
  sizeHint {type INTEGER},

  mappedTo {type VARCHAR(254)},
  imported {type BOOLEAN},
  readOnly {type BOOLEAN},

  PRIMARY KEY(attrName)
);
INSERT INTO SubstitutionRuleMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('id', 'INTEGER', null, {false}, {true});
INSERT INTO SubstitutionRuleMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('orgPositionId', 'INTEGER', null, {false}, {true});
INSERT INTO SubstitutionRuleMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('substituteId', 'INTEGER', null, {false}, {true});
INSERT INTO SubstitutionRuleMeta (attrName, dataType, mappedTo, imported, readOnly)
  VALUES ('roleId', 'INTEGER', null, {false}, {true});







INSERT INTO Agent (id, userName, password)
  VALUES (-2, 'system', '6d9b86250eb52ddf95d8d5c831011495640e3cd0');
INSERT INTO Agent (id, userName, password)
  VALUES (-1, 'supervisor', '6d9b86250eb52ddf95d8d5c831011495640e3cd0');

INSERT INTO OrgPosition (id, name)
  VALUES (-2, 'system');
INSERT INTO OrgPosition (id, name)  
  VALUES (-1, 'supervisor');
INSERT INTO OrgPosition (id, name)  
  VALUES (-3, 'Global Worklist');
INSERT INTO OrgPosition (id, name)  
  VALUES (-4, 'Global Fallback Worklist');

INSERT INTO OrgPositionOccupation (orgPositionId, agentId)
  VALUES (-2, -2);
INSERT INTO OrgPositionOccupation (orgPositionId, agentId)
  VALUES (-1, -1);
INSERT INTO OrgPositionOccupation (orgPositionId, agentId)
  VALUES (-3, -1);
INSERT INTO OrgPositionOccupation (orgPositionId, agentId)
  VALUES (-4, -1);

INSERT INTO Role (id) VALUES (-1);
INSERT INTO Role (id) VALUES (-2);
INSERT INTO Role (id) VALUES (-3);
INSERT INTO Role (id) VALUES (-4);

INSERT INTO OrgPositionDescription (orgPositionId, roleId)
  VALUES (-1, -1);
INSERT INTO OrgPositionDescription (orgPositionId, roleId)
  VALUES (-2, -2);
