--
-- Template
--

CREATE TABLE PMTemplate (
	IDHigh {type BIGINT} NOT NULL,
	IDLow {type BIGINT} NOT NULL,
	Description {type VARCHAR(2000)},
	InstanceNameTemplate {type VARCHAR(200)},
	Name {type VARCHAR(200)},
	ProcessType {type VARCHAR(200)},
	SupervisorAgentID {type BIGINT},
	SupervisorAgentName {type VARCHAR(30)},
	SupervisorOrgPosID {type BIGINT},
	SupervisorOrgPosName {type VARCHAR(250)},
	Version {type VARCHAR(200)},
	StartNodeID {type INTEGER}, 
	EndNodeID {type INTEGER}, 
	
	PRIMARY KEY(IDHigh, IDLow)
);


--
-- Node
--

CREATE TABLE PMNode (
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	ID {type INTEGER} NOT NULL,
	IconIDHigh {type BIGINT},
	IconIDLow {type BIGINT},
	IsAutoStart {type BOOLEAN},
	BranchID {type INTEGER},
	CorrespondingBlockNodeID {type INTEGER},
	Description {type VARCHAR(2000)},
	Name {type VARCHAR(200)},
	SplitNodeID {type INTEGER},
	StaffAssignmentRule {type CLOB},
	Type {type INTEGER},
	TopologicalID {type INTEGER},
	
	PRIMARY KEY(ID, TemplateIDHigh, TemplateIDLow),
	FOREIGN KEY(TemplateIDHigh, TemplateIDLow) REFERENCES PMTemplate(IDHigh, IDLow)
		ON DELETE CASCADE
);


--
-- ProcessModelParameter
--

CREATE TABLE PMProcessModelParameter (
	AccessType {type INTEGER} NOT NULL,
	Name {type VARCHAR(100)} NOT NULL,
	IsIndexed {type BOOLEAN} NOT NULL,
	NodeID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	ConnectorDisabled {type BOOLEAN},
	DataType {type INTEGER},
	DefaultValue {type CLOB},
	Description {type CLOB},
	IdentifierIDHigh {type BIGINT},
	IdentifierIDLow {type BIGINT},
	IsDecisionParameter {type BOOLEAN},
	IsFailure {type BOOLEAN},
	IsOptional {type BOOLEAN},
	IsVirtual {type BOOLEAN},
	UserDefinedDataType {type VARCHAR(2000)},
	
	PRIMARY KEY (AccessType, Name, IsIndexed, NodeID, TemplateIDHigh, TemplateIDLow),
  	FOREIGN KEY(NodeID, TemplateIDHigh, TemplateIDLow) REFERENCES PMNode (ID, TemplateIDHigh, TemplateIDLow)
);

CREATE TABLE PMParameterUserAttributes (
	AccessType {type INTEGER} NOT NULL,
	Name {type VARCHAR(100)} NOT NULL,
	IsIndexed {type BOOLEAN} NOT NULL,
	NodeID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	UAKey {type VARCHAR(200)} NOT NULL,
	UAValue {type CLOB},
	
	FOREIGN KEY (AccessType, Name, IsIndexed, NodeID, TemplateIDHigh, TemplateIDLow) 
		REFERENCES PMProcessModelParameter (AccessType, Name, IsIndexed, NodeID, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE,
	PRIMARY KEY (AccessType, Name, IsIndexed, NodeID, TemplateIDHigh, TemplateIDLow, UAKey)
);

CREATE TABLE PMParameterConfiguration (
	AccessType {type INTEGER} NOT NULL,
	Name {type VARCHAR(100)} NOT NULL,
	IsIndexed {type BOOLEAN} NOT NULL,
	NodeID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	Type {type INTEGER} NOT NULL,
	ConfKey {type VARCHAR(200)} NOT NULL,
	ConfValue {type CLOB},
	IsFixed {type BOOLEAN},
	
	FOREIGN KEY (AccessType, Name, IsIndexed, NodeID, TemplateIDHigh, TemplateIDLow)
		REFERENCES PMProcessModelParameter (AccessType, Name, IsIndexed, NodeID, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE,
	PRIMARY KEY (AccessType, Name, IsIndexed, NodeID, TemplateIDHigh, TemplateIDLow, Type, ConfKey)
);

--
-- Instance
--
CREATE TABLE PMInstance (
	LogIDHigh {type BIGINT} NOT NULL,
	LogIDLow {type BIGINT} NOT NULL,
	IDHigh {type BIGINT} NOT NULL,
	IDLow {type BIGINT} NOT NULL,
	InitiatorAgentID {type BIGINT},
	InitiatorAgentName {type VARCHAR(30)},
	InitiatorOrgPosID {type BIGINT},
	InitiatorOrgPosName {type VARCHAR(250)},
	IsModified {type BOOLEAN},
	Name {type VARCHAR(200)},
	CreationTime {type BIGINT},
	SupervisorAgentID {type BIGINT},
	SupervisorAgentName {type VARCHAR(30)},
	SupervisorOrgPosID {type BIGINT},
	SupervisorOrgPosName {type VARCHAR(250)},
	BaseTemplateIDHigh {type BIGINT},
	BaseTemplateIDLow {type BIGINT},
	TemplateIDHigh {type BIGINT},
	TemplateIDLow {type BIGINT},
	
	UNIQUE(IDHigh, IDLow),
	PRIMARY KEY(LogIDHigh, LogIDLow)
);


--
-- Tables that depend on Template
--


CREATE TABLE PMTemplateStatus (
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	BuildTimeState {type INTEGER},
	SubProcessUsage {type INTEGER},
	TopLevelUsage {type BOOLEAN},
	IsDerivable {type BOOLEAN},
	DerivableComment {type CLOB},
	TlOutdated {type BOOLEAN},
	SpOutdated {type BOOLEAN},
	TlInstantiable {type BOOLEAN},
	SpInstantiable {type BOOLEAN},
	TlInstancesMigratable {type BOOLEAN},
	SpInstancesMigratable {type BOOLEAN},
	TlInstancesChangeable {type BOOLEAN},
	SpInstancesChangeable {type BOOLEAN},
	TlOutdatedComment {type CLOB},
	SpOutdatedComment {type CLOB},
	TlInstantiableComment {type CLOB},
	SpInstantiableComment {type CLOB},
	TlInstancesMigratableComment {type CLOB},
	SpInstancesMigratableComment {type CLOB},
	TlInstancesChangeableComment {type CLOB},
	SpInstancesChangeableComment {type CLOB},
	StarterRule {type CLOB},
	
	PRIMARY KEY(TemplateIDHigh, TemplateIDLow),
	FOREIGN KEY(TemplateIDHigh, TemplateIDLow) REFERENCES PMTemplate(IDHigh, IDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMTemplateUserAttributes (
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	UAKey {type VARCHAR(200)} NOT NULL,
	UAValue {type CLOB},
	
	PRIMARY KEY (TemplateIDHigh, TemplateIDLow, UAKey),
	FOREIGN KEY(TemplateIDHigh, TemplateIDLow) REFERENCES PMTemplate(IDHigh, IDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMTemplateLocks (
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	AgentID {type BIGINT},
	AgentName {type VARCHAR(30)},
	OrgPosID {type BIGINT},
	OrgPosName {type VARCHAR(250)},
	LockCount {type INTEGER},
	
	PRIMARY KEY(TemplateIDHigh, TemplateIDLow),
	FOREIGN KEY(TemplateIDHigh, TemplateIDLow) REFERENCES PMTemplate(IDHigh, IDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMTemplateConfiguration (
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	Type {type INTEGER} NOT NULL,
	ConfKey {type VARCHAR(200)} NOT NULL,
	ConfValue {type CLOB},
	IsFixed {type BOOLEAN},
	
	PRIMARY KEY(TemplateIDHigh, TemplateIDLow, Type, ConfKey),
	FOREIGN KEY(TemplateIDHigh, TemplateIDLow) REFERENCES PMTemplate(IDHigh, IDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMTemplateConfDescription (
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	EntryName {type VARCHAR(200)} NOT NULL,
	Description {type CLOB},
	DataType {type INTEGER},
	IsOptional {type BOOLEAN},

	PRIMARY KEY (TemplateIDHigh, TemplateIDLow, EntryName),
	FOREIGN KEY (TemplateIDHigh, TemplateIDLow) REFERENCES PMTemplate (IDHigh, IDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMTemplateConfDescRestriction (
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	EntryName {type VARCHAR(200)} NOT NULL,
	Restriction {type VARCHAR(200)} NOT NULL,

	PRIMARY KEY (TemplateIDHigh, TemplateIDLow, EntryName, Restriction),
	FOREIGN KEY (TemplateIDHigh, TemplateIDLow) REFERENCES PMTemplate (IDHigh, IDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMTemplateConfDescUA (
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	EntryName {type VARCHAR(200)} NOT NULL,
	UAKey {type VARCHAR(200)} NOT NULL,
	UAValue {type CLOB},

	PRIMARY KEY (TemplateIDHigh, TemplateIDLow, EntryName, UAKey),
	FOREIGN KEY (TemplateIDHigh, TemplateIDLow) REFERENCES PMTemplate (IDHigh, IDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMTemplateConfDescPlugins (
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	EntryName {type VARCHAR(200)} NOT NULL,
	PluginID {type VARCHAR(200)} NOT NULL,
	PluginExtensionPointID {type VARCHAR(200)} NOT NULL,
	DataKey {type VARCHAR(200)} NOT NULL,
	DataValue {type CLOB},

	PRIMARY KEY (TemplateIDHigh, TemplateIDLow, EntryName, PluginID, PluginExtensionPointID, DataKey),
	FOREIGN KEY (TemplateIDHigh, TemplateIDLow) REFERENCES PMTemplate (IDHigh, IDLow)
		ON DELETE CASCADE
);

--
-- Tables that depend on Instance
--



CREATE TABLE PMInstanceStatus (
	InstanceIDHigh {type BIGINT} NOT NULL,
	InstanceIDLow {type BIGINT} NOT NULL,
	MigrationStatus {type INTEGER},
	MigrationComment {type CLOB},
	ExecutionStatus {type INTEGER},
	ExecutionComment {type CLOB},
	
	PRIMARY KEY(InstanceIDHigh, InstanceIDLow)
);

CREATE TABLE PMInstanceUserAttributes (
	InstanceLogIDHigh {type BIGINT} NOT NULL,
	InstanceLogIDLow {type BIGINT} NOT NULL,
	UAKey {type VARCHAR(200)} NOT NULL,
	UAValue {type CLOB},
	
	PRIMARY KEY (InstanceLogIDHigh, InstanceLogIDLow, UAKey),
	FOREIGN KEY(InstanceLogIDHigh, InstanceLogIDLow) REFERENCES PMInstance(LogIDHigh, LogIDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMInstanceTerminationURIs (
	InstanceLogIDHigh {type BIGINT} NOT NULL,
	InstanceLogIDLow {type BIGINT} NOT NULL,
	URI {type VARCHAR(500)} NOT NULL,

	PRIMARY KEY(InstanceLogIDHigh, InstanceLogIDLow, URI),
	FOREIGN KEY(InstanceLogIDHigh, InstanceLogIDLow) REFERENCES PMInstance
			(LogIDHigh, LogIDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMInstanceLocks (
	InstanceIDHigh {type BIGINT} NOT NULL,
	InstanceIDLow {type BIGINT} NOT NULL,
	AgentID {type BIGINT},
	AgentName {type VARCHAR(30)},
	OrgPosID {type BIGINT},
	OrgPosName {type VARCHAR(250)},
	LockCount {type INTEGER},
	
	PRIMARY KEY(InstanceIDHigh, InstanceIDLow)
);

CREATE TABLE PMParentEBPInstanceReference (
	InstanceLogIDHigh {type BIGINT} NOT NULL,
	InstanceLogIDLow {type BIGINT} NOT NULL,
	EBPType {type INTEGER},
	Iteration {type INTEGER},
	IsActivity {type BOOLEAN},
	NodeID {type INTEGER},
	ParentInstanceIDHigh {type BIGINT},
	ParentInstanceIDLow {type BIGINT},
	
	PRIMARY KEY(InstanceLogIDHigh, InstanceLogIDLow),
	FOREIGN KEY(InstanceLogIDHigh, InstanceLogIDLow) REFERENCES PMInstance(LogIDHigh, LogIDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMEBPInstRefRunManURIs (
	InstanceLogIDHigh {type BIGINT} NOT NULL,
	InstanceLogIDLow {type BIGINT} NOT NULL,
	URI {type VARCHAR(500)},
	
	FOREIGN KEY(InstanceLogIDHigh, InstanceLogIDLow) REFERENCES PMParentEBPInstanceReference(InstanceLogIDHigh, InstanceLogIDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMEBPInstRefExManURIs (
	InstanceLogIDHigh {type BIGINT} NOT NULL,
	InstanceLogIDLow {type BIGINT} NOT NULL,
	URI {type VARCHAR(500)} NOT NULL,
	
	FOREIGN KEY(InstanceLogIDHigh, InstanceLogIDLow) REFERENCES PMParentEBPInstanceReference(InstanceLogIDHigh, InstanceLogIDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMNodeInstanceData (
	InstanceLogIDHigh {type BIGINT} NOT NULL,
	InstanceLogIDLow {type BIGINT} NOT NULL,
	NodeID {type INTEGER} NOT NULL,
	Iteration {type INTEGER},
	ExecutionMode {type INTEGER},
	State {type INTEGER},
	AgentID {type BIGINT},
	AgentName {type VARCHAR(30)},
	OrgPosID {type BIGINT},
	OrgPosName {type VARCHAR(250)},

	PRIMARY KEY(InstanceLogIDHigh, InstanceLogIDLow, NodeID),
	FOREIGN KEY(InstanceLogIDHigh, InstanceLogIDLow) REFERENCES PMInstance(LogIDHigh, LogIDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMNIDRunManURIs (
	InstanceLogIDHigh {type BIGINT} NOT NULL,
	InstanceLogIDLow {type BIGINT} NOT NULL,
	NodeID {type INTEGER} NOT NULL,
	URI {type VARCHAR(500)} NOT NULL,
	
	PRIMARY KEY (InstanceLogIDHigh, InstanceLogIDLow, NodeID, URI),
	FOREIGN KEY(InstanceLogIDHigh,InstanceLogIDLow,NodeID) REFERENCES PMNodeInstanceData(InstanceLogIDHigh, InstanceLogIDLow, NodeID)
		ON DELETE CASCADE
);

CREATE TABLE PMLWPInstance (
	InstanceLogIDHigh {type BIGINT} NOT NULL,
	InstanceLogIDLow {type BIGINT} NOT NULL,
	NodeID {type INTEGER} NOT NULL,
	ListIndex {type INTEGER} NOT NULL,
	ChildInstanceIDHigh {type BIGINT},
	ChildInstanceIDLow {type BIGINT},
	
	PRIMARY KEY(InstanceLogIDHigh, InstanceLogIDLow, NodeID, ListIndex),
	FOREIGN KEY(InstanceLogIDHigh,InstanceLogIDLow,NodeID) REFERENCES PMNodeInstanceData(InstanceLogIDHigh, InstanceLogIDLow, NodeID)
		ON DELETE CASCADE
);


--
-- Node
--

CREATE TABLE PMNodeUserAttributes (
	NodeID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	UAKey {type VARCHAR(200)} NOT NULL,
	UAValue {type CLOB},
	
	PRIMARY KEY (NodeID, TemplateIDHigh, TemplateIDLow, UAKey),
	FOREIGN KEY(NodeID, TemplateIDHigh, TemplateIDLow) REFERENCES PMNode(ID, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE
);	
	
CREATE TABLE PMEdge (
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	SourceNodeID {type INTEGER} NOT NULL,
	EndNodeID {type INTEGER} NOT NULL,
	EdgeCode {type BIGINT},
	Type {type INTEGER},
	
	PRIMARY KEY(TemplateIDHigh, TemplateIDLow, SourceNodeID, EndNodeID),
	FOREIGN KEY(SourceNodeID, TemplateIDHigh, TemplateIDLow) REFERENCES PMNode(ID, TemplateIDHigh, TemplateIDLow),
	FOREIGN KEY(EndNodeID, TemplateIDHigh, TemplateIDLow) REFERENCES PMNode(ID, TemplateIDHigh, TemplateIDLow)

  -- ON DELETE CASCADE not possible for both FKs (MSSQL won't allow it) -> code has to compensate for this
);

	
CREATE TABLE PMEdgeUserAttributes (
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	SourceNodeID {type INTEGER} NOT NULL,
	EndNodeID {type INTEGER} NOT NULL,
	UAKey {type VARCHAR(200)} NOT NULL,
	UAValue {type CLOB},
	
	PRIMARY KEY(TemplateIDHigh, TemplateIDLow, SourceNodeID, EndNodeID, UAKey),
	FOREIGN KEY(TemplateIDHigh, TemplateIDLow, SourceNodeID, EndNodeID) REFERENCES 
		PMEdge(TemplateIDHigh, TemplateIDLow, SourceNodeID, EndNodeID)
		ON DELETE CASCADE
);	

CREATE TABLE PMDataElement (
	ID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	DataType {type INTEGER},
	Description {type CLOB},
	IconIDHigh {type BIGINT},
	IconIDLow {type BIGINT},
	IdentifierIDHigh {type BIGINT},
	IdentifierIDLow {type BIGINT},
	Name {type VARCHAR(200)},
	IsPublic {type BOOLEAN},
	UDTName {type VARCHAR(200)},
	IsVirtual {type BOOLEAN},
	
	PRIMARY KEY (ID, TemplateIDHigh, TemplateIDLow),
	FOREIGN KEY(TemplateIDHigh, TemplateIDLow) REFERENCES PMTemplate(IDHigh, IDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMDataElementUserAttributes (
	DataElementID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	UAKey {type VARCHAR(200)} NOT NULL,
	UAValue {type CLOB},
	
	PRIMARY KEY (DataElementID, TemplateIDHigh, TemplateIDLow, UAKey),
	FOREIGN KEY(DataElementID, TemplateIDHigh, TemplateIDLow) REFERENCES 
		PMDataElement(ID, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE
);	


CREATE TABLE PMDataEdge (
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	NodeID {type INTEGER} NOT NULL,
	DataElementID {type INTEGER} NOT NULL,
	AccessType {type INTEGER} NOT NULL,
	ConnectorDisabled {type BOOLEAN},
	IsOptional {type BOOLEAN},
	ParameterName {type VARCHAR(100)},
	ParameterIsIndexed {type BOOLEAN},
	
	PRIMARY KEY(NodeID, DataElementID, AccessType, TemplateIDHigh, TemplateIDLow),
	FOREIGN KEY(DataElementID, TemplateIDHigh, TemplateIDLow)
	  REFERENCES PMDataElement(ID, TemplateIDHigh, TemplateIDLow),
	FOREIGN KEY (AccessType, ParameterName, ParameterIsIndexed, NodeID, TemplateIDHigh, TemplateIDLow)
	  REFERENCES PMProcessModelParameter(AccessType, Name, IsIndexed, NodeID, TemplateIDHigh, TemplateIDLow)

  -- ON DELETE CASCADE not possible for FKs (MSSQL would allow only one CASCADE,
  -- but Derby requires both FKs to have the same rule clause)
);


CREATE TABLE PMDataEdgeUserAttributes (
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	NodeID {type INTEGER} NOT NULL,
	DataElementID {type INTEGER} NOT NULL,
	AccessType {type INTEGER} NOT NULL,
	UAKey {type VARCHAR(200)} NOT NULL,
	UAValue {type CLOB},
	
	PRIMARY KEY (NodeID, DataElementID, AccessType, TemplateIDHigh, TemplateIDLow, UAKey),
	FOREIGN KEY(NodeID, DataElementID, AccessType, TemplateIDHigh, TemplateIDLow) REFERENCES 
		PMDataEdge(NodeID, DataElementID, AccessType, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE
);



--
-- ExecutableBusinessProcess
--

CREATE TABLE PMExecutableBusinessProcess (
	NodeID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	IsCloseable {type BOOLEAN},
	IsSuspendable {type BOOLEAN},
	IsResettable {type BOOLEAN},
	Type {type INTEGER},
	
	PRIMARY KEY(NodeID, TemplateIDHigh, TemplateIDLow),
	FOREIGN KEY(NodeID, TemplateIDHigh, TemplateIDLow) REFERENCES PMNode(ID, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMEBPUserAttributes (
	NodeID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	IsLWP {type BOOLEAN} NOT NULL,
	UAKey {type VARCHAR(200)} NOT NULL,
	UAValue {type CLOB},
	
	PRIMARY KEY (NodeID, TemplateIDHigh, TemplateIDLow, IsLWP, UAKey),
	FOREIGN KEY(NodeID, TemplateIDHigh, TemplateIDLow) REFERENCES PMExecutableBusinessProcess(NodeID, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMEBPConfiguration (
	NodeID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	Type {type INTEGER} NOT NULL,
	ConfKey {type VARCHAR(200)} NOT NULL,
	ConfValue {type CLOB},
	IsFixed {type BOOLEAN},
	
	FOREIGN KEY (NodeID, TemplateIDHigh, TemplateIDLow) REFERENCES PMExecutableBusinessProcess(NodeID, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE,
	PRIMARY KEY (NodeID, TemplateIDHigh, TemplateIDLow, Type, ConfKey)
);

CREATE TABLE PMEBPPlugins (
	NodeID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	PluginID {type VARCHAR(200)} NOT NULL,
	PluginExtensionPointID {type VARCHAR(200)} NOT NULL,
	DataKey {type VARCHAR(200)} NOT NULL,
	IsIndexed {type BOOLEAN} NOT NULL,
	DataValue {type CLOB},
	
	FOREIGN KEY (NodeID, TemplateIDHigh, TemplateIDLow) REFERENCES PMExecutableBusinessProcess(NodeID, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE,
	PRIMARY KEY (NodeID, TemplateIDHigh, TemplateIDLow, PluginID, PluginExtensionPointID, DataKey, IsIndexed)
);

CREATE TABLE PMSubProcess (
	NodeID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	ReferencedTemplateIDHigh {type BIGINT},
	ReferencedTemplateIDLow {type BIGINT},
	IsVarPar {type BOOLEAN},
	Type {type INTEGER},
	
	PRIMARY KEY(NodeID, TemplateIDHigh, TemplateIDLow),
	FOREIGN KEY(NodeID, TemplateIDHigh, TemplateIDLow) REFERENCES PMExecutableBusinessProcess(NodeID, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE
);


--
-- Activity
--

CREATE TABLE PMActivity (
	NodeID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	IDHigh {type BIGINT},
	IDLow {type BIGINT},
	Name {type VARCHAR(200)},
	ConfSetName {type VARCHAR(250)},
	Description {type CLOB},
	ECName {type VARCHAR(200)},
	GUIContextID {type VARCHAR(250)},
	IconIDHigh {type BIGINT},
	IconIDLow {type BIGINT},
	ImplementationClass {type CLOB},
	IsDecisionActivity {type BOOLEAN},
	IsSingleton {type BOOLEAN},
	OperationName {type VARCHAR(250)},
	ParameterChangePolicy {type TINYINT},
	SupportsTestExecution {type BOOLEAN},
	SupportsViewOnly {type BOOLEAN},
	SystemComponent {type BLOB},
	
	PRIMARY KEY(NodeID, TemplateIDHigh, TemplateIDLow),
	FOREIGN KEY(NodeID, TemplateIDHigh, TemplateIDLow) REFERENCES PMExecutableBusinessProcess(NodeID, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMDecisionActivityStatement (
	NodeID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	DecisionID {type BIGINT} NOT NULL,
	DecisionLabel {type VARCHAR(200)},
	DecisionStatement {type VARCHAR(4000)},
	EdgeCode {type BIGINT},

	PRIMARY KEY(NodeID, TemplateIDHigh, TemplateIDLow, DecisionID),
	FOREIGN KEY(NodeID, TemplateIDHigh, TemplateIDLow) REFERENCES PMActivity(NodeID, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMActivityClassPath (
	NodeID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	Path {type VARCHAR(2000)} NOT NULL,
	ActivityEntityType {type INTEGER} NOT NULL,
	Idx {type INTEGER},

	FOREIGN KEY(NodeID, TemplateIDHigh, TemplateIDLow) REFERENCES PMActivity(NodeID, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE,
	PRIMARY KEY (NodeID, TemplateIDHigh, TemplateIDLow, Path, ActivityEntityType)
);

CREATE TABLE PMActivityAttributeOrigins (
	NodeID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	ActivityAttribute {type INTEGER} NOT NULL,
	ActivityEntityType {type INTEGER},
	
	FOREIGN KEY (NodeID, TemplateIDHigh, TemplateIDLow) REFERENCES PMActivity(NodeID, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE,
	PRIMARY KEY (NodeID, TemplateIDHigh, TemplateIDLow, ActivityAttribute)
);

--
-- Plugin tables
--

CREATE TABLE PMTemplatePlugins (
	DataKey {type VARCHAR(200)} NOT NULL,
	DataValue {type CLOB},
	PluginID {type VARCHAR(200)} NOT NULL,
	PluginExtensionPointID {type VARCHAR(200)} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	
	PRIMARY KEY(DataKey, TemplateIDHigh, TemplateIDLow, PluginID, PluginExtensionPointID),
	FOREIGN KEY(TemplateIDHigh, TemplateIDLow) REFERENCES PMTemplate(IDHigh, IDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMInstancePlugins (
	DataKey {type VARCHAR(200)} NOT NULL,
	DataValue {type CLOB},
	PluginID {type VARCHAR(200)} NOT NULL,
	PluginExtensionPointID {type VARCHAR(200)} NOT NULL,
	InstanceLogIDHigh {type BIGINT} NOT NULL,
	InstanceLogIDLow {type BIGINT} NOT NULL,
	
	PRIMARY KEY(DataKey, InstanceLogIDHigh, InstanceLogIDLow, PluginID, PluginExtensionPointID),
	FOREIGN KEY(InstanceLogIDHigh, InstanceLogIDLow) REFERENCES PMInstance(LogIDHigh, LogIDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMDataElementPlugins (
	DataKey {type VARCHAR(200)} NOT NULL,
	DataValue {type CLOB},
	PluginID {type VARCHAR(200)} NOT NULL,
	PluginExtensionPointID {type VARCHAR(200)} NOT NULL,
	DataElementID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	
	PRIMARY KEY(DataKey, DataElementID, TemplateIDHigh, TemplateIDLow, PluginID, PluginExtensionPointID),
	FOREIGN KEY(DataElementID, TemplateIDHigh, TemplateIDLow) REFERENCES PMDataElement(ID, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMNodePlugins (
	DataKey {type VARCHAR(200)} NOT NULL,
	DataValue {type CLOB},
	PluginID {type VARCHAR(200)} NOT NULL,
	PluginExtensionPointID {type VARCHAR(200)} NOT NULL,
	NodeID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,
	
	PRIMARY KEY(DataKey, NodeID, TemplateIDHigh, TemplateIDLow, PluginID, PluginExtensionPointID),
	FOREIGN KEY(NodeID, TemplateIDHigh, TemplateIDLow) REFERENCES PMNode(ID, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE
);

CREATE TABLE PMParameterPlugins (
	DataKey {type VARCHAR(200)} NOT NULL,
	DataValue {type CLOB},
	PluginID {type VARCHAR(200)} NOT NULL,
	PluginExtensionPointID {type VARCHAR(200)} NOT NULL,
	ParameterAccessType {type INTEGER} NOT NULL,
	ParameterName {type VARCHAR(100)} NOT NULL,
	ParameterIsIndexed {type BOOLEAN} NOT NULL,
	NodeID {type INTEGER} NOT NULL,
	TemplateIDHigh {type BIGINT} NOT NULL,
	TemplateIDLow {type BIGINT} NOT NULL,

	
	PRIMARY KEY(DataKey, ParameterAccessType, ParameterName, ParameterIsIndexed, NodeID, TemplateIDHigh, TemplateIDLow, PluginID, PluginExtensionPointID),
	FOREIGN KEY(ParameterAccessType, ParameterName, ParameterIsIndexed, NodeID, TemplateIDHigh, TemplateIDLow) REFERENCES 
		PMProcessModelParameter(AccessType, Name, IsIndexed, NodeID, TemplateIDHigh, TemplateIDLow)
		ON DELETE CASCADE
);


--
-- Enquiry
--

CREATE TABLE PMEnquiry (
	InstanceLogIDHigh {type BIGINT} NOT NULL,
	InstanceLogIDLow {type BIGINT} NOT NULL,
	NodeID {type INTEGER} NOT NULL,
	EnquiryIndex {type INTEGER} NOT NULL,
	Question {type CLOB},
	Reply {type CLOB},

	PRIMARY KEY(InstanceLogIDHigh, InstanceLogIDLow, NodeID, EnquiryIndex),
	FOREIGN KEY(InstanceLogIDHigh, InstanceLogIDLow, NodeID) REFERENCES
		PMNodeInstanceData (InstanceLogIDHigh, InstanceLogIDLow, NodeID)
		ON DELETE CASCADE
);

CREATE TABLE PMEnquiryQualifiedAgents (
	InstanceLogIDHigh {type BIGINT} NOT NULL,
	InstanceLogIDLow {type BIGINT} NOT NULL,
	NodeID {type INTEGER} NOT NULL,
	EnquiryIndex {type INTEGER} NOT NULL,
	AgentID {type BIGINT} NOT NULL,
	OrgPosID {type BIGINT} NOT NULL,
	Type {type INTEGER} NOT NULL,
	AgentName {type VARCHAR(30)},
	OrgPosName {type VARCHAR(250)},

	PRIMARY KEY(InstanceLogIDHigh, InstanceLogIDLow, NodeID, EnquiryIndex, AgentID, OrgPosID, Type),
	FOREIGN KEY(InstanceLogIDHigh, InstanceLogIDLow, NodeID, EnquiryIndex) REFERENCES
		PMEnquiry (InstanceLogIDHigh, InstanceLogIDLow, NodeID, EnquiryIndex)
		ON DELETE CASCADE
);
