
-- lockingAgentName and lockingOrgPosName: Redundancy to OMM. ulk wanted this...


CREATE TABLE Template (
	idHigh {type BIGINT} NOT NULL,
	idLow {type BIGINT} NOT NULL,
	lockingAgentID {type BIGINT},
	lockingOrgPosID {type BIGINT},
	lockingAgentName {type VARCHAR(30)},
	lockingOrgPosName {type VARCHAR(2000)},
	lockCount {type BIGINT} NOT NULL,
	xmlBlob {type BLOB} NOT NULL,

	PRIMARY KEY(idHigh, idLow)
);

CREATE TABLE Instance (
	idHigh {type BIGINT} NOT NULL,
	idLow {type BIGINT} NOT NULL,
	logIDHigh {type BIGINT} NOT NULL,
	logIDLow {type BIGINT} NOT NULL,
	templateIDHigh {type BIGINT} NOT NULL,
	templateIDLow {type BIGINT} NOT NULL,
	lockingAgentID {type BIGINT},
	lockingOrgPosID {type BIGINT},
	lockingAgentName {type VARCHAR(30)},
	lockingOrgPosName {type VARCHAR(2000)},
	lockCount {type BIGINT} NOT NULL,
	xmlBlob {type BLOB} NOT NULL,

	PRIMARY KEY(idHigh, idLow),
	FOREIGN KEY (templateIDHigh, templateIDLow) REFERENCES Template(idHigh, idLow)
);

CREATE TABLE EmbeddedTemplate (
	idHigh {type BIGINT} NOT NULL,
	idLow {type BIGINT} NOT NULL,
	parentTemplateIDHigh {type BIGINT} NOT NULL,
	parentTemplateIDLow {type BIGINT} NOT NULL,

	PRIMARY KEY(idHigh, idLow),
	FOREIGN KEY (parentTemplateIDHigh, parentTemplateIDLow) REFERENCES Template(idHigh, idLow)
);

CREATE TABLE BaseTemplateIDs (
	idHigh {type BIGINT} NOT NULL,
	idLow {type BIGINT} NOT NULL,
	baseIDHigh {type BIGINT} NOT NULL,
	baseIDLow {type BIGINT} NOT NULL,

	PRIMARY KEY (idHigh, idLow),
	FOREIGN KEY (idHigh, idLow) REFERENCES Template (idHigh, idLow),
	FOREIGN KEY (baseIDHigh, baseIDLow) REFERENCES Template (idHigh, idLow)
);
