-- create statements for worklist database tables

{createSeq "ClientID" start=1};


CREATE TABLE wl_iwl
(
	idH 							{type BIGINT}			NOT NULL,
	idL								{type BIGINT}			NOT NULL,
	agentID							{type BIGINT}			NOT NULL,
	orgPositionID					{type BIGINT}			NOT NULL,
	agentName						{type LONGVARCHAR}		NOT NULL,
	orgPositionName					{type LONGVARCHAR}		NOT NULL,
	revision						{type BIGINT}			NOT NULL,
	absenceFrom						{type BIGINT}			NOT NULL,
	absenceTo						{type BIGINT}			NOT NULL,
	substitutionRule				{type LONGVARCHAR},
	serializedUserAttributes		{type BLOB}				NOT NULL,
	serializedWorklistConfig		{type BLOB}				NOT NULL,

	updateThreshold					{type INTEGER},
	updateUserAttributes			{type BLOB},

	PRIMARY KEY (idH, idL)
);


CREATE TABLE wl_thres
(
	priority						{type INTEGER}			NOT NULL,
	interval_						{type BIGINT}			NOT NULL,
	idH								{type BIGINT}			NOT NULL,
	idL								{type BIGINT}			NOT NULL,

	PRIMARY KEY(priority, idH, idL),

	FOREIGN KEY(idH, idL)
		REFERENCES wl_iwl(idH, idL) ON DELETE CASCADE
);


CREATE TABLE wl_iwli
(
	idH								{type BIGINT}			NOT NULL,
	idL								{type BIGINT}			NOT NULL,
	title							{type LONGVARCHAR}		NOT NULL,
	description						{type LONGVARCHAR},
	iconIDH							{type BIGINT},
	iconIDL							{type BIGINT},
	processTemplateName				{type LONGVARCHAR}		NOT NULL,
	processInstanceName				{type LONGVARCHAR}		NOT NULL,
	state							{type LONGVARCHAR}		NOT NULL,
	priority						{type INTEGER}			NOT NULL,
	complexity						{type BIGINT}			NOT NULL,
	activationDate					{type BIGINT}			NOT NULL,
	assignmentDate					{type BIGINT}			NOT NULL,
	escalationDate					{type BIGINT}			NOT NULL,
	dueDate							{type BIGINT}			NOT NULL,
	assignedAgentID					{type BIGINT},
	assignedOrgPositionID			{type BIGINT},
	assignedAgentName				{type LONGVARCHAR},
	assignedOrgPositionName			{type LONGVARCHAR},
	currentEscalationLevel			{type INTEGER}			NOT NULL,
	currentDelegationLevel			{type INTEGER}			NOT NULL,
	serializedUserAttributes		{type BLOB}				NOT NULL,
	staffAssignmentRule				{type LONGVARCHAR}		NOT NULL,
	escalationHandlingProcedureID	{type LONGVARCHAR},
	distribHandlingProcedureID		{type LONGVARCHAR},
	delegationHandlingProcedureID	{type LONGVARCHAR},
	availableStateDelegationIndex	{type INTEGER}			NOT NULL,
	parameterDataContext			{type BLOB}				NOT NULL,
	activityType					{type LONGVARCHAR}		NOT NULL,
	supportedPlugins				{type BLOB}				NOT NULL,
	pluginDatas						{type BLOB}				NOT NULL,
	itemStored						{type BOOLEAN}			NOT NULL,

	PRIMARY KEY(idH, idL)
);


CREATE TABLE wl_act
(
	instanceID_h					{type BIGINT}			NOT NULL,
	instanceID_l					{type BIGINT}			NOT NULL,
	baseTemplateID_h				{type BIGINT}			NOT NULL,
	baseTemplateID_l				{type BIGINT}			NOT NULL,
	nodeID							{type INTEGER}			NOT NULL,
	iteration						{type INTEGER}			NOT NULL,
	executionManagerURIs			{type BLOB}				NOT NULL,
	runtimeManagerURIs				{type BLOB}				NOT NULL,
	isSuspensable					{type BOOLEAN}			NOT NULL,
	isResetable						{type BOOLEAN}			NOT NULL,
	isCloseable						{type BOOLEAN}			NOT NULL,
	serializedUserAttributes		{type BLOB}				NOT NULL,
	supportsViewOnly				{type BOOLEAN}			NOT NULL,
	executableComponentName			{type VARCHAR(254)},
	idH								{type BIGINT}			NOT NULL,
	idL								{type BIGINT}			NOT NULL,
	guiContextID					{type VARCHAR(254)},

	PRIMARY KEY(instanceID_h, instanceID_l, nodeID, iteration),

	FOREIGN KEY(idH, idL)
		REFERENCES wl_iwli(idH, idL)
);


CREATE TABLE wl_asw
(
	idH								{type BIGINT}			NOT NULL,
	idL								{type BIGINT}			NOT NULL,
	itemID_h						{type BIGINT}			NOT NULL,
	itemID_l						{type BIGINT}			NOT NULL,

	PRIMARY KEY(idH, idL, itemID_h, itemID_l),

	FOREIGN KEY(itemID_h, itemID_l)
		REFERENCES wl_iwli(idH, idL)
);


CREATE TABLE wl_iwlis
(
	title							{type LONGVARCHAR},
	description						{type LONGVARCHAR},
	priority						{type INTEGER}			NOT NULL,
	dueDate							{type BIGINT}			NOT NULL,
	dueDateEscalationID				{type LONGVARCHAR},
	resubmissionDate				{type BIGINT}			NOT NULL,
	escalationDate					{type BIGINT}			NOT NULL,
	serializedUserAttributes		{type BLOB}				NOT NULL,
	supportedPlugins				{type BLOB}				NOT NULL,
	pluginDatas						{type BLOB}				NOT NULL,
	worklistID_h					{type BIGINT}			NOT NULL,
	worklistID_l					{type BIGINT}			NOT NULL,
	itemID_h						{type BIGINT}			NOT NULL,
	itemID_l						{type BIGINT}			NOT NULL,

	PRIMARY KEY(worklistID_h, worklistID_l, itemID_h, itemID_l),

	FOREIGN KEY(worklistID_h, worklistID_l)
		REFERENCES wl_iwl(idH, idL) ON DELETE CASCADE,

	FOREIGN KEY(itemID_h, itemID_l)
		REFERENCES wl_iwli(idH, idL) ON DELETE CASCADE
);
CREATE INDEX wl_iwlis_itemID ON wl_iwlis (itemID_h ASC, itemID_l ASC);


CREATE TABLE wl_del
(
	delegatorAgentID				{type BIGINT}			NOT NULL,
	delegatorOrgPositionID			{type BIGINT}			NOT NULL,
	delegatorAgentName				{type LONGVARCHAR}		NOT NULL,
	delegatorOrgPositionName		{type LONGVARCHAR}		NOT NULL,
	comment_						{type LONGVARCHAR}		NOT NULL,
	seqNr							{type INTEGER}			NOT NULL,
	itemID_h						{type BIGINT}			NOT NULL,
	itemID_l						{type BIGINT}			NOT NULL,

	PRIMARY KEY(itemID_h, itemID_l, seqNr),

	FOREIGN KEY(itemID_h, itemID_l)
		REFERENCES wl_iwli(idH, idL) ON DELETE CASCADE
);


CREATE TABLE wl_enq
(
	originatorAgentID				{type BIGINT}			NOT NULL,
	originatorOrgPositionID			{type BIGINT}			NOT NULL,
	originatorAgentName				{type LONGVARCHAR}		NOT NULL,
	originatorOrgPositionName		{type LONGVARCHAR}		NOT NULL,
	question						{type LONGVARCHAR}		NOT NULL,
	reply							{type LONGVARCHAR},
	hasReply						{type BOOLEAN}			NOT NULL,
	replierAgentID					{type BIGINT}			NOT NULL,
	replierOrgPositionID			{type BIGINT}			NOT NULL,
	replierAgentName				{type LONGVARCHAR},
	replierOrgPositionName			{type LONGVARCHAR},
	seqNr							{type INTEGER}			NOT NULL,
	itemID_h						{type BIGINT}			NOT NULL,
	itemID_l						{type BIGINT}			NOT NULL,

	PRIMARY KEY(itemID_h, itemID_l, seqNr),

	FOREIGN KEY(itemID_h, itemID_l)
		REFERENCES wl_iwli(idH, idL) ON DELETE CASCADE
);


CREATE TABLE wl_hasdr
(
	itemID_h						{type BIGINT}			NOT NULL,
	itemID_l						{type BIGINT}			NOT NULL,
	seqNr							{type INTEGER}			NOT NULL,
	agentID							{type BIGINT}			NOT NULL,
	orgPositionID					{type BIGINT}			NOT NULL,
	agentName						{type LONGVARCHAR}		NOT NULL,
	orgPositionName					{type LONGVARCHAR}		NOT NULL,

	PRIMARY KEY(itemID_h, itemID_l, seqNr, agentID, orgPositionID),

	FOREIGN KEY(itemID_h, itemID_l, seqNr)
		REFERENCES wl_del(itemID_h, itemID_l, seqNr) ON DELETE CASCADE
);


CREATE TABLE wl_haser
(
	itemID_h						{type BIGINT}			NOT NULL,
	itemID_l						{type BIGINT}			NOT NULL,
	seqNr							{type INTEGER}			NOT NULL,
	agentID							{type BIGINT}			NOT NULL,
	orgPositionID					{type BIGINT}			NOT NULL,
	agentName						{type LONGVARCHAR}		NOT NULL,
	orgPositionName					{type LONGVARCHAR}		NOT NULL,

	PRIMARY KEY(itemID_h, itemID_l, seqNr, agentID, orgPositionID),

	FOREIGN KEY(itemID_h, itemID_l, seqNr)
		REFERENCES wl_enq(itemID_h, itemID_l, seqNr) ON DELETE CASCADE
);


CREATE TABLE wl_uri
(
	uriString						{type LONGVARCHAR}		NOT NULL,
	clientID						{type BIGINT}			NOT NULL,

	PRIMARY KEY(clientID)
);


CREATE TABLE wl_qa
(
	agentID							{type BIGINT}			NOT NULL,
	orgPositionID					{type BIGINT}			NOT NULL,
	
	PRIMARY KEY(agentID, orgPositionID)
);


CREATE TABLE wl_hasc
(
	agentID							{type BIGINT}			NOT NULL,
	orgPositionID					{type BIGINT}			NOT NULL,
	clientID						{type BIGINT}			NOT NULL,
	counter							{type BIGINT}			NOT NULL,

	PRIMARY KEY(agentID, orgPositionID, clientID),
	
	FOREIGN KEY(agentID, orgPositionID)
		REFERENCES wl_qa(agentID, orgPositionID),

	FOREIGN KEY(clientID)
		REFERENCES wl_uri(clientID) ON DELETE CASCADE
);
