/*
 * Decompiled with CFR 0.152.
 */
package edu.uulm.scbayes.logic.cnf.dimacs;

import edu.uulm.scbayes.logic.cnf.dimacs.DIMACSInstance;
import edu.uulm.scbayes.logic.cnf.dimacs.DimacsClause;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

public final class DIMACSGenerator$ {
    public static final DIMACSGenerator$ MODULE$;

    static {
        new DIMACSGenerator$();
    }

    public DimacsClause generateClause(int numVars, int numPosAtoms, int numNegAtoms, Random rnd) {
        HashSet<Integer> posAtoms = new HashSet<Integer>();
        while (posAtoms.size() < numPosAtoms) {
            int candidate = rnd.nextInt(numVars) + 1;
            Object object = posAtoms.contains(BoxesRunTime.boxToInteger(candidate)) ? BoxedUnit.UNIT : posAtoms.$plus$eq((Object)BoxesRunTime.boxToInteger(candidate));
        }
        HashSet<Integer> negAtoms = new HashSet<Integer>();
        while (negAtoms.size() < numNegAtoms) {
            int candidate = rnd.nextInt(numVars) + 1;
            Object object = posAtoms.contains(BoxesRunTime.boxToInteger(candidate)) || negAtoms.contains(BoxesRunTime.boxToInteger(candidate)) ? BoxedUnit.UNIT : negAtoms.$plus$eq((Object)BoxesRunTime.boxToInteger(candidate));
        }
        return new DimacsClause(Predef$.MODULE$.wrapIntArray((int[])posAtoms.toArray(ClassTag$.MODULE$.Int())), Predef$.MODULE$.wrapIntArray((int[])negAtoms.toArray(ClassTag$.MODULE$.Int())));
    }

    public DIMACSInstance generateRandomKSAT(int numVariables, int clauseSize, int clauses, Random rnd) {
        return new DIMACSInstance(new StringOps(Predef$.MODULE$.augmentString("random generated k-SAT, %d variables, k = %d, %d clauses")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(numVariables), BoxesRunTime.boxToInteger(clauseSize), BoxesRunTime.boxToInteger(clauses)})), numVariables, ((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), clauses).map(new Serializable(clauseSize, rnd){
            public static final long serialVersionUID = 0L;
            private final int clauseSize$1;
            private final Random rnd$1;

            public final Tuple2<Object, Object> apply(int idxCl) {
                int posAtoms = this.rnd$1.nextInt(this.clauseSize$1);
                return new Tuple2$mcII$sp(idxCl, posAtoms);
            }
            {
                this.clauseSize$1 = clauseSize$1;
                this.rnd$1 = rnd$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).map(new Serializable(numVariables, clauseSize, rnd){
            public static final long serialVersionUID = 0L;
            private final int numVariables$1;
            private final int clauseSize$1;
            private final Random rnd$1;

            public final DimacsClause apply(Tuple2<Object, Object> x$1) {
                Tuple2<Object, Object> tuple22 = x$1;
                if (tuple22 != null) {
                    int posAtoms = tuple22._2$mcI$sp();
                    DimacsClause dimacsClause = DIMACSGenerator$.MODULE$.generateClause(this.numVariables$1, posAtoms, this.clauseSize$1 - posAtoms, this.rnd$1);
                    return dimacsClause;
                }
                throw new MatchError(tuple22);
            }
            {
                this.numVariables$1 = numVariables$1;
                this.clauseSize$1 = clauseSize$1;
                this.rnd$1 = rnd$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()));
    }

    private DIMACSGenerator$() {
        MODULE$ = this;
    }
}

