/*
 * Decompiled with CFR 0.152.
 */
package edu.uulm.scbayes.mln.parsing;

import edu.uulm.scbayes.logic.AbstractPredicateDefinition;
import edu.uulm.scbayes.logic.Constant;
import edu.uulm.scbayes.logic.Formula;
import edu.uulm.scbayes.logic.Signature;
import edu.uulm.scbayes.logic.TruthAssignment;
import edu.uulm.scbayes.mln.MLNWeightedFormula;
import edu.uulm.scbayes.mln.MarkovLogicNetwork;
import edu.uulm.scbayes.mln.parsing.FOLParser$;
import edu.uulm.scbayes.mln.parsing.ParseHelpers$;
import edu.uulm.scbayes.mln.parsing.SignatureBuilder;
import java.io.FileReader;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.util.parsing.combinator.Parsers;

public final class ParseHelpers$ {
    public static final ParseHelpers$ MODULE$;

    static {
        new ParseHelpers$();
    }

    public synchronized <A, P extends Parsers> A unpack(Parsers.ParseResult<A> pr) {
        try {
            return pr.get();
        }
        catch (Throwable throwable2) {
            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("Parse error: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{pr})));
        }
    }

    public List<Formula> parseLogicFormulas(String s2, SignatureBuilder sm) {
        return (List)this.unpack(FOLParser$.MODULE$.parseAll(this.logicFileParser$1(sm), s2));
    }

    public List<AbstractPredicateDefinition> parsePredicateDefs(String s2, SignatureBuilder sm) {
        return this.unpack(FOLParser$.MODULE$.parseAll(FOLParser$.MODULE$.rep1(new Serializable(sm){
            public static final long serialVersionUID = 0L;
            private final SignatureBuilder sm$2;

            public final Parsers.Parser<AbstractPredicateDefinition> apply() {
                return FOLParser$.MODULE$.predicateDefinition(this.sm$2);
            }
            {
                this.sm$2 = sm$2;
            }
        }), s2));
    }

    public List<BoxedUnit> parseDomains(String s2, SignatureBuilder sm) {
        return this.unpack(FOLParser$.MODULE$.parseAll(FOLParser$.MODULE$.rep1(new Serializable(sm){
            public static final long serialVersionUID = 0L;
            private final SignatureBuilder sm$3;

            public final Parsers.Parser<BoxedUnit> apply() {
                return FOLParser$.MODULE$.domainDefinition(this.sm$3);
            }
            {
                this.sm$3 = sm$3;
            }
        }), s2));
    }

    public List<Formula> parseFormulas(String s2, Signature sig) {
        return this.unpack(FOLParser$.MODULE$.parseAll(FOLParser$.MODULE$.rep1(new Serializable(sig){
            public static final long serialVersionUID = 0L;
            private final Signature sig$1;

            public final Parsers.Parser<Formula> apply() {
                return FOLParser$.MODULE$.formula(this.sig$1);
            }
            {
                this.sig$1 = sig$1;
            }
        }), s2));
    }

    public Formula parseFormula(String s2, Signature sig) {
        return this.unpack(FOLParser$.MODULE$.parse(FOLParser$.MODULE$.formula(sig), s2));
    }

    public List<MLNWeightedFormula> parseWeightedFormulas(String s2, Signature sig) {
        return this.unpack(FOLParser$.MODULE$.parseAll(FOLParser$.MODULE$.rep1(new Serializable(sig){
            public static final long serialVersionUID = 0L;
            private final Signature sig$2;

            public final Parsers.Parser<MLNWeightedFormula> apply() {
                return FOLParser$.MODULE$.weightedFormula(this.sig$2);
            }
            {
                this.sig$2 = sig$2;
            }
        }), s2));
    }

    public Tuple2<Signature, List<MLNWeightedFormula>> parseMLN(String s2) {
        SignatureBuilder sb = new SignatureBuilder();
        return this.unpack(FOLParser$.MODULE$.parseAll(FOLParser$.MODULE$.mlnFileParser(sb), s2));
    }

    public MarkovLogicNetwork loadMLNFile(String file) {
        SignatureBuilder sb = new SignatureBuilder();
        FileReader in = new FileReader(file);
        Tuple2 tuple22 = this.liftedTree1$1(file, sb, in);
        if (tuple22 != null) {
            Tuple2<Signature, List> tuple23;
            Signature signature = (Signature)tuple22._1();
            List formulaList = (List)tuple22._2();
            Tuple2<Signature, List> tuple24 = tuple23 = new Tuple2<Signature, List>(signature, formulaList);
            Signature signature2 = tuple24._1();
            List formulaList2 = tuple24._2();
            return new MarkovLogicNetwork(formulaList2, signature2);
        }
        throw new MatchError(tuple22);
    }

    public TruthAssignment parseEvidence(String s2, Signature signature) {
        Tuple2<TruthAssignment, Seq<Constant>> tuple22 = this.unpack(FOLParser$.MODULE$.parseAll(FOLParser$.MODULE$.multipleEvidence(signature), s2));
        if (tuple22 != null) {
            Tuple2<TruthAssignment, Seq<Constant>> tuple23;
            TruthAssignment ta = tuple22._1();
            Seq<Constant> constants = tuple22._2();
            Tuple2<TruthAssignment, Seq<Constant>> tuple24 = tuple23 = new Tuple2<TruthAssignment, Seq<Constant>>(ta, constants);
            TruthAssignment ta2 = tuple24._1();
            Seq<Constant> constants2 = tuple24._2();
            Predef$.MODULE$.assert(constants2.isEmpty(), (Function0<Object>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "parsing of evidence file created new constants";
                }
            }));
            return ta2;
        }
        throw new MatchError(tuple22);
    }

    public TruthAssignment loadEvidenceFile(String file, Signature signature) {
        Tuple2<TruthAssignment, Seq<Constant>> tuple22 = this.unpack(FOLParser$.MODULE$.parseAll(FOLParser$.MODULE$.multipleEvidence(signature), new FileReader(file)));
        if (tuple22 != null) {
            Tuple2<TruthAssignment, Seq<Constant>> tuple23;
            TruthAssignment ta = tuple22._1();
            Seq<Constant> constants = tuple22._2();
            Tuple2<TruthAssignment, Seq<Constant>> tuple24 = tuple23 = new Tuple2<TruthAssignment, Seq<Constant>>(ta, constants);
            TruthAssignment ta2 = tuple24._1();
            Seq<Constant> constants2 = tuple24._2();
            Predef$.MODULE$.assert(constants2.isEmpty(), (Function0<Object>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "parsing of evidence file created new constants";
                }
            }));
            return ta2;
        }
        throw new MatchError(tuple22);
    }

    public Tuple2<TruthAssignment, Seq<Constant>> parseEvidenceAllowNewConstants(String s2, Signature signature) {
        return this.unpack(FOLParser$.MODULE$.parseAll(FOLParser$.MODULE$.multipleEvidence(signature), s2));
    }

    public Tuple2<TruthAssignment, Seq<Constant>> loadEvidenceFileAllowNewConstants(String file, Signature signature) {
        return this.unpack(FOLParser$.MODULE$.parseAll(FOLParser$.MODULE$.multipleEvidence(signature), new FileReader(file)));
    }

    private final Parsers.Parser logicFileParser$1(SignatureBuilder sm$1) {
        return FOLParser$.MODULE$.rep(new Serializable(sm$1){
            public static final long serialVersionUID = 0L;
            private final SignatureBuilder sm$1;

            public final Parsers.Parser<AbstractPredicateDefinition> apply() {
                return FOLParser$.MODULE$.predicateDefinition(this.sm$1);
            }
            {
                this.sm$1 = sm$1;
            }
        }).$tilde(new Serializable(sm$1){
            public static final long serialVersionUID = 0L;
            public final SignatureBuilder sm$1;

            public final Parsers.Parser<List<BoxedUnit>> apply() {
                return FOLParser$.MODULE$.rep(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.logicFileParser.1.2 $outer;

                    public final Parsers.Parser<BoxedUnit> apply() {
                        return FOLParser$.MODULE$.domainDefinition(this.$outer.sm$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.sm$1 = sm$1;
            }
        }).$tilde$greater(new Serializable(sm$1){
            public static final long serialVersionUID = 0L;
            public final SignatureBuilder sm$1;

            public final Parsers.Parser<List<Formula>> apply() {
                return FOLParser$.MODULE$.rep1(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.logicFileParser.1.3 $outer;

                    public final Parsers.Parser<Formula> apply() {
                        return FOLParser$.MODULE$.formula(this.$outer.sm$1.getSignature());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.sm$1 = sm$1;
            }
        });
    }

    private final Tuple2 liftedTree1$1(String file$1, SignatureBuilder sb$1, FileReader in$1) {
        try {
            return this.unpack(FOLParser$.MODULE$.parseAll(FOLParser$.MODULE$.mlnFileParser(sb$1), in$1));
        }
        catch (Exception exception) {
            throw new RuntimeException(new StringBuilder().append((Object)"Error while parsing mln file ").append((Object)file$1).toString(), exception);
        }
        finally {
            in$1.close();
        }
    }

    private ParseHelpers$() {
        MODULE$ = this;
    }
}

