# UUMLN - University of Ulm Markov Logic Networks
 This is a framework for inference in Markov Logic Networks (MLN).

 This package is currently mainly published for making the code used in the paper
 "Approximate online inference for dynamic markov logic networks" available. If you are using the code for handling dynamic
 MLNs for a publication, please cite this paper.

# Available Inference Algorithms

- Gibbs sampling
- MCSat
- Loopy Belief Propagation
- exact by explicit enumeration of models (slow)

The code contains also junction tree inference, but this is broken since I removed a dependency and switched to
 a newer tree decomposition method.

Implementation of algorithms is very bad (which I know now). The MCMC algorithms might be passable. BP is both inefficient
and without a proper schedule; I think it's synchronized.

# Dynamic MLNs

UUMLN supports inference in dynamic MLNs, i.e., MLNs that have a `Time` sort. Note that for the dynamic code to work,
 you have to use the sort name `Time`.

We support two kinds of special domains. In general dynamic domains there must exist a sort named `Time`
that contains only integer constants. Temporal predicates must have the time sort as their first parameter.

Then *pure* dynamic domains contain **only** temporal predicates.

# Syntax

For examples see the files under `res/mln`.

 * The `succ(x)` function is built-in for integer constants (dynamically checked).
Alternatively one can use the `+` infix operator. For substraction one has to add the negative
value as in `x + (-5)`.

 * Ranges of integers can be given as `Time = {0,...,9}` as with alchemy or as `Time = {0 - 9}`.
You can't mix them as in `{1, 2, 5 - 10}`.

 * As with alchemy, we support marking parameters as functionally dependent on other parameters by appending a
    `!` after the sort in the predicate declaration. Contrary to alchemy we currently only support marking the
    very last parameter as functionally dependend on the previous ones.

## Differences to *alchemy*
This implementation does a few things differently than the original implementation in *alchemy*.

### What's worse

 - always infer all atoms (no query can be specified)
 - all constants have to appear in mln file (they cannot be given by the evidence file)
 - no weight learning
 - no lifting
 - no lazy inference
 - no memory or time limit
 - no MAP inference
 - no decision
 - no hybrid

### What's better

 - support for a sort hierarchy via `isA` relation
 - filtering for dynamic MLNs

### What's simply different

 - don't break up CNFs into clauses, splitting the weight. Quoting from *alchemy*'s page on MLN syntax:
     >Alchemy converts input formulas into CNF. This means that a conjunction of $n$ conjuncts in a formula results in $n$ formulas.
 - the parser imposes different capitalization rules; I think this should be fixed at some point:

            val predname = "[a-z][a-zA-Z_]*".r
            val sortname = "[A-Z][a-zA-Z_]*".r
            val constantLiteral = "[A-Z][a-zA-Z0-9_]*".r
            val variableLiteral = "\\??[a-z][a-zA-Z0-9_]*".r

# How to build?

1. Install a recent version of [SBT](http://www.scala-sbt.org/).
2. Run `sbt assembly` to generate an executable jar.
3. Find the jar under `target/scala-2.10/uumln-XXX.jar`

You can run the tests with `sbt test`.

# References

    @inproceedings{geier2011approximate,
       title={Approximate online inference for dynamic markov logic networks},
       author={Geier, Thomas and Biundo, Susanne},
       booktitle={Tools with Artificial Intelligence (ICTAI), 2011 23rd IEEE International Conference on},
       pages={764--768},
       year={2011},
       organization={IEEE}
     }
