package edu.uulm.scbayes.factorgraph

import edu.uulm.scbayes.probabilities.DiscreteVariable

/**
 * A factor node for a discrete factor graph. This isn't necessarily discrete, so ...
 *
 *
 * Date: 3/10/11
 */

trait DiscreteFactor[V <: DiscreteVariable] extends (IndexedSeq[Int] => Double) {
  /**
   * @return None if the factor is deterministic and not fulfilled.
   */
  def logFactor(assign: IndexedSeq[Int]): Double

  /** Map this array of variables to their assignment to feed it to logFactor */
  def assignmentVariables: IndexedSeq[V]

  def variables: Set[V] = assignmentVariables.toSet

  /**
   * @return None if the factor is deterministic and not fulfilled.
   */
  def logFactorFromInterpretation(assign: PartialFunction[V,Int]): Double =
    logFactor(assignmentVariables.map(assign))

  def apply(v1: IndexedSeq[Int]): Double = logFactor(v1)
}