package edu.uulm.scbayes.factorgraph

import edu.uulm.scbayes.probabilities.DiscreteVariable

/**
*
*
* Date: 3/10/11
*/

class DiscreteFactorGraph[VarT <: DiscreteVariable, FacT <: DiscreteFactor[VarT]](val variables: Set[VarT],
                                                                                  val factors: Set[FacT]
                                                                                 ) extends FactorGraph[VarT,FacT] {
  lazy val factor2var: Map[FacT, Set[VarT]] =
    (for (f <- factors) yield f -> f.variables).toMap

  lazy val var2factors: Map[VarT, Set[FacT]] =
    (for (v <- variables) yield v -> factors.filter(f => factor2var(f).contains(v))).toMap

  /** reflexive factor neighbourhood */
  lazy val factorAdjacency: Map[FacT, Set[FacT]] = {
    factors.map{f =>
      val neighboursOfF: Set[FacT] = this.variablesOf(f).flatMap(this.factorsOf(_))(collection.breakOut)
      f -> neighboursOfF
    }.toMap
  }

  def variablesOf(f: FacT): Set[VarT] = factor2var(f)

  def factorsOf(v: VarT): Set[FacT] = var2factors(v)

  override def toString: String = {
    "variables\n\t" +
      variables.map(_.toString).toSeq.sorted.mkString("\n\t") +
      "\nfactors\n\t" +
      factors.toSeq.map(_.toString).groupBy(_.size).mapValues(_.sorted).toSeq.sortBy(_._1).map(_._2).flatten.mkString("\n\t")
  }

  def combineFactors: DiscreteFactorGraph[VarT, TableFactor[VarT]] = {
    //put all edges under exactly one covering edge
    val cover = this.edgeCover
    val coverGroups = edges.groupBy(e => cover.find(c => isSubEdgeOf(e,c)).get).values

    val combinedFactors = coverGroups.map(TableFactor.combineFactors[VarT,FacT])

    val toSet = combinedFactors.toSet

    assert(toSet.size == combinedFactors.size)

    new DiscreteFactorGraph(variables, toSet)
  }
}