package edu.uulm.scbayes.factorgraph

/**
* Simple graph trait.
 *
*
* Date: 3/10/11
*/

trait FactorGraph[V,F] extends EdgeLabeledHyperGraph[V,F]{
  def variables: Set[V]
  def factors: Set[F]
  def variablesOf(f: F): Set[V]
  def factorsOf(v: V): Set[F]

  def nodes: Set[V] = variables
  def edges: Set[F] = factors
  def nodesOf(edge: F): Set[V] = variablesOf(edge).toSet
}