package edu.uulm.scbayes.factorgraph.messages

class DiscreteMessage( val data: Array[Double] ) extends IndexedSeq[Double] {
  require(data.forall(_ != Double.NaN), "oops")
  def length: Int = data.size
  def apply(x: Int): Double = data(x)
  def normalized: DiscreteMessage = {
    val normalization = data.sum
    new DiscreteMessage(data.map(_ / normalization))
  }
  def *(that: DiscreteMessage) = {
    require(this.length == that.length, "can only multiply messages of same length")
    new DiscreteMessage(data.zip(that.data).map(t => t._1 * t._2) (collection.breakOut))
  }
}

object DiscreteMessage {
  def normalized(data: Array[Double]) = {
    val normalization = data.sum
    new DiscreteMessage(data.map(_ / normalization))
  }
}
