package edu.uulm.scbayes.inference

import edu.uulm.scbayes.probabilities.DiscreteVariable
import edu.uulm.scbayes.factorgraph.DiscreteFactor

/**
 * This trait represents the function of running a stepping inferer until some kind of convergence is reached.
 *
 *
 * Date: 15.06.11
 */

trait ConvergenceRunner[TInf <: SteppingInferer] {
  def runUntilConvergence[V <: DiscreteVariable, F <: DiscreteFactor[V],T <: TInf](inferer: T, state: T#TState[V,F]): T#TState[V,F]
}