package edu.uulm.scbayes.inference

import incremental.SteppingEFBP
import edu.uulm.scbayes.probabilities.DiscreteVariable
import edu.uulm.scbayes.factorgraph.{DiscreteFactor, DiscreteFactorGraph}
import collection.Iterator
import edu.uulm.scbayes.factorgraph.messages.DiscreteMessage

/**
 * Stops convergence, once no entry in subsequent messages exceeds the given parameter lambda.
 *
 * Date: 15.06.11
 */

class EFBPMessageConvergence(val lambda: Double) extends ConvergenceRunner[SteppingEFBP] {

  /** Given two messages of the same variable, check if they contain a value that differs more than lambda. */
  def messageDiffers(m1: DiscreteMessage, m2: DiscreteMessage): Boolean =
    m1.zip(m2).exists(t => math.abs(t._1 - t._2) > lambda)

  def runUntilConvergence[V <: DiscreteVariable, F <: DiscreteFactor[V], T <: SteppingEFBP](inferer: T,
                                                                                            state: T#TState[V, F]): T#TState[V, F] = {
    val iterator: Iterator[(DiscreteFactorGraph[V, F], Set[V], Set[F], Map[(F, V), DiscreteMessage], Map[(V, F), DiscreteMessage])] =
      Iterator.iterate(state)(inferer.advanceState)

    iterator.sliding(2).dropWhile{
      case Seq((_,_,_,messages1,_),(_,_,_,messages2,_)) => {
        messages1.keys.exists(key => messageDiffers(messages1(key), messages2(key)))
      }
    }.next().head
  }
}